/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.struct.rights;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yigo.common.json.JSONSerializable;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BaseFormRights
implements JSONSerializable {
    protected String formKey = null;
    protected List<String> optRights = new ArrayList<String>();
    protected List<String> visibleRights = new ArrayList<String>();
    protected List<String> enableRights = new ArrayList<String>();
    protected boolean hasAllOptRights = false;
    protected boolean hasAllEnableRights = true;
    protected boolean hasAllVisibleRights = true;
    protected boolean needCache = true;
    protected boolean defStatus = true;

    public BaseFormRights() {
    }

    public BaseFormRights(String formKey) {
        this.formKey = formKey;
    }

    public void setFormKey(String formKey) {
        this.formKey = formKey;
    }

    public String getFormKey() {
        return this.formKey;
    }

    public boolean hasVisibleRights(String fieldKey) {
        if (this.hasAllVisibleRights) {
            return true;
        }
        return !this.visibleRights.contains(fieldKey);
    }

    public void addVisibleRights(String fieldKey) {
        if (this.hasAllVisibleRights) {
            this.hasAllVisibleRights = false;
        }
        this.visibleRights.add(fieldKey);
    }

    public void removeVisibleRights(String fieldKey) {
        this.visibleRights.remove(fieldKey);
        this.hasAllVisibleRights = this.visibleRights.isEmpty();
    }

    public void addVisibleRights(List<String> visibleRightsList) {
        if (visibleRightsList != null) {
            this.visibleRights.addAll(visibleRightsList);
        }
        this.hasAllVisibleRights = this.visibleRights.isEmpty();
    }

    public List<String> getVisibleRights() {
        return this.visibleRights;
    }

    public boolean hasEnableRights(String fieldKey) {
        if (this.hasAllEnableRights) {
            return true;
        }
        return !this.enableRights.contains(fieldKey);
    }

    public void addEnableRights(String fieldKey) {
        if (this.hasAllEnableRights) {
            this.hasAllEnableRights = false;
        }
        this.enableRights.add(fieldKey);
    }

    public void removeEnableRights(String fieldKey) {
        this.enableRights.remove(fieldKey);
        this.hasAllEnableRights = this.enableRights.isEmpty();
    }

    public void addEnableRights(List<String> enableRightsList) {
        if (enableRightsList != null) {
            this.enableRights.addAll(enableRightsList);
        }
        this.hasAllEnableRights = this.enableRights.isEmpty();
    }

    public boolean hasOptRights(String optKey) {
        if (this.hasAllOptRights) {
            return true;
        }
        return this.optRights.contains(optKey);
    }

    public List<String> getEnableRights() {
        return this.enableRights;
    }

    public void addOptRights(List<String> optRights) {
        if (optRights != null) {
            this.optRights.addAll(optRights);
        }
    }

    public void addOptRights(String optKey) {
        if (optKey.equalsIgnoreCase("*")) {
            this.hasAllOptRights = true;
        } else if (!this.optRights.contains(optKey)) {
            this.optRights.add(optKey);
        }
    }

    public void removeOptRights(String optKey) {
        if (this.hasAllOptRights) {
            this.hasAllOptRights = false;
        }
        this.optRights.remove(optKey);
    }

    public List<String> getOptRights() {
        return this.optRights;
    }

    public void setAllVisibleRights(boolean b) {
        if (b) {
            this.visibleRights.clear();
        }
        this.hasAllVisibleRights = b;
    }

    public void setAllEnableRights(boolean b) {
        if (b) {
            this.enableRights.clear();
        }
        this.hasAllEnableRights = b;
    }

    public void setAllOptRights(boolean b) {
        if (!b) {
            this.optRights.clear();
        }
        this.hasAllOptRights = b;
    }

    public boolean hasAllVisibleRights() {
        return this.hasAllVisibleRights;
    }

    public boolean hasAllEnableRights() {
        return this.hasAllEnableRights;
    }

    public boolean hasAllOptRights() {
        return this.hasAllOptRights;
    }

    public boolean needCache() {
        return this.needCache;
    }

    public void setNeedCache(boolean needCache) {
        this.needCache = needCache;
    }

    public JSONObject toJSON() throws SerializationException, JSONException {
        JSONObject jsonObj = new JSONObject();
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"formKey", (String)this.formKey, (String)"");
        jsonObj.put("needCache", this.needCache);
        if (this.hasAllOptRights) {
            jsonObj.put("allOptRights", true);
        } else {
            jsonObj.put("allOptRights", false);
            JSONArray optArray = new JSONArray();
            for (String opt : this.optRights) {
                optArray.put((Object)opt);
            }
            jsonObj.put("optRights", (Object)optArray);
        }
        if (this.hasAllEnableRights) {
            jsonObj.put("allEnableRights", true);
        } else {
            jsonObj.put("allEnableRights", false);
            JSONArray enableArray = new JSONArray();
            for (String field : this.enableRights) {
                enableArray.put((Object)field);
            }
            jsonObj.put("enableRights", (Object)enableArray);
        }
        if (this.hasAllVisibleRights) {
            jsonObj.put("allVisibleRights", true);
        } else {
            jsonObj.put("allVisibleRights", false);
            JSONArray visibleArray = new JSONArray();
            for (String field : this.visibleRights) {
                visibleArray.put((Object)field);
            }
            jsonObj.put("visibleRights", (Object)visibleArray);
        }
        return jsonObj;
    }

    public void fromJSON(JSONObject jsonObj) throws Throwable {
        String field;
        int i;
        this.formKey = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"formKey", (String)"");
        this.needCache = jsonObj.getBoolean("needCache");
        this.hasAllOptRights = jsonObj.getBoolean("allOptRights");
        if (!this.hasAllOptRights) {
            JSONArray optArray = jsonObj.getJSONArray("optRights");
            this.optRights.clear();
            for (i = 0; i < optArray.length(); ++i) {
                String opt = optArray.getString(i);
                this.optRights.add(opt);
            }
        }
        this.hasAllEnableRights = jsonObj.getBoolean("allEnableRights");
        if (!this.hasAllEnableRights) {
            JSONArray enableArray = jsonObj.getJSONArray("enableRights");
            this.enableRights.clear();
            for (i = 0; i < enableArray.length(); ++i) {
                field = enableArray.getString(i);
                this.enableRights.add(field);
            }
        }
        this.hasAllVisibleRights = jsonObj.getBoolean("allVisibleRights");
        if (!this.hasAllVisibleRights) {
            JSONArray visibleArray = jsonObj.getJSONArray("visibleRights");
            this.visibleRights.clear();
            for (i = 0; i < visibleArray.length(); ++i) {
                field = visibleArray.getString(i);
                this.visibleRights.add(field);
            }
        }
    }

    public boolean isDefStatus() {
        return this.defStatus;
    }

    public void setDefStatus(boolean defStatus) {
        this.defStatus = defStatus;
    }
}

