/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.struct.condition;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yigo.common.json.JSONSerializable;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.struct.condition.IConditionItem;
import com.bokesoft.yigo.struct.dict.ItemData;
import com.bokesoft.yigo.struct.exception.StructException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TranformConditionItem
implements JSONSerializable,
IConditionItem {
    private String key = "";
    private int type = -1;
    private boolean onlyDate = true;
    private Object value = "";
    private String itemKey = "";
    private int stateMask = 7;
    private int precision = 0;
    private int scale = 0;
    private boolean integerValue = false;
    private JSONObject filter = null;

    public TranformConditionItem() {
    }

    public TranformConditionItem(JSONObject jsonObj) throws SerializationException, JSONException {
        try {
            this.fromJSON(jsonObj);
        }
        catch (StructException e) {
            throw new RuntimeException("conditionItem JSON \u8f6c\u5316\u5931\u8d25\u3002");
        }
    }

    public JSONObject toJSON() throws StructException, JSONException {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("key", (Object)this.key);
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"type", (int)this.type, (int)-1);
        jsonObj.put("value", this.value2Json(this.type, this.value));
        jsonObj.put("onlyDate", this.onlyDate);
        jsonObj.put("itemKey", (Object)this.itemKey);
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"stateMask", (int)this.stateMask, (int)7);
        jsonObj.put("filter", (Object)this.filter);
        return jsonObj;
    }

    public void fromJSON(JSONObject jsonObj) throws SerializationException, JSONException {
        this.key = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"key", (String)"");
        this.type = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"type", (int)-1);
        this.precision = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"precision", (int)0);
        this.scale = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"scale", (int)0);
        this.integerValue = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"integerValue", (boolean)false);
        this.value = this.json2Value(this.type, jsonObj.opt("value"));
        this.onlyDate = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"onlyDate", (boolean)true);
        this.itemKey = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"itemKey", (String)"");
        this.stateMask = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"stateMask", (int)7);
        this.filter = jsonObj.optJSONObject("filter");
    }

    private Object value2Json(int controlType, Object value) throws SerializationException, JSONException {
        if (value == null) {
            return value;
        }
        Object ret = null;
        switch (controlType) {
            case 205: {
                ret = TypeConvertor.toDate((Object)value).getTime();
                break;
            }
            case 206: 
            case 241: 
            case 242: {
                if (value instanceof ItemData) {
                    ret = ((ItemData)value).toJSON();
                    break;
                }
                if (!(value instanceof List)) break;
                JSONArray jsonArray = new JSONArray();
                List list = (List)value;
                for (ItemData itemData : list) {
                    jsonArray.put((Object)itemData.toJSON());
                }
                ret = jsonArray;
                break;
            }
            default: {
                ret = value;
            }
        }
        return ret;
    }

    private Object json2Value(int controlType, Object value) throws StructException, JSONException {
        ArrayList<ItemData> ret = null;
        switch (controlType) {
            case 205: {
                ret = new Date(TypeConvertor.toLong((Object)value));
                break;
            }
            case 206: 
            case 241: 
            case 242: {
                if (value instanceof JSONArray) {
                    ArrayList<ItemData> list = new ArrayList<ItemData>();
                    JSONArray jsonArray = (JSONArray)value;
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        JSONObject itemObj = jsonArray.getJSONObject(i);
                        list.add(new ItemData(itemObj));
                    }
                    ret = list;
                    break;
                }
                if (!(value instanceof JSONObject)) break;
                ret = new ItemData((JSONObject)value);
                break;
            }
            case 210: {
                if (this.scale == 0) {
                    if (this.precision <= 9) {
                        ret = TypeConvertor.toInteger((Object)value);
                        break;
                    }
                    ret = TypeConvertor.toLong((Object)value);
                    break;
                }
                ret = TypeConvertor.toBigDecimal((Object)value, (Integer)this.scale);
                break;
            }
            case 204: {
                if (this.integerValue) {
                    ret = TypeConvertor.toInteger((Object)value);
                    break;
                }
            }
            default: {
                ret = value;
            }
        }
        return ret;
    }

    protected void cloneValue(TranformConditionItem item) {
        item.setKey(this.key);
        item.setOnlyDate(this.onlyDate);
        item.setType(this.type);
        item.setValue(this.value);
        item.setItemKey(this.itemKey);
        item.setStateMask(this.stateMask);
        item.setFilter(this.filter);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean isOnlyDate() {
        return this.onlyDate;
    }

    public void setOnlyDate(boolean onlyDate) {
        this.onlyDate = onlyDate;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public String getItemKey() {
        return this.itemKey;
    }

    public void setItemKey(String itemKey) {
        this.itemKey = itemKey;
    }

    @Override
    public int getStateMask() {
        return this.stateMask;
    }

    public void setStateMask(int stateMask) {
        this.stateMask = stateMask;
    }

    @Override
    public JSONObject getFilter() {
        return this.filter;
    }

    public void setFilter(JSONObject filter) {
        this.filter = filter;
    }
}

