/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.struct.datatable;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.struct.abstractdatatable.IRow;
import com.bokesoft.yes.struct.abstractdatatable.RowState;
import com.bokesoft.yes.struct.datatable.filter.FilterRow;
import com.bokesoft.yes.struct.datatable.json.RowDataListImpl;
import com.bokesoft.yes.struct.document.IJSONHandler;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import com.bokesoft.yigo.struct.exception.StructException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Row
extends IRow
implements Externalizable,
IJSONHandler,
FilterRow {
    private DataTable dataTable = null;
    private int bookmark = -1;
    private int parentBookmark = -1;
    private Object[] dataList = null;
    private Object[] originalDataList = null;

    public Row(DataTable dataTable) {
        this.dataTable = dataTable;
        int size = this.getMetaData().getColumnCount();
        this.dataList = new Object[size];
        this.rowState = 1;
        this.bookmark = dataTable.applyNewBookMark();
    }

    public Row(DataTable dataTable, boolean flag) {
        this.dataTable = dataTable;
        int size = this.getMetaData().getColumnCount();
        this.dataList = new Object[size];
    }

    public Row(DataTable dataTable, JSONObject jsonObj) throws StructException, JSONException {
        this.dataTable = dataTable;
        this.rowState = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"row_state", (int)0);
        this.bookmark = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"row_bookmark", (int)-1);
        this.parentBookmark = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"row_parent_bookmark", (int)-1);
        JSONArray dataArray = jsonObj.getJSONArray("data");
        int columnCount = this.getMetaData().getColumnCount();
        int dataLength = dataArray.length();
        if (columnCount != dataLength) {
            throw new StructException(2, StructException.formatMessage(null, 2, new Object[0]));
        }
        this.dataList = new Object[columnCount];
        for (int i = 0; i < dataLength; ++i) {
            Object dataObj = dataArray.get(i);
            dataObj = this.getMetaData().getColumnInfo(i).getDataTypeAction().fromJSON(dataObj);
            this.dataList[i] = dataObj = this.convertNullValue(i, dataObj);
        }
        if (jsonObj.has("originaldata")) {
            JSONArray originalDataArray = jsonObj.getJSONArray("originaldata");
            if (columnCount != originalDataArray.length()) {
                throw new StructException(2, StructException.formatMessage(null, 2, new Object[0]));
            }
            this.originalDataList = new Object[columnCount];
            for (int i = 0; i < originalDataArray.length(); ++i) {
                Object dataObj = originalDataArray.get(i);
                dataObj = this.getMetaData().getColumnInfo(i).getDataTypeAction().fromJSON(dataObj);
                this.originalDataList[i] = dataObj = this.convertNullValue(i, dataObj);
            }
        }
    }

    public void setState(int state) {
        this.rowState = state;
    }

    private DataTableMetaData getMetaData() {
        return this.dataTable.getMetaData();
    }

    public Row(ObjectInput in) throws IOException, ClassNotFoundException {
        this.rowState = 0;
        this.readExternal(in);
    }

    public Object getOriginalObject(int index) {
        if (this.originalDataList == null) {
            return this.dataList[index];
        }
        return this.originalDataList[index];
    }

    public void setObject(int index, Object value) {
        this.setObject(index, value, true);
    }

    public void setObject(int index, Object value, boolean changeState) {
        if (this.rowState == 0 || this.rowState == 1 || this.rowState == 2) {
            if (this.rowState == 0 && changeState) {
                boolean ignoreChangeState = false;
                DataTableMetaData metaData = this.getMetaData();
                if (metaData != null) {
                    ColumnInfo col = metaData.getColumnInfo(index);
                    ignoreChangeState = col.getIgnoreChangeState();
                }
                if (!ignoreChangeState) {
                    this.createOriginData();
                    this.rowState = 2;
                }
            }
            this.dataList[index] = value = this.convertNullValue(index, value);
            this.updateIndex();
        }
    }

    public void updateIndex() {
        this.dataTable.updateIndexRowByBookmark(this.bookmark);
    }

    public Object getObject(int index) {
        Object value = this.dataList[index];
        return value;
    }

    public void stateUpdate() {
        this.rowState = 0;
        this.originalDataList = null;
    }

    @Deprecated
    public void resetOriginalData() {
        this.originalDataList = null;
    }

    public void createOriginData() {
        int size = this.dataList.length;
        Object[] originalDataList = new Object[size];
        System.arraycopy(this.dataList, 0, originalDataList, 0, size);
        this.originalDataList = originalDataList;
    }

    public Object[] getOriginalDataList() {
        return this.originalDataList;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int i;
        out.writeInt(this.rowState);
        int size = this.dataList.length;
        out.writeInt(size);
        for (i = 0; i < size; ++i) {
            this.getMetaData().getColumnInfo(i).getDataTypeAction().writeExternalForColumnObject(this.dataList[i], out);
        }
        out.writeBoolean(this.originalDataList != null);
        if (this.originalDataList != null) {
            for (i = 0; i < size; ++i) {
                this.getMetaData().getColumnInfo(i).getDataTypeAction().writeExternalForColumnObject(this.originalDataList[i], out);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.rowState = in.readInt();
        int size = in.readInt();
        DataTableMetaData metaData = this.getMetaData();
        for (int i = 0; i < size; ++i) {
            this.dataList[i] = metaData.getColumnInfo(i).getDataTypeAction().readExternalForColumnObject(in);
        }
        boolean existoData = in.readBoolean();
        if (existoData) {
            this.originalDataList = new Object[size];
            for (int i = 0; i < size; ++i) {
                this.originalDataList[i] = metaData.getColumnInfo(i).getDataTypeAction().readExternalForColumnObject(in);
            }
        }
    }

    public Row deepClone(DataTable cloneTable) {
        int i;
        Row clone = new Row(cloneTable);
        clone.rowState = this.rowState;
        clone.bookmark = this.bookmark;
        clone.parentBookmark = this.parentBookmark;
        DataTableMetaData metaData = this.getMetaData();
        int size = this.dataList.length;
        for (i = 0; i < size; ++i) {
            clone.dataList[i] = metaData.getColumnInfo(i).getDataTypeAction().getCloneValue(this.dataList[i]);
        }
        if (this.originalDataList != null) {
            clone.originalDataList = new Object[size];
            for (i = 0; i < size; ++i) {
                clone.originalDataList[i] = metaData.getColumnInfo(i).getDataTypeAction().getCloneValue(this.originalDataList[i]);
            }
        }
        return clone;
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject jsonObj = new JSONObject();
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"row_state", (int)this.rowState, (int)0);
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"row_bookmark", (int)this.bookmark, (int)-1);
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"row_parent_bookmark", (int)this.parentBookmark, (int)-1);
        JSONArray dataArray = new JSONArray();
        int size = this.dataList.length;
        int veridColumnIndex = this.getMetaData().findColumnIndexByKey("VERID");
        for (int i = 0; i < size; ++i) {
            Object data = this.dataList[i];
            if (i == veridColumnIndex) {
                int verID = TypeConvertor.toInteger((Object)data);
                data = verID >= 0 ? verID : -verID;
            }
            dataArray.put(this.getMetaData().getColumnInfo(i).getDataTypeAction().toJSON(data));
        }
        jsonObj.put("data", (Object)dataArray);
        if (this.originalDataList != null) {
            JSONArray originalDataArray = new JSONArray();
            for (int i = 0; i < size; ++i) {
                Object originalData = this.originalDataList[i];
                if (i == veridColumnIndex) {
                    int verID = TypeConvertor.toInteger((Object)originalData);
                    originalData = verID >= 0 ? verID : -verID;
                }
                originalDataArray.put(this.getMetaData().getColumnInfo(i).getDataTypeAction().toJSON(originalData));
            }
            jsonObj.put("originaldata", (Object)originalDataArray);
        }
        return jsonObj;
    }

    @Override
    public int getBookmark() {
        return this.bookmark;
    }

    @Override
    public int getParentBookmark() {
        return this.parentBookmark;
    }

    public void setParentBookmark(int parentBookmark) {
        this.parentBookmark = parentBookmark;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendString(sb);
        return sb.toString();
    }

    public void appendString(StringBuilder sb) {
        sb.append("<Row BOOK_MARK=\"");
        sb.append(this.bookmark);
        sb.append("\" PARENT_BOOK_MARK=\"");
        sb.append(this.parentBookmark);
        sb.append("\" ROW_STATE=\"");
        sb.append(RowState.parseString(this.rowState));
        sb.append("\" ");
        DataTableMetaData md = this.getMetaData();
        for (int i = 0; i < md.getColumnCount(); ++i) {
            ColumnInfo ci = md.getColumnInfo(i);
            sb.append(ci.getColumnKey());
            sb.append("=\"");
            sb.append(ci.getDataTypeAction().toString(this.dataList[i]));
            sb.append("\" ");
        }
        sb.append("/>\n");
    }

    public void removeOriginalData() {
        this.originalDataList = null;
    }

    public Object[] getDataList() {
        return this.dataList;
    }

    @Override
    public IJSONHandler newHandler(String token) {
        if ("data".equals(token)) {
            return new RowDataListImpl(this.dataTable, this.dataList);
        }
        return null;
    }

    @Override
    public void putAttr(String name, String value) {
        if ("row_state".equals(name)) {
            this.rowState = Integer.parseInt(value);
        } else if ("row_bookmark".equals(name)) {
            this.bookmark = Integer.parseInt(value);
        }
    }

    public void impl_SetBookmarkSeed(int value) {
        this.bookmark = value;
    }

    @Override
    public void endHandler() {
    }

    @Override
    public void endChildHandler(IJSONHandler handler) {
    }

    @Override
    public Object getObject(String columnKey) throws StructException {
        int col = this.dataTable.getMetaData().findColumnIndexByKey(columnKey);
        return this.getObject(col);
    }

    public Object convertNullValue(int columnIndex, Object value) {
        if (value != null) {
            return value;
        }
        ColumnInfo columnInfo = this.getMetaData().getColumnInfo(columnIndex);
        int dataType = columnInfo.getDataType();
        if (dataType == 1002 || dataType == 1011 || dataType == 1012) {
            value = "";
        } else if (dataType == 1006 || dataType == 1007 || dataType == 1005 || dataType == 1001 || dataType == 1010) {
            value = TypeConvertor.toDataType((int)dataType, (Object)0);
        }
        return value;
    }
}

