/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.struct.rights;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yigo.common.json.JSONSerializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DictRights
implements JSONSerializable {
    private List<Long> ids = new ArrayList<Long>();
    private List<Long> readRightIds = new ArrayList<Long>();
    private List<Long> writeRightIds = new ArrayList<Long>();
    private String itemKey = null;
    private boolean hasAllRights = false;
    private boolean hasEmptRights = false;

    public DictRights() {
    }

    public DictRights(String itemKey) {
        this.itemKey = itemKey;
    }

    public boolean hasRights(long oid) {
        if (this.hasAllRights) {
            return true;
        }
        if (oid == 0L) {
            return true;
        }
        return this.ids.contains(oid);
    }

    public boolean hasRead(long oid) {
        if (this.hasAllRights) {
            return true;
        }
        if (oid == 0L) {
            return true;
        }
        return this.readRightIds.contains(oid);
    }

    public boolean hasWrite(long oid) {
        if (this.hasAllRights) {
            return true;
        }
        if (oid == 0L) {
            return true;
        }
        return this.writeRightIds.contains(oid);
    }

    public List<Long> getIDs() {
        return this.ids;
    }

    public List<Long> getReadRightIds() {
        return this.readRightIds;
    }

    public List<Long> getWriteRightIds() {
        return this.writeRightIds;
    }

    public int size() {
        return this.ids.size();
    }

    public JSONObject toJSON() throws SerializationException, JSONException {
        JSONObject jsonObj = new JSONObject();
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"itemKey", (String)this.itemKey, (String)"");
        jsonObj.put("emptRights", this.hasEmptRights);
        if (this.hasAllRights) {
            jsonObj.put("allRights", true);
        } else {
            jsonObj.put("allRights", false);
            JSONArray idsArray = new JSONArray();
            for (long id : this.ids) {
                idsArray.put(id);
            }
            jsonObj.put("ids", (Object)idsArray);
        }
        return jsonObj;
    }

    public void fromJSON(JSONObject jsonObj) throws SerializationException, JSONException {
        this.itemKey = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"itemKey", (String)"");
        this.hasEmptRights = jsonObj.getBoolean("emptRights");
        this.hasAllRights = jsonObj.getBoolean("allRights");
        if (!this.hasAllRights) {
            JSONArray idsArray = jsonObj.getJSONArray("ids");
            this.ids.clear();
            for (int i = 0; i < idsArray.length(); ++i) {
                long id = idsArray.getLong(i);
                this.ids.add(id);
            }
        }
    }

    public void addWriteRightsDictID(long dictID) {
        if (this.hasAllRights) {
            return;
        }
        if (!this.writeRightIds.contains(dictID)) {
            this.writeRightIds.add(dictID);
        }
    }

    public void addDictID(long dictID) {
        if (this.hasAllRights) {
            return;
        }
        if (!this.ids.contains(dictID)) {
            this.ids.add(dictID);
        }
    }

    public void addReadRightsDictID(long dictID) {
        if (this.hasAllRights) {
            return;
        }
        if (!this.readRightIds.contains(dictID)) {
            this.readRightIds.add(dictID);
        }
    }

    public void addDictIDs(Collection<Long> collection) {
        if (this.hasAllRights) {
            return;
        }
        this.ids.removeAll(collection);
        this.ids.addAll(collection);
    }

    public void addReadRightsDictIDs(Collection<Long> collection) {
        if (this.hasAllRights) {
            return;
        }
        this.readRightIds.removeAll(collection);
        this.readRightIds.addAll(collection);
    }

    public void addWriteRightsDictIDs(Collection<Long> collection) {
        if (this.hasAllRights) {
            return;
        }
        this.writeRightIds.removeAll(collection);
        this.writeRightIds.addAll(collection);
    }

    public void setAllRights(boolean b) {
        this.hasAllRights = b;
    }

    public boolean hasAllRights() {
        return this.hasAllRights;
    }

    public boolean hasEmptRights() {
        return this.hasEmptRights;
    }

    public void setEmptRights(boolean b) {
        this.hasEmptRights = b;
    }

    public String getItemKey() {
        return this.itemKey;
    }

    public void merge(DictRights dr) {
        if (dr == null) {
            return;
        }
        if (!this.itemKey.equals(dr.getItemKey())) {
            throw new RuntimeException("\u4e0d\u540c\u5b57\u5178\u7684\u6743\u9650\u65e0\u6cd5\u5408\u5e76.");
        }
        if (dr.hasEmptRights) {
            this.hasEmptRights = true;
        }
        if (this.hasAllRights) {
            return;
        }
        if (dr.hasAllRights()) {
            this.hasAllRights = true;
            return;
        }
        this.ids.removeAll(dr.getIDs());
        this.ids.addAll(dr.getIDs());
        this.readRightIds.removeAll(dr.getReadRightIds());
        this.readRightIds.addAll(dr.getReadRightIds());
        this.writeRightIds.removeAll(dr.getWriteRightIds());
        this.writeRightIds.addAll(dr.getWriteRightIds());
    }

    public DictRights clone() {
        DictRights clone = new DictRights(this.itemKey);
        clone.merge(this);
        return clone;
    }
}

