package com.bokesoft.yigo.struct.util;

import org.json.JSONObject;

import com.bokesoft.yigo.common.def.JavaDataType;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;

public class DataDecoder {
	public static Object decode(int type, JSONObject json) throws Throwable {
		Object result = null;
		switch ( type ) {
		case JavaDataType.USER_DATATABLE: {
			DataTable table = new DataTable();
			table.fromJSON(json);
			result = table;
		}
			break;
		case JavaDataType.USER_DOCUMENT: {
			Document document = new Document(null, -1);
			document.fromJSON(json);
			result = document;
		}
			break;
		}
		return result;
	}
}
