package com.bokesoft.yigo.struct.rights;

import java.util.HashSet;
import java.util.Set;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yigo.common.json.JSONSerializable;

public class ServiceRights implements JSONSerializable {
	/**
	 * 有权限的服务集合
	 */
	private Set<String> serviceIDs = new HashSet<>();
	
	private boolean hasAllRights = false;
	
	public boolean hasServiceRights(String serviceID) {
		if (hasAllRights) {
			return true;
		}
		return serviceIDs.contains(serviceID);
	}
	
	public void addServiceID(String serviceID) {
		if (hasAllRights) {
			return;
		}else if ("*".equals(serviceID)) {
			hasAllRights = true;
		}else {
			serviceIDs.add(serviceID);
		}
	}
	
	public boolean hasAllRights() {
		return hasAllRights;
	}

	public void setHasAllRights(boolean hasAllRights) {
		this.hasAllRights = hasAllRights;
	}
	
	public Set<String> getServiceIDs() {
		return serviceIDs;
	}

	public void merge(ServiceRights rights) {
		if (rights == null || hasAllRights) {
			return;
		}
		
		if (rights.hasAllRights()) {
			hasAllRights = rights.hasAllRights();
			return;
		}
		
		serviceIDs.addAll(rights.getServiceIDs());
	}

	@Override
	public JSONObject toJSON() throws Throwable {
		JSONObject json = new JSONObject();
		if (hasAllRights) {
			json.put(RightsJSONConstants.SERVICERIGHTS_ALLRIGHTS, true);
		}else {
			json.put(RightsJSONConstants.SERVICERIGHTS_ALLRIGHTS, false);
			JSONArray array = new JSONArray();
			for (String ids : serviceIDs) {
				array.put(ids);
			}
			json.put(RightsJSONConstants.SERVICERIGHTS_IDS, array);
		}
		return json;
	}

	@Override
	public void fromJSON(JSONObject jsonObj) throws Throwable {
		if (jsonObj.has(RightsJSONConstants.SERVICERIGHTS_ALLRIGHTS)) {
			hasAllRights  = jsonObj.getBoolean(RightsJSONConstants.SERVICERIGHTS_ALLRIGHTS);
		}
		
		if (!hasAllRights && jsonObj.has(RightsJSONConstants.SERVICERIGHTS_IDS)) {
			JSONArray array = jsonObj.getJSONArray(RightsJSONConstants.SERVICERIGHTS_IDS);
			serviceIDs.clear();
			for (int i = 0; i < array.length(); i++) {
				serviceIDs.add(array.getString(i));
			}
		}

	}

}
