package com.bokesoft.yigo.struct.rights;

/**
 * 表单权限， 包含字段可见， 字段可编辑， 操作权限
 * 
 * @author zhufw
 *
 */
public class FormRights extends BaseFormRights {
	
	public FormRights(){
		
	}
	
	public FormRights(String formKey){
		super(formKey);
	}
	
	public FormRights clone(){
		FormRights fr = new FormRights(this.formKey);
		
		fr.setAllEnableRights(this.hasAllEnableRights);
		fr.setAllVisibleRights(this.hasAllVisibleRights);
		fr.setAllOptRights(this.hasAllOptRights);
	
		if(!this.hasAllEnableRights){
			for(String s : this.enableRights){
				fr.addEnableRights(s);
			}
		}
		
		if(!this.hasAllOptRights){
			for(String s : this.optRights){
				fr.addOptRights(s);
			}
		}
		
		if(!this.hasAllVisibleRights){
			for(String s : this.visibleRights){
				fr.addVisibleRights(s);
			}
		}
		
		fr.setDefStatus(this.defStatus);
		return fr;
	}
	
	public void merge(BaseFormRights fr) {
		if(fr == null){
			return;
		}
		
		if (!this.formKey.equals(fr.getFormKey())) {
			throw new RuntimeException("不同表单的权限无法合并.");
		}

		if (!this.hasAllOptRights) {
			if (fr.hasAllOptRights()) {
				this.hasAllOptRights = true;
			} else {
				// 操作权限，存有权限的optkey
				optRights.removeAll(fr.getOptRights());
				optRights.addAll(fr.getOptRights());
			}
		}
		// 最多权限原则
		if (!fr.defStatus) {
			if (!this.hasAllVisibleRights || this.isDefStatus()) {
				if (!this.hasAllVisibleRights && !fr.hasAllVisibleRights) {
					// 字段可见行权限，　存的是没有权限的字段key
					visibleRights.retainAll(fr.getVisibleRights());
					if (visibleRights.isEmpty()) {
						this.hasAllVisibleRights = true;
					}
				} else {
					visibleRights.clear();
					visibleRights.addAll(fr.getVisibleRights());
					this.hasAllVisibleRights = fr.hasAllVisibleRights;
				}
			}
			
			if (!this.hasAllEnableRights || this.isDefStatus()) {
				if (!this.hasAllEnableRights && !fr.hasAllEnableRights) {
					// 字段可编辑行权限，　存的是没有权限的字段key
					enableRights.retainAll(fr.getEnableRights());
					if (enableRights.isEmpty()) {
						this.hasAllEnableRights = true;
					}
				} else {
					enableRights.clear();
					enableRights.addAll(fr.getEnableRights());
					this.hasAllEnableRights = fr.hasAllEnableRights;
				}
			}
			
			this.defStatus = false;
		}

	}
}
