package com.bokesoft.yigo.struct.document.track;

/**
 * 单据的执行轨迹记录，用于中间层性能优化。
 * 
 * @author 刘翔翔
 *
 */
public class TrackDetail {

	/** 从UI发起请求 */
	public static final int FROM_UI = 0;

	/** 数据新增以后保存 */
	public static final int NEW_SAVE = 1;

	/** 数据被修改以后保存 */
	public static final int MODIFY_SAVE = 2;

	/** 数据被执行删除 */
	public static final int DELETE = 3;

	/** 数据执行迁移 */
	public static final int MIGRATION = 4;

	/** 数据自动下推 */
	public static final int AUTO_MAP = 5;

	/** 由中间层发起的单据保存 */
	public static final int MID_SAVE = 6;
	
	/** 自启动流程 */
	public static final int AUTO_START_INSTANCE = 7;

	/** 操作类型 */
	private int type;

	/** 操作的细节 */
	private String info;

	public TrackDetail(int type, String info) {
		this.type = type;
		this.info = info;
	}

	public int getType() {
		return type;
	}

	public String getInfo() {
		return info;
	}

}
