package com.bokesoft.yigo.struct.document;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;

import org.json.JSONObject;

import com.bokesoft.yigo.common.json.JSONSerializable;

/**
 * <br>全文检索的时候， 匹配到的数据由于权限过滤， 最后不一定会载入。 
 * 最后载入数据的序号和匹配集中的序号是不同的，分页的时候需要有一个Map来映射这些关系。翻页的时候， 已经过滤完的页面不需要再次过滤。
 * <br>客户端和服务器之间用这个数据结构来传递这个映射关系， 对于一次会话，每次服务器处理完一次载入请求就会把最新的映射关系返回给客户端保存，下次请求会把这个映射关系发送给服务器。
 * @author lingc
 *
 */
public class SolrMap implements JSONSerializable {
	
	/**
	 * 查询语句
	 */
	private String queryString = null;
	
	/**
	 * 有权限的数据和匹配集中的对应关系
	 */
	private Map<Integer, Integer> map = new HashMap<Integer, Integer>();
	
	public static final String QUERY = "query";
	
	public static final String MAP = "map";
	
	@Override
	public JSONObject toJSON() throws Throwable {
		JSONObject result = new JSONObject();
		JSONObject mapJsonObejct = new JSONObject();
		Integer key;
		Integer value;
		for (Entry<Integer, Integer> e : map.entrySet()) {
			key = e.getKey();
			value = e.getValue();
			mapJsonObejct.put(key.toString(), value);
		}
		result.put(MAP, mapJsonObejct) ;
		result.put(QUERY, queryString);
		return result;
	}

	@Override
	public void fromJSON(JSONObject json) throws Throwable {
		if(json != null && json.length() > 0){
			/*map*/
			JSONObject jsonObj = json.getJSONObject(MAP);
			if(jsonObj !=null && jsonObj.length() > 0){
				Iterator<?> iterator = jsonObj.keys();
				Integer int1;
				Integer int2;
				while(iterator.hasNext()){
					String key = (String) iterator.next();
					int1 = Integer.parseInt(key);
					int2 = jsonObj.getInt(key);
					map.put(int1, int2);
				}
			}
			/*query*/
			this.queryString = json.optString(QUERY);
		}
		
		
	}

	public void put(Integer int1, Integer int2){
		map.put(int1, int2);
	}
	
	public void remove(Integer int1){
		map.remove(int1);
	}
	
	public Integer get(Integer int1){
		return map.get(int1);
	}

	public String getQueryString() {
		return queryString;
	}

	public void setQueryString(String queryString) {
		this.queryString = queryString;
	}
	
	public void clear(){
		this.map.clear();
	}
	
	@SuppressWarnings("unchecked")
	protected Object clone() {
		SolrMap newObj = new SolrMap();
		newObj.queryString = queryString;
		newObj.map = map == null ? null : (HashMap<Integer, Integer>)((HashMap<Integer, Integer>)map).clone();
		return newObj;
	}
}
