package com.bokesoft.yigo.struct.dict;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yes.struct.dict.DictJSONConstants;
import com.bokesoft.yes.struct.dict.ItemRow;
import com.bokesoft.yes.struct.dict.ItemTableBase;
import com.bokesoft.yigo.common.def.SystemField;
import com.bokesoft.yigo.common.i18n.DefaultLocale;
import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.common.json.JSONSerializable;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.struct.exception.StructException;

/**
 * Tleft Tright 属性不放去缓存中， 添加或删除一个节点会带来一连串的Tleft Tright 变化， 对字典缓存更新过于频繁，而且涉及过多。
 * parentID 属性 保留， 当节点删除时， 清除该节点下的子节点缓存。
 * 
 * @author zhufw
 *
 */
public class Item implements JSONSerializable , Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -7640509081419239905L;
	
	private Map<String, ItemTableBase> itemTables = new HashMap<String, ItemTableBase>();
	/** 对应OID */
	private long OID;

	/** 节点类型 */
	private int nodeType;

	/** 父节点的OID */
	//private ItemData parentID;

	/** 启用标记 */
	private int enable;

	/** 字典的itemKey */
	private String itemKey = "";
	
	/** 字典的displayCaption */
	private String caption = "";
	
	private String mainTableKey = "";
	
	// 多语种caption
	private Map<String, String> i18nCaptions;
	// 多语种字段
	private Map<String, Object> i18nValues;
	
	private Map<String, List<String>> i18nColumns;
	// 根據displaycolumn设置显示code或useCode
	private String showCode;
	
	private boolean isInitI18n = false;
	
	public Item() {
	}
	
	public Item(String itemKey, long id) {
		this.itemKey = itemKey;
		this.OID = id;
		
		if(id == 0){
			nodeType = 1;
		}
	}
	
	public Item(JSONObject jsonObj)throws JSONException{
		try {
			this.fromJSON(jsonObj);
		} catch (StructException e) {
			e.printStackTrace();
			throw new RuntimeException("Item json 序列化错误:"+jsonObj);
		}
	}

	public String getItemKey(){
		return itemKey;
	}
	
	public long getID() {
		return OID;
	}

	public int getNodeType() {
		return nodeType;
	}
	
	public long getParentID() {
		return TypeConvertor.toLong(getValue(SystemField.PARENTID_DICT_KEY));
	}

	//public ItemData getParentID() {
	//	return parentID;
	//}
	
	public int getEnable() {
		return enable;
	}

	public ItemTableBase getItemTable(String tableKey) {
		return itemTables.get(tableKey);
	}

	public Map<String, ItemTableBase> getItemTables() {
		return itemTables;
	}

	/**
	 * 获取字典字段的值
	 * 
	 * @param tableKey 表标识
	 * @param colKey 列标识
	 * @return tableKey所在的表colKey列的值
	 */
	public Object getValue(String tableKey , String colKey) {
		if(this.i18nColumns != null) {
			List<String> columns = i18nColumns.get(tableKey);
			if(columns != null) {
				if(columns.contains(colKey)) {
					ILocale locale = DefaultLocale.getDefaultLocale();
					if(locale != null) {
						return this.getI18nValue(tableKey, colKey, locale.getLocale());
					}
				}
			}
		}

		ItemTableBase tableBase = itemTables.get(tableKey);
		if(tableBase == null){
			return null;
		}
		return tableBase.getValue(colKey);
	}
	
	public static void main(String[] args){
		String a = "zfw.nana";
		int pos = a.indexOf('.');
		String b = a.substring(0, pos);
		String c = a.substring(pos+1);
//		System.out.println(b);
//		System.out.println(c);
	}
	
	public Object getValue(String colKey) {
		String tableKey = null;
		int pos = colKey.indexOf('.');
		if(pos > 0){
			tableKey = colKey.substring(0,pos);
			colKey = colKey.substring(pos+1);
		}else{
			tableKey = mainTableKey;
		}
		
		return getValue(tableKey , colKey);
	}
	
	public Object impl_getValue(String tableKey , String colKey, String locale) {
		return this.getValue(tableKey, colKey);
	}
	
	@Deprecated
	public Object impl_getValue(String tableKey , String colKey) {
		return this.getValue(tableKey, colKey);
	}

	@Deprecated
	public Object impl_getValue(String colKey) {
		String tableKey = null;
		int pos = colKey.indexOf('.');
		if(pos > 0){
			tableKey = colKey.substring(0,pos);
			colKey = colKey.substring(pos+1);
		}else{
			tableKey = mainTableKey;
		}
		
		return impl_getValue(tableKey , colKey);
	}
//	/**
//	 * 获取字典明细字段的值 ， 返回的是明细字段的集合
//	 * 
//	 * @param sField
//	 * @return
//	 * @throws Throwable
//	 */
	/*public Object getDtlValue(String sField) {
		Object value = null;
		for (ItemTableBase tableBase : itemTables.values()) {
			if (!tableBase.isHeadMode() && tableBase.existsColKey(sField)) {
				value = tableBase.getValue(sField);
				break;
			}
		}
		return value;
	}*/

	public String getCaption(){
		if(i18nCaptions == null || i18nCaptions.isEmpty()) {
			return this.caption;
		}
		
		ILocale locale = DefaultLocale.getDefaultLocale();
		if(locale == null) {
			return this.caption;
		}
		return getCaption(locale.getLocale());
	}
	
	public void setCaption(String s){
		this.caption = s;
	}
	
	public void addI18nCaption(String locale, String caption) {
		if(i18nCaptions == null) {
			i18nCaptions = new HashMap<>();
		}
		i18nCaptions.put(locale, caption);
	}
	
	public String getCaption(String locale) {
		if(i18nCaptions == null || i18nCaptions.isEmpty()) {
			return this.caption;
		}
		
		if(locale == null) {
			return this.caption;
		}
		
		String s = i18nCaptions.getOrDefault(locale, "");
		return s;
	}
	
	/**
	 * 字典根據displaycolumn设置显示code或useCode
	 * @param s
	 */
	public void setShowCode(String s) {
		this.showCode = s;
	}
	
	public String getShowCode() {
		return this.showCode;
	}
	
	public void setInitI18n() {
		this.isInitI18n = true;
	}
	
	public boolean getIsInitI18n() {
		return this.isInitI18n;
	}
	
	/**
	 * 添加多语种字段值
	 * @param tableKey 表
	 * @param colKey 字段
	 * @param value 值
	 * @param locale 语种
	 */
	public void addI18nValue(String tableKey, String colKey, Object value, String locale) {
		if(i18nValues == null) {
			this.i18nValues = new HashMap<>();
		}
		
		String key = tableKey + "_" + colKey + "_" + locale;
		i18nValues.put(key, value);
	}
	
	public Object getI18nValue(String tableKey, String colKey, String locale) {
		if(i18nValues == null) {
			return "";
		}
		
		if(locale == null) {
			ILocale l = DefaultLocale.getDefaultLocale();
			if(l != null) {
				locale = l.getLocale();
			}
		}
		
		String key = tableKey + "_" + colKey + "_" + locale;
		return TypeConvertor.toString(i18nValues.get(key));
	}
	
	public Object getI18nValue(String colKey, String locale) {
		String tableKey = null;
		int pos = colKey.indexOf('.');
		if(pos > 0) {
			tableKey = colKey.substring(0, pos);
			colKey = colKey.substring(pos + 1);
		}else {
			tableKey = mainTableKey;
		}
		return getI18nValue(tableKey, colKey, locale);
	}
	
	
//	/**
//	 * 根据节点ID获取节点的显示值 , 配置中不做设置的情况下 返回 Code + Name
//	 * 
//	 * @param itemKey
//	 * @param id
//	 * @param displayFields
//	 * @return
//	 * @throws Throwable
//	 */
	/*public String getCaption(List<String> displayFields) throws Throwable {
		StringBuffer sb = new StringBuffer();
		if(displayFields != null && displayFields.size() > 0){
			
			for(int i = 0 ; i < displayFields.size() ; i ++){
				if(i > 0 ){
					sb.append(" ");
				}
				sb.append(TypeConvertor.toString(getFieldValue(displayFields.get(i))));
			}
		}else{
			sb.append(TypeConvertor.toString(item.getFieldValue("code")))
			.append(" ")
			.append(TypeConvertor.toString(item.getFieldValue("name")));
		}

		return sb.toString();
	}*/

	public void addItemTableBase(ItemTableBase tb , boolean isMainTable) {
		itemTables.put(tb.getKey(), tb);
		if(isMainTable){
			mainTableKey = tb.getKey();
			if(hasInited){
				throw new RuntimeException("已经初始化过， 不应该再初始化数据。");
			}
			initData(tb);
		}
		//if (tb.isHeadMode() && tb.getRowCount() > 0) {
		//	initData(tb);
		//}else if(tb.isHeadMode() && tb.getRowCount()==0){
		//	tb.regAddRowCallBack(new Callback<ItemTableBase , Boolean>(){
		//		@Override
		//		public Boolean call(ItemTableBase tb) throws Throwable {
		//			initData(tb);
		//			return true;
		//		}
		//	});
		//}
	}
	
	private boolean hasInited = false;
	private void initData(ItemTableBase tb){
		OID = (OID == 0) ? TypeConvertor.toLong(tb.getValue("OID")) : OID;
		
		nodeType = TypeConvertor.toInteger(tb.getValue("NodeType"));
		
		this.itemKey = tb.getItemKey();
		//long pID = (OID != 0) ? TypeConvertor.toLong(tb.getValue("parentID")) : 0;
		//this.parentID = new ItemData(getItemKey(), pID);
		
		//status = (OID != 0) ? TypeConvertor.toInteger(tb.getValue("status")) : status;
		
		enable =  TypeConvertor.toInteger(tb.getValue("Enable")) ;
		hasInited = true;
	}
	
	/**
	 * 转换为json对象
	 * 
	 * @return json对象
	 */
	@Override
	public JSONObject toJSON() throws SerializationException,JSONException {
		JSONObject jsonObj = new JSONObject();
		jsonObj.put(DictJSONConstants.ITEM_ITEMKEY, getItemKey());
		JSONHelper.writeToJSON(jsonObj, DictJSONConstants.ITEM_OID, OID, 0);
		JSONHelper.writeToJSON(jsonObj, DictJSONConstants.ITEM_NODETYPE,
				nodeType, 0);
		
		//jsonObj.put(DictJSONConstants.ITEM_PARENTID, parentID.toJSON());

		//JSONHelper.writeToJSON(jsonObj, DictJSONConstants.ITEM_STATUS, status,0);
		JSONHelper.writeToJSON(jsonObj, DictJSONConstants.ITEM_ENABLE, enable,0);
		jsonObj.put(DictJSONConstants.ITEM_CAPTION, caption);
		jsonObj.put(DictJSONConstants.ITEM_MAINTABLEKEY, mainTableKey);
		
		jsonObj.put(DictJSONConstants.ITEM_SHOWCODE, showCode);
		
		if(this.i18nCaptions != null && !this.i18nCaptions.isEmpty()) {
			JSONObject i18ns = new JSONObject();
			for(Map.Entry<String, String> entry : i18nCaptions.entrySet()) {
				i18ns.put(entry.getKey(), entry.getValue());
			}
			jsonObj.put(DictJSONConstants.ITEM_I18NCAPTION, i18ns);
		}
		
		if(this.i18nColumns != null && !this.i18nColumns.isEmpty()) {
			JSONObject i18ncols = new JSONObject(i18nColumns);
			jsonObj.put(DictJSONConstants.ITEM_I18NCOLUMNS, i18ncols);
		}
		
		if(this.i18nValues != null && !this.i18nValues.isEmpty()) {
			JSONObject i18nV = new JSONObject(i18nValues);
			jsonObj.put(DictJSONConstants.ITEM_I18NVALUES, i18nV);
		}
		
		//JSONArray tableArray = new JSONArray();
		JSONObject jsonTables = new JSONObject();
		for (String sKey : itemTables.keySet()) {
			if (sKey.endsWith(MetaTable._T)) {
				continue;
			}
			ItemTableBase table = itemTables.get(sKey);
	
			JSONObject itemTableObject = table.toJSON();
			jsonTables.put(sKey, itemTableObject);
			//tableArray.put(itemTableObject);
		}

		jsonObj.put(DictJSONConstants.ITEM_ITEMTABLES, jsonTables);
		jsonObj.put(DictJSONConstants.ITEM_ISINITI18N, this.isInitI18n);
		
		//jsonObj.put(DictJSONConstants.ITEM_ITEMTABLE_LIST, tableArray);

		return jsonObj;

	}

	/**
	 * 从JSON对象获得对应的属性
	 * 
	 * @param jsonObj
	 *            json对象
	 * @throws StructException 结构异常
	 * @throws SerializationException 序列化异常
	 */
	@Override
	public void fromJSON(JSONObject jsonObj) throws SerializationException,JSONException {
		OID = JSONHelper.readFromJSON(jsonObj, DictJSONConstants.ITEM_OID, 0);
		itemKey = JSONHelper.readFromJSON(jsonObj,DictJSONConstants.ITEM_ITEMKEY,"");
		nodeType = JSONHelper.readFromJSON(jsonObj,
				DictJSONConstants.ITEM_NODETYPE, 0);
		// parentID = new ItemData(jsonObj.getJSONObject(DictJSONConstants.ITEM_PARENTID));
		// parentID = JSONHelper.readFromJSON(jsonObj,
		// DictJSONConstants.ITEM_PARENTID, 0);
		// status = JSONHelper.readFromJSON(jsonObj,DictJSONConstants.ITEM_STATUS, 0);
		enable = JSONHelper.readFromJSON(jsonObj,DictJSONConstants.ITEM_ENABLE, 0);

		caption = JSONHelper.readFromJSON(jsonObj,DictJSONConstants.ITEM_CAPTION,"");
		mainTableKey = JSONHelper.readFromJSON(jsonObj,DictJSONConstants.ITEM_MAINTABLEKEY,"");

		showCode =JSONHelper.readFromJSON(jsonObj,DictJSONConstants.ITEM_SHOWCODE,"");
		
		JSONObject i18n = jsonObj.optJSONObject(DictJSONConstants.ITEM_I18NCAPTION);
		if(i18n != null) {
			for(String lang : i18n.keySet()) {
				String v = i18n.optString(lang);
				if(v != null && !v.isEmpty()) {
					this.i18nCaptions.put(lang, v);
				}
			}
		}
		
		JSONObject i18nV = jsonObj.optJSONObject(DictJSONConstants.ITEM_I18NVALUES);
		if(i18nV != null) {
			for(String k : i18nV.keySet()) {
				String v = i18nV.optString(k);
				if(v != null && !v.isEmpty()) {
					this.i18nCaptions.put(k, v);
				}
			}
		}
		
		JSONObject i18ncols = jsonObj.optJSONObject(DictJSONConstants.ITEM_I18NCOLUMNS);
		if(i18ncols != null) {
			this.i18nColumns = jsonToMapList(i18ncols);
		}
		
		JSONObject jsonTables = jsonObj.getJSONObject(DictJSONConstants.ITEM_ITEMTABLES);
		itemTables.clear();

		@SuppressWarnings("unchecked")
		Iterator<String> it = jsonTables.keys();
		String key = null;
		while(it.hasNext()){
			key = it.next();
			JSONObject tableObj = jsonTables.getJSONObject(key);
			ItemTableBase table = new ItemTableBase(tableObj);
			itemTables.put(table.getKey(), table);
		}
//		for (int i = 0; i < tableArray..length(); i++) {
//			JSONObject tableObj = tableArray.getJSONObject(i);
//			ItemTableBase table = new ItemTableBase(tableObj);
//			itemTables.put(table.getKey(), table);
//		}
		this.isInitI18n = JSONHelper.readFromJSON(jsonObj,DictJSONConstants.ITEM_ISINITI18N, false);
	}
	
	private Map<String, List<String>> jsonToMapList(JSONObject jsonObj){
		 Map<String, List<String>> outerMap = new HashMap<>();
	        
	        Iterator<String> keys = jsonObj.keys();
	        while(keys.hasNext()) {
	            String key = keys.next();
	            JSONArray innerObj = jsonObj.getJSONArray(key);
	            List<String> list = new ArrayList<>();
	            for(int i = 0; i < innerObj.length(); i++) {
	            	String s = innerObj.getString(i);
	            	list.add(s);
	            }
	            outerMap.put(key, list);
	        }
	        return outerMap;
	}
	
	public void setI18nColumns(Map<String, List<String>> map) {
		this.i18nColumns = map;
	}
	
	public String toString(){
		return getItemKey()+"_"+OID;
	}
	
	public ItemData toItemData(){
		return new ItemData(getItemKey() , OID);
	}
	
	public BaseItem toBaseItem(){
		BaseItem baseItem = new BaseItem(getItemKey(), OID);
		
		baseItem.setEnable(enable);
		baseItem.setNodeType(nodeType);
		baseItem.setShowCode(showCode);
		
		ILocale defaultLocale = DefaultLocale.getDefaultLocale();
		String locale = "";
		if(defaultLocale != null) {
			locale = defaultLocale.getLocale();
		}
		
		baseItem.setCaption(this.getCaption(locale));
		
		ItemTableBase mainTableBase = itemTables.get(this.mainTableKey);
		
		if(mainTableBase != null){
			 List<ItemRow> list = mainTableBase.getRows();
			 
			 if(list != null && !list.isEmpty()){
				 List<String> columns = null;
				 if(this.i18nColumns != null) {
					 columns = i18nColumns.get(this.mainTableKey);
				 }
					
				 ItemRow row = list.get(0);
				 
				 String key = null;
				 Object value = null;
				 for(Entry<String, Object> entry :row.getEntrySet()){
					 key = entry.getKey();
					 if(columns != null && columns.contains(key)) {
						 value =  this.getI18nValue(this.mainTableKey, key, locale);
					 }else {
						 value = entry.getValue(); 
					 }
					 baseItem.setValue(key, value);
				 }
			 }
		}
		return baseItem;
	}
	
	public boolean equals(Item o){
		if(o == null){
			return false;
		}
		return toString().equalsIgnoreCase(o.toString());
	}
	
	@Override
	public int hashCode() {
		return toString().hashCode();
	}

	private void writeObject(ObjectOutputStream out) {
		try {
			out.writeUTF(this.itemKey);
			out.writeLong(OID);
			out.writeInt(nodeType);
			out.writeInt(enable);
			out.writeObject(itemTables);
			out.writeUTF(this.mainTableKey);
			out.writeUTF(this.caption);
			out.writeUTF(this.showCode);
			out.writeObject(this.i18nCaptions);
			out.writeObject(this.i18nValues);
			out.writeObject(this.i18nColumns);
			out.writeBoolean(this.isInitI18n);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

	@SuppressWarnings("unchecked")
	private void readObject(ObjectInputStream in){
		try {
			this.itemKey = in.readUTF();
			this.OID = in.readLong();
			this.nodeType = in.readInt();
			this.enable = in.readInt();
			this.itemTables = (HashMap<String, ItemTableBase>) in.readObject();
			this.mainTableKey = in.readUTF();
			this.caption = in.readUTF();
			this.showCode = in.readUTF();
			this.i18nCaptions = (Map<String, String>)in.readObject();
			this.i18nValues = (Map<String,Object>)in.readObject();
			this.i18nColumns = (Map<String,List<String>>)in.readObject();
			this.isInitI18n = in.readBoolean();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		
	}
	
	public Item clone(){
		Item i = new Item();
		i.itemKey = itemKey;
		i.OID = OID;
		i.nodeType = nodeType;
		i.enable = enable;
		i.caption = caption;
		
		Map<String, ItemTableBase> map = new HashMap<String, ItemTableBase>();
		for(ItemTableBase itb : itemTables.values()){
			map.put(itb.getKey(), itb.clone());
		}
		
		i.itemTables = map;
		i.mainTableKey = mainTableKey;
		i.showCode = showCode;
		if(this.i18nCaptions != null) {
			i.i18nCaptions = new HashMap<>();
			i.i18nCaptions.putAll(i18nCaptions);
		}
		
		if(this.i18nValues != null) {
			i.i18nValues = new HashMap<>();
			i.i18nValues.putAll(i18nValues);
		}
		
		if(this.i18nColumns != null) {
			i.i18nColumns = new HashMap<>();
			i.i18nColumns.putAll(this.i18nColumns);
		}
		i.isInitI18n = this.isInitI18n;
		return i;
	}
}
