package com.bokesoft.yigo.bpm;

import com.bokesoft.yes.bpm.common.exception.BPMError;
import com.bokesoft.yes.bpm.engine.common.BPMUtil;
import com.bokesoft.yes.bpm.engine.common.Result;
import com.bokesoft.yes.bpm.engine.instance.BPMInstance;
import com.bokesoft.yes.bpm.engine.instance.BPMInstanceFactory;
import com.bokesoft.yes.bpm.engine.instance.CreateNodeUtil;
import com.bokesoft.yes.bpm.engine.instance.VirtualInstance;
import com.bokesoft.yes.bpm.engine.node.ExecComplexJoin;
import com.bokesoft.yes.bpm.engine.node.ExecExclusiveFork;
import com.bokesoft.yes.bpm.engine.node.ExecInline;
import com.bokesoft.yes.bpm.engine.node.ExecJoin;
import com.bokesoft.yes.bpm.engine.node.ExecNode;
import com.bokesoft.yes.bpm.engine.node.ExecUserTask;
import com.bokesoft.yes.bpm.engine.util.ProcessUtil;
import com.bokesoft.yes.bpm.interpreter.INode;
import com.bokesoft.yes.bpm.interpreter.defaultproxy.DefaultProxy;
import com.bokesoft.yes.bpm.meta.transform.ManualTransferInfo;
import com.bokesoft.yes.bpm.workitem.Workitem;
import com.bokesoft.yes.bpm.workitem.WorkitemUtil;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.common.def.SystemID;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.meta.bpm.process.node.MetaNode;

/**
 * 人工干预流程，将指定节点的工作项提交并转移到其他节点
 * @author wbh
 *
 */
public class ManualTransferToNode {
	/** 干预信息*/
	private ManualTransferInfo info = null;
	
	/**
	 * 构造函数
	 * @param workitemID 工作项ID
	 * @param tgtNodeID 转移的目标节点
	 * @param auditResult 审批结果
	 * @param userInfo 审批意见
	 * @param lock 转移到目标节点后是否锁定后继工作项
	 */
	public ManualTransferToNode(long workitemID, int tgtNodeID, int auditResult, String userInfo, boolean lock) {
		info = new ManualTransferInfo();
		info.setWorkitemID(workitemID);
		info.setTransferTo(tgtNodeID);
		info.setAuditResult(auditResult);
		info.setUserInfo(userInfo);
		info.setLock(lock);
	}
	/**
	 * 构造函数
	 * @param instanceID 流程实例ID
	 * @param nodeID 节点ID
	 * @param tgtNodeID 转移的目标节点ID
	 * @param auditResult 审批结果
	 * @param userInfo 审批意见
	 * @param lock 转移到目标节点后是否锁定后继工作项
	 */
	public ManualTransferToNode(long instanceID, int nodeID, int tgtNodeID, int auditResult, String userInfo, boolean lock) {
		info = new ManualTransferInfo();
		info.setInstanceID(instanceID);
		info.setNodeID(nodeID);
		info.setTransferTo(tgtNodeID);
		info.setAuditResult(auditResult);
		info.setUserInfo(userInfo);
	}
	/**
	 * 执行操作，需要调用者自己做事务处理
	 * @param context
	 * @throws Throwable
	 */
	public void transfer(BPMContext context)throws Throwable{
		if (info == null) {
			return;
		}
		
		//获取流程实例
		long instanceID = info.getInstanceID();
		long workitemID = info.getWorkitemID();
		Workitem wi = null;
		if (workitemID > 0) {
			wi = loadWorkitem(context, workitemID);
			instanceID = wi.getInstanceID();
		}
		context = BPMContext.getBPMContext(context, instanceID);
		context.setUpdateWorkitem(wi);
		
		BPMInstance instance = BPMInstanceFactory.getBPMInstance(context, instanceID);
		if (instance == null) {
			return ;
		}
		
		//权限检查
		MetaProcess process = BPMUtil.getProcessByInstance(context, instance);
		String processKey = process.getKey();
		int verID = process.getVersion();
		long srcOpt = info.getSrcOperator() > 0 ? info.getSrcOperator() : context.getCurUserID();
		if (srcOpt > 0) {
			context.setSrcOperator(srcOpt);
		}
		boolean flag = false;
		//TODO 是否允许自定义
		// 默认只有管理员可以操作
		if (!flag) {
			if (srcOpt != SystemID.AdminOperatorID && !ProcessUtil.isProcessAdministrator(context, srcOpt, processKey, verID)) {
				throw BPMError.getBPMError(context.getEnv(), BPMError.COMMIT_RIGHT_ERROR);
			}
		}
		
		
		//获取转移目标节点
		int tgtNodeID =info.getTransferTo();
		
		
		//获取当前节点
		int nodeID = wi == null ? info.getNodeID() : wi.getNodeID();
		int inlineNodeID = wi == null ? info.getInlineNodeID() : wi.getInlineNodeID(); 
		
		ExecNode node = instance.getNodeByID(inlineNodeID, nodeID);
		
		
		//提交节点上的所有未完成工作项
		node.manualTransfer(context, info);
		
		//进入目标节点
		ExecNode tgtNode = null;
		try {
			tgtNode = instance.getNodeByID(-1, tgtNodeID);
		}catch(Throwable e) {
			tgtNode = createNode(instance.getMainInstance(), tgtNodeID, node, context);
		}
		
		if (tgtNode != null) {
			tgtNode.input(context);
		}
		
		// 是否锁定后继工作项
		if (info.isLock()) {
			WorkitemUtil.lockWorkitem(context, tgtNodeID, instanceID, process);
		}
		
		context.getInstanceDataContainer().save();
	}
	
	private ExecNode createNode(VirtualInstance virtualInstance, int tgtNodeID, ExecNode node, BPMContext context) throws Throwable {
		MetaNode metaNode = virtualInstance.getMetaNodeByID(tgtNodeID);
		CreateNodeUtil createNodeUtil = new CreateNodeUtil(context, virtualInstance);
		ExecNode tNode = createNodeUtil.createNode(metaNode);
		createNodeUtil.handleExclusiveFork(node, tNode);
		createNodeUtil.handleJoin(node, tNode);
		return tNode;
	}	
	
	private Workitem loadWorkitem(BPMContext context, long wid) throws Throwable {
		Workitem workitem = WorkitemUtil.loadWorkitem(context, wid);
		if (workitem == null)
			return null;
		workitem.setAuditResult(info.getAuditResult());
		workitem.setUserInfo(info.getUserInfo());
		workitem.setResultInfo(Result.parseToString(info.getAuditResult()));
		return workitem;
	}
}
