/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.bpm;

import com.bokesoft.yes.bpm.engine.instance.BPMInstance;
import com.bokesoft.yes.bpm.engine.instance.BPMInstanceFactory;
import com.bokesoft.yes.bpm.meta.transform.PPObject;
import com.bokesoft.yes.bpm.workitem.Workitem;
import com.bokesoft.yes.bpm.workitem.WorkitemUtil;
import com.bokesoft.yigo.bpm.common.BPMContext;
import java.util.List;

public class BatchTransferTask {
    private Long workitemID = -1L;
    private PPObject ppObject = null;
    private boolean createRecord = false;
    private String userinfo = "";
    private int auditResult = -1;
    private long srcOperator = 0L;
    private int transferType = -1;

    public BatchTransferTask(long l2, List<Long> list) {
        this.workitemID = l2;
        this.ppObject = new PPObject(list);
    }

    public BatchTransferTask(long l2, List<Long> list, boolean bl, String string, int n2, long l3, int n3) {
        this.workitemID = l2;
        this.ppObject = new PPObject(list);
        this.createRecord = bl;
        this.userinfo = string;
        this.auditResult = n2;
        this.srcOperator = l3;
        this.transferType = n3;
    }

    public void transfer(BPMContext bPMContext) throws Throwable {
        Workitem workitem = WorkitemUtil.loadWorkitem(bPMContext, this.workitemID);
        if (workitem == null) {
            return;
        }
        bPMContext = BPMContext.getBPMContext(bPMContext, workitem.getInstanceID());
        bPMContext.setUpdateWorkitem(workitem);
        if (this.createRecord) {
            workitem.setWorkItemState(2);
            workitem.setAuditResult(this.auditResult);
            workitem.setUserInfo(this.userinfo);
        } else {
            workitem.setWorkItemState(1);
        }
        workitem.setTransferType(this.transferType);
        BPMInstance bPMInstance = BPMInstanceFactory.getBPMInstance(bPMContext, workitem.getInstanceID());
        if (bPMInstance != null) {
            bPMContext.setSrcOperator(this.srcOperator);
            bPMInstance.getNodeByID(workitem.getInlineNodeID(), workitem.getNodeID()).batchTransferTask(bPMContext, this.ppObject, this.createRecord);
        }
        bPMContext.getInstanceDataContainer().save();
    }

    public boolean isCreateRecord() {
        return this.createRecord;
    }

    public void setCreateRecord(boolean bl) {
        this.createRecord = bl;
    }

    public String getUserinfo() {
        return this.userinfo;
    }

    public void setUserinfo(String string) {
        this.userinfo = string;
    }

    public int getAuditResult() {
        return this.auditResult;
    }

    public void setAuditResult(int n2) {
        this.auditResult = n2;
    }

    public long getSrcOperator() {
        return this.srcOperator;
    }

    public void setSrcOperator(long l2) {
        this.srcOperator = l2;
    }

    public int getTransferType() {
        return this.transferType;
    }

    public void setTransferType(int n2) {
        this.transferType = n2;
    }
}

