package com.bokesoft.yigo.bpm;

import com.bokesoft.yes.bpm.engine.data.row.RDirectTransition;
import com.bokesoft.yes.bpm.engine.data.table.TDirectTransition;
import com.bokesoft.yes.bpm.engine.data.virtual.table.VTDirectTransition;
import com.bokesoft.yes.bpm.engine.instance.BPMInstance;
import com.bokesoft.yes.bpm.engine.instance.BPMInstanceFactory;
import com.bokesoft.yes.bpm.engine.node.ExecNode;
import com.bokesoft.yes.struct.abstractdatatable.RowState;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaTableTrigger;
import com.bokesoft.yigo.meta.bpm.process.node.MetaAudit;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.service.IServiceProcess;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.document.track.TrackDetail;

public class DirectAuditCheckProcess implements IServiceProcess<DefaultContext> {

	@Override
	public void process(DefaultContext context) throws Throwable {
		Document doc = context.getDocument();
		if (doc.isNew())
			return;
		boolean modifyCheck = doc.getDocumentTrack().contains(TrackDetail.FROM_UI, "") && !doc.getDocumentTrack().contains(TrackDetail.MID_SAVE, "");
		if (modifyCheck) {
			boolean needDataSave = false;
			BPMContext BPMContext = new BPMContext(context);
			BPMInstance instance = BPMInstanceFactory.getBPMInstanceByOID(BPMContext, doc.getOID(), true);
			if (instance == null)
				return;
			TDirectTransition dt = instance.getInstanceData().getDirectTransition();
			dt.load(context.getDBManager());
			for(RDirectTransition rDirectTransition : dt) {
				VTDirectTransition vTDirectTransition = dt.getVTDirectTransitionMap().get(rDirectTransition.getInlineNodeID());
				vTDirectTransition.internalAddRow(rDirectTransition);
			}
			for (RDirectTransition data : dt.visableRows()) {
				if (checkDataChanged(data, instance, doc)) {
					data.setDeleted();
					needDataSave = true;
				}
			}
			if (needDataSave)
				BPMContext.getInstanceDataContainer().save();
		}
	}

	private boolean checkDataChanged(RDirectTransition data, BPMInstance instance, Document doc) {
		ExecNode node = instance.getNodeByID(data.getInlineNodeID(), data.getNodeID());
		MetaAudit audit = (MetaAudit) node.getNodeModel();
		for (MetaTableTrigger mt : audit.getDirectAuditCondition()) {
			DataTable table = doc.get(mt.getKey());
			if (table != null && !table.isEmpty() && mt.getColumnKeyList().size() > 0) {
				table.beforeFirst();
				while (table.next()) {
					if (table.getState() == RowState.MODIFIED) {
						for (String ck : mt.getColumnKeyList()) {
							if (table.getMetaData().getColumnInfo(ck).getDataTypeAction().compare(table.getObject(ck), table.getOriginalObject(ck)) != 0) {
								return true;
							}
						}
					}
				}
			}
		}
		return false;
	}

}
