package com.bokesoft.yes.bpm.extend.service;

import com.bokesoft.yes.bpm.common.exception.BPMError;
import com.bokesoft.yes.bpm.engine.instance.BPMInstance;
import com.bokesoft.yes.bpm.engine.instance.BPMInstanceFactory;
import com.bokesoft.yes.bpm.engine.node.ExecNode;
import com.bokesoft.yes.bpm.engine.node.ExecUserTask;
import com.bokesoft.yes.bpm.engine.util.ProcessUtil;
import com.bokesoft.yes.bpm.service.cmd.BPMServiceCmd;
import com.bokesoft.yes.bpm.workitem.Workitem;
import com.bokesoft.yes.bpm.workitem.WorkitemState;
import com.bokesoft.yes.bpm.workitem.WorkitemUtil;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.common.util.TypeConvertor;

public class TransferTaskCmd extends BPMServiceCmd {

	public static final String TAG = "TransferTask";

	private Long workitemID;

	private Long operatorID;

	private boolean createRecord;
	
	private String userinfo;
	
	private int auditResult;
	
	private long srcOperator;
	
	private int transferType;

	public TransferTaskCmd(Long wID, Long operatorID, boolean createRecord, String userinfo, int auditResult) {
		workitemID = wID;
		this.operatorID = operatorID;
		this.createRecord = createRecord;
		this.userinfo = userinfo;
		this.auditResult = auditResult;
	}

	public TransferTaskCmd() {
	}

	@Override
	public void dealArguments(BPMContext context, StringHashMap<Object> arguments) throws Throwable {
		workitemID = TypeConvertor.toLong(arguments.get("WorkitemID"));
		operatorID = TypeConvertor.toLong(arguments.get("OperatorID"));
		createRecord = TypeConvertor.toBoolean(arguments.get("CreateRecord"));
		userinfo = TypeConvertor.toString(arguments.get("UserInfo"));
		auditResult = TypeConvertor.toInteger(arguments.get("AuditResult"));
		srcOperator = TypeConvertor.toLong(arguments.get("SrcOpt"));
		transferType = TypeConvertor.toInteger(arguments.get("TransferType"));
	}

	public String getCmd() {
		return "";
	}

	@Override
	public Object doCmd(BPMContext context) throws Throwable {
		Workitem workitem = WorkitemUtil.loadWorkitem(context, workitemID);
		if (workitem == null)
			return "";
		long optID = srcOperator > 0?srcOperator:context.getCurUserID();
		
		context = BPMContext.getBPMContext(context, workitem.getInstanceID());
		context.setUpdateWorkitem(workitem);
		BPMInstance instance = BPMInstanceFactory.getBPMInstance(context, workitem.getInstanceID());
		if (null == instance)
			throw BPMError.getBPMError(context.getEnv(), BPMError.NO_INSTANCE_DATA);
		String processKey = instance.getInstanceData().getInstance().getData().getProcessKey();
		int verID = instance.getInstanceData().getInstance().getData().getVerID();
		if (!workitem.getParticipatorList().contains(optID) && !ProcessUtil.isProcessAdministrator(context, optID, processKey, verID)) {
			throw BPMError.getBPMError(context.getEnv(), BPMError.COMMIT_RIGHT_ERROR);
		}
		if (createRecord) {
			workitem.setWorkItemState(WorkitemState.FINISH);
			workitem.setAuditResult(auditResult);
			workitem.setUserInfo(userinfo);
		} else {
			workitem.setWorkItemState(WorkitemState.NEW);
		}
		workitem.setTransferType(transferType);
		
		context.setSrcOperator(srcOperator);
		ExecNode node = instance.getNodeByID(workitem.getInlineNodeID(), workitem.getNodeID());
		node.transferTask(context, operatorID, createRecord);
		
		context.getInstanceDataContainer().save();
		return null;
	}

	public int getTransferType() {
		return transferType;
	}

	public void setTransferType(int transferType) {
		this.transferType = transferType;
	}

	public void setSrcOperator(long srcOperator) {
		this.srcOperator = srcOperator;
	}
	@Override
	public IServiceCmd<BPMContext> newInstance() {
		return new TransferTaskCmd();
	}

}
