package com.bokesoft.yes.bpm.extend.service;

import java.util.HashMap;

import com.bokesoft.yes.bpm.service.cmd.RefuseTaskCmd;
import com.bokesoft.yes.mid.base.IMidVEFactory;
import com.bokesoft.yes.mid.base.IServiceEnvData;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.service.GeneralService;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.mid.base.IServiceContext;
import com.bokesoft.yigo.mid.service.IServiceProvider;

public class BPMExtendService extends GeneralService<BPMContext> {
	@Override
	public String getServiceName() {
		return "BPMExtendService";
	}
	
	@Override
	protected Object[][] getCmdImplTable() {
		return new Object[][] { 
			{ "EndorseTask", new EndorseTaskCmd() }, 
			{ "LaunchTask", new LaunchTaskCmd() }, 
			{ "TransferTask", new TransferTaskCmd() }, 
			{ "RefuseTask", new RefuseTaskCmd() },
			{ "BatchEndorseTask", new BatchEndorseTaskCmd()}
		};
	}

	@Override
	protected IServiceCmd<BPMContext> getDefaultImpl() {
		return null;
	}

	@Override
	public void dealWithEnv(BPMContext context, String cmd, IServiceEnvData data) throws Throwable {
	}

	@Override
	public void dealWithResult(BPMContext context, String cmd, Object result) throws Throwable {
	}

	@SuppressWarnings("unchecked")
	@Override
	public IServiceCmd<BPMContext> getPrototype(BPMContext context, String cmd) {
		return (IServiceCmd<BPMContext>) BPMExtendService.prototype.get(cmd);
	}

	private static HashMap<String, IServiceCmd<?>> prototype = null;
	static {
		BPMExtendService.prototype = new HashMap<String, IServiceCmd<?>>();
		GeneralService.initPrototype(BPMExtendService.prototype, new BPMExtendService());
	}

	@Override
	public IServiceContext newServiceContext(IMidVEFactory veFactory) throws Throwable {
		return new BPMContext(veFactory.createVE());
	}

	@Override
	public IServiceProvider<BPMContext> newInstance() {
		return new BPMExtendService();
	}

}
