package com.bokesoft.yes.bpm.meta.transform.graph;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yigo.common.json.JSONSerializable;

public class TransBPMPath implements JSONSerializable{
	
	private LinkedHashMap<Integer, TransBPMPathNode> map = null;
	
	private ArrayList<Integer> last = null;
	
	public TransBPMPath() {
		map = new LinkedHashMap<Integer, TransBPMPathNode>();
		last = new ArrayList<Integer>();
	}
	
	public void add(int stepID, int source, int target) {
		map.put(stepID, new TransBPMPathNode(stepID, source, target));
	}
	
	public void addl(Integer nodeID) {
		last.add(nodeID);
	}

	public ArrayList<Integer> getLast(){
		return last;
	}
	@Override
	public JSONObject toJSON() throws Throwable {
		JSONObject json = new JSONObject();
		JSONArray jsonArray = new JSONArray();
		for(Map.Entry<Integer, TransBPMPathNode> entry : map.entrySet()) {
			jsonArray.put(entry.getValue().toJSON());
		}
		JSONArray jsonArray2 = new JSONArray();
		for(Integer i : last) {
			jsonArray2.put(i);
		}
		json.put("steps", jsonArray);
		json.put("last", jsonArray2);
		return json;
	}

	@Override
	public void fromJSON(JSONObject jsonObj) throws Throwable {
		JSONArray jsonArray = jsonObj.getJSONArray("steps");
		for ( int i = 0, size = jsonArray.length(); i<size; ++i ) {
			JSONObject json = jsonArray.getJSONObject(i);
			TransBPMPathNode node = new TransBPMPathNode();
			node.fromJSON(json);
			map.put(node.stepID, node);
		}
		JSONArray jsonArray2 = jsonObj.getJSONArray("last");
		for ( int i = 0, size = jsonArray2.length(); i<size; ++i ) {
			Object json2 = jsonArray2.get(i);
			Integer value = new Integer(json2.toString());
			last.add(value);
		}
	}
	
	public boolean containPath(int source, int target) {
		TransBPMPathNode node = null;
		for( Map.Entry<Integer, TransBPMPathNode> entry: map.entrySet()) {
			node = entry.getValue();
			if (node.source == source && node.target == target) {
				return true;
			}
		}
		return false;
	}

	public LinkedHashMap<Integer, TransBPMPathNode> getPathMap() {
		return map;
	}
	
//	public TransBPMPathNode getLast() {
//		TransBPMPathNode node = null;
//		for( Map.Entry<Integer, TransBPMPathNode> entry: map.entrySet()) {
//			node = entry.getValue();
//		}
//		return node;
//	}
	
}
