package com.bokesoft.yes.bpm.meta.transform;

import java.util.ArrayList;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yigo.common.json.JSONSerializable;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaBPMOperation;

/**
 * 工作项信息的传输信息
 * 
 * @author 刘翔翔
 *
 */
public class WorkitemInfo implements JSONSerializable {
	
	/** 新增状态*/
	public static final int NEW = 1;
	/** 完成状态*/
	public static final int FINISH = 2;

	// 用于构造界面操作的属性
	/** 工作项编号 */
	private Long workitemID = -1L;
	/** 实例编号 */
	private Long instanceID = -1l;
	/** 单据编号 */
	private Long OID = -1l;
	/** 嵌入节点的ID */
	private Integer inlineNodeID = -1;
	/** 节点的ID */
	private Integer nodeID = -1;
	/** 工作项状态*/
	private Integer state = -1;
	/** 驳回位置*/
	private String backSite = "";
	/**
	 * 驳回相应位置的操作员
	 */
	private Long backSiteOpt=-1L;
	
	private long srcOperator = -1l;
	/** 表单的KEY */
	private String formKey = "";
	/** 反向模板的KEY*/
	private String templateKey = "";
	
	private Boolean ignoreFormState = null;
	/** 直送后是否保持原操作员，默认为false*/
	private boolean keepParts = false;
	/** 工作项对应需要添加的界面操作 */
	private ArrayList<MetaBPMOperation> operationList = new ArrayList<MetaBPMOperation>();

	// 附件的信息
	/** 附件的OID */
	private Long attachmentOID = -1L;
	/** 附件的类型 */
	private int attachmentType = -1;
	/** 附件的信息 */
	private String attachmentInfo = "";
	/** 附件的打开参数 */
	private String attachmentPara = "";
	/** 附件的打开参数 */
	private String attachmentKey = "";
	/** 附件的操作类型 */
	private int attachmentOperateType=-1;

	// 用于提交工作项的属性
	private Integer auditResult = -1;

	private String userInfo = "";

	private String operationKey = "";

	private String nextOpStr = "";
	
	private int status = -1;
	/** 驳回后是否允许直送*/
	private boolean allowTransit = true;
	/** 操作类型，默认为正常提交*/
	private int operationType = BPMOperationType.OPT_COMMIT;
	/** 任意跳转位置*/
	private Integer straightSite = -1;
	
	private long endorserID = 0;

	@Override
	public void fromJSON(JSONObject json) throws SerializationException {
		OID = json.getLong("OID");
		inlineNodeID = json.getInt("InlineNodeID");
		nodeID = json.getInt("NodeID");
		formKey = json.getString("FormKey");
		workitemID = json.getLong("WorkitemID");
		instanceID = json.getLong("InstanceID");
		state = json.optInt("State");

		attachmentOID = json.getLong("AttachmentOID");
		attachmentType = json.getInt("AttachmentType");
		attachmentInfo = json.getString("AttachmentInfo");
		attachmentPara = json.getString("AttachmentPara");
		attachmentKey = json.getString("AttachmentKey");
		attachmentOperateType = json.getInt("AttachmentOperateType");

		if (json.has("EndorserID")) {
			endorserID = json.getLong("EndorserID");
		}
		JSONArray ja = json.getJSONArray("ItemList");
		operationList.clear();
		for (int i = 0; i < ja.length(); i++) {
			MetaBPMOperation item = new MetaBPMOperation();
			item.fromJSON(ja.getJSONObject(i));
			operationList.add(item);
		}

		auditResult = json.getInt("AuditResult");
		userInfo = json.optString("UserInfo");
		operationKey = json.getString("OperationKey");
		nextOpStr = json.getString("NextOpStr");
		if (json.has("BackSite")) {
			backSite = json.getString("BackSite");
			if(json.has("BackSiteOpt"))
				backSiteOpt=json.getLong("BackSiteOpt");
		}
		if (json.has("TemplateKey")) {
			templateKey = json.getString("TemplateKey");
		}
		if (json.has("IgnoreFormState")) {
			ignoreFormState = json.getBoolean("IgnoreFormState");
		}
		if (json.has("KeepParts")) {
			keepParts = json.getBoolean("KeepParts");
		}
		if (json.has("Status")) {
			status = json.getInt("Status");
		}
		if (json.has("SrcOperator")) {
			srcOperator = json.getLong("SrcOperator");
		}
		if (json.has("AllowTransit")) {
			allowTransit = json.getBoolean("AllowTransit");
		}
		if (json.has("OperationType")) {
			operationType = json.getInt("OperationType");
		}
		if (json.has("StraightSite")) {
			straightSite = json.getInt("StraightSite");
		}
		
	}

	public JSONObject toJSON() throws SerializationException {
		JSONObject workitemObj = new JSONObject();
		workitemObj.put("OID", OID);
		workitemObj.put("InlineNodeID", inlineNodeID);
		workitemObj.put("NodeID", nodeID);
		workitemObj.put("FormKey", formKey);
		workitemObj.put("WorkitemID", workitemID);
		workitemObj.put("InstanceID", instanceID);
		workitemObj.put("State", state);

		workitemObj.put("AttachmentOID", attachmentOID);
		workitemObj.put("AttachmentType", attachmentType);
		workitemObj.put("AttachmentInfo", attachmentInfo);
		workitemObj.put("AttachmentPara", attachmentPara);
		workitemObj.put("AttachmentKey", attachmentKey);
		workitemObj.put("AttachmentOperateType", attachmentOperateType);

		JSONArray ja = new JSONArray();
		workitemObj.put("ItemList", ja);
		for (int i = 0; i < operationList.size(); i++) {
			JSONObject item = operationList.get(i).toJSON();
			ja.put(item);
		}

		workitemObj.put("AuditResult", auditResult);
		workitemObj.put("UserInfo", userInfo);
		workitemObj.put("OperationKey", operationKey);
		workitemObj.put("NextOpStr", nextOpStr);
		workitemObj.put("BackSite", backSite);
		workitemObj.put("BackSiteOpt", backSiteOpt);
		workitemObj.put("TemplateKey", templateKey);
		workitemObj.put("IgnoreFormState", ignoreFormState);
		workitemObj.put("KeepParts", keepParts);
		workitemObj.put("Status", status);
		workitemObj.put("SrcOperator", srcOperator);
		workitemObj.put("AllowTransit", allowTransit);
		workitemObj.put("OperationType", operationType);
		workitemObj.put("StraightSite", straightSite);
		return workitemObj;
	}

	public Long getOID() {
		return OID;
	}

	public void setOID(Long oID) {
		OID = oID;
	}

	public String getFormKey() {
		return formKey;
	}

	public void setFormKey(String formKey) {
		this.formKey = formKey;
	}
	
	public Integer getState() {
		return state;
	}
	
	public void setState(Integer state) {
		this.state = state;
	}
	
	public String getTemplateKey() {
		return templateKey;
	}
	
	public void setTemplateKey(String templateKey) {
		this.templateKey = templateKey;
	}
	
	public Boolean getIgnoreFormState() {
		return ignoreFormState;
	}
	
	public void setIgnoreFormState(Boolean ignoreFormState) {
		this.ignoreFormState = ignoreFormState;
	}
	
	public void setKeepParts(boolean keepParts) {
		this.keepParts = keepParts;
	}
	
	public boolean getKeepParts() {
		return this.keepParts;
	}

	public ArrayList<MetaBPMOperation> getOperationList() {
		return operationList;
	}

	public Long getWorkitemID() {
		return workitemID;
	}

	public void setWorkitemID(Long workitemID) {
		this.workitemID = workitemID;
	}

	public Integer getAuditResult() {
		return auditResult;
	}

	public void setAuditResult(Integer auditResult) {
		this.auditResult = auditResult;
	}

	public String getUserInfo() {
		return userInfo;
	}

	public Long getInstanceID() {
		return instanceID;
	}

	public void setInstanceID(Long instanceID) {
		this.instanceID = instanceID;
	}

	public void setUserInfo(String userInfo) {
		this.userInfo = userInfo;
	}

	public Integer getInlineNodeID() {
		return inlineNodeID;
	}

	public void setInlineNodeID(Integer inlineNodeID) {
		this.inlineNodeID = inlineNodeID;
	}

	public Integer getNodeID() {
		return nodeID;
	}

	public void setNodeID(Integer nodeID) {
		this.nodeID = nodeID;
	}

	public String getBackSite() {
		return backSite;
	}
	
	public void setBackSite(String directSite) {
		this.backSite = directSite;
	}

	public String getOperationKey() {
		return operationKey;
	}

	public void setOperationKey(String operationKey) {
		this.operationKey = operationKey;
	}

	public String getNextOpStr() {
		return nextOpStr;
	}

	public void setNextOpStr(String nextOpStr) {
		this.nextOpStr = nextOpStr;
	}
	
	public int getStatus() {
		return status;
	}
	
	public void setStatus(int status) {
		this.status = status;
	}

	public Long getAttachmentOID() {
		return attachmentOID;
	}

	public void setAttachmentOID(Long attachmentOID) {
		this.attachmentOID = attachmentOID;
	}

	public String getAttachmentInfo() {
		return attachmentInfo;
	}

	public void setAttachmentInfo(String attachmentInfo) {
		this.attachmentInfo = attachmentInfo;
	}

	public String getAttachmentPara() {
		return attachmentPara;
	}

	public void setAttachmentPara(String attachmentPara) {
		this.attachmentPara = attachmentPara;
	}

	public int getAttachmentType() {
		return attachmentType;
	}

	public void setAttachmentType(int attachmentType) {
		this.attachmentType = attachmentType;
	}

	public int getAttachmentOperateType() {
		return attachmentOperateType;
	}

	public void setAttachmentOperateType(int attachmentOperateType) {
		this.attachmentOperateType = attachmentOperateType;
	}

	public String getAttachmentKey() {
		return attachmentKey;
	}

	public void setAttachmentKey(String attachmentKey) {
		this.attachmentKey = attachmentKey;
	}

	public Long getBackSiteOpt() {
		return backSiteOpt;
	}

	public void setBackSiteOpt(Long backSiteOpt) {
		this.backSiteOpt = backSiteOpt;
	}

	public long getSrcOperator() {
		return srcOperator;
	}
	
	public void setSrcOperator(long srcOperator) {
		this.srcOperator = srcOperator;
	}

	public boolean isAllowTransit() {
		return allowTransit;
	}

	public void setAllowTransit(boolean allowTransit) {
		this.allowTransit = allowTransit;
	}

	/**
	 * @return the operationType
	 */
	public int getOperationType() {
		return operationType;
	}

	/**
	 * @param operationType the operationType to set
	 */
	public void setOperationType(int operationType) {
		this.operationType = operationType;
	}
	
	public void setStraightSite(Integer straightSite) {
		this.straightSite = straightSite;
	}
	
	public Integer getStraightSite() {
		return straightSite;
	}
	
	public long getEndorserID() {
		return endorserID;
	}

	public void setEndorserID(long endorserID) {
		this.endorserID = endorserID;
	}
}
