package com.bokesoft.yes.bpm.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/**
 * BPM流程最简模型
 */

public class BPMProcessModel {

	/** 标识 */
	private String key = "";
	/** 节点集合，Key为节点id */
	private Map<Integer, BPMNodeModel> nodes = new HashMap<Integer, BPMNodeModel>();
	/** 起始节点ID */
	private int beginNodeID;
	/** 版本号 */
	private int version = 1;

	/**
	 * 取得标识
	 * 
	 * @return 标识
	 */
	public String getKey() {
		return key;
	}

	/**
	 * 设置标识
	 * 
	 * @param key 标识
	 */
	public void setKey(String key) {
		this.key = key;
	}

	/**
	 * 取得节点
	 * 
	 * @param id 节点id
	 * @return 节点
	 */
	public BPMNodeModel getNode(int id) {
		return nodes.get(id);
	}

	/**
	 * 添加节点
	 * 
	 * @param node 节点
	 */
	public void addNode(BPMNodeModel node) {
		nodes.put(node.getID(), node);
	}

	/**
	 * 取得节点集合
	 * 
	 * @return 节点集合
	 */
	public Collection<BPMNodeModel> getNodes() {
		return nodes.values();
	}

	/**
	 * 取得起始节点ID
	 * 
	 * @return 起始节点ID
	 */
	public int getBeginNodeID() {
		return beginNodeID;
	}

	/**
	 * 设置起始节点ID
	 * 
	 * @param beginNodeID 起始节点ID
	 */
	public void setBeginNodeID(int beginNodeID) {
		this.beginNodeID = beginNodeID;
	}

	/**
	 * 取得版本号
	 * 
	 * @return 版本号
	 */
	public int getVersion() {
		return version;
	}

	/**
	 * 设置版本号
	 * 
	 * @param version 版本号
	 */
	public void setVersion(int version) {
		this.version = version;
	}
}
