package com.bokesoft.yes.bpm.meta.transform.graph;

import java.util.ArrayList;
import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMAnchor;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMAudit;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMBegin;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMBranchEnd;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMComplexJoin;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMCountersign;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMDataMap;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMDecision;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMEnd;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMEvent;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMExclusiveFork;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMExclusiveJoin;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMFork;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMGateWay;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMInline;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMJoin;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMManualTask;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMMessageReceive;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMMessageSend;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMMultiAudit;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMMultiUserTask;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMNode;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMObject;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMServiceTask;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMState;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMStateAction;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMSubProcess;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMSwimline;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMTimer;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMUserTask;
import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yigo.common.json.JSONSerializable;

/**
 * BPMGraph定义视图端的流程图展示定义，主要用于统一普通应用程序和web应用程序对流程图的展示，但不包括设计状态的流程图
 * 
 * @author 王元和
 *
 */
public class TransBPMGraph implements JSONSerializable {
	/** 流程的KEY */
	private String key = "";

	/** 流程的名称 */
	private String caption = "";

	/** 流程的版本 */
	private int version = 1;

	/** 节点的集合 */
	private ArrayList<TransBPMNode> nodeArray = null;

	/** 泳道的集合 */
	private ArrayList<TransBPMSwimline> swimArray = null;

	/** 前流程流转路径 */
	private TransBPMPath path = null;

	public TransBPMGraph() {
		super();
	}

	/**
	 * 设置流程KEY
	 * 
	 * @param key
	 *            流程KEY
	 */
	public void setKey(String key) {
		this.key = key;
	}

	/**
	 * 取得流程KEY
	 * 
	 * @return 流程KEY
	 */
	public String getKey() {
		return this.key;
	}

	/**
	 * 设置流程名称
	 * 
	 * @param caption
	 *            流程名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}

	/**
	 * 取得流程名称
	 * 
	 * @return 流程名称
	 */
	public String getCaption() {
		return this.caption;
	}

	/**
	 * 设置流程版本
	 * 
	 * @param version
	 *            流程版本
	 */
	public void setVersion(int version) {
		this.version = version;
	}

	/**
	 * 取得流程版本
	 * 
	 * @return 流程版本
	 */
	public int getVersion() {
		return this.version;
	}

	/**
	 * 清加节点
	 * 
	 * @param node
	 *            节点
	 */
	public void addNode(TransBPMNode node) {
		if (this.nodeArray == null) {
			this.nodeArray = new ArrayList<TransBPMNode>();
		}
		this.nodeArray.add(node);
	}

	/**
	 * 取得节点数量
	 * 
	 * @return 节点数量
	 */
	public int getNodeCount() {
		return this.nodeArray == null ? 0 : this.nodeArray.size();
	}

	/**
	 * 取得指定序号的节点
	 * 
	 * @param index
	 *            序号
	 * @return index所指位置的节点
	 */
	public TransBPMNode getNode(int index) {
		return this.nodeArray.get(index);
	}

	/**
	 * 返回节点的迭代器
	 * 
	 * @return 节点迭代器
	 */
	public Iterator<TransBPMNode> iteratorNode() {
		return this.nodeArray.iterator();
	}

	/**
	 * 返回泳道的迭代器
	 * 
	 * @return 泳道迭代器
	 */
	public Iterator<TransBPMSwimline> iteratorSwim() {
		if (swimArray != null) {
			return this.swimArray.iterator();
		}
		return null;
	}

	/**
	 * 添加泳道
	 * 
	 * @param swim
	 *            泳道
	 */
	public void addSwim(TransBPMSwimline swim) {
		if (this.swimArray == null) {
			this.swimArray = new ArrayList<TransBPMSwimline>();
		}
		this.swimArray.add(swim);
	}

	/**
	 * 设置当前流程流转路径
	 * 
	 * @param path
	 */
	public void setTransPath(TransBPMPath path) {
		this.path = path;
	}

	/**
	 * 获取当前流程流转路径
	 * 
	 * @param path
	 */
	public TransBPMPath getTransPath() {
		return this.path;
	}

	public static final String tag_key = "key";
	public static final String tag_caption = "caption";
	public static final String tag_version = "version";
	public static final String tag_nodes = "nodes";
	public static final String tag_swims = "swims";

	private TransBPMNode createNode(String tagName) {
		TransBPMNode node = null;
		if (TransBPMAudit.TAG_NAME.equals(tagName)) {
			node = new TransBPMAudit();
		} else if (TransBPMBegin.TAG_NAME.equals(tagName)) {
			node = new TransBPMBegin();
		} else if (TransBPMBranchEnd.TAG_NAME.equals(tagName)) {
			node = new TransBPMBranchEnd();
		} else if (TransBPMComplexJoin.TAG_NAME.equals(tagName)) {
			node = new TransBPMComplexJoin();
		} else if (TransBPMCountersign.TAG_NAME.equals(tagName)) {
			node = new TransBPMCountersign();
		} else if (TransBPMDataMap.TAG_NAME.equals(tagName)) {
			node = new TransBPMDataMap();
		} else if (TransBPMDecision.TAG_NAME.equals(tagName)) {
			node = new TransBPMDecision();
		} else if (TransBPMEnd.TAG_NAME.equals(tagName)) {
			node = new TransBPMEnd();
		} else if (TransBPMEvent.TAG_NAME.equals(tagName)) {
			node = new TransBPMEvent();
		} else if (TransBPMFork.TAG_NAME.equals(tagName)) {
			node = new TransBPMFork();
		} else if (TransBPMExclusiveFork.TAG_NAME.equals(tagName)) {
			node = new TransBPMExclusiveFork();
		} else if (TransBPMInline.TAG_NAME.equals(tagName)) {
			node = new TransBPMInline();
		} else if (TransBPMJoin.TAG_NAME.equals(tagName)) {
			node = new TransBPMJoin();
		} else if (TransBPMServiceTask.TAG_NAME.equals(tagName)) {
			node = new TransBPMServiceTask();
		} else if (TransBPMState.TAG_NAME.equals(tagName)) {
			node = new TransBPMState();
		} else if (TransBPMSubProcess.TAG_NAME.equals(tagName)) {
			node = new TransBPMSubProcess();
		} else if (TransBPMTimer.TAG_NAME.equals(tagName)) {
			node = new TransBPMTimer();
		} else if (TransBPMUserTask.TAG_NAME.equals(tagName)) {
			node = new TransBPMUserTask();
		} else if (TransBPMManualTask.TAG_NAME.equals(tagName)) {
			node = new TransBPMManualTask();
		} else if (TransBPMStateAction.TAG_NAME.equals(tagName)) {
			node = new TransBPMStateAction();
		} else if (TransBPMMultiUserTask.TAG_NAME.equals(tagName)) {
			node = new TransBPMMultiUserTask();
		} else if (TransBPMMultiAudit.TAG_NAME.equals(tagName)) {
			node = new TransBPMMultiAudit();
		} else if (TransBPMGateWay.TAG_NAME.equals(tagName)) {
			node = new TransBPMGateWay();
		} else if (TransBPMMessageSend.TAG_NAME.equals(tagName)) {
			node = new TransBPMMessageSend();
		} else if (TransBPMMessageReceive.TAG_NAME.equals(tagName)) {
			node = new TransBPMMessageReceive();
		} else if (TransBPMAnchor.TAG_NAME.equals(tagName)) {
			node = new TransBPMAnchor();
		} else if (TransBPMExclusiveJoin.TAG_NAME.equals(tagName)){
			node = new TransBPMExclusiveJoin();
		}
		return node;
	}

	private TransBPMSwimline createSwimLine() {
		return new TransBPMSwimline();
	}

	@Override
	public JSONObject toJSON() throws Throwable {
		JSONObject json = new JSONObject();
		json.put(tag_key, this.key);
		json.put(tag_caption, this.caption);
		json.put(tag_version, this.version);
		if (this.nodeArray != null) {
			JSONArray jsonArray = new JSONArray();
			Iterator<TransBPMNode> it = this.nodeArray.iterator();
			TransBPMNode node = null;
			while (it.hasNext()) {
				node = it.next();
				jsonArray.put(node.toJSON());
			}
			json.put(tag_nodes, jsonArray);
		}

		if (path != null) {
			json.put("transpath", path.toJSON());
		}
		return json;
	}

	@Override
	public void fromJSON(JSONObject json) throws Throwable {
		this.key = json.optString(tag_key);
		this.caption = json.optString(tag_caption);
		this.version = json.optInt(tag_version);
		if (json.has(tag_nodes)) {
			JSONArray jsonArray = json.getJSONArray(tag_nodes);
			for (int i = 0, size = jsonArray.length(); i < size; ++i) {
				JSONObject tmpJson = jsonArray.getJSONObject(i);
				String tagName = tmpJson.optString(TransBPMObject.tag_tag_name);
				TransBPMNode node = this.createNode(tagName);
				node.fromJSON(tmpJson);
				this.addNode(node);
			}
		}
		if (json.has(tag_swims)) {
			JSONArray jsonArray = json.getJSONArray(tag_swims);
			for (int i = 0, size = jsonArray.length(); i < size; ++i) {
				JSONObject tmpJson = jsonArray.getJSONObject(i);
				TransBPMSwimline swimLine = this.createSwimLine();
				swimLine.fromJSON(tmpJson);
				this.addSwim(swimLine);
			}
		}
		if (json.has("transpath")) {
			this.path = new TransBPMPath();
			path.fromJSON(json.optJSONObject("transpath"));
		}
	}
}
