package com.bokesoft.yes.bpm.meta.transform;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yigo.common.json.JSONSerializable;

public class Item implements JSONSerializable {

	private String key = "";

	private String caption = "";

	private String action = "";

	@Override
	public void fromJSON(JSONObject js) throws SerializationException {
		key = js.getString("Key");
		caption = js.getString("Caption");
		action = js.getString("Action");
	}

	public JSONObject toJSON() throws SerializationException {
		JSONObject js = new JSONObject();
		js.put("Key", key);
		js.put("Caption", caption);
		js.put("Action", action);
		return js;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public String getCaption() {
		return caption;
	}

	public void setCaption(String caption) {
		this.caption = caption;
	}

	public String getAction() {
		return action;
	}

	public void setAction(String action) {
		this.action = action;
	}

}
