/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.tool;

import com.bokesoft.yes.parser.Item;
import com.bokesoft.yes.parser.Parser;
import com.bokesoft.yes.parser.Rule;
import com.bokesoft.yes.parser.SyntaxTree;
import com.bokesoft.yes.tool.FormulaDeparser;
import com.bokesoft.yes.tool.FormulaDeparserWithFormat;
import com.bokesoft.yes.tool.FormulaFormat;
import com.bokesoft.yigo.common.util.TypeConvertor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;

public class FormulaUtil {
    public static boolean isSetValueFunction(Item item) {
        return FormulaUtil.isSetValueFunctionSimple(item) || FormulaUtil.isSetValueFunctionIf(item) || FormulaUtil.isSetValueFunctionPreIIF(item) || FormulaUtil.isSetValueFunctionPreIIF2(item);
    }

    private static boolean isSetValueFunctionSimple(Item item) {
        if (item.getRule().getIndex() != 19 || !item.getFactor(0).getFullLexValue().equalsIgnoreCase("setValue")) {
            return false;
        }
        Item item_2 = item.getFactor(2);
        if (item_2.getRule().getIndex() != 17) {
            return false;
        }
        return item.getChildCount() >= 6;
    }

    private static boolean isSetValueFunctionIf(Item item) {
        int ruleIndex = item.getRule().getIndex();
        if (ruleIndex == 26 || ruleIndex == 28) {
            Item item_5 = item.getFactor(5);
            Item tmp = item_5.getRule().getIndex() == 0 ? item_5.getFactor(0) : item_5;
            return FormulaUtil.isSetValueFunctionSimple(tmp);
        }
        if (ruleIndex == 27) {
            Item tmp;
            Item item_5 = item.getFactor(5);
            Item item2 = tmp = item_5.getRule().getIndex() == 0 ? item_5.getFactor(0) : item_5;
            if (!FormulaUtil.isSetValueFunctionSimple(tmp)) {
                return false;
            }
            Item item_9 = item.getFactor(9);
            Item item3 = tmp = item_9.getRule().getIndex() == 0 ? item_9.getFactor(0) : item_9;
            return tmp.getRule().getIndex() == 17;
        }
        return false;
    }

    private static boolean isSetValueFunctionPreIIF(Item item) {
        if (item.getRule().getIndex() != 19 || !item.getFactor(0).getFullLexValue().equalsIgnoreCase("IIF") && !item.getFactor(0).getFullLexValue().equalsIgnoreCase("IIFS")) {
            return false;
        }
        Item item_4 = item.getFactor(4);
        if (!FormulaUtil.isSetValueFunctionSimple(item_4)) {
            return false;
        }
        return item.getChildCount() <= 8;
    }

    private static boolean isSetValueFunctionPreIIF2(Item item) {
        if (item.getRule().getIndex() != 19 || !item.getFactor(0).getFullLexValue().equalsIgnoreCase("IIF")) {
            return false;
        }
        if (item.getFactor(4).getRule().getIndex() != 17) {
            return false;
        }
        return FormulaUtil.isSetValueFunctionSimple(item.getFactor(6));
    }

    public static String getSetValueFieldKey(Item item) {
        if (FormulaUtil.isSetValueFunctionSimple(item)) {
            return item.getFactor(2).getFactor(0).getLexValue();
        }
        if (FormulaUtil.isSetValueFunctionIf(item)) {
            Item item_5 = item.getFactor(5);
            Item tmp = item_5.getRule().getIndex() == 0 ? item_5.getFactor(0) : item_5;
            return tmp.getFactor(2).getFactor(0).getLexValue();
        }
        if (FormulaUtil.isSetValueFunctionPreIIF(item)) {
            return item.getFactor(4).getFactor(2).getFactor(0).getLexValue();
        }
        if (FormulaUtil.isSetValueFunctionPreIIF2(item)) {
            return item.getFactor(6).getFactor(2).getFactor(0).getLexValue();
        }
        throw new RuntimeException("\u8c03\u7528\u9519\u8bef\uff0cisSetValueFunction()\u4e3aFalse\u3002");
    }

    public static String getSetValueFormula(Item item) {
        if (FormulaUtil.isSetValueFunctionSimple(item)) {
            return FormulaDeparser.deParse(item.getFactor(4));
        }
        if (FormulaUtil.isSetValueFunctionIf(item)) {
            Item item_5 = item.getFactor(5);
            Item tmp = item_5.getRule().getIndex() == 0 ? item_5.getFactor(0) : item_5;
            return "IIF(" + FormulaDeparser.deParse(item.getFactor(2)) + ", " + FormulaDeparser.deParse(tmp.getFactor(4)) + ", " + FormulaUtil.getSetValueFieldKey(item) + ")";
        }
        if (FormulaUtil.isSetValueFunctionPreIIF(item)) {
            return "IIF(" + FormulaDeparser.deParse(item.getFactor(2)) + ", " + FormulaDeparser.deParse(item.getFactor(4).getFactor(4)) + ", " + FormulaUtil.getSetValueFieldKey(item) + ")";
        }
        if (FormulaUtil.isSetValueFunctionPreIIF2(item)) {
            return "IIF(!(" + FormulaDeparser.deParse(item.getFactor(2)) + "), " + FormulaDeparser.deParse(item.getFactor(6).getFactor(4)) + ", " + FormulaUtil.getSetValueFieldKey(item) + ")";
        }
        throw new RuntimeException("\u8c03\u7528\u9519\u8bef\uff0cisSetValueFunction()\u4e3aFalse\u3002");
    }

    public static boolean getSetValueIsValueChanged(Item item) {
        if (FormulaUtil.isSetValueFunctionSimple(item)) {
            return item.getChildCount() < 7 ? false : TypeConvertor.toBoolean((Object)item.getFactor(6).getFactor(0).getLexValue());
        }
        if (FormulaUtil.isSetValueFunctionIf(item)) {
            Item item_5 = item.getFactor(5);
            Item tmp = item_5.getRule().getIndex() == 0 ? item_5.getFactor(0) : item_5;
            return tmp.getChildCount() < 7 ? false : TypeConvertor.toBoolean((Object)tmp.getFactor(6).getFactor(0).getLexValue());
        }
        if (FormulaUtil.isSetValueFunctionPreIIF(item)) {
            Item tmp = item.getFactor(4);
            return tmp.getChildCount() < 7 ? false : TypeConvertor.toBoolean((Object)tmp.getFactor(6).getFactor(0).getLexValue());
        }
        if (FormulaUtil.isSetValueFunctionPreIIF2(item)) {
            Item tmp = item.getFactor(6);
            return tmp.getChildCount() < 7 ? false : TypeConvertor.toBoolean((Object)tmp.getFactor(6).getFactor(0).getLexValue());
        }
        throw new RuntimeException("\u8c03\u7528\u9519\u8bef\uff0cisSetValueFunction()\u4e3aFalse\u3002");
    }

    public static List<Item> getStatements(Item item) {
        ArrayList<Item> result = new ArrayList<Item>();
        if (item.getRule().getIndex() == 1) {
            int i = 0;
            int size = item.getChildCount();
            while (i < size) {
                result.add(item.getFactor(i));
                i += 2;
            }
        } else {
            result.add(item);
        }
        return result;
    }

    public static String addDefaultFormulaValue(Item item, String srcFieldKey, String srcFieldCheckRule, String tgtFieldKey, String tgtOrginalDefaultFormulaValue, String tgtValueChanged, Stack<String> path) {
        if (FormulaUtil.isCheckRuleEmpty(srcFieldCheckRule)) {
            if (FormulaUtil.isEmpty(tgtOrginalDefaultFormulaValue)) {
                throw new RuntimeException(String.valueOf(FormulaDeparser.deParse(item)) + "\u8f6c\u5316\u4e3a\u9ed8\u8ba4\u503c\u4e0d\u5bf9\uff0c\u89e6\u53d1\u5b57\u6bb5\u7684\u68c0\u67e5\u548c\u76ee\u6807\u5b57\u6bb5\u7684\u539f\u9ed8\u8ba4\u503c\u90fd\u4e3a\u7a7a\u3002" + path.toString());
            }
            if (FormulaUtil.getSetValueIsValueChanged(item) && !FormulaUtil.isEmpty(tgtValueChanged)) {
                return null;
            }
            return FormulaDeparser.deParse(item);
        }
        if (srcFieldCheckRule.length() > 30) {
            return "IIF(isCheck('" + srcFieldKey + "'), " + FormulaDeparser.deParse(item) + ", " + tgtFieldKey + ")";
        }
        return "IIF(" + srcFieldCheckRule + ", " + FormulaDeparser.deParse(item) + ", " + tgtFieldKey + ")";
    }

    private static boolean isCheckRuleEmpty(String checkRule) {
        return StringUtils.isBlank((CharSequence)checkRule) || checkRule.equalsIgnoreCase("true");
    }

    private static boolean isEmpty(String formula) {
        return StringUtils.isBlank((CharSequence)formula);
    }

    public static void main(String[] args) {
        String f = "setValue('AA', 1+ 2, true)";
        Parser parser = new Parser(null);
        SyntaxTree syntaxTree = parser.parse(f);
        System.out.println(FormulaUtil.isSetValueFunction(syntaxTree.getRoot()));
        f = "setValue('AA', 1+ 2, true);Hi( 1+2);SEtValue('BB', 2);SEtValue('BB', 2, false)";
        syntaxTree = parser.parse(f);
        System.out.println(FormulaDeparser.deParse(syntaxTree.getRoot()));
        for (Item item : FormulaUtil.getStatements(syntaxTree.getRoot())) {
            System.out.println(String.valueOf(FormulaDeparser.deParse(item)) + ":" + FormulaUtil.isSetValueFunction(item));
            if (!FormulaUtil.isSetValueFunction(item)) continue;
            System.out.println(FormulaUtil.getSetValueIsValueChanged(item));
        }
    }

    public static String format(String formula) {
        if (StringUtils.isBlank((CharSequence)formula)) {
            return null;
        }
        Parser parser = new Parser(null);
        SyntaxTree syntaxTree = parser.parse(formula);
        return Objects.isNull(syntaxTree) ? formula : FormulaDeparser.deParse(syntaxTree.getRoot());
    }

    public static boolean isSame(String formula0, String formula1) {
        SyntaxTree syntaxTree1;
        Parser parser;
        SyntaxTree syntaxTree0;
        if (formula0.equals(formula1)) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)formula0)) {
            if (StringUtils.isBlank((CharSequence)formula1)) {
                return true;
            }
        } else if (StringUtils.isBlank((CharSequence)formula1)) {
            return false;
        }
        if ((syntaxTree0 = (parser = new Parser(null)).parse(formula0)) == (syntaxTree1 = parser.parse(formula1))) {
            return true;
        }
        if (Objects.isNull(syntaxTree0) || Objects.isNull(syntaxTree1)) {
            return false;
        }
        return FormulaUtil.isSame(syntaxTree0.getRoot(), syntaxTree1.getRoot());
    }

    private static boolean isSame(Item item0, Item item1) {
        int ruleIndex;
        if (item0 == item1) {
            return true;
        }
        if (Objects.isNull(item0) || Objects.isNull(item1)) {
            return false;
        }
        if (item0.getRule() != item1.getRule() || !StringUtils.equals((CharSequence)item0.getLexValue(), (CharSequence)item1.getLexValue()) || !StringUtils.equals((CharSequence)item0.getFullLexValue(), (CharSequence)item1.getFullLexValue()) || item0.getChildCount() != item1.getChildCount()) {
            return false;
        }
        Rule rule = item0.getRule();
        if (rule != null && ((ruleIndex = rule.getIndex()) == 2 || ruleIndex == 4) && (FormulaUtil.isSame(item0.getFactor(0), item1.getFactor(0)) && FormulaUtil.isSame(item0.getFactor(2), item1.getFactor(2)) || FormulaUtil.isSame(item0.getFactor(0), item1.getFactor(2)) && FormulaUtil.isSame(item0.getFactor(2), item1.getFactor(0)))) {
            return true;
        }
        int childCount = item0.getChildCount();
        int i = 0;
        while (i < childCount) {
            if (!FormulaUtil.isSame(item0.getFactor(i), item1.getFactor(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String deParseStatements(List<Item> items, FormulaFormat format) {
        if (items.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder(512);
        sb.append(FormulaDeparserWithFormat.deParse(items.get(0), format));
        int i = 1;
        int size = items.size();
        while (i < size) {
            sb.append(";").append(FormulaDeparserWithFormat.deParse(items.get(i), format));
            ++i;
        }
        return sb.toString();
    }

    public static List<Item> getLeafItems(Item item) {
        ArrayList<Item> result = new ArrayList<Item>();
        return FormulaUtil.getLeafItems(item, result);
    }

    private static List<Item> getLeafItems(Item item, List<Item> result) {
        if (item.getChildCount() == 0) {
            if (item.getLexValue() == ";" && item.getFullLexValue() != null && item.getFullLexValue().length() > 0) {
                return result;
            }
            result.add(item);
        } else {
            for (Item subItem : item.getAllChild()) {
                FormulaUtil.getLeafItems(subItem, result);
            }
        }
        return result;
    }

    public static boolean isDependFieldKey(String formula, String fieldKey) {
        Parser parser = new Parser(null);
        SyntaxTree syntaxTree = parser.parse(formula);
        List<Item> leafItems = FormulaUtil.getLeafItems(syntaxTree.getRoot());
        for (Item item : leafItems) {
            if (!fieldKey.equals(item.getLexValue()) || !"id".equals(item.getRuleFactor().getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isCalcFormula(String formula) {
        if (StringUtils.isBlank((CharSequence)formula)) {
            return false;
        }
        Parser parser = new Parser(null);
        SyntaxTree syntaxTree = parser.parse(formula);
        return FormulaUtil.isCalcItem(syntaxTree.getRoot());
    }

    private static boolean isCalcItem(Item item) {
        ArrayList children;
        Rule rule = item.getRule();
        if (Objects.isNull(rule)) {
            return false;
        }
        int ruleIndex = rule.getIndex();
        if (ruleIndex == 2 || ruleIndex == 3 || ruleIndex == 4 || ruleIndex == 5) {
            return true;
        }
        if (ruleIndex == 19) {
            String functionName = item.getFactor(0).getLexValue();
            if (functionName.equalsIgnoreCase("GetDictOID") || functionName.equalsIgnoreCase("GetDictValue")) {
                return true;
            }
            if (functionName.startsWith("com.bokesoft.")) {
                return true;
            }
        }
        if ((children = item.getAllChild()) != null) {
            for (Item childItem : children) {
                if (!FormulaUtil.isCalcItem(childItem)) continue;
                return true;
            }
        }
        return false;
    }
}

