/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.tool;

import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.mid.base.CoreSetting;
import com.bokesoft.yes.parser.Item;
import com.bokesoft.yes.parser.Parser;
import com.bokesoft.yes.parser.SyntaxTree;
import com.bokesoft.yes.tool.FormulaDeparserWithFormat;
import com.bokesoft.yes.tool.FormulaFormat;
import com.bokesoft.yes.tool.FormulaUtil;
import com.bokesoft.yigo.meta.common.MetaMacro;
import com.bokesoft.yigo.meta.common.MetaMacroCollection;
import com.bokesoft.yigo.meta.commondef.MetaCommonDef;
import com.bokesoft.yigo.meta.factory.DefaultMetaFactory;
import com.bokesoft.yigo.meta.factory.DefaultMetaResolverFactory;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.IMetaResolverFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.solution.MetaProject;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class FillMacro4Designer {
    public static final FillMacro4Designer instance = new FillMacro4Designer();

    public static void main(String[] args) throws Throwable {
        String solutionPath = FillMacro4Designer.getSolutionPath(args);
        IMetaFactory metaFactory = FillMacro4Designer.loadSolution(solutionPath);
        MetaForm po = metaFactory.getMetaForm("MM_PurchaseOrder");
        System.out.println(FillMacro4Designer.parseFormula(metaFactory, po, "UICheck()"));
    }

    private static String getSolutionPath(String[] args) {
        String solutionPath = FilePathHelper.toBackFilePath(CoreSetting.getInstance().getSolutionPath());
        if (args != null && args.length > 0) {
            solutionPath = args[0];
        }
        return Paths.get(solutionPath, new String[0]).toAbsolutePath().toString();
    }

    private static IMetaFactory loadSolution(String solutionPath) throws Throwable {
        DefaultMetaResolverFactory metaResolverFactory = new DefaultMetaResolverFactory(solutionPath);
        DefaultMetaFactory metaFactory = new DefaultMetaFactory((IMetaResolverFactory)metaResolverFactory);
        metaFactory.getSolution();
        metaFactory.preLoadEntity();
        return metaFactory;
    }

    public static String parseFormula(IMetaFactory metaFactory, MetaForm metaForm, String formula) {
        StringBuilder result = new StringBuilder(1024);
        FillMacro4Designer.parseFormula(metaFactory, metaForm, formula, result, 0);
        return result.toString();
    }

    public static String parseFormula(IMetaFactory metaFactory, MetaForm metaForm, String formula, StringBuilder result, int level) {
        List<String> statements = FillMacro4Designer.splitStatements(metaFactory, metaForm, formula);
        int i = 0;
        int size = statements.size();
        while (i < size) {
            String statement = statements.get(i).trim();
            int k = 0;
            while (k < level) {
                result.append("\t");
                ++k;
            }
            result.append(statement).append("\n");
            ArrayList<String> foundMacroPaths = new ArrayList<String>();
            String statementFillMacro = FillMacro4Designer.fillMacro(metaFactory, metaForm, statement, foundMacroPaths);
            if (!statementFillMacro.equals(statement)) {
                for (String foundMacroPath : foundMacroPaths) {
                    int k2 = 0;
                    while (k2 <= level) {
                        result.append("\t");
                        ++k2;
                    }
                    result.append(foundMacroPath).append("\n");
                }
                FillMacro4Designer.parseFormula(metaFactory, metaForm, statementFillMacro, result, level + 1);
            }
            ++i;
        }
        return null;
    }

    private static List<String> splitStatements(IMetaFactory metaFactory, MetaForm metaForm, String formula) {
        ArrayList<String> result = new ArrayList<String>();
        Parser parser = new Parser(null);
        try {
            SyntaxTree syntaxTree = parser.parse(formula);
            if (syntaxTree != null) {
                StringBuilder sb = new StringBuilder(512);
                sb.append(formula).append(":\t");
                FormulaFormat format = FormulaFormat.parse(formula, syntaxTree);
                Item item = syntaxTree.getRoot();
                List<Item> statements = FormulaUtil.getStatements(item);
                int size = statements.size();
                if (size > 1) {
                    int i = 0;
                    while (i < size) {
                        result.add(FormulaDeparserWithFormat.deParse(statements.get(i), format));
                        ++i;
                    }
                    return result;
                }
            }
            result.add(formula);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private static String fillMacro(final IMetaFactory metaFactory, final MetaForm metaForm, final String formula, final List<String> foundMacroPaths) {
        final Parser parser = new Parser(null);
        SyntaxTree syntaxTree = parser.parse(formula);
        if (syntaxTree != null) {
            StringBuilder sb = new StringBuilder(512);
            FormulaFormat format = FormulaFormat.parse(formula, syntaxTree);
            FormulaDeparserWithFormat deparser = new FormulaDeparserWithFormat(){
                Map<String, String> macroArgs = null;

                @Override
                protected StringBuilder deParse19Function(Item factor, StringBuilder sb, FormulaFormat format) {
                    if (this.macroArgs != null) {
                        return super.deParse19Function(factor, sb, format);
                    }
                    String functionName = factor.getFactor(0).getFullLexValue();
                    int argumentCount = (factor.getChildCount() - 2) / 2;
                    MetaMacro macro = null;
                    try {
                        macro = FillMacro4Designer.findMacro(metaFactory, metaForm, functionName, foundMacroPaths);
                    }
                    catch (Throwable e) {
                        throw new RuntimeException("\u53d6\u5b8f\u516c\u5f0f\u9519\u8bef", e);
                    }
                    if (macro != null) {
                        String[] argsList = macro.getArgsList();
                        if ((Objects.isNull(argsList) ? 0 : argsList.length) != argumentCount) {
                            System.err.println("\u8868\u5355" + metaForm.getKey() + "\u8868\u8fbe\u5f0f" + formula + "\u4e2d\u5b8f\u516c\u5f0f" + functionName + "\u7684\u53c2\u6570\u4e2a\u6570\u5e94\u4e3a" + (Objects.isNull(argsList) ? 0 : argsList.length) + "\uff0c\u800c\u8868\u8fbe\u5f0f\u4e2d\u4e3a" + argumentCount + "\uff0c\u8868\u8fbe\u5f0f\u9519\u8bef\uff0c\u8bf7\u4fee\u6b63\u3002");
                            return super.deParse19Function(factor, sb, format);
                        }
                        String macroContent = macro.getContent();
                        if (StringUtils.isBlank((CharSequence)macroContent)) {
                            System.err.println("\u8868\u5355" + metaForm.getKey() + "\u8868\u8fbe\u5f0f" + formula + "\u4e2d\u5b8f\u516c\u5f0f" + functionName + "\u7684\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8868\u8fbe\u5f0f\u9519\u8bef\uff0c\u8bf7\u4fee\u6b63\u3002");
                            return super.deParse19Function(factor, sb, format);
                        }
                        this.macroArgs = new HashMap<String, String>();
                        int i = 0;
                        while (i < argumentCount) {
                            StringBuilder argSB = new StringBuilder(128);
                            super.deParse(factor.getFactor(2 + i * 2), argSB, format);
                            this.macroArgs.put(argsList[i], argSB.toString());
                            ++i;
                        }
                        SyntaxTree macroSyntaxTree = parser.parse(macroContent);
                        FormulaFormat macroFormat = FormulaFormat.parse(macroContent, macroSyntaxTree);
                        super.deParse(macroSyntaxTree.getRoot(), sb, macroFormat);
                        this.macroArgs = null;
                        return sb;
                    }
                    return super.deParse19Function(factor, sb, format);
                }

                @Override
                protected StringBuilder deParse18ID(Item factor, StringBuilder sb, FormulaFormat format) {
                    String id = factor.getFactor(0).getFullLexValue();
                    if (this.macroArgs != null && this.macroArgs.containsKey(id)) {
                        return sb.append(format.getPreFormat(factor.getFactor(0))).append(this.macroArgs.get(id));
                    }
                    return super.deParse18ID(factor, sb, format);
                }
            };
            Item item = syntaxTree.getRoot();
            deparser.deParse(item, sb, format).append(format.getLastFormat());
            return sb.toString();
        }
        return formula;
    }

    private static MetaMacro findMacro(IMetaFactory metaFactory, MetaForm metaForm, String name, List<String> macros) throws Throwable {
        MetaCommonDef metaCommonDef;
        MetaProject metaProject;
        MetaCommonDef metaCommonDef2;
        MetaMacroCollection macroCollection = metaForm.getMacroCollection();
        MetaMacro metaMacro = null;
        if (macroCollection != null && (metaMacro = (MetaMacro)macroCollection.get(name)) != null) {
            macros.add("// " + name + "()@" + metaForm.getProject().getKey() + "\\" + ((MetaFormProfile)metaFactory.getMetaFormList().get(metaForm.getKey())).getResource());
        }
        if (Objects.isNull(metaMacro) && (metaCommonDef2 = metaFactory.getCommonDef((metaProject = (MetaProject)metaForm.getProject()).getKey())) != null && (macroCollection = metaCommonDef2.getMacroCollection()) != null && (metaMacro = (MetaMacro)macroCollection.get(name)) != null) {
            macros.add("// " + name + "()@" + metaForm.getProject().getKey() + "\\CommonDef.xml");
        }
        if (Objects.isNull(metaMacro) && (metaCommonDef = metaFactory.getCommonDef("")) != null && (macroCollection = metaCommonDef.getMacroCollection()) != null && (metaMacro = (MetaMacro)macroCollection.get(name)) != null) {
            macros.add("// " + name + "()@CommonDef.xml");
        }
        return metaMacro;
    }
}

