/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.helper;

import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.design.xml.node.XmlTree;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public final class MetaFormHelper {
    private static final List<String> TABLE_KEY_REF_LIST = Arrays.asList("ED_DataBinding", "Condition", "ConditionTarget", "GridRow", "ListView", "ColumnExpand");
    private static final List<String> COLUMN_KEY_REF_LIST = Arrays.asList("DataBinding", "Condition", "ConditionTarget", "GridCell", "ListViewColumn", "ColumnExpand");

    public static boolean isBeExtended(MetaForm metaForm) throws Throwable {
        String extend = metaForm.getExtend();
        if (StringUtils.isNotBlank((CharSequence)extend)) {
            return false;
        }
        String formKey = metaForm.getKey();
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaFormList metaFormList = metaFactory.getMetaFormList();
        for (MetaFormProfile metaFormProfile : metaFormList) {
            if (!StringUtils.equals((CharSequence)metaFormProfile.getExtend(), (CharSequence)formKey)) continue;
            return true;
        }
        return false;
    }

    public static Pair<List<MetaFormProfile>, MetaFormProfile> listVestMetaFormByOriginal(MetaForm metaForm) throws Throwable {
        String extend = metaForm.getExtend();
        if (StringUtils.isNotBlank((CharSequence)extend)) {
            return Pair.of(Collections.emptyList(), null);
        }
        ArrayList<MetaFormProfile> vestList = new ArrayList<MetaFormProfile>();
        MetaFormProfile specVest = null;
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaFormList metaFormList = metaFactory.getMetaFormList();
        for (MetaFormProfile metaFormProfile : metaFormList) {
            if (!StringUtils.equals((CharSequence)metaFormProfile.getExtend(), (CharSequence)metaForm.getKey())) continue;
            if (Objects.equals(metaFormProfile.getMergeToSource(), Boolean.TRUE)) {
                specVest = metaFormProfile;
                continue;
            }
            vestList.add(metaFormProfile);
        }
        return Pair.of(vestList, specVest);
    }

    public static Pair<List<MetaFormProfile>, MetaFormProfile> listVestMetaFormBySpecVest(MetaForm metaForm) throws Throwable {
        if (StringUtils.isBlank((CharSequence)metaForm.getExtend()) || !Objects.equals(metaForm.getMergeToSource(), Boolean.TRUE)) {
            return Pair.of(Collections.emptyList(), null);
        }
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        ArrayList<MetaFormProfile> vestList = new ArrayList<MetaFormProfile>();
        MetaFormProfile originalForm = (MetaFormProfile)metaFactory.getMetaFormList().get(metaForm.getExtend());
        MetaFormList metaFormList = metaFactory.getMetaFormList();
        for (MetaFormProfile metaFormProfile : metaFormList) {
            if (!StringUtils.equals((CharSequence)metaFormProfile.getExtend(), (CharSequence)originalForm.getKey()) || StringUtils.equals((CharSequence)metaFormProfile.getKey(), (CharSequence)metaForm.getKey())) continue;
            vestList.add(metaFormProfile);
        }
        return Pair.of(vestList, (Object)originalForm);
    }

    public static MetaForm getExtendMetaForm(MetaForm metaForm) throws Throwable {
        String extend = metaForm.getExtend();
        if (StringUtils.isBlank((CharSequence)extend)) {
            return metaForm;
        }
        return MetaFactory.getGlobalInstance().getMetaForm(extend);
    }

    public static void updateColumnKey(Diff diff, String oldColumnKey, String newColumnKey) {
        if (Objects.isNull(diff.getMetaForm()) || Objects.isNull(diff.getXmlTree())) {
            return;
        }
        XmlTree xmlTree = diff.getXmlTree().xmlTree;
        TagNode rootNode = xmlTree.getRoot();
        TagNode bodyNode = rootNode.getOrCreateChildByTagName("Body");
        Consumer<TagNode> tagNodeConsumer = tagNode -> {
            Map<String, String> attributes = tagNode.getAttributes();
            String attrVal = attributes.get("ColumnKey");
            if (StringUtils.equalsIgnoreCase((CharSequence)attrVal, (CharSequence)oldColumnKey)) {
                tagNode.setAttribute("ColumnKey", newColumnKey);
            }
        };
        COLUMN_KEY_REF_LIST.forEach(tagName -> bodyNode.findNodesByTagName((String)tagName).forEach(tagNodeConsumer));
    }

    public static void updateTableKey(Diff diff, String oldTableKey, String newTableKey) {
        if (Objects.isNull(diff.getMetaForm()) || Objects.isNull(diff.getXmlTree())) {
            return;
        }
        XmlTree xmlTree = diff.getXmlTree().xmlTree;
        TagNode rootNode = xmlTree.getRoot();
        TagNode bodyNode = rootNode.getOrCreateChildByTagName("Body");
        Consumer<TagNode> tagNodeConsumer = tagNode -> {
            Map<String, String> attributes = tagNode.getAttributes();
            String attrVal = attributes.get("TableKey");
            if (StringUtils.equalsIgnoreCase((CharSequence)attrVal, (CharSequence)oldTableKey)) {
                tagNode.setAttribute("TableKey", newTableKey);
            }
        };
        TABLE_KEY_REF_LIST.forEach(tagName -> bodyNode.findNodesByTagName((String)tagName).forEach(tagNodeConsumer));
    }
}

