/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.xml.parse;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.design.xml.ex.TextSyntaxException;
import com.bokesoft.yes.design.xml.parse.CharUtil;
import com.bokesoft.yes.design.xml.parse.Entry;
import java.util.Objects;

public class TextAnalyzer {
    private static final TextAnalyzer sington = new TextAnalyzer();

    public static TextAnalyzer New() {
        return sington;
    }

    public Entry getBlank(String source, int bg) {
        int ed = source.length();
        int i = bg;
        while (i < source.length()) {
            char c = source.charAt(i);
            if (!CharUtil.isBlank(c)) {
                ed = i;
                break;
            }
            ++i;
        }
        if (ed <= bg) {
            return null;
        }
        Entry e = new Entry();
        e.setType(2);
        e.setBg(bg);
        e.setEd(ed - 1);
        return e;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Entry getString(String source, int bg, char[] borderChar, char[] escape, boolean useLRLN) {
        boolean isStart = false;
        Entry entry = null;
        char useBorder = '\"';
        int i = bg;
        while (i < source.length()) {
            block15: {
                char c = source.charAt(i);
                if (!isStart) {
                    if (!CharUtil.isBlank(c)) {
                        if (!CharUtil.isInIt(c, borderChar)) {
                            return null;
                        }
                        isStart = true;
                        useBorder = c;
                        entry = new Entry();
                        entry.setType(1);
                        entry.setBg(i);
                    }
                } else {
                    if (c == useBorder) {
                        if (i == source.length() - 1) {
                            entry.setEd(i);
                            break;
                        }
                        if (CharUtil.isInIt(c, escape)) {
                            if (source.charAt(i + 1) == c) {
                                ++i;
                                break block15;
                            } else {
                                entry.setEd(i);
                                break;
                            }
                        }
                        entry.setEd(i);
                        break;
                    }
                    if (CharUtil.isInIt(c, escape)) {
                        ++i;
                    } else if (!(c != '\r' && c != '\n' || useLRLN)) {
                        throw new TextSyntaxException("\u5b57\u7b26\u4e32\u4e0d\u80fd\u6362\u884c[\\r\\n]\r\n[" + source.substring(bg, i) + "\r\n^^^^^^^^^^^^^^^^^^^^^^^^^^\r\n" + source.substring(i) + "]");
                    }
                }
            }
            ++i;
        }
        if (Objects.isNull(entry)) {
            return null;
        }
        if (entry.getEd() == -1) {
            throw new TextSyntaxException("\u5b57\u7b26\u4e32\u6ca1\u6709\u6b63\u5e38\u7684\u7ed3\u675f[\\r\\n]\r\n[" + source.substring(entry.getBg()) + "]");
        }
        return entry;
    }

    public Entry getCommonString(String source, int bg) {
        return this.getString(source, bg, new char[]{'\"'}, new char[]{'\\'}, false);
    }

    public Entry getXmlString(String source, int bg) {
        return this.getString(source, bg, new char[]{'\"', '\''}, null, true);
    }

    public Entry getSqlString(String source, int bg) {
        return this.getString(source, bg, new char[]{'\''}, new char[]{'\\', '\''}, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Entry getName(String source, int bg, char[] wordChars, char[] endChars) {
        boolean isStart = false;
        Entry entry = new Entry();
        entry.setType(3);
        int i = bg;
        while (i < source.length()) {
            char c = source.charAt(i);
            if (!isStart) {
                if (!CharUtil.isBlank(c)) {
                    if (!CharUtil.isNameStartChar(c)) return null;
                    isStart = true;
                    entry.setBg(i);
                }
            } else if (!CharUtil.isNameChar(c) && !CharUtil.isInIt(c, wordChars)) {
                if (!CharUtil.isBlank(c) && !CharUtil.isInIt(c, endChars)) throw new TextSyntaxException("\u5143\u7d20\u540d\u79f0\uff0c\u4e0d\u80fd\u542b\u6709\u5b57\u7b26[" + c + "]\r\n[" + source.substring(bg, i) + "\r\n^^^^^^^^^^^^^^^^^^^^^^^^^^\r\n" + source.substring(i) + "]");
                entry.setEd(i - 1);
                break;
            }
            ++i;
        }
        if (entry.getBg() == -1) {
            return null;
        }
        if (entry.getEd() != -1) return entry;
        entry.setEd(source.length() - 1);
        return entry;
    }

    public Entry getComment(String source, int bg, String bgStr, String endStr) {
        boolean isStart = false;
        Entry entry = new Entry();
        entry.setType(4);
        int i = bg;
        while (i < source.length()) {
            if (!isStart) {
                if (StringUtil.isString((String)source, (String)bgStr, (int)i)) {
                    isStart = true;
                    entry.setBg(i);
                    i += bgStr.length() - 1;
                }
            } else if (StringUtil.isString((String)source, (String)endStr, (int)i)) {
                entry.setEd(i + (endStr.length() - 1));
                break;
            }
            ++i;
        }
        if (entry.getBg() == -1) {
            return null;
        }
        if (entry.getEd() == -1) {
            throw new TextSyntaxException("Comment\u5143\u7d20\u6ca1\u6709\u7ed3\u5c3e\r\n[" + source.substring(entry.getBg()) + "]");
        }
        return entry;
    }
}

