/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.utils;

import com.bokesoft.erp.metaobjectchange.MetaObjectChange;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.context.DesignerContext;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.erp.scope.MetaFormAllFormulScopeCache;
import com.bokesoft.yes.erpdatamap.ERPMetaMap;
import com.bokesoft.yes.erpdatamap.dom.ERPMetaMapLoad;
import com.bokesoft.yes.log.LogSvr;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.mid.migration.period.MigrationStruct;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.dataelement.MetaDataElement;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigration;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationProfile;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectProfile;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictProperties;
import com.bokesoft.yigo.meta.intf.IMetaProject;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.meta.solution.MetaProjectCollection;
import com.bokesoft.yigo.meta.solution.MetaProjectProfile;
import com.bokesoft.yigo.meta.solution.MetaSolution;
import com.bokesoft.yigo.meta.util.MetaAnnotationUtil;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ReloadForm {
    public static boolean delayedProcessScope = false;

    public static void setDelayedProcessScope(boolean delayedProcessScope) {
        ReloadForm.delayedProcessScope = delayedProcessScope;
    }

    public static String reloadFormKey(IMetaFactory metaFactory, String formKey, String resource) throws Throwable {
        return ReloadForm.reloadFormKey(metaFactory, formKey, resource, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String reloadFormKey(IMetaFactory metaFactory, String formKey, String resource, boolean reloadObjectFlag) throws Throwable {
        MetaFormProfile metaFormProfile = (MetaFormProfile)metaFactory.getMetaFormList().get(formKey);
        if (metaFormProfile == null) {
            metaFormProfile = (MetaFormProfile)metaFactory.getExtFormList().get(formKey);
        }
        if (metaFormProfile != null) {
            MetaDataObject dataObject;
            String oldResource = metaFormProfile.getResource();
            if (resource != null) {
                if (metaFormProfile.getProject().getKey().equalsIgnoreCase("webconfig")) {
                    metaFormProfile.setResource(".." + File.separatorChar + ".." + File.separatorChar + ".." + File.separatorChar + ".." + File.separatorChar + resource);
                } else {
                    metaFormProfile.setResource(resource);
                }
            }
            MetaForm metaForm = metaFormProfile.getForm();
            if (reloadObjectFlag && metaForm != null && metaForm.getDataSource() != null && (dataObject = metaForm.getDataSource().getDataObject()) != null && !DesignerContext.isChangedDataObject(dataObject)) {
                if (delayedProcessScope) {
                    MetaObjectChange.fireChangeDesignMetaDataObject((MetaDataObject)dataObject, (String[])new String[]{"DBCache,TableCache,MetaCache"});
                } else {
                    MetaObjectChange.fireChangeDesignMetaDataObject((MetaDataObject)dataObject, (String[])new String[0]);
                }
            }
            if (metaForm != null) {
                if (delayedProcessScope) {
                    MetaObjectChange.fireChangeDesignMetaForm((MetaForm)metaForm, (String[])new String[]{"DBCache", "TableCache", "MetaCache", "TableCacheAll"});
                } else {
                    MetaObjectChange.fireChangeDesignMetaForm((MetaForm)metaForm, (String[])new String[0]);
                }
            }
            metaFactory.reloadDesignMetaForm(formKey);
            MetaFormProfile metaFormProfile2 = metaFormProfile;
            synchronized (metaFormProfile2) {
                metaForm = metaFactory.getMetaForm(formKey);
                MetaFormProfile finalMetaFormProfile = metaFormProfile;
                metaForm.doPostProcess(0, param -> {
                    if (param instanceof MetaDictProperties) {
                        ((MetaDictProperties)param).calItemKey(finalMetaFormProfile.getProject().getKey());
                    } else if (param instanceof MetaTable) {
                        ((MetaTable)param).initI18nColumn(MetaFactory.getGlobalInstance());
                    }
                    return true;
                });
                metaFormProfile.setRunType(2);
                if (metaFormProfile.getMergeToSource().booleanValue() && !metaFormProfile.getExtend().isEmpty()) {
                    metaFactory.replaceMetaForm4VestDiff(metaFormProfile.getExtend(), metaForm);
                    MetaForm metaForm1 = metaFactory.getMetaForm(metaFormProfile.getExtend());
                    ((MetaFormProfile)metaFactory.getMetaFormList().get(metaFormProfile.getExtend())).setRunType(2);
                    MetaFormAllFormulScopeCache.instance.changeMetaForm(metaForm);
                    MetaFormAllFormulScopeCache.instance.changeMetaForm(metaForm1);
                }
            }
            ReloadForm.processTemplateDataElement(metaFactory, metaForm);
            return oldResource;
        }
        return null;
    }

    public static String reloadDataObjectKey(IMetaFactory metaFactory, String dataObjectKey, String resource) throws Throwable {
        return ReloadForm.reloadDataObjectKey(metaFactory, dataObjectKey, resource, null);
    }

    public static String reloadDataObjectKey(IMetaFactory metaFactory, String dataObjectKey, String resource, String projectKey) throws Throwable {
        MetaDataObjectProfile metaDataObjectProfile = (MetaDataObjectProfile)metaFactory.getDataObjectList().get(dataObjectKey);
        String projectKey1 = metaDataObjectProfile.getProject().getKey();
        String resource1 = LoadFileTree.getResource(resource, projectKey1);
        if (Objects.isNull(metaDataObjectProfile)) {
            metaDataObjectProfile = new MetaDataObjectProfile();
            metaDataObjectProfile.setKey(dataObjectKey);
            XmlTreeWithPath parse1 = XmlTreeWithPath.parseFilePathNotLoadTmp(resource);
            String caption = parse1.xmlTree.getRoot().getAttributes().get("Caption");
            metaDataObjectProfile.setCaption(caption);
            if (StringUtils.isBlank((CharSequence)projectKey)) {
                projectKey = projectKey1;
            }
            MetaProject metaProject = metaFactory.getMetaProject(projectKey);
            metaDataObjectProfile.setProject((IMetaProject)metaProject);
            metaDataObjectProfile.setResource(resource1);
            metaFactory.getDataObjectList().add((KeyPairMetaObject)metaDataObjectProfile);
        }
        String oldResource = metaDataObjectProfile.getResource();
        if (resource != null) {
            metaDataObjectProfile.setResource(resource1);
        }
        MetaObjectChange.fireChangeDesignMetaDataObject((MetaDataObject)metaDataObjectProfile.getDataObject(), (String[])new String[0]);
        try {
            metaFactory.reloadDataObject(dataObjectKey);
        }
        catch (Exception e) {
            LogSvr.getInstance().error("\n", (Throwable)e);
        }
        MetaDataObject dataObject = metaFactory.getDataObject(dataObjectKey);
        ReloadForm.processTemplateDataElement(metaFactory, dataObject);
        return oldResource;
    }

    public static String reloadDataMigrationKey(IMetaFactory metaFactory, String daMigrationKey, String resource) throws Throwable {
        MetaDataMigrationProfile metaDataMigrationProfile = (MetaDataMigrationProfile)metaFactory.getDataMigrationList().get(daMigrationKey);
        if (metaDataMigrationProfile != null) {
            String oldResource = metaDataMigrationProfile.getResource();
            if (resource != null) {
                metaDataMigrationProfile.setResource(resource);
            }
            try {
                metaFactory.reloadDataMigration(metaDataMigrationProfile.getExtend());
                metaFactory.reloadDataMigration(daMigrationKey);
                MetaDataMigration dataMigration = metaFactory.getDataMigration(daMigrationKey);
                MigrationStruct.remove((String)dataMigration.getTgtDataObjectKey());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return oldResource;
        }
        return null;
    }

    public static void reloadCustom(String projectKey, String key) throws Throwable {
        IMetaFactory iMetaFactory = MetaFactory.getGlobalInstance();
        MetaSolution solution = iMetaFactory.getSolution();
        MetaProjectCollection projectCollection = solution.getProjectCollection();
        MetaProject project = ((MetaProjectProfile)projectCollection.get(projectKey)).getProject();
        ReloadForm.reloadERPMap(key, iMetaFactory, project);
    }

    private static ERPMetaMap reloadERPMap(String key, IMetaFactory iMetaFactory, MetaProject project1) throws Exception {
        List customList = iMetaFactory.getCustomList();
        MetaProject project = project1;
        Iterator iterator = customList.iterator();
        while (iterator.hasNext()) {
            KeyPairMetaObject next = (KeyPairMetaObject)iterator.next();
            if (!(next instanceof ERPMetaMap) || !key.equalsIgnoreCase(next.getKey())) continue;
            project = (MetaProject)((ERPMetaMap)next).getProject();
            iterator.remove();
        }
        String dataMapPathByKey = LoadFileTree.getDataMapPathByKey(key);
        File file = new File(dataMapPathByKey);
        InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);
        Document doc = DomHelper.createDocument((InputStream)in);
        Element rootEl = doc.getDocumentElement();
        String extend = DomHelper.readAttr((Element)rootEl, (String)"Extend", (String)"");
        boolean parentMap = StringUtils.isNotEmpty((CharSequence)extend);
        ERPMetaMap srcMetaERPMap = null;
        if (parentMap) {
            srcMetaERPMap = ReloadForm.reloadERPMap(extend, iMetaFactory, project);
        }
        ERPMetaMapLoad load = new ERPMetaMapLoad(1, parentMap);
        load.load(doc);
        ERPMetaMap dataMap = (ERPMetaMap)load.getRootMetaObject();
        dataMap.setProject((IMetaProject)project);
        customList.add(dataMap);
        if (parentMap) {
            dataMap.setProject(srcMetaERPMap.getProject());
            ERPMetaMap keyPairMetaObject = (ERPMetaMap)iMetaFactory.getMetaCustomObject(ERPMetaMap.class, key);
            ReloadForm.doMergeERPMap(iMetaFactory, keyPairMetaObject, srcMetaERPMap);
        }
        return dataMap;
    }

    public static void processTemplateDataElement(IMetaFactory metaFactory, MetaDataObject dataObject) throws Throwable {
        if (Objects.isNull(dataObject)) {
            return;
        }
        if (!Objects.equals(dataObject.getPrimaryType(), 2)) {
            return;
        }
        MetaTableCollection tableCollection = dataObject.getTableCollection();
        for (MetaTable metaTable : tableCollection) {
            for (MetaColumn metaColumn : metaTable) {
                String dataElementKey = metaColumn.getDataElementKey();
                if (StringUtils.isBlank((CharSequence)dataElementKey) || Objects.nonNull(metaColumn.getDataType()) && metaColumn.getDataType() >= 0) continue;
                MetaDataElement dataElement = metaFactory.getDataElementDef().getDataElement(dataElementKey);
                if (dataElement == null) {
                    throw new MetaException(4214, SimpleStringFormat.format((String)StringTable.getString(null, (String)"", (String)"NoDataElementDefined"), (Object[])new Object[]{dataElementKey}));
                }
                MetaAnnotationUtil.mergeProperty((Object)metaColumn, (MetaDataElement)dataElement);
                metaColumn.setDataElement(dataElement);
            }
        }
    }

    public static void processTemplateDataElement(IMetaFactory metaFactory, MetaForm metaForm) throws Throwable {
        if (Objects.isNull(metaForm)) {
            return;
        }
        if (!Objects.equals(metaForm.getFormType(), 8)) {
            return;
        }
        MetaDataSource dataSource = metaForm.getDataSource();
        if (Objects.isNull(dataSource)) {
            return;
        }
        MetaDataObject dataObject = dataSource.getDataObject();
        ReloadForm.processTemplateDataElement(metaFactory, dataObject);
    }

    private static void doMergeERPMap(IMetaFactory iMetaFactory, ERPMetaMap metaCustomObject, ERPMetaMap srcMetaERPMap) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> aClass = Class.forName("com.bokesoft.yes.erpdatamap.vest.ERPMapVestDiffProcessor");
        Method method = aClass.getMethod("doMergeERPMap", ERPMetaMap.class, ERPMetaMap.class, IMetaFactory.class);
        method.invoke(aClass, metaCustomObject, srcMetaERPMap, iMetaFactory);
    }
}

