/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.setting.impl;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.cmd.CheckXMLChanged;
import com.bokesoft.yes.design.cmd.CommitDiffCmd;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.cmd.XmlDiffProcessor;
import com.bokesoft.yes.design.setting.impl.HandleSettingService;
import com.bokesoft.yes.design.setting.util.SettingCommonUtils;
import com.bokesoft.yes.design.vo.ResponseResult;
import com.bokesoft.yes.design.vo.SettingVo;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.helper.DocumentHelper;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;

public abstract class HandleSettingImpl
implements HandleSettingService {
    public boolean isTableChange(DataTable dataTable) {
        int i = 0;
        while (i < dataTable.size()) {
            if (dataTable.getState(i) != 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public ResponseResult<JSONObject> handleData(SettingVo settingVo) throws Throwable {
        ResponseResult<JSONObject> result = new ResponseResult<JSONObject>();
        JSONObject jsonObject = new JSONObject();
        Document document = HandleSettingImpl.getDocument(settingVo);
        String diffJsonString = settingVo.getDiff();
        List<Diff> diffs = SettingCommonUtils.getDiffsByJson(diffJsonString);
        String type = settingVo.getType();
        CommitDiffCmd.loadXmlTrees(diffs, "", "D_" + type);
        for (Diff diff : diffs) {
            this.dealData(document, diff, jsonObject);
            String oldXml = SettingCommonUtils.saveXml(diff.getXmlTree(), diff.getXmlTree().xmlTree.getRoot(), diff, jsonObject);
            try {
                this.reload(diff.getFilePath());
                this.saveXml(diff.getXmlTree(), diff.getXmlTree().xmlTree.getRoot(), diff, jsonObject);
            }
            catch (Exception e) {
                FileUtils.writeStringToFile((File)new File(diff.getFilePath()), (String)oldXml, (String)"UTF-8");
                this.reload(diff.getFilePath());
                throw new RuntimeException(e.getMessage());
            }
            List<UICommand> uiCommands = this.getUiCommands(diff);
            uiCommands.add(UICommand.showTip("\u64cd\u4f5c\u6210\u529f"));
            jsonObject.put("UICommand", uiCommands);
        }
        result.setCode(0);
        result.setMsg("\u64cd\u4f5c" + type + "\u6210\u529f");
        jsonObject.put("msg", (Object)("\u64cd\u4f5c" + type + "\u6210\u529f"));
        result.setData(jsonObject);
        return result;
    }

    @Override
    public List<UICommand> getUiCommands(Diff diff) {
        ArrayList<UICommand> result1 = new ArrayList<UICommand>();
        result1.add(UICommand.reloadXmlSource(diff.getFilePath()));
        return result1;
    }

    public String genFinalXML(XmlTreeWithPath xmlTree, TagNode rootNode, Diff diff, JSONObject jsonObject) {
        String filePath = diff.getFilePath();
        XmlDiffProcessor.genXmlDiff(xmlTree, rootNode, diff, true);
        String xml = xmlTree.xmlTree.getOrgXml();
        String orgXmlFragment = diff.getOrgXmlFragment();
        String newXmlFragment = diff.getNewXmlFragment();
        boolean insertIndent = diff.isPropertyDiff() && !diff.isGridColumnDrag();
        xml = CheckXMLChanged.mergeXML(xml, diff.getStartLine(), orgXmlFragment, newXmlFragment, null, insertIndent);
        if (diff.getNewXmlFragment() != null) {
            jsonObject.put("newXml", (Object)diff.getNewXmlFragment());
        } else {
            jsonObject.put("newXml", (Object)xmlTree.xmlTree.getOrgXml());
        }
        jsonObject.put("xmlPath", (Object)(StringUtil.isBlankOrNull((String)filePath) ? filePath : FilePathHelper.toFrontFilePath(filePath)));
        return xml;
    }

    protected static Document getDocument(SettingVo settingVo) throws Throwable {
        String docStr = settingVo.getDocument();
        Document document = DocumentHelper.parseDocumentFormJSON(docStr);
        return document;
    }
}

