/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.search;

import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.search.TextSearchRequestor;
import com.bokesoft.yes.design.search.text.FileMatchResource;
import com.bokesoft.yes.design.search.text.TextSearchMatchAccess;
import com.bokesoft.yes.design.xml.parse.Element;
import com.bokesoft.yes.design.xml.parse.Util;
import java.io.File;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

public class TextSearchVisitor {
    private final TextSearchRequestor fCollector;
    private final Pattern fSearchPattern;

    public TextSearchVisitor(TextSearchRequestor collector, Pattern searchPattern) {
        this.fCollector = collector;
        this.fSearchPattern = searchPattern;
    }

    public boolean search() {
        block7: {
            long start = System.currentTimeMillis();
            ThreadPoolExecutor executorService = new ThreadPoolExecutor(10, 64, 10L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            try {
                try {
                    this.fCollector.beginReporting();
                    List<String> solutionsPath = LoadFileTree.getAllSolutionsPath();
                    for (String solutionPath : solutionsPath) {
                        File solutionDir = new File(solutionPath);
                        this.processDir(solutionDir, solutionDir, executorService);
                    }
                    executorService.shutdown();
                    while (!executorService.awaitTermination(100L, TimeUnit.MILLISECONDS)) {
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.fCollector.endReporting();
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.fCollector.endReporting();
                throw throwable;
            }
            this.fCollector.endReporting();
        }
        long end = System.currentTimeMillis();
        return true;
    }

    public boolean processDir(File dir, File solutionDir, ExecutorService executorService) throws Exception {
        if (dir != null && dir.isDirectory()) {
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.isDirectory()) {
                    this.processDir(child, solutionDir, executorService);
                } else {
                    executorService.submit(() -> this.processFile(child, solutionDir));
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean processFile(File file, File solutionDir) throws Exception {
        Matcher matcher;
        Matcher matcher2 = matcher = this.fSearchPattern.pattern().length() == 0 ? null : this.fSearchPattern.matcher("");
        if (!this.fCollector.acceptFile(file, solutionDir) || matcher == null) {
            return false;
        }
        String fileContent = FileUtils.readFileToString((File)file, (String)"UTF-8");
        String fileType = this.getFileType(fileContent);
        if (this.fCollector.acceptFileType(fileType)) {
            this.locateMatches(file, solutionDir, fileContent, matcher, fileType);
        }
        return true;
    }

    private void locateMatches(File file, File solutionDir, String searchInput, Matcher matcher, String fileType) {
        matcher.reset(searchInput);
        FileMatchResource fileMatchRes = new FileMatchResource(solutionDir, file, fileType);
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            if (end == start) continue;
            ReusableMatchAccess access = new ReusableMatchAccess();
            access.initialize(fileMatchRes, start, end - start, searchInput);
            this.fCollector.acceptPatternMatch(access);
        }
    }

    private String getFileType(String searchInput) {
        int ix = Util.getBeginIndex(searchInput);
        int maxIndex = searchInput.length();
        while (ix < maxIndex) {
            Element ele = Util.getNextElement(searchInput, ix);
            if (ele.getType() == 0) {
                return ele.getTagName();
            }
            ix = ele.getEndIndex() + 1;
        }
        return "";
    }

    public static class ReusableMatchAccess
    extends TextSearchMatchAccess {
        private FileMatchResource fFile;
        private int fOffset;
        private int fLength;
        private CharSequence fContent;

        public void initialize(FileMatchResource file, int offset, int length, CharSequence content) {
            this.fFile = file;
            this.fOffset = offset;
            this.fLength = length;
            this.fContent = content;
        }

        @Override
        public int getMatchOffset() {
            return this.fOffset;
        }

        @Override
        public int getMatchLength() {
            return this.fLength;
        }

        @Override
        public int getFileContentLength() {
            return this.fContent.length();
        }

        @Override
        public char getFileContentChar(int offset) {
            return this.fContent.charAt(offset);
        }

        @Override
        public String getFileContent(int offset, int length) {
            return this.fContent.subSequence(offset, offset + length).toString();
        }

        @Override
        public FileMatchResource getFile() {
            return this.fFile;
        }
    }
}

