/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.resolver;

import com.bokesoft.yigo.common.dom.DomSAXReader;
import com.bokesoft.yigo.common.dom.IDomSAXReaderListener;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;
import org.xml.sax.Attributes;

public class DesignProjectMetaResolver
implements IMetaResolver {
    private String projectPath = null;

    public DesignProjectMetaResolver(String projectPath) {
        this.projectPath = projectPath;
    }

    public InputStream read(String resource, int type) throws Exception {
        File f;
        if (resource.indexOf(File.separatorChar) == -1) {
            resource = String.valueOf(this.projectPath) + File.separatorChar + resource;
        }
        if (!(f = new File(resource)).exists() || f.isDirectory()) {
            return null;
        }
        return new FileInputStream(f);
    }

    public boolean write(String resource, byte[] data) throws Exception {
        File f;
        if (resource.indexOf(File.separatorChar) == -1) {
            resource = String.valueOf(this.projectPath) + File.separatorChar + resource;
        }
        if (!(f = new File(resource)).exists()) {
            f.createNewFile();
        }
        FileOutputStream out = new FileOutputStream(f);
        out.write(data);
        out.close();
        return true;
    }

    public int listResource(String resource, String flag, List<String> resources, List<String> names, List<Boolean> flags) throws Exception {
        File f = new File(String.valueOf(this.projectPath) + File.separatorChar + resource);
        File[] files = f.listFiles();
        if (files != null) {
            int length = files.length;
            File childFile = null;
            ArrayList<String> tempResources = new ArrayList<String>();
            ArrayList<String> tempNames = new ArrayList<String>();
            ArrayList<Boolean> tempFlags = new ArrayList<Boolean>();
            int i = 0;
            while (i < length) {
                String fileName;
                childFile = files[i];
                if (childFile.isDirectory()) {
                    fileName = childFile.getName().toLowerCase();
                    if (!fileName.equalsIgnoreCase(".svn")) {
                        resources.add(childFile.getAbsolutePath());
                        names.add(childFile.getName());
                        flags.add(true);
                    }
                } else {
                    fileName = childFile.getName().toLowerCase();
                    if (fileName.endsWith(flag)) {
                        tempResources.add(childFile.getAbsolutePath());
                        tempNames.add(childFile.getName());
                        tempFlags.add(false);
                    }
                }
                ++i;
            }
            resources.addAll(tempResources);
            names.addAll(tempNames);
            flags.addAll(tempFlags);
        }
        return resources.size();
    }

    public boolean isListAbsolutePath() {
        return true;
    }

    public String getPath(String resource) {
        return String.valueOf(this.projectPath) + File.separatorChar + resource;
    }

    public URI getURI(String resource, int type) throws Exception {
        return null;
    }

    public char getSeparator() {
        return File.separatorChar;
    }

    public JSONObject readProfile(String resource, int type) throws Exception {
        final JSONObject profileInfo = new JSONObject();
        DomSAXReader reader = new DomSAXReader(null, new IDomSAXReaderListener(){

            public void startElement(Object parent, String resource, String uri, String localName, String qName, Attributes attributes) {
                profileInfo.put("TagName", (Object)qName);
                int i = 0;
                while (i < attributes.getLength()) {
                    profileInfo.put(attributes.getQName(i), (Object)attributes.getValue(i));
                    ++i;
                }
            }

            public void endElement(String uri, String localName, String qName) {
            }

            public boolean stopParse(boolean startElement, String tagName) {
                return true;
            }
        });
        try (InputStream in = this.read(resource, 0);){
            try {
                reader.start(in, resource);
            }
            catch (Exception exception) {
                if (in != null) {
                    in.close();
                }
            }
        }
        return profileInfo;
    }
}

