/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.metaobjecttype;

import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.MetaObjectType;
import com.bokesoft.yes.design.Property;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.struct.document.Document;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public interface MetaXMLDiffProcessing {
    public void mergeDiff(MetaForm var1, Diff var2, Document var3) throws Throwable;

    default public void genXmlDiff(XmlTreeWithPath xmlTree, TagNode node, Diff diff, boolean isFirst) {
        int bgIndex = node.getElement().getBgIndex();
        int startLine = xmlTree.xmlTree.getLineByIndex(bgIndex);
        String orgXmlFragment = xmlTree.xmlTree.getNodeString(startLine);
        String newXmlFragment = DesignIOMetaUtil.getXml(node);
        if (isFirst) {
            diff.setXmlDiff(xmlTree, startLine, orgXmlFragment, newXmlFragment);
        } else {
            diff.setXmlDiff2(xmlTree, startLine, orgXmlFragment, newXmlFragment);
        }
    }

    default public String getXmlTreeKey(Diff diff, String controlerType, String primaryKey) throws Throwable {
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        MetaObjectType metaObjectType = diff.getMetaObjectType();
        if (metaObjectType == MetaObjectType.field || metaObjectType == MetaObjectType.panel || metaObjectType == MetaObjectType.subDetail || metaObjectType == MetaObjectType.grid || metaObjectType == MetaObjectType.D_DictView || metaObjectType == MetaObjectType.listView) {
            String buddyKey = "";
            String name = diff.properties.get((int)0).property.name;
            String controlType = ControlType.toString((Integer)diff.getControlType());
            TagNode fieldNode = xmlTree.xmlTree.getTagNode(String.valueOf(controlType) + "@" + diff.getKey());
            if (fieldNode != null) {
                buddyKey = fieldNode.getAttributes().get("BuddyKey");
            }
            if ("Label".equals(controlType)) {
                if (Property.key.name.equalsIgnoreCase(name)) {
                    String orgVal = diff.properties.get((int)0).orgValue;
                    return controlType + "@" + orgVal;
                }
                String key = diff.getKey();
                return controlType + "@" + key;
            }
            if (Property.key.name.equalsIgnoreCase(name)) {
                String orgVal = diff.properties.get((int)0).orgValue;
                StringBuilder fieldString = new StringBuilder().append(controlType).append("@").append(orgVal);
                TagNode coluNode = xmlTree.xmlTree.getTagNode(fieldString.toString());
                if (Objects.isNull(coluNode)) {
                    throw new Throwable("warning: \u4e0d\u80fd\u4fee\u6539!");
                }
                String key = coluNode.getAttributes().get("BuddyKey");
                if (StringUtils.isBlank((CharSequence)key)) {
                    return fieldString.toString();
                }
                StringBuilder labString = new StringBuilder().append("Label").append("@").append(key);
                return labString.append(",").append((CharSequence)fieldString).toString();
            }
            if (Property.BuddyKey.name.equalsIgnoreCase(name)) {
                StringBuilder fieldString = new StringBuilder().append(controlType).append("@").append(diff.getKey());
                TagNode coluNode = xmlTree.xmlTree.getTagNode(fieldString.toString());
                if (Objects.isNull(coluNode)) {
                    throw new Throwable("\u4e0d\u80fd\u4fee\u6539!");
                }
                StringBuilder labString = new StringBuilder().append("Label").append("@").append(buddyKey);
                return labString.append(",").append((CharSequence)fieldString).toString();
            }
            if (Property.buddyCaption.name.equalsIgnoreCase(name) || Property.buddyX.name.equalsIgnoreCase(name) || Property.buddyY.name.equalsIgnoreCase(name)) {
                return "Label" + "@" + buddyKey;
            }
            String key = diff.getKey();
            return controlType + "@" + key;
        }
        if (metaObjectType == MetaObjectType.gridField && diff.properties.size() > 0 || metaObjectType == MetaObjectType.GridCellType) {
            String name = diff.properties.get((int)0).property.name;
            if (Property.key.name.equalsIgnoreCase(name)) {
                String orgVal = diff.properties.get((int)0).orgValue;
                StringBuilder CellPrimary = new StringBuilder().append("GridCell").append("@").append(orgVal);
                StringBuilder ColumnPrimary = new StringBuilder().append("GridColumn").append("@").append(orgVal);
                return CellPrimary.append(",").append((CharSequence)ColumnPrimary).toString();
            }
            String key = diff.getKey();
            if (Property.visible.name.equalsIgnoreCase(name)) {
                return "GridColumn" + "@" + key;
            }
            if (Property.caption.name.equalsIgnoreCase(name)) {
                StringBuilder CellPrimary = new StringBuilder().append("GridCell").append("@").append(key);
                StringBuilder ColumnPrimary = new StringBuilder().append("GridColumn").append("@").append(key);
                return CellPrimary.append(",").append((CharSequence)ColumnPrimary).toString();
            }
            return "GridCell" + "@" + key;
        }
        if (metaObjectType == MetaObjectType.listViewField) {
            String name = diff.properties.get((int)0).property.name;
            if (Property.key.name.equalsIgnoreCase(name)) {
                String orgVal = diff.properties.get((int)0).orgValue;
                return "ListViewColumn" + "@" + orgVal;
            }
            String key = diff.getKey();
            if (Property.visible.name.equalsIgnoreCase(name)) {
                return "ListViewColumn" + "@" + key;
            }
            if (Property.caption.name.equalsIgnoreCase(name)) {
                return "ListViewColumn" + "@" + key;
            }
            return "ListViewColumn" + "@" + key;
        }
        if (metaObjectType == MetaObjectType.operationCollection || metaObjectType == MetaObjectType.operation) {
            String key = !"Key".equals(diff.properties.get((int)0).property.name) ? diff.getKey() : primaryKey;
            StringBuilder optPrimary = new StringBuilder().append(MetaObjectType.operation.name).append("@").append(key);
            StringBuilder colPrimary = new StringBuilder().append(MetaObjectType.operationCollection.name).append("@").append(key);
            return optPrimary.append(",").append((CharSequence)colPrimary).toString();
        }
        if (metaObjectType == MetaObjectType.toolbar) {
            String orgVal = diff.properties.get((int)0).orgValue;
            if ("Caption".equals(diff.properties.get((int)0).property.name)) {
                return "ToolBar" + "@" + diff.getKey();
            }
            return "ToolBar" + "@" + orgVal;
        }
        if (metaObjectType == MetaObjectType.ToolBar) {
            return "ToolBar" + "@";
        }
        if (MetaObjectType.GridHeadColumn.equals(metaObjectType)) {
            if (diff.properties.get((int)0).property.name.equals("Key")) {
                return "GridColumn@" + diff.properties.get((int)0).orgValue;
            }
            return "GridColumn@" + diff.getKey();
        }
        return controlerType + "@" + primaryKey;
    }
}

