/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.mergesingle.util;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.mergesingle.impl.SingleSettingImpl;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yigo.common.def.CondSign;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.def.FilterOptSign;
import com.bokesoft.yigo.common.def.FilterValueType;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import org.apache.commons.lang3.StringUtils;

public class GridFilterOperUtil
extends SingleSettingImpl {
    @Override
    public void dealData(Document document, Diff diff, JSONObject jsonObject) throws Throwable {
        DataTable headTable = document.get("ED_GridFilterHead");
        DataTable detailTable = document.get("ED_GridFilterDetail");
        String xmlTreeKey = "Grid@" + diff.getKey();
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        TagNode fieldNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
        GridFilterOperUtil.dealGridFilter(fieldNode, headTable, detailTable);
        this.setTagNode(fieldNode);
    }

    private static void dealGridFilter(TagNode node, DataTable headTable, DataTable detailTable) {
        TagNode filter = null;
        if (headTable.size() > 0) {
            filter = node.getOrCreateChildByTagName("GridFilter");
            filter.setAttribute("Op", FilterOptSign.toString((Integer)headTable.getInt(0, "GridFilter")));
            if (!StringUtils.isNotEmpty((CharSequence)Integer.toString(headTable.getInt(0, "GridFilter")))) {
                filter.getAttributes().remove("Op");
            }
            filter.setAttribute("FilterDependency", headTable.getString(0, "FilterDependency"));
            if (!StringUtils.isNotEmpty((CharSequence)headTable.getString(0, "FilterDependency"))) {
                filter.getAttributes().remove("FilterDependency");
            }
            filter.getChildren().clear();
        }
        int i = 0;
        while (i < detailTable.size()) {
            String type = FilterValueType.format((Integer)Integer.parseInt(detailTable.getString(i, "Type")));
            String fieldKey = detailTable.getString(i, "FieldKey");
            String index = detailTable.getString(i, "Index");
            String condSign = CondSign.toString((Integer)Integer.parseInt(detailTable.getString(i, "CondSign")));
            String refValue = detailTable.getString(i, "RefValue");
            String dataType = "";
            if (StringUtils.isNotEmpty((CharSequence)detailTable.getString(i, "DataType"))) {
                dataType = DataType.toString((Integer)Integer.parseInt(detailTable.getString(i, "DataType")));
            }
            TagNode filterValue = new TagNode("FilterValue", null);
            filterValue.setAttribute("Index", index);
            if (StringUtils.isNotEmpty((CharSequence)type)) {
                filterValue.setAttribute("Type", type);
            }
            if (StringUtils.isNotEmpty((CharSequence)fieldKey)) {
                filterValue.setAttribute("FieldKey", fieldKey);
            }
            if (StringUtils.isNotEmpty((CharSequence)condSign)) {
                filterValue.setAttribute("CondSign", condSign);
            }
            if (StringUtils.isNotEmpty((CharSequence)refValue)) {
                filterValue.setAttribute("RefValue", refValue);
            }
            if (StringUtils.isNotEmpty((CharSequence)dataType)) {
                filterValue.setAttribute("DataType", dataType);
            }
            filter.addNode(filterValue);
            ++i;
        }
    }
}

