/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.io;

import com.bokesoft.distro.tech.bootsupport.starter.deployment.SpringResourceMultiSolutionMetaResolverFactory;
import com.bokesoft.distro.tech.yigosupport.deployment.resource.ResourceMultiSolutionResolver;
import com.bokesoft.distro.tech.yigosupport.deployment.resource.utils.ResourcePaths;
import com.bokesoft.erp.WebDesignerConfiguration;
import com.bokesoft.erp.design.config.ERPWebDesignerMetaFactory;
import com.bokesoft.erp.register.ErpConfig;
import com.bokesoft.yes.design.MetaObjectType;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.cmd.DeleteXmlFileCmd;
import com.bokesoft.yes.design.cmd.EntryProcessor;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.io.Tree;
import com.bokesoft.yes.design.io.TreeNode;
import com.bokesoft.yes.design.newproject.CreateEmptyProjectAction;
import com.bokesoft.yes.design.utils.IDLookup;
import com.bokesoft.yes.design.vo.RecycleForm;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.erpdatamap.ERPMetaMap;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.meta.persist.dom.commondef.MetaCommonDefLoad;
import com.bokesoft.yes.meta.persist.dom.mobiledef.MetaMobileDefLoad;
import com.bokesoft.yes.meta.persist.dom.solution.MetaProjectLoad;
import com.bokesoft.yes.mid.hotdeploy.MidMetaFactoryManager;
import com.bokesoft.yes.mid.meta.MidMetaFactory;
import com.bokesoft.yes.struct.abstractdatatable.SortCriteria;
import com.bokesoft.yigo.common.def.FormType;
import com.bokesoft.yigo.common.util.FileUtil;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.KeyPairCompositeObject;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.common.MetaMacroCollection;
import com.bokesoft.yigo.meta.commondef.MetaCommonDef;
import com.bokesoft.yigo.meta.commondef.MetaOperationCollection;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationList;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationProfile;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectList;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectProfile;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.factory.DefaultMetaFactory;
import com.bokesoft.yigo.meta.factory.DefaultMetaResolverFactory;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.IMetaResolverFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.form.component.MetaEmbed;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.intf.IMetaSolution;
import com.bokesoft.yigo.meta.mobiledef.MetaMobileDef;
import com.bokesoft.yigo.meta.path.MetaSecurityFilter;
import com.bokesoft.yigo.meta.path.MetaSecurityFilterLoad;
import com.bokesoft.yigo.meta.report.MetaReportProfile;
import com.bokesoft.yigo.meta.report.MetaReportSubList;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.meta.solution.MetaProjectCollection;
import com.bokesoft.yigo.meta.solution.MetaProjectProfile;
import com.bokesoft.yigo.meta.solution.MetaSolution;
import com.bokesoft.yigo.meta.strings.MetaStringTable;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadFileTree {
    private static final Logger log = LoggerFactory.getLogger(LoadFileTree.class);
    public static Tree tree;
    public static final Map<String, DefaultMetaFactory> metaDesignerFactoryMap;
    public static final Map<String, String> metaDesignerSolutionPathMap;
    private static Map<String, TreeNode> mapFormKeyToXmlPath;
    private static Map<String, TreeNode> mapDataObjectKeyToXmlPath;
    public static Map<String, TreeNode> mapDataElementKeyToXmlPath;
    public static Map<String, TreeNode> mapDomainKeyToXmlPath;
    public static HashSet<String> loadImportSolutions;
    private static Map<String, Map<String, TreeNode>> excelKeyToXmlPath;
    private static Map<String, Map<String, TreeNode>> printKeyToXmlPath;
    private static Map<String, TreeNode> mapDataKeyToXmlPath;
    private static Map<String, TreeNode> mapDataMigrationToXmlPath;
    private static Map<String, TreeNode> mapBpmKeyToXmlPath;
    private static Map<String, String> designableSolutionKeyMap;
    private static Set<String> jarProjectKey;
    private static DefaultMetaFactory primaryResolverFactory;
    static int oidSeed;

    static {
        metaDesignerFactoryMap = new LinkedHashMap<String, DefaultMetaFactory>();
        metaDesignerSolutionPathMap = new LinkedHashMap<String, String>();
        loadImportSolutions = new HashSet();
        designableSolutionKeyMap = new HashMap<String, String>();
        jarProjectKey = new HashSet<String>();
        primaryResolverFactory = null;
        oidSeed = 0;
    }

    public static void loadFileTree(DefaultContext context, DataTable dataTable, String parentKey) throws Throwable {
        LoadFileTree.ensureLoad();
        if (!dataTable.getMetaData().constains("ChildrenCount")) {
            dataTable.addColumn(new ColumnInfo("ChildrenCount", 1001));
        }
        if (StringUtils.isBlank((CharSequence)parentKey)) {
            parentKey = LoadFileTree.tree.root.key;
        }
        parentKey = FilePathHelper.toBackFilePath(parentKey);
        List<TreeNode> children = LoadFileTree.tree.getNode((String)parentKey).children;
        if (children != null) {
            for (TreeNode node : children) {
                LoadFileTree.addOneRecord(dataTable, node, tree.getNode(parentKey));
            }
        }
        SortCriteria[] sortCriteria = new SortCriteria[2];
        sortCriteria[1] = new SortCriteria("Key", true);
        sortCriteria[0] = new SortCriteria("Type", true);
        dataTable.setSort(sortCriteria);
        dataTable.sort();
    }

    private static TreeNode getTreeNodeByFormKey4HR(String formKey) {
        if (mapFormKeyToXmlPath.containsKey(formKey)) {
            return mapFormKeyToXmlPath.get(formKey);
        }
        if (formKey != null && formKey.length() > 1 && formKey.substring(formKey.length() - 2, formKey.length() - 1).equals("N")) {
            String orgFormKey = formKey.substring(0, formKey.length() - 2);
            return mapFormKeyToXmlPath.get(orgFormKey);
        }
        if (formKey != null && formKey.length() == 1) {
            return mapFormKeyToXmlPath.get(formKey);
        }
        return null;
    }

    public static TreeNode getTreeNodeByDataObjectKey4HR(String DataObject) {
        if (mapDataObjectKeyToXmlPath.containsKey(DataObject.toLowerCase())) {
            return mapDataObjectKeyToXmlPath.get(DataObject.toLowerCase());
        }
        return null;
    }

    private static MetaForm getMetaForm4HR(IMetaFactory metaFactory, String formKey) throws Throwable {
        if (formKey.charAt(formKey.length() - 2) == 'N') {
            String orgFormKey = formKey.substring(0, formKey.length() - 2);
            if (metaFactory.getMetaFormList().containsKey(orgFormKey)) {
                return metaFactory.getMetaForm(orgFormKey);
            }
        }
        return null;
    }

    public static List<String[]> loadFilePathsByFormKey(DefaultContext context, String formKey, String entryParas, String container) throws Throwable {
        List<String[]> tmp;
        String entryFormKey;
        LoadFileTree.ensureLoad();
        if (Objects.isNull(LoadFileTree.getTreeNodeByFormKey4HR(formKey))) {
            return Collections.emptyList();
        }
        ArrayList<String[]> result = new ArrayList<String[]>();
        ArrayList<String[]> dataObjectResult = new ArrayList<String[]>();
        IMetaFactory metaFactory = context.getVE().getMetaFactory();
        if (StringUtils.isNotBlank((CharSequence)container)) {
            MetaFormList metaFormList = metaFactory.getMetaFormList();
            MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
            if (Objects.isNull(metaFormList.get(container)) && dataObjectList.get(container) != null) {
                TreeNode nodeDataObject = mapDataObjectKeyToXmlPath.get(container.toLowerCase());
                container = null;
                dataObjectResult.add(new String[]{nodeDataObject.key, nodeDataObject.namePath});
            }
        }
        LoadFileTree.loadFilePathsByFormKey(metaFactory, result, dataObjectResult, formKey, container);
        result.addAll(dataObjectResult);
        if (entryParas != null && entryParas.length() > 0) {
            entryFormKey = entryParas;
            tmp = LoadFileTree.loadFilePathsByFormKey(context, entryFormKey, null, container);
            result.addAll(tmp);
        }
        if (container != null && container.length() > 0) {
            entryFormKey = container;
            tmp = LoadFileTree.loadFilePathsByFormKey(context, entryFormKey, null, null);
            result.addAll(tmp);
        }
        return result;
    }

    private static void loadFilePathsByFormKey(IMetaFactory metaFactory, List<String[]> result, List<String[]> dataObjectResult, String formKey, String container) throws Throwable {
        String extend;
        String dataObjectKey;
        MetaDataSource dataSource;
        String templateKey;
        TreeNode nodeEmbed;
        TreeNode node = LoadFileTree.getTreeNodeByFormKey4HR(formKey);
        result.add(new String[]{node.key, node.namePath});
        MetaForm metaForm = metaFactory.getMetaForm(formKey);
        for (MetaEmbed metaEmbed : metaForm.getEmbeds()) {
            String embedKey = metaEmbed.getFormKey();
            TreeNode nodeEmbed2 = mapFormKeyToXmlPath.get(embedKey);
            if (nodeEmbed2 == null) continue;
            result.add(new String[]{nodeEmbed2.key, nodeEmbed2.namePath});
        }
        MetaForm metaForm4HR = LoadFileTree.getMetaForm4HR(metaFactory, formKey);
        if (metaForm4HR != null) {
            for (MetaEmbed metaEmbed : metaForm4HR.getEmbeds()) {
                String embedKey = metaEmbed.getFormKey();
                nodeEmbed = mapFormKeyToXmlPath.get(embedKey);
                result.add(new String[]{nodeEmbed.key, nodeEmbed.namePath});
            }
        }
        if ((templateKey = metaForm.getTemplateKey()) != null && templateKey.length() > 0) {
            LoadFileTree.loadFilePathsByFormKey(metaFactory, result, dataObjectResult, templateKey, container);
        }
        if ((dataSource = metaForm.getDataSource()) != null && (dataObjectKey = dataSource.getRefObjectKey()) != null && dataObjectKey.length() > 0) {
            TreeNode nodeDataObject = mapDataObjectKeyToXmlPath.get(dataObjectKey.toLowerCase());
            dataObjectResult.add(new String[]{nodeDataObject.key, nodeDataObject.namePath});
            MetaDataObject dataObject = metaFactory.getDataObject(dataObjectKey);
            String otherKey = dataObject.getExtend();
            if (StringUtils.isBlank((CharSequence)otherKey)) {
                otherKey = dataObject.getMergeToSourceMapKey();
            }
            if (StringUtils.isNotBlank((CharSequence)otherKey)) {
                TreeNode otherNode = mapDataObjectKeyToXmlPath.get(otherKey.toLowerCase());
                dataObjectResult.add(new String[]{otherNode.key, otherNode.namePath});
            }
        }
        if ((extend = metaForm.getExtend()) != null && !"".equals(extend)) {
            nodeEmbed = mapFormKeyToXmlPath.get(extend);
            result.add(new String[]{nodeEmbed.key, nodeEmbed.namePath});
        }
    }

    public static void clear() {
        tree = null;
        mapBpmKeyToXmlPath.clear();
        mapFormKeyToXmlPath.clear();
        mapDomainKeyToXmlPath.clear();
        mapDataElementKeyToXmlPath.clear();
        excelKeyToXmlPath.clear();
        printKeyToXmlPath.clear();
        mapDataKeyToXmlPath.clear();
        mapDataMigrationToXmlPath.clear();
        mapDataObjectKeyToXmlPath.clear();
        designableSolutionKeyMap.clear();
    }

    public static String loadFilePathByFormFieldKey(String formKey, String fieldKey, String parentKey, String entryParas, String type) throws Throwable {
        String result;
        int keylong;
        LoadFileTree.ensureLoad();
        if (formKey.equals(fieldKey) && MetaObjectType.form.name.equals(type)) {
            return LoadFileTree.mapFormKeyToXmlPath.get((Object)formKey).key;
        }
        if (formKey != null && !"".equals(formKey) && Objects.isNull(LoadFileTree.getTreeNodeByFormKey4HR(formKey))) {
            TreeNode node = LoadFileTree.getTreeNodeByDataObjectKey4HR(formKey);
            if (node != null) {
                String namePath = node.namePath;
                return namePath;
            }
            return null;
        }
        if (MetaObjectType.DataObject.name.equals(type) && LoadFileTree.getTreeNodeByFormKey4HR(formKey) != null) {
            TreeNode node = LoadFileTree.getTreeNodeByFormKey4HR(formKey);
            if (node != null) {
                String namePath = node.namePath;
                return namePath;
            }
            return null;
        }
        if (Objects.isNull(LoadFileTree.getTreeNodeByFormKey4HR(formKey))) {
            return null;
        }
        MetaForm containerForm = null;
        String otherKey = null;
        if (entryParas != null && (keylong = entryParas.length()) > 0 && !entryParas.equals("null")) {
            otherKey = entryParas;
            containerForm = StringUtils.isBlank((CharSequence)otherKey) ? null : MetaFactory.getGlobalInstance().getMetaForm(otherKey);
        }
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaForm metaForm = metaFactory.getMetaForm(formKey);
        for (MetaEmbed metaEmbed : metaForm.getEmbeds()) {
            String embedKey = metaEmbed.getFormKey();
            if (IDLookup.getIDLookup(metaFactory.getMetaForm(embedKey)).containFieldKey(fieldKey)) {
                return LoadFileTree.mapFormKeyToXmlPath.get((Object)embedKey).key;
            }
            if (parentKey == null || IDLookup.getIDLookup(metaFactory.getMetaForm(embedKey)).getPanelKeyByFieldKey(parentKey) == null) continue;
            return LoadFileTree.mapFormKeyToXmlPath.get((Object)embedKey).key;
        }
        String templateKey = metaForm.getTemplateKey();
        if (templateKey != null && templateKey.length() > 0 && (result = LoadFileTree.loadFilePathByFormFieldKey(formKey, fieldKey, parentKey, entryParas, null)) != null) {
            return result;
        }
        IDLookup idLoopup = null;
        IDLookup containerIdLoopup = null;
        if (metaForm != null) {
            idLoopup = IDLookup.getIDLookup(metaForm);
        }
        if (containerForm != null) {
            containerIdLoopup = IDLookup.getIDLookup(containerForm);
        }
        String refObjectKey = null;
        String dataObjectKey = null;
        if (Objects.isNull(metaForm.getDataSource())) {
            if (containerForm != null && containerForm.getDataSource() != null) {
                refObjectKey = containerForm.getDataSource().getRefObjectKey();
                dataObjectKey = containerForm.getDataSource().getDataObject().getKey();
            }
        } else {
            refObjectKey = metaForm.getDataSource().getRefObjectKey();
            dataObjectKey = metaForm.getDataSource().getDataObject().getKey();
        }
        if (refObjectKey != null && refObjectKey.length() > 0 && refObjectKey.equals(fieldKey)) {
            return LoadFileTree.mapDataObjectKeyToXmlPath.get((Object)refObjectKey.toLowerCase()).key;
        }
        if ("DataObjectCheckRule".equals(fieldKey)) {
            return LoadFileTree.getTreeNodeByFormKey4HR((String)formKey).key;
        }
        MetaMacroCollection macroCollection = metaForm.getMacroCollection();
        MetaGrid metaGridByGridKey = idLoopup.getMetaGridByGridKey(parentKey);
        if (Objects.isNull(metaGridByGridKey) && containerIdLoopup != null) {
            metaGridByGridKey = containerIdLoopup.getMetaGridByGridKey(parentKey);
        }
        MetaGrid metaGrid = idLoopup.getMetaGridByGridKey(fieldKey);
        if (Objects.isNull(metaGridByGridKey) && containerIdLoopup != null) {
            metaGridByGridKey = containerIdLoopup.getMetaGridByGridKey(fieldKey);
        }
        boolean isHave = false;
        if (metaForm.getDataSource() != null) {
            MetaTableCollection tableCollection = metaForm.getDataSource().getDataObject().getTableCollection();
            int i = 0;
            while (i < tableCollection.size()) {
                isHave = ((MetaTable)tableCollection.get(i)).containsKey(fieldKey);
                if (isHave) break;
                ++i;
            }
        }
        if (idLoopup.containFieldKey(fieldKey) || idLoopup.containFieldKey(parentKey) && !"ToolBar".equals(idLoopup.getTagNameByKey(parentKey)) || isHave || metaGridByGridKey != null || metaGrid != null || dataObjectKey != null && dataObjectKey.equals(fieldKey) || macroCollection != null && macroCollection.containsKey(fieldKey) || metaForm.getKey().equalsIgnoreCase(fieldKey) || "null".equalsIgnoreCase(fieldKey)) {
            return LoadFileTree.getTreeNodeByFormKey4HR((String)formKey).key;
        }
        if (containerIdLoopup != null && (containerIdLoopup.containFieldKey(fieldKey) || containerIdLoopup.containFieldKey(parentKey) && !"ToolBar".equals(containerIdLoopup.getTagNameByKey(parentKey)) || metaGridByGridKey != null || metaGrid != null || dataObjectKey.equals(otherKey))) {
            return LoadFileTree.getTreeNodeByFormKey4HR((String)otherKey).key;
        }
        MetaOperationCollection metaOperationCollection = metaFactory.getMetaForm(formKey).getOperationCollection();
        if (metaOperationCollection != null) {
            for (KeyPairCompositeObject keyPairCompositeObject : metaOperationCollection) {
                if (fieldKey != null && fieldKey.equals(keyPairCompositeObject.getKey())) {
                    return LoadFileTree.getTreeNodeByFormKey4HR((String)formKey).key;
                }
                if (!(keyPairCompositeObject instanceof MetaOperationCollection)) continue;
                for (KeyPairCompositeObject pairCompositeObject : (MetaOperationCollection)keyPairCompositeObject) {
                    if (fieldKey == null || !fieldKey.equals(pairCompositeObject.getKey())) continue;
                    return LoadFileTree.getTreeNodeByFormKey4HR((String)formKey).key;
                }
            }
        }
        if (LoadFileTree.getTreeNodeByFormKey4HR(formKey) != null) {
            return LoadFileTree.getTreeNodeByFormKey4HR((String)formKey).key;
        }
        return null;
    }

    public static String loadFilePathByDataObjectFieldKey(String refObjectKey) throws Throwable {
        if (mapDataObjectKeyToXmlPath.get(refObjectKey.toLowerCase()) != null) {
            return LoadFileTree.mapDataObjectKeyToXmlPath.get((Object)refObjectKey.toLowerCase()).key;
        }
        return null;
    }

    public static String loadFilePathByVestFormFieldKey(boolean is, String formKey, String fieldKey, String parentKey, String entryParas) throws Throwable {
        String result;
        int keylong;
        LoadFileTree.ensureLoad();
        if (Objects.isNull(LoadFileTree.getTreeNodeByFormKey4HR(formKey))) {
            return null;
        }
        MetaForm containerForm = null;
        String otherKey = null;
        if (entryParas != null && entryParas.contains("FormKey") && (keylong = entryParas.length()) > 0 && !entryParas.equals("null")) {
            otherKey = entryParas;
            containerForm = StringUtils.isBlank((CharSequence)otherKey) ? null : MetaFactory.getGlobalInstance().getMetaForm(otherKey);
        }
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaForm metaForm = metaFactory.getMetaForm(formKey);
        for (MetaEmbed metaEmbed : metaForm.getEmbeds()) {
            String embedKey = metaEmbed.getFormKey();
            if (IDLookup.getIDLookup(metaFactory.getMetaForm(embedKey)).containFieldKey(fieldKey)) {
                return LoadFileTree.mapFormKeyToXmlPath.get((Object)embedKey).key;
            }
            if (parentKey == null || IDLookup.getIDLookup(metaFactory.getMetaForm(embedKey)).getPanelKeyByFieldKey(parentKey) == null) continue;
            return LoadFileTree.mapFormKeyToXmlPath.get((Object)embedKey).key;
        }
        String templateKey = metaForm.getTemplateKey();
        if (templateKey != null && templateKey.length() > 0 && (result = LoadFileTree.loadFilePathByFormFieldKey(formKey, fieldKey, parentKey, entryParas, null)) != null) {
            return result;
        }
        IDLookup idLoopup = null;
        IDLookup containerIdLoopup = null;
        if (metaForm != null) {
            idLoopup = IDLookup.getIDLookup(metaForm);
        }
        if (containerForm != null) {
            containerIdLoopup = IDLookup.getIDLookup(containerForm);
        }
        String refObjectKey = null;
        String dataObjectKey = null;
        if (Objects.isNull(metaForm.getDataSource())) {
            if (containerForm != null && containerForm.getDataSource() != null) {
                refObjectKey = containerForm.getDataSource().getRefObjectKey();
                dataObjectKey = containerForm.getDataSource().getDataObject().getKey();
            }
        } else {
            refObjectKey = metaForm.getDataSource().getRefObjectKey();
            dataObjectKey = metaForm.getDataSource().getDataObject().getKey();
        }
        if (refObjectKey != null && refObjectKey.length() > 0 && refObjectKey.equals(fieldKey)) {
            return LoadFileTree.mapDataObjectKeyToXmlPath.get((Object)refObjectKey.toLowerCase()).key;
        }
        if ("DataObjectCheckRule".equals(fieldKey)) {
            return LoadFileTree.getTreeNodeByFormKey4HR((String)formKey).key;
        }
        MetaMacroCollection macroCollection = metaForm.getMacroCollection();
        MetaGrid metaGridByGridKey = idLoopup.getMetaGridByGridKey(parentKey);
        if (Objects.isNull(metaGridByGridKey) && containerIdLoopup != null) {
            metaGridByGridKey = containerIdLoopup.getMetaGridByGridKey(parentKey);
        }
        MetaGrid metaGrid = idLoopup.getMetaGridByGridKey(fieldKey);
        if (Objects.isNull(metaGridByGridKey) && containerIdLoopup != null) {
            metaGridByGridKey = containerIdLoopup.getMetaGridByGridKey(fieldKey);
        }
        boolean isHave = false;
        if (metaForm.getDataSource() != null) {
            MetaTableCollection tableCollection = metaForm.getDataSource().getDataObject().getTableCollection();
            int i = 0;
            while (i < tableCollection.size()) {
                isHave = ((MetaTable)tableCollection.get(i)).containsKey(fieldKey);
                if (isHave) break;
                ++i;
            }
        }
        if (is || idLoopup.containFieldKey(fieldKey) || idLoopup.containFieldKey(parentKey) && !"ToolBar".equals(idLoopup.getTagNameByKey(parentKey)) || isHave || metaGridByGridKey != null || metaGrid != null || dataObjectKey.equals(fieldKey) || macroCollection.containsKey(fieldKey) || metaForm.getKey().equalsIgnoreCase(fieldKey) || "null".equalsIgnoreCase(fieldKey)) {
            return LoadFileTree.getTreeNodeByFormKey4HR((String)formKey).key;
        }
        if (containerIdLoopup != null && (containerIdLoopup.containFieldKey(fieldKey) || containerIdLoopup.containFieldKey(parentKey) && !"ToolBar".equals(containerIdLoopup.getTagNameByKey(parentKey)) || metaGridByGridKey != null || metaGrid != null || dataObjectKey.equals(otherKey))) {
            return LoadFileTree.getTreeNodeByFormKey4HR((String)otherKey).key;
        }
        MetaOperationCollection metaOperationCollection = metaFactory.getMetaForm(formKey).getOperationCollection();
        if (metaOperationCollection != null) {
            for (KeyPairCompositeObject keyPairCompositeObject : metaOperationCollection) {
                if (fieldKey.equals(keyPairCompositeObject.getKey())) {
                    return LoadFileTree.getTreeNodeByFormKey4HR((String)formKey).key;
                }
                if (!(keyPairCompositeObject instanceof MetaOperationCollection)) continue;
                for (KeyPairCompositeObject pairCompositeObject : (MetaOperationCollection)keyPairCompositeObject) {
                    if (!fieldKey.equals(pairCompositeObject.getKey())) continue;
                    return LoadFileTree.getTreeNodeByFormKey4HR((String)formKey).key;
                }
            }
        }
        return null;
    }

    public static List<String> loadParentPathsByPath(DefaultContext context, String path) throws Throwable {
        LoadFileTree.ensureLoad();
        TreeNode node = tree.getNode(path);
        ArrayList<String> result = new ArrayList<String>();
        while (node != null && node != LoadFileTree.tree.root) {
            result.add(node.key);
            node = tree.getNode(node.parentKey);
        }
        Collections.reverse(result);
        return result;
    }

    public static Map<String, String> loadNodeAttrByPath(DefaultContext context, String path) throws Throwable {
        LoadFileTree.ensureLoad();
        HashMap<String, String> map = new HashMap<String, String>();
        TreeNode node = tree.getNode(path);
        if (node == null) {
            return map;
        }
        map.put("OID", String.valueOf(oidSeed++));
        map.put("Key", FilePathHelper.toFrontFilePath(node.key));
        map.put("ParentKey", FilePathHelper.toFrontFilePath(node.parentKey));
        map.put("Description", node.description);
        map.put("Type", node.type);
        map.put("IsInJar", Boolean.toString(node.isInJar));
        map.put("FocusRowChangedFormula", FilePathHelper.toFrontFilePath(node.focusRowChangedFormula));
        if (node.type.equalsIgnoreCase("file")) {
            XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(node.key, false);
            if (xmlTreeWithPath == null) {
                return map;
            }
            TagNode root = xmlTreeWithPath.xmlTree.getRoot();
            String tagName = root.getTagName();
            if (tagName.equals("RightsDefinition")) {
                tagName = "NoRights";
            }
            map.put("Type", tagName);
        }
        return map;
    }

    public static String getPathByFormKey(String formKey) throws Throwable {
        LoadFileTree.ensureLoad();
        if (Objects.isNull(LoadFileTree.getTreeNodeByFormKey4HR(formKey))) {
            return null;
        }
        TreeNode node = LoadFileTree.getTreeNodeByFormKey4HR(formKey);
        return node.key;
    }

    public static String getPathByDataObject(String DataObjectKey) throws Throwable {
        LoadFileTree.ensureLoad();
        if (Objects.isNull(LoadFileTree.getTreeNodeByDataObjectKey4HR(DataObjectKey))) {
            return null;
        }
        TreeNode node = LoadFileTree.getTreeNodeByDataObjectKey4HR(DataObjectKey);
        return node.key;
    }

    public static void ensureLoad() throws Throwable {
        if (Objects.isNull(tree)) {
            mapFormKeyToXmlPath = new HashMap<String, TreeNode>();
            mapDataObjectKeyToXmlPath = new HashMap<String, TreeNode>();
            mapDataElementKeyToXmlPath = new HashMap<String, TreeNode>();
            mapDomainKeyToXmlPath = new HashMap<String, TreeNode>();
            mapDataKeyToXmlPath = new HashMap<String, TreeNode>();
            mapDataMigrationToXmlPath = new HashMap<String, TreeNode>();
            mapBpmKeyToXmlPath = new HashMap<String, TreeNode>();
            excelKeyToXmlPath = new HashMap<String, Map<String, TreeNode>>();
            printKeyToXmlPath = new HashMap<String, Map<String, TreeNode>>();
            log.info("ensureLoad(): \u5f00\u59cb\u52a0\u8f7d\u6587\u4ef6\u6811 - loadFileTree() ...");
            LoadFileTree.loadFileTree();
            log.info("ensureLoad(): \u52a0\u8f7d\u6587\u4ef6\u6811 - loadFileTree() \u5b8c\u6210 .");
        } else {
            log.info("ensureLoad(): \u6587\u4ef6\u6811\u5df2\u52a0\u8f7d, \u65e0\u5b9e\u9645\u64cd\u4f5c .");
        }
    }

    public static void ensureLoad(IMetaFactory metaFactory) throws Throwable {
        if (Objects.isNull(tree)) {
            mapFormKeyToXmlPath = new HashMap<String, TreeNode>();
            mapDataObjectKeyToXmlPath = new HashMap<String, TreeNode>();
            mapDataElementKeyToXmlPath = new HashMap<String, TreeNode>();
            mapDomainKeyToXmlPath = new HashMap<String, TreeNode>();
            mapDataKeyToXmlPath = new HashMap<String, TreeNode>();
            mapDataMigrationToXmlPath = new HashMap<String, TreeNode>();
            mapBpmKeyToXmlPath = new HashMap<String, TreeNode>();
            excelKeyToXmlPath = new HashMap<String, Map<String, TreeNode>>();
            printKeyToXmlPath = new HashMap<String, Map<String, TreeNode>>();
            LoadFileTree.loadFileTree(metaFactory);
        }
    }

    public static void ensureLoad(String solutionPath) throws Throwable {
        if (Objects.isNull(tree)) {
            mapFormKeyToXmlPath = new HashMap<String, TreeNode>();
            mapDataObjectKeyToXmlPath = new HashMap<String, TreeNode>();
            mapDataElementKeyToXmlPath = new HashMap<String, TreeNode>();
            mapDomainKeyToXmlPath = new HashMap<String, TreeNode>();
            mapDataKeyToXmlPath = new HashMap<String, TreeNode>();
            mapDataMigrationToXmlPath = new HashMap<String, TreeNode>();
            mapBpmKeyToXmlPath = new HashMap<String, TreeNode>();
            excelKeyToXmlPath = new HashMap<String, Map<String, TreeNode>>();
            printKeyToXmlPath = new HashMap<String, Map<String, TreeNode>>();
            LoadFileTree.loadFileTree(solutionPath);
        }
    }

    private static void addOneRecord(DataTable dataTable, TreeNode node, TreeNode pNode) throws Throwable {
        int rowIndex = dataTable.append();
        dataTable.setObject(rowIndex, "OID", (Object)oidSeed++);
        StringBuilder sb = new StringBuilder(256);
        sb.append(node.name);
        switch (node.name) {
            case "DataMap": {
                sb.append(" ").append("\u6570\u636e\u6620\u5c04");
                break;
            }
            case "Custom": {
                sb.append(" ").append("\u6570\u636e\u6620\u5c04");
                break;
            }
            case "BPM": {
                sb.append(" ").append("\u5de5\u4f5c\u6d41\u7a0b");
                break;
            }
            case "BPM.xml": {
                sb.append(" ").append("\u5de5\u4f5c\u6d41\u7a0b\u5355\u636e\u5173\u8054\u8bbe\u7f6e");
                break;
            }
            case "Entry.xml": {
                sb.append(" ").append("\u83dc\u5355");
                break;
            }
            case "Form": {
                sb.append(" ").append("\u8868\u5355");
                break;
            }
            case "DataMigration": {
                sb.append(" ").append("\u6570\u636e\u8fc1\u79fb");
                break;
            }
            case "DataObject": {
                sb.append(" ").append("\u6570\u636e\u5bf9\u8c61");
                break;
            }
            case "DataElement": {
                sb.append(" ").append("\u6570\u636e\u5143\u7d20");
                break;
            }
            case "Domain": {
                sb.append(" ").append("\u57df");
                break;
            }
            default: {
                if (sb.indexOf(".xml") == -1) break;
                int length = sb.length() - 4;
                sb = new StringBuilder(sb.substring(0, length));
            }
        }
        if (node.description != null && node.description.length() > 0) {
            sb.append(" ").append(node.description);
        }
        LoadFileTree.checkChildFile(node);
        if (node.type.equalsIgnoreCase("file")) {
            boolean isFirstLevel;
            boolean bl = isFirstLevel = Objects.isNull(pNode) || pNode == LoadFileTree.tree.root;
            if (!isFirstLevel) {
                sb.append(" (");
            }
            sb.append(File.separator).append(pNode.namePath);
            if (!isFirstLevel) {
                sb.append(")");
            }
        }
        if (node.name.equals("BPM")) {
            int i = 0;
            while (i < dataTable.size() - 1) {
                if (dataTable.getString(i, "Name").contains("BPM.xml")) {
                    int newRowIndex = 0;
                    if (i != 0) {
                        newRowIndex = i - 1;
                    }
                    dataTable.setObject(rowIndex, "Name", dataTable.getObject(newRowIndex, "Name"));
                    dataTable.setObject(rowIndex, "Description", dataTable.getObject(newRowIndex, "Description"));
                    dataTable.setObject(rowIndex, "Key", dataTable.getObject(newRowIndex, "Key"));
                    dataTable.setObject(rowIndex, "ParentKey", dataTable.getObject(newRowIndex, "ParentKey"));
                    dataTable.setString(rowIndex, "FocusRowChangedFormula", dataTable.getString(newRowIndex, "FocusRowChangedFormula"));
                    dataTable.setObject(rowIndex, "Type", dataTable.getObject(newRowIndex, "Type"));
                    dataTable.setObject(rowIndex, "FileType", dataTable.getObject(newRowIndex, "FileType"));
                    dataTable.setObject(rowIndex, "ProjectKey", dataTable.getObject(newRowIndex, "ProjectKey"));
                    if (node.type.equalsIgnoreCase("fold")) {
                        dataTable.setObject(rowIndex, "ChildrenCount", (Object)1);
                    } else {
                        dataTable.setObject(rowIndex, "ChildrenCount", dataTable.getObject(newRowIndex, "ChildrenCount"));
                    }
                    rowIndex = newRowIndex;
                }
                ++i;
            }
        }
        dataTable.setObject(rowIndex, "Name", (Object)FilePathHelper.toFrontFilePath(sb.toString()));
        dataTable.setObject(rowIndex, "Description", (Object)node.description);
        dataTable.setObject(rowIndex, "Key", (Object)FilePathHelper.toFrontFilePath(node.key));
        dataTable.setObject(rowIndex, "ParentKey", (Object)FilePathHelper.toFrontFilePath(node.parentKey));
        String focusRowChangedFormula = StringUtils.isBlank((CharSequence)node.focusRowChangedFormula) ? node.focusRowChangedFormula : FilePathHelper.toFrontFilePath(node.focusRowChangedFormula);
        dataTable.setString(rowIndex, "FocusRowChangedFormula", focusRowChangedFormula);
        dataTable.setObject(rowIndex, "Type", (Object)node.type);
        if (node.type.equalsIgnoreCase("file")) {
            String path = node.key;
            XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(path, false);
            TagNode root = xmlTreeWithPath.xmlTree.getRoot();
            String tagName = root.getTagName();
            if (tagName.equals("RightsDefinition")) {
                tagName = "NoRights";
            }
            dataTable.setObject(rowIndex, "FileType", (Object)tagName);
            String key = root.getAttributes().get("Key");
            if (!(key == null || key.length() <= 0 || key.equals(node.name.split(".xml")[0]) || tagName.equals("Solution") || tagName.equals("Entry"))) {
                tagName.equals("Project");
            }
        } else {
            dataTable.setObject(rowIndex, "FileType", (Object)"");
        }
        dataTable.setObject(rowIndex, "ProjectKey", (Object)node.projectKey);
        if (node.type.equalsIgnoreCase("fold")) {
            dataTable.setObject(rowIndex, "ChildrenCount", (Object)1);
        } else {
            dataTable.setObject(rowIndex, "ChildrenCount", (Object)node.allChildrenCount);
        }
        dataTable.setBoolean(rowIndex, "IsInJar", Boolean.valueOf(node.isInJar));
    }

    private static void checkChildFile(TreeNode parentNode) throws Throwable {
        if (parentNode.allChildrenCount > 0) {
            int i = 0;
            while (i < parentNode.allChildrenCount) {
                String path;
                XmlTreeWithPath xmlTreeWithPath;
                TreeNode node = parentNode.children.get(i);
                if (node.type.equalsIgnoreCase("file") && Objects.isNull(xmlTreeWithPath = XmlTreeWithPath.parseFilePath(path = node.key, false))) {
                    parentNode.removeChild(node);
                }
                ++i;
            }
        }
    }

    private static String getRootReourceClasspath(IMetaResolverFactory metaResolverFactory) throws ReflectiveOperationException {
        if (metaResolverFactory instanceof SpringResourceMultiSolutionMetaResolverFactory) {
            String rootResourcePath = (String)FieldUtils.readDeclaredField((Object)metaResolverFactory, (String)"rootResourcePath", (boolean)true);
            return rootResourcePath;
        }
        return null;
    }

    private static String metaResolverFactory2String(IMetaResolverFactory metaResolverFactory) throws Exception {
        if (metaResolverFactory == null) {
            return null;
        }
        String clsName = metaResolverFactory.getClass().getSimpleName();
        String descr = metaResolverFactory instanceof SpringResourceMultiSolutionMetaResolverFactory ? LoadFileTree.getRootReourceClasspath(metaResolverFactory) : metaResolverFactory.getSolutionPath();
        return String.valueOf(clsName) + ": " + descr;
    }

    public static void loadFileTree() throws Throwable {
        Object rootResourcePath;
        primaryResolverFactory = null;
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        String workspacePath = FilePathHelper.getWorkspacePath();
        Collection metaSolutions = metaFactory.getMetaSolutions();
        IMetaResolverFactory primaryMetaResolverFactory = metaFactory.getMetaResolverFactory();
        log.info("loadFileTree() - \u51c6\u5907\u901a\u8fc7 '{}' \u52a0\u8f7d\u4e3b Solution ...", (Object)LoadFileTree.metaResolverFactory2String(primaryMetaResolverFactory));
        String primaryRootResourcePath = LoadFileTree.getRootReourceClasspath(primaryMetaResolverFactory);
        MidMetaFactory midMetaFactory = new MidMetaFactory(primaryMetaResolverFactory);
        MetaSolution midMetaFactorySolution = midMetaFactory.getSolution();
        File primarySolutionFile = FileUtils.getFile((String[])new String[]{metaFactory.getSolutionPath()});
        File primarySolutionParentFile = primarySolutionFile.getParentFile();
        String primarySolutionPath = primarySolutionFile.getCanonicalPath();
        if (primaryRootResourcePath != null) {
            log.info("loadFileTree() - \u52a0\u8f7d\u4e3b Solution '{}', \u8def\u5f84\u4e3a '{}' .", (Object)midMetaFactorySolution.getKey(), (Object)primaryRootResourcePath);
        } else {
            log.info("loadFileTree() - \u52a0\u8f7d\u4e3b Solution '{}', \u8def\u5f84\u4e3a '{}' .", (Object)midMetaFactorySolution.getKey(), (Object)primarySolutionPath);
        }
        primaryResolverFactory = midMetaFactory;
        metaDesignerFactoryMap.put(primarySolutionPath, (DefaultMetaFactory)midMetaFactory);
        metaDesignerSolutionPathMap.put(metaFactory.getSolution().getKey(), primarySolutionPath);
        designableSolutionKeyMap.put(midMetaFactorySolution.getKey(), StringUtils.substringAfterLast((String)primarySolutionPath, (int)File.separatorChar));
        for (MetaSolution metaSolution : metaSolutions) {
            String slnKey = metaSolution.getKey();
            IMetaResolverFactory resolverFactory = metaFactory.getMetaResolverFactoryBySolution(slnKey);
            if (Objects.isNull(resolverFactory)) continue;
            String solutionPath = FileUtils.getFile((String[])new String[]{resolverFactory.getSolutionPath()}).getCanonicalPath();
            if (!StringUtils.contains((CharSequence)solutionPath, (CharSequence)workspacePath)) {
                log.info("loadFileTree()|\u8d44\u6e90\u5904\u7406 - \u51c6\u5907\u5904\u7406\u4e0d\u5728 Workspace Path '{}' \u4e2d\u7684 Solution '{}'(\u76ee\u5f55\u4e3a '{}') ...", new Object[]{workspacePath, slnKey, solutionPath});
                rootResourcePath = LoadFileTree.getRootReourceClasspath(resolverFactory);
                if (rootResourcePath != null) {
                    if (((String)rootResourcePath).startsWith("classpath:/")) {
                        log.info("loadFileTree()|\u8d44\u6e90\u5904\u7406 - \u5f00\u59cb\u5904\u7406 Solution '{}', rootResourcePath='{}' ...", (Object)slnKey, rootResourcePath);
                        String resourcePathName = ((String)rootResourcePath).substring("classpath:/".length());
                        if (StringUtils.equals((CharSequence)rootResourcePath, (CharSequence)primaryRootResourcePath)) {
                            log.info("loadFileTree()|\u8d44\u6e90\u5904\u7406 - \u5ffd\u7565 Solution '{}' \u52a0\u8f7d(\u4e3b Solution \u5df2\u52a0\u8f7d) .", (Object)slnKey);
                        } else {
                            ERPWebDesignerMetaFactory metaFactory1 = new ERPWebDesignerMetaFactory(resolverFactory);
                            metaFactory1.setDesignerMetaFactory((DefaultMetaFactory)midMetaFactory);
                            metaFactory1.getSolution();
                        }
                        IMetaResolver iMetaResolver = resolverFactory.newMetaResolver("");
                        LoadFileTree.saveUploadResource(resourcePathName);
                        LoadFileTree.saveUploadResource(resourcePathName, iMetaResolver);
                        log.info("loadFileTree()|\u8d44\u6e90\u5904\u7406 - \u5904\u7406 Solution '{}' \u5b8c\u6210, rootResourcePath='{}' .", (Object)slnKey, rootResourcePath);
                        continue;
                    }
                    log.warn("loadFileTree()|\u8d44\u6e90\u5904\u7406 - \u6682\u4e0d\u652f\u6301 Solution '{}' \u7684\u8d44\u6e90\u7c7b\u578b '{}', \u8be5 Solution \u5c06\u88ab\u5ffd\u7565 .", (Object)slnKey, rootResourcePath);
                    continue;
                }
                log.info("loadFileTree()|\u8d44\u6e90\u5904\u7406 - \u5ffd\u7565\u4e0d\u662f\u901a\u8fc7\u8d44\u6e90\u52a0\u8f7d\u7684 Solution '{}' .", (Object)slnKey);
                continue;
            }
            log.info("loadFileTree()|\u8d44\u6e90\u5904\u7406 - \u5b58\u653e\u5728 Workspace Path '{}' \u4e0b\u7684 Solution '{}'(\u76ee\u5f55\u4e3a '{}') \u4e0d\u9700\u8981\u989d\u5916\u5904\u7406 .", new Object[]{workspacePath, slnKey, solutionPath});
        }
        tree = new Tree(workspacePath);
        designableSolutionKeyMap.clear();
        if (StringUtils.isNotBlank((CharSequence)metaFactory.getSolutionPath())) {
            String primarySolutionPath1 = metaFactory.getSolutionPath();
            File primarySolutionFile1 = FileUtils.getFile((String[])new String[]{primarySolutionPath1});
            primarySolutionPath1 = primarySolutionFile1.getCanonicalPath();
            File slnXml2 = new File(primarySolutionFile1, "Solution.xml");
            if (!slnXml2.exists()) {
                log.info("loadFileTree()|TreeNode\u52a0\u8f7d - \u4e3b Solution \u76ee\u5f55 '{}' \u4e2d\u4e0d\u5b58\u5728 Solution.xml, \u5ffd\u7565\u52a0\u8f7d .", (Object)primarySolutionFile1);
            } else if (!StringUtils.contains((CharSequence)primarySolutionPath1, (CharSequence)workspacePath)) {
                log.info("loadFileTree()|TreeNode\u52a0\u8f7d - \u4e3b Solution \u76ee\u5f55 '{}' \u4e0d\u5728 Workspace Path '{}' \u4e0b , \u5ffd\u7565\u52a0\u8f7d .", (Object)primarySolutionFile1, (Object)workspacePath);
            } else {
                log.info("loadFileTree()|TreeNode\u52a0\u8f7d - \u4e3b Solution \u4e3a\u6709\u6548\u76ee\u5f55 '{}', \u5c06\u901a\u8fc7\u76ee\u5f55\u52a0\u8f7d ...", (Object)primarySolutionFile1);
                String primarySolutionParentPath = primarySolutionParentFile.getCanonicalPath();
                LoadFileTree.getTreeNode(primarySolutionParentPath, primarySolutionPath, true);
            }
        }
        for (MetaSolution metaSolution : metaSolutions) {
            String solutionPath2;
            IMetaResolverFactory resolverFactory;
            if (designableSolutionKeyMap.containsKey(metaSolution.getKey()) || Objects.isNull(resolverFactory = metaFactory.getMetaResolverFactoryBySolution(metaSolution.getKey())) || !StringUtils.contains((CharSequence)(solutionPath2 = FileUtils.getFile((String[])new String[]{resolverFactory.getSolutionPath()}).getCanonicalPath()), (CharSequence)workspacePath)) continue;
            log.info("loadFileTree()|TreeNode\u52a0\u8f7d - \u52a0\u8f7d Workspace Path '{}' \u4e0b\u7684 Solution \u76ee\u5f55 '{}' ...", (Object)workspacePath, (Object)solutionPath2);
            LoadFileTree.getTreeNode(workspacePath, solutionPath2, true);
        }
        Set loadedSolutionKeys = metaSolutions.stream().filter(Objects::nonNull).map(MetaSolution::getKey).collect(Collectors.toSet());
        String[] solutionDirs = FileUtils.getFile((String[])new String[]{workspacePath}).list((dirFile, fileName) -> !designableSolutionKeyMap.containsValue(fileName));
        rootResourcePath = solutionDirs;
        int solutionPath = solutionDirs.length;
        int solutionPath2 = 0;
        while (solutionPath2 < solutionPath) {
            String solutionDir = rootResourcePath[solutionPath2];
            String solutionPath3 = Paths.get(workspacePath, solutionDir).toString();
            if (Files.exists(Paths.get(solutionPath3, "Solution.xml"), new LinkOption[0])) {
                MetaSolution solution;
                Object key;
                DefaultMetaResolverFactory metaResolverFactory = new DefaultMetaResolverFactory(solutionPath3);
                DefaultMetaFactory factory = metaDesignerFactoryMap.get(solutionPath3);
                if (factory == null) {
                    factory = new MidMetaFactory((IMetaResolverFactory)metaResolverFactory);
                }
                if (loadedSolutionKeys.contains(key = (solution = factory.getSolution()).getKey())) {
                    LoadFileTree.doGetTreeNode(workspacePath, solutionPath3, true, factory, false);
                    log.info("loadFileTree()|TreeNode\u52a0\u8f7d - \u52a0\u8f7d Workspace Path '{}' \u4e0b Key='{}' \u7684\u5173\u8054 Solution \u76ee\u5f55 '{}' ...", new Object[]{workspacePath, key, solutionPath3});
                }
            }
            ++solutionPath2;
        }
        String filePath = WebDesignerConfiguration.getDesignerImportSolutionsPath();
        log.info("loadFileTree()|TreeNode\u52a0\u8f7d - \u5f00\u59cb\u52a0\u8f7d ImportSolution,  DesignerImportSolutionsPath = '{}' ...", (Object)filePath);
        TreeNode solutionNode = new TreeNode("ImportSolution", "importsolution", "\u5bfc\u5165\u7684solution", String.valueOf(workspacePath) + "Import", workspacePath, "", "");
        LoadFileTree.tree.root.children.add(solutionNode);
        tree.addTreeNode(solutionNode, true);
        File file = new File(filePath);
        if (!file.exists()) {
            try {
                FileUtils.writeStringToFile((File)file, (String)"<ImportSolutions/>\n", (String)"UTF-8");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            SAXReader reader = new SAXReader();
            Document doc = reader.read(new File(filePath));
            Element root = doc.getRootElement();
            List importSolution = root.elements("ImportSolution");
            for (Element element : importSolution) {
                String solutionPath4 = element.attributeValue("SolutionPath");
                log.info("loadFileTree()|TreeNode\u52a0\u8f7d - \u52a0\u8f7d ImportSolution '{}' ...", (Object)solutionPath4);
                DefaultMetaResolverFactory metaResolverFactory = new DefaultMetaResolverFactory(solutionPath4);
                MidMetaFactory factory = new MidMetaFactory((IMetaResolverFactory)metaResolverFactory);
                LoadFileTree.loadImportSolution(metaFactory, workspacePath, solutionPath4, (IMetaResolverFactory)metaResolverFactory, (DefaultMetaFactory)factory);
            }
        }
        ErpConfig.initExtendConfig();
        String designerSolutionDataPath = WebDesignerConfiguration.getDesignerSolutionDataPath();
        File fDesignerSolutionDataPath = FileUtils.getFile((String[])new String[]{designerSolutionDataPath}).getCanonicalFile();
        Collection slnXmls = FileUtils.listFiles((File)fDesignerSolutionDataPath, (IOFileFilter)new NameFileFilter("Solution.xml"), (IOFileFilter)TrueFileFilter.INSTANCE);
        String[] list = (String[])slnXmls.stream().map(slnXml -> fDesignerSolutionDataPath.toPath().relativize(slnXml.getParentFile().toPath())).map(slnRelativePath -> slnRelativePath.toString()).distinct().toArray(String[]::new);
        log.info("loadFileTree()|TreeNode\u52a0\u8f7d - \u5f00\u59cb\u52a0\u8f7d Jar \u5305\u4e2d\u7684 Solution, \u5171\u5305\u62ec {} \u4e2a: '{}' ...", (Object)list.length, (Object)list);
        TreeNode solution1 = new TreeNode("JarSolution", "jarsolution", "Jar\u5305\u4e2d\u7684solution", designerSolutionDataPath, workspacePath, "", "");
        solution1.isInJar = true;
        if (list.length > 0) {
            LoadFileTree.tree.root.children.add(solution1);
            tree.addTreeNode(solution1, true);
        }
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            String dir = String.valueOf(designerSolutionDataPath) + File.separator + path;
            log.info("loadFileTree()|TreeNode\u52a0\u8f7d - \u52a0\u8f7d Jar \u5305\u4e2d\u7684 Solution '{}' ...", (Object)dir);
            DefaultMetaResolverFactory metaResolverFactory = new DefaultMetaResolverFactory(dir);
            DefaultMetaFactory factory = metaDesignerFactoryMap.get(dir);
            if (factory == null) {
                factory = new MidMetaFactory((IMetaResolverFactory)metaResolverFactory);
            }
            LoadFileTree.doGetTreeNode(solution1.key, dir, true, factory, true);
            ++n2;
        }
    }

    public static void loadFileTree(IMetaFactory metaFactory) throws Throwable {
        Collection metaSolutions = metaFactory.getMetaSolutions();
        File primarySolutionFile = FileUtils.getFile((String[])new String[]{metaFactory.getSolutionPath()});
        File primarySolutionParentFile = primarySolutionFile.getParentFile();
        String primarySolutionParentPath = primarySolutionParentFile.getCanonicalPath();
        tree = new Tree(primarySolutionParentPath);
        designableSolutionKeyMap.clear();
        if (StringUtils.isNotBlank((CharSequence)metaFactory.getSolutionPath())) {
            String primarySolutionPath = primarySolutionFile.getCanonicalPath();
            DefaultMetaFactory factory = metaDesignerFactoryMap.get(primarySolutionPath);
            if (factory == null) {
                DefaultMetaResolverFactory metaResolverFactory = new DefaultMetaResolverFactory(primarySolutionPath);
                factory = new MidMetaFactory((IMetaResolverFactory)metaResolverFactory);
            }
            primaryResolverFactory = factory;
            LoadFileTree.getTreeNode(primarySolutionParentPath, primarySolutionPath, true, factory);
        }
        for (MetaSolution metaSolution : metaSolutions) {
            String solutionPath;
            IMetaResolverFactory resolverFactory;
            if (designableSolutionKeyMap.containsKey(metaSolution.getKey()) || Objects.isNull(resolverFactory = metaFactory.getMetaResolverFactoryBySolution(metaSolution.getKey())) || !StringUtils.contains((CharSequence)(solutionPath = FileUtils.getFile((String[])new String[]{resolverFactory.getSolutionPath()}).getCanonicalPath()), (CharSequence)primarySolutionParentPath)) continue;
            LoadFileTree.getTreeNode(primarySolutionParentPath, solutionPath, true);
        }
    }

    public static void loadImportSolution(IMetaFactory metaFactory, String workspacePath, String solutionPath, IMetaResolverFactory metaResolverFactory, DefaultMetaFactory factory) throws Throwable {
        String key = String.valueOf(workspacePath) + "Import";
        TreeNode solutionNode = tree.getNode(key);
        LoadFileTree.doGetTreeNode(solutionNode.key, solutionPath, true, factory, false);
        if (!loadImportSolutions.contains(solutionPath)) {
            metaFactory.load(metaResolverFactory, true, false, false);
            loadImportSolutions.add(solutionPath);
        }
    }

    private static void saveUploadResource(String parent, IMetaResolver iMetaResolver) throws Exception {
        ResourceMultiSolutionResolver resourceMultiSolutionResolver = (ResourceMultiSolutionResolver)iMetaResolver;
        Field resources1 = resourceMultiSolutionResolver.getClass().getDeclaredField("resources");
        resources1.setAccessible(true);
        ResourcePaths resourcePaths = (ResourcePaths)resources1.get(iMetaResolver);
        Field pathField = resourcePaths.getClass().getDeclaredField("paths");
        pathField.setAccessible(true);
        List paths = (List)pathField.get(resourcePaths);
        int i = 0;
        while (i < paths.size()) {
            LoadFileTree.saveUploadResource(String.valueOf(parent) + (String)paths.get(i));
            ++i;
        }
    }

    public static void saveUploadResource(String fileName) throws IOException {
        InputStream is = MidMetaFactoryManager.class.getResourceAsStream("/" + fileName);
        if (is == null) {
            return;
        }
        String filePath = LoadFileTree.createFile(fileName);
        if (fileName.endsWith(".xml") && !filePath.contains("EXIST")) {
            File file = new File(filePath);
            LoadFileTree.inputStreamToFile(is, file);
        }
    }

    public static String createFile(String filename) {
        String dirPath = WebDesignerConfiguration.getDesignerSolutionDataPath();
        File dir = new File(dirPath);
        dir.mkdirs();
        String filePath = String.valueOf(dirPath) + File.separator + filename;
        File file = new File(filePath);
        if (!file.exists()) {
            try {
                if (filename.endsWith(".xml")) {
                    FileUtils.writeStringToFile((File)file, (String)"", (String)"UTF-8");
                } else {
                    file.mkdirs();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return filePath;
        }
        return "EXIST" + filePath;
    }

    public static void loadFileTree(String solutionPath) throws Throwable {
        String parent = new File(solutionPath).getParent();
        tree = new Tree(parent);
        designableSolutionKeyMap.clear();
        LoadFileTree.getTreeNode(parent, solutionPath, true);
    }

    private static String safeGetSolutionKey(DefaultMetaFactory metaFactory) throws Exception {
        IMetaResolverFactory resolverFactory = metaFactory.getMetaResolverFactory();
        IMetaResolver resolver = resolverFactory.newMetaResolver("");
        JSONObject slnXmlData = resolver.readProfile("Solution.xml", 0);
        return slnXmlData.getString("Key");
    }

    private static String getTreeNode(String parent, String dir, boolean create) throws Throwable {
        DefaultMetaFactory factory = metaDesignerFactoryMap.get(dir);
        if (factory == null) {
            DefaultMetaResolverFactory metaResolverFactory = new DefaultMetaResolverFactory(dir);
            factory = new MidMetaFactory((IMetaResolverFactory)metaResolverFactory);
        }
        return LoadFileTree.doGetTreeNode(parent, dir, create, factory, false);
    }

    private static String getTreeNode(String parent, String dir, boolean create, DefaultMetaFactory factory) throws Throwable {
        return LoadFileTree.doGetTreeNode(parent, dir, create, factory, false);
    }

    private static String doGetTreeNode(String parent, String dir, boolean create, DefaultMetaFactory targetSolutionMetaFactory, boolean isJarSolution) throws Throwable {
        Object metaFactory;
        if (primaryResolverFactory == null) {
            throw new IllegalStateException(String.valueOf(LoadFileTree.class.getName()) + ": Global primaryResolverFactory uninitialized");
        }
        String targetSlnKey = LoadFileTree.safeGetSolutionKey(targetSolutionMetaFactory);
        String primarySlnKey = LoadFileTree.safeGetSolutionKey(primaryResolverFactory);
        String primarySlnPath = primaryResolverFactory.getSolutionPath();
        if (primaryResolverFactory != targetSolutionMetaFactory) {
            if (isJarSolution && StringUtils.equals((CharSequence)targetSlnKey, (CharSequence)primarySlnKey)) {
                log.info("doGetTreeNode()|\u5904\u7406 jar \u5305\u4e2d\u7684 [\u4e3b Solution] - key='{}', dir='{}' (JAR={}) (path='{}') ...", new Object[]{targetSlnKey, dir, isJarSolution, primarySlnPath});
                metaFactory = targetSolutionMetaFactory;
            } else {
                log.info("doGetTreeNode()|\u5904\u7406 Solution - key='{}', dir='{}' (JAR={}) ...", new Object[]{targetSlnKey, dir, isJarSolution});
                metaFactory = new ERPWebDesignerMetaFactory(targetSolutionMetaFactory.getMetaResolverFactory());
                ((ERPWebDesignerMetaFactory)((Object)metaFactory)).setDesignerMetaFactory(primaryResolverFactory);
            }
        } else {
            log.info("doGetTreeNode()|\u5904\u7406 [\u4e3b Solution] - key='{}', dir='{}' (JAR={}) ...", new Object[]{targetSlnKey, dir, isJarSolution});
            metaFactory = targetSolutionMetaFactory;
        }
        metaFactory.getSolution();
        MetaFormList metaFormList = metaFactory.getMetaFormList();
        MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
        MetaDataMigrationList dataMigrationList = metaFactory.getDataMigrationList();
        MetaSolution solution = metaFactory.getSolution();
        MetaProjectCollection projectCollection = solution.getProjectCollection();
        dir = FilePathHelper.toBackFilePath(dir);
        File solutionFile = new File(dir);
        TreeNode solution1 = new TreeNode(solution.getKey(), "solution", solution.getCaption(), solutionFile.getAbsolutePath(), parent, "", solution.getKey());
        solution1.isInJar = isJarSolution;
        for (MetaProjectProfile metaProjectProfile : projectCollection) {
            String projectKey = metaProjectProfile.getKey();
            if (isJarSolution) {
                jarProjectKey.add(projectKey);
            }
            MetaProject project = metaFactory.getMetaProject(projectKey);
            String projectKey1 = project.getKey();
            File projectFile = new File(solutionFile, project.getKey());
            TreeNode node = new TreeNode(projectKey, "project", project.getCaption(), projectFile.getAbsolutePath(), dir, projectKey1, solution.getKey());
            node.namePath = node.name;
            solution1.addChild(node);
            LoadFileTree.loadProjectFileTree(node, projectFile, metaFormList, dataObjectList, (IMetaFactory)metaFactory, dataMigrationList, projectKey1);
        }
        String finalDir = dir;
        solutionFile.listFiles(file -> {
            String pathName = file.getAbsolutePath();
            String name = FilenameUtils.getName((String)pathName);
            String extension = FilenameUtils.getExtension((String)pathName);
            if (extension.equalsIgnoreCase("xml")) {
                TreeNode node = new TreeNode(name, "file", "", pathName, finalDir, "", treeNode.solutionKey);
                solution1.addChild(node);
            } else if (file.isDirectory() && (name.equalsIgnoreCase("DataElement") || name.equalsIgnoreCase("Domain"))) {
                TreeNode node = new TreeNode(name, "fold", name, pathName, finalDir, "", treeNode.solutionKey);
                node.namePath = node.name;
                solution1.addChild(node);
                LoadFileTree.loadDomainElementFileTree(node, file, "");
            }
            return false;
        });
        metaDesignerFactoryMap.put(dir, (DefaultMetaFactory)metaFactory);
        metaDesignerSolutionPathMap.put(metaFactory.getSolution().getKey(), dir);
        if (CollectionUtils.isNotEmpty(LoadFileTree.tree.root.children)) {
            List oldNodeList = LoadFileTree.tree.root.children.stream().filter(item -> Objects.equals(item.key, treeNode.key)).collect(Collectors.toList());
            LoadFileTree.tree.root.children.removeAll(oldNodeList);
            if (!create) {
                LoadFileTree.tree.root.children.add(solution1);
            }
        }
        tree.addTreeNode(solution1, create);
        designableSolutionKeyMap.put(solution.getKey(), StringUtils.substringAfterLast((String)dir, (int)File.separatorChar));
        return solution.getKey();
    }

    public static void inputStreamToFile(InputStream ins, File file) {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            int bytesRead = 0;
            byte[] buffer = new byte[1024];
            while ((bytesRead = ins.read(buffer, 0, 1024)) != -1) {
                ((OutputStream)os).write(buffer, 0, bytesRead);
            }
            ((OutputStream)os).close();
            ins.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void loadDomainElementFileTree(TreeNode PNode, File parentFile, String projectKey) {
        String parentPath = parentFile.getAbsolutePath();
        String type = parentFile.getName();
        parentFile.listFiles(file -> {
            String pathName = file.getAbsolutePath();
            String name = FilenameUtils.getName((String)pathName);
            if (file.isDirectory()) {
                TreeNode node = new TreeNode(name, "fold", "", pathName, parentPath, projectKey, treeNode.solutionKey);
                PNode.addChild(node);
                LoadFileTree.loadDomainElementFileTree(node, file, projectKey);
            } else {
                String baseName = FilenameUtils.getBaseName((String)pathName);
                String extension = FilenameUtils.getExtension((String)pathName);
                if (extension.equalsIgnoreCase("xml")) {
                    String caption = "";
                    TreeNode node = new TreeNode(name, "file", caption, pathName, parentPath, projectKey, treeNode.solutionKey);
                    if (type.equalsIgnoreCase("DataElement")) {
                        caption = baseName;
                        node = new TreeNode(name, "file", caption, pathName, parentPath, projectKey, treeNode.solutionKey);
                        mapDataElementKeyToXmlPath.put(baseName.toLowerCase(), node);
                    } else if (type.equalsIgnoreCase("Domain")) {
                        caption = baseName;
                        node = new TreeNode(name, "file", caption, pathName, parentPath, projectKey, treeNode.solutionKey);
                        mapDomainKeyToXmlPath.put(baseName.toLowerCase(), node);
                    }
                    PNode.addChild(node);
                }
            }
            return false;
        });
    }

    private static void loadProjectFileTree(TreeNode solution1, File parentFile, MetaFormList metaFormList, MetaDataObjectList dataObjectList, IMetaFactory metaFactory, MetaDataMigrationList dataMigrationList, String projectKey) {
        String parentPath = parentFile.getAbsolutePath();
        AtomicReference<String> parentBaseName = new AtomicReference<String>(FilenameUtils.getBaseName((String)parentPath));
        parentFile.listFiles(file -> {
            String pathName = file.getAbsolutePath();
            String name = FilenameUtils.getName((String)pathName);
            if (file.isDirectory()) {
                TreeNode node = new TreeNode(name, "fold", "", pathName, parentPath, projectKey, treeNode.solutionKey);
                solution1.addChild(node);
                LoadFileTree.loadProjectFileTree(node, file, metaFormList, dataObjectList, metaFactory, dataMigrationList, projectKey);
            } else {
                String baseName = FilenameUtils.getBaseName((String)pathName);
                String extension = FilenameUtils.getExtension((String)pathName);
                if (extension.equalsIgnoreCase("xml")) {
                    String secondLine = null;
                    try {
                        String xml = FileUtil.File2String((File)file, (String)"UTF-8");
                        secondLine = DesignIOMetaUtil.getSecondLine(xml);
                        String subString = DesignIOMetaUtil.getSubString(secondLine, "<([A-Za-z_]\\w*)\\s");
                        parentBaseName.set(subString);
                    }
                    catch (Throwable xml) {
                        // empty catch block
                    }
                    String caption = "";
                    TreeNode node = new TreeNode(name, "file", caption, pathName, parentPath, projectKey, treeNode.solutionKey);
                    if (((String)parentBaseName.get()).equalsIgnoreCase("DataObject")) {
                        caption = Objects.isNull(dataObjectList.get(baseName)) ? "" : ((MetaDataObjectProfile)dataObjectList.get(baseName)).getCaption();
                        node = new TreeNode(name, "file", caption, pathName, parentPath, projectKey, treeNode.solutionKey);
                        mapDataObjectKeyToXmlPath.put(baseName.toLowerCase(), node);
                    } else if (((String)parentBaseName.get()).equalsIgnoreCase("Map")) {
                        caption = Objects.isNull(metaFactory.getMetaCustomObject(ERPMetaMap.class, baseName)) ? "" : ((ERPMetaMap)metaFactory.getMetaCustomObject(ERPMetaMap.class, baseName)).getCaption();
                        node = new TreeNode(name, "file", caption, pathName, parentPath, projectKey, treeNode.solutionKey);
                        mapDataKeyToXmlPath.put(baseName, node);
                    } else if (((String)parentBaseName.get()).equalsIgnoreCase("DataMigration")) {
                        caption = Objects.isNull(dataMigrationList.get(baseName)) ? "" : ((MetaDataMigrationProfile)dataMigrationList.get(baseName)).getCaption();
                        node = new TreeNode(name, "file", caption, pathName, parentPath, projectKey, treeNode.solutionKey);
                        mapDataMigrationToXmlPath.put(baseName, node);
                    } else if (((String)parentBaseName.get()).equalsIgnoreCase("Process")) {
                        node = new TreeNode(name, "file", caption, pathName, parentPath, projectKey, treeNode.solutionKey);
                        mapBpmKeyToXmlPath.put(baseName, node);
                    } else if (((String)parentBaseName.get()).equalsIgnoreCase("Workbook")) {
                        try {
                            caption = Objects.isNull(metaFactory.getExcelTemplate(projectKey, baseName)) ? "" : metaFactory.getExcelTemplate(projectKey, baseName).getCaption();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        node = new TreeNode(name, "file", caption, pathName, parentPath, projectKey, treeNode.solutionKey);
                        if (!excelKeyToXmlPath.containsKey(projectKey)) {
                            HashMap stringTreeNodeMap = new HashMap();
                            excelKeyToXmlPath.put(projectKey, stringTreeNodeMap);
                        }
                        excelKeyToXmlPath.get(projectKey).put(baseName, node);
                    } else if (((String)parentBaseName.get()).equalsIgnoreCase("Report")) {
                        if (secondLine != null) {
                            String formKey = DesignIOMetaUtil.getSubString(secondLine, "FormKey=\"([A-Za-z_]\\w*)\"");
                            try {
                                MetaReportSubList reportSubList = metaFactory.getReportSubList(formKey);
                                MetaReportProfile metaReportProfile = (MetaReportProfile)reportSubList.get(baseName);
                                caption = metaReportProfile.getCaption();
                            }
                            catch (Throwable reportSubList) {
                                // empty catch block
                            }
                            node = new TreeNode(name, "file", caption, pathName, parentPath, projectKey, treeNode.solutionKey);
                            if (!printKeyToXmlPath.containsKey(formKey)) {
                                HashMap objectObjectHashMap = new HashMap();
                                printKeyToXmlPath.put(formKey, objectObjectHashMap);
                            }
                            printKeyToXmlPath.get(formKey).put(baseName, node);
                        }
                    } else if (((String)parentBaseName.get()).equalsIgnoreCase("Form")) {
                        caption = Objects.isNull(metaFormList.get(baseName)) ? "" : (StringUtils.isEmpty((CharSequence)((MetaFormProfile)metaFormList.get(baseName)).getCaption()) ? "\u8868\u5355" : ((MetaFormProfile)metaFormList.get(baseName)).getCaption());
                        node = new TreeNode(name, "file", caption, pathName, parentPath, projectKey, treeNode.solutionKey);
                        mapFormKeyToXmlPath.put(baseName, node);
                    }
                    solution1.addChild(node);
                }
            }
            return false;
        });
    }

    public static List<String[]> searchNodes(DefaultContext context, String search, int maxCount) throws Throwable {
        LoadFileTree.ensureLoad();
        ArrayList<String[]> result = new ArrayList<String[]>();
        String[] searchStrs = search.split("[ \u3000]+");
        if (searchStrs.length > 0) {
            LoadFileTree.searchNodes(LoadFileTree.tree.root, searchStrs, result, maxCount);
        }
        return result;
    }

    public static void main(String[] args) {
        String a = "  \u6211\u662f\u4e00\u4e2a\u534a\u89d2\u7a7a\u683c \u6211\u662f\u4e00\u4e2a\u5168\u89d2\u7a7a\u683c\u3000\u6211\u662f\u591a\u4e2a\u7a7a\u683c    \u770b\u770b\u80fd\u5426\u5206\u9694\u5f00\u6765";
        String[] searchStrs = a.split("[ \u3000]+");
        String b = "    ";
        String[] bs = b.split("[ \u3000]+");
    }

    private static void searchNodes(TreeNode node, String[] searchStrs, List<String[]> result, int maxCount) {
        boolean exist;
        if (result.size() >= maxCount) {
            return;
        }
        StringBuilder sbFound = new StringBuilder(256).append(node.name).append(" ").append(node.description);
        if (node.type == "file") {
            sbFound.append(" ").append(node.key);
        }
        if (exist = LoadFileTree.existStrs(sbFound.toString(), searchStrs)) {
            StringBuilder sb = new StringBuilder(256);
            if (node.description != null && node.description.length() > 0) {
                sb.append(node.description).append(" ");
            }
            sb.append(node.name);
            if (node.type == "file") {
                String[] split = StringUtils.split((String)node.key, (char)File.separatorChar);
                int i = split.length - 2;
                while (i > 0) {
                    sb.append(File.separatorChar).append(split[i]);
                    --i;
                }
            }
            String[] found = new String[]{sb.toString(), node.key, node.description};
            result.add(found);
        }
        if (node.children != null) {
            for (TreeNode childNode : node.children) {
                LoadFileTree.searchNodes(childNode, searchStrs, result, maxCount);
            }
        }
    }

    private static boolean existStrs(String s, String[] searchStrs) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return false;
        }
        boolean result = true;
        String[] stringArray = searchStrs;
        int n = searchStrs.length;
        int n2 = 0;
        while (n2 < n) {
            String searchStr = stringArray[n2];
            if (!StringUtils.containsIgnoreCase((CharSequence)s, (CharSequence)searchStr)) {
                result = false;
                break;
            }
            ++n2;
        }
        return result;
    }

    public static TreeNode getProjectNode(String projectKey) throws Throwable {
        LoadFileTree.ensureLoad();
        for (Map.Entry<String, TreeNode> stringTreeNodeEntry : Tree.map.entrySet()) {
            TreeNode node = stringTreeNodeEntry.getValue();
            if (node.type != "project" || !node.name.equals(projectKey)) continue;
            return node;
        }
        return null;
    }

    public static String getProjectKey(String filePath) throws Throwable {
        LoadFileTree.ensureLoad();
        return Tree.map.get((Object)filePath).projectKey;
    }

    public static TreeNode getTreeNode(String filePath) throws Throwable {
        LoadFileTree.ensureLoad();
        TreeNode treeNode = Tree.map.get(filePath);
        return treeNode;
    }

    public static TreeNode deleteProjectNode(String projectKey) throws Throwable {
        LoadFileTree.ensureLoad();
        for (Map.Entry<String, TreeNode> stringTreeNodeEntry : Tree.map.entrySet()) {
            TreeNode node = stringTreeNodeEntry.getValue();
            if (node.type != "project" || !node.name.equals(projectKey)) continue;
            Tree.map.get(node.parentKey).removeChild(node);
            return node;
        }
        return null;
    }

    public static void deleteProjectNodeByProjectKey(String projectKey) throws Throwable {
        TreeNode treeNode = LoadFileTree.deleteProjectNode(projectKey);
        if (Objects.nonNull(treeNode)) {
            LoadFileTree.removeChild(treeNode);
            Tree.map.remove(treeNode.key);
        }
    }

    private static void removeChild(TreeNode treeNode) {
        if (Objects.nonNull(treeNode) && treeNode.children != null && treeNode.children.size() > 0) {
            for (TreeNode child : treeNode.children) {
                LoadFileTree.removeChild(child);
                Tree.map.remove(child.key);
            }
        }
    }

    public static String getProjectFilePath(String projectKey) throws Throwable {
        TreeNode node = LoadFileTree.getProjectNode(projectKey);
        return Objects.isNull(node) ? null : node.key;
    }

    public static TreeNode getChildFoldNode(TreeNode parentNode, String foldName, String projectKey, String solutionKey) {
        if (parentNode == null) {
            return new TreeNode(foldName, "fold", "", projectKey, projectKey, projectKey, solutionKey);
        }
        if (parentNode.children != null) {
            for (TreeNode node : parentNode.children) {
                if (node.type != "fold" || !node.name.equals(foldName)) continue;
                return node;
            }
        }
        String pathName = Paths.get(parentNode.key, foldName).toString();
        TreeNode node = new TreeNode(foldName, "fold", "", pathName, parentNode.key, projectKey, solutionKey);
        tree.getNode(node.parentKey).addChild(node);
        return node;
    }

    public static String newFile(String projectKey, int formType, String fileName, String key, String caption, String directory, String isdirectory) throws Throwable {
        TreeNode projectNode = LoadFileTree.getProjectNode(projectKey);
        TreeNode formFold = LoadFileTree.getChildFoldNode(projectNode, "Form", projectKey, projectNode.solutionKey);
        String sFormType = FormType.toString((Integer)formType);
        String formTypeFoldName = sFormType.equals("Entity") ? "Bill" : sFormType;
        TreeNode formTypeFold = null;
        if ("1".equals(isdirectory)) {
            if (directory.isEmpty()) {
                directory = "Bill";
                formTypeFold = LoadFileTree.getChildFoldNode(formFold, directory, projectKey, projectNode.solutionKey);
            } else if (directory.contains("/") && !directory.contains("//") && !directory.contains("\\")) {
                String[] split = directory.split("/");
                int i = 0;
                while (i < split.length) {
                    formFold = LoadFileTree.getChildFoldNode(formFold, split[i], projectKey, projectNode.solutionKey);
                    ++i;
                }
                formTypeFold = formFold;
            } else {
                formTypeFold = LoadFileTree.getChildFoldNode(formFold, directory, projectKey, projectNode.solutionKey);
            }
        } else {
            formTypeFold = LoadFileTree.getChildFoldNode(formFold, formTypeFoldName, projectKey, projectNode.solutionKey);
        }
        String pathName = Paths.get(formTypeFold.key, fileName).toString();
        TreeNode node = new TreeNode(String.valueOf(key) + ".xml", "file", caption, pathName, formTypeFold.key, projectKey, projectNode.solutionKey);
        mapFormKeyToXmlPath.put(key, node);
        tree.getNode(node.parentKey).addChild(node);
        return pathName;
    }

    public static String getSolutionPath(String solutionKey) {
        return metaDesignerSolutionPathMap.get(solutionKey);
    }

    public static String newProjectFile(String key, String caption, String SolutionKey) throws Throwable {
        String pathName = null;
        SolutionKey = FilePathHelper.toBackFilePath(SolutionKey);
        DefaultMetaFactory defaultMetaFactory = metaDesignerFactoryMap.get(SolutionKey);
        MetaSolution solution = defaultMetaFactory.getSolution();
        if (Objects.isNull(LoadFileTree.getProjectNode(key)) || Objects.isNull(solution.getProject(key))) {
            pathName = String.valueOf(SolutionKey) + File.separator + key;
            CreateEmptyProjectAction createEmptyProjectAction = new CreateEmptyProjectAction(SolutionKey, key, caption);
            createEmptyProjectAction.doAction();
            MetaProjectProfile metaProjectProfile = new MetaProjectProfile();
            metaProjectProfile.setCaption(caption);
            metaProjectProfile.setKey(key);
            MetaProjectLoad metaProjectLoad = new MetaProjectLoad(1);
            DefaultMetaResolverFactory metaResolverFactory = new DefaultMetaResolverFactory(SolutionKey);
            IMetaResolver projectMetaResolver = metaResolverFactory.newMetaResolver(String.valueOf(metaResolverFactory.getSeparator()) + metaProjectProfile.getKey());
            metaProjectLoad.load(projectMetaResolver, "Project.xml");
            MetaProject metaProject2 = (MetaProject)metaProjectLoad.getRootMetaObject();
            metaProjectProfile.setProject(metaProject2);
            metaProject2.setSolution((IMetaSolution)solution);
            MetaStringTable strings = new MetaStringTable();
            metaProject2.setStrings(strings);
            MetaCommonDefLoad commonDefLoad = new MetaCommonDefLoad(1);
            commonDefLoad.load(projectMetaResolver, "CommonDef.xml");
            MetaCommonDef commonDef = (MetaCommonDef)commonDefLoad.getRootMetaObject();
            if (commonDef != null) {
                commonDef.doPostProcess(0, null);
            }
            metaProject2.setCommonDef(commonDef);
            MetaMobileDefLoad mobildDefLoad = new MetaMobileDefLoad(1);
            mobildDefLoad.load(projectMetaResolver, "MobileDef.xml");
            MetaMobileDef metaMobileDef = (MetaMobileDef)mobildDefLoad.getRootMetaObject();
            if (metaMobileDef != null) {
                metaMobileDef.doPostProcess(0, null);
            }
            metaProject2.setMobileDef(metaMobileDef);
            MetaSecurityFilterLoad securityFilterLoad = new MetaSecurityFilterLoad(1);
            securityFilterLoad.load(projectMetaResolver, "SecurityFilter.xml");
            MetaSecurityFilter securityFilter = (MetaSecurityFilter)securityFilterLoad.getRootMetaObject();
            if (securityFilter != null) {
                securityFilter.doPostProcess(0, null);
            }
            metaProject2.setSecurityFilter(securityFilter);
            IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
            MetaProjectCollection projectCollection = globalInstance.getSolution().getProjectCollection();
            projectCollection.add((KeyPairMetaObject)metaProjectProfile);
            Map projectResolverMap = globalInstance.getProjectResolverMap();
            projectResolverMap.put(key, projectMetaResolver);
            MetaProjectCollection defaultProjectCollection = defaultMetaFactory.getSolution().getProjectCollection();
            defaultProjectCollection.add((KeyPairMetaObject)metaProjectProfile);
            HashMap defaultProjectResolverMap = defaultMetaFactory.getProjectResolverMap();
            defaultProjectResolverMap.put(key, projectMetaResolver);
            EntryProcessor.writeSolution(key, caption, SolutionKey);
            String workspacePath = FilePathHelper.getWorkspacePath();
            if (loadImportSolutions.contains(SolutionKey)) {
                DefaultMetaFactory factory = metaDesignerFactoryMap.get(SolutionKey);
                String SolutionKey1 = factory.getSolution().getKey();
                loadImportSolutions.remove(SolutionKey);
                LoadFileTree.removeFilePath(SolutionKey);
                Collection metaSolutions = MetaFactory.getGlobalInstance().getMetaSolutions();
                for (MetaSolution metaSolution : metaSolutions) {
                    if (!metaSolution.getKey().equals(SolutionKey1)) continue;
                    metaSolutions.remove(metaSolution);
                    break;
                }
                LoadFileTree.clear();
            } else {
                LoadFileTree.getTreeNode(workspacePath, SolutionKey, false);
            }
            ErpConfig.initExtendConfig();
        }
        return pathName;
    }

    public static boolean isExistKey(String key) {
        return mapBpmKeyToXmlPath != null && mapBpmKeyToXmlPath.containsKey(key);
    }

    public static String newBpmFile(String projectKey, String fileName, String key, String caption) throws Throwable {
        if (mapBpmKeyToXmlPath == null || mapBpmKeyToXmlPath.containsKey(key)) {
            throw new Exception("\u8be5key'" + key + "'\u5df2\u5b58\u5728");
        }
        TreeNode projectNode = LoadFileTree.getProjectNode(projectKey);
        TreeNode formFold = LoadFileTree.getChildFoldNode(projectNode, "BPM", projectKey, projectNode.solutionKey);
        String pathName = Paths.get(formFold.key, fileName).toString();
        TreeNode node = new TreeNode(String.valueOf(key) + ".xml", "file", caption, pathName, formFold.key, projectKey, projectNode.solutionKey);
        mapBpmKeyToXmlPath.put(key, node);
        tree.getNode(node.parentKey).addChild(node);
        return pathName;
    }

    public static String newDomainFile(String projectKey, String fileName, String key, String caption, String solutionPath) throws Throwable {
        if (mapDomainKeyToXmlPath == null || mapDomainKeyToXmlPath.containsKey(key)) {
            throw new Exception("\u8be5key'" + key + "'\u5df2\u5b58\u5728");
        }
        if (projectKey.isEmpty()) {
            TreeNode treeNode = Tree.map.get(solutionPath);
            TreeNode formFold = LoadFileTree.getChildFoldNode(treeNode, "Domain", projectKey, treeNode.solutionKey);
            String pathName = Paths.get(formFold.key, fileName).toString();
            TreeNode node = new TreeNode(String.valueOf(key) + ".xml", "file", caption, pathName, formFold.key, projectKey, treeNode.solutionKey);
            mapDomainKeyToXmlPath.put(key, node);
            tree.getNode(node.parentKey).addChild(node);
            return pathName;
        }
        TreeNode projectNode = LoadFileTree.getProjectNode(projectKey);
        TreeNode formFold = LoadFileTree.getChildFoldNode(projectNode, "Domain", projectKey, projectNode.solutionKey);
        String pathName = Paths.get(formFold.key, fileName).toString();
        TreeNode node = new TreeNode(String.valueOf(key) + ".xml", "file", caption, pathName, formFold.key, projectKey, projectNode.solutionKey);
        mapDomainKeyToXmlPath.put(key, node);
        tree.getNode(node.parentKey).addChild(node);
        return pathName;
    }

    public static String newDataElementFile(String projectKey, String fileName, String key, String caption, String solutionPath) throws Throwable {
        if (mapDataElementKeyToXmlPath == null || mapDataElementKeyToXmlPath.containsKey(key)) {
            throw new Exception("\u8be5key'" + key + "'\u5df2\u5b58\u5728");
        }
        if (projectKey.isEmpty()) {
            TreeNode treeNode = Tree.map.get(solutionPath);
            TreeNode formFold = LoadFileTree.getChildFoldNode(treeNode, "DataElement", projectKey, treeNode.solutionKey);
            String pathName = Paths.get(formFold.key, fileName).toString();
            TreeNode node = new TreeNode(String.valueOf(key) + ".xml", "file", caption, pathName, formFold.key, projectKey, treeNode.solutionKey);
            mapDataElementKeyToXmlPath.put(key.toLowerCase(), node);
            tree.getNode(node.parentKey).addChild(node);
            return pathName;
        }
        TreeNode projectNode = LoadFileTree.getProjectNode(projectKey);
        TreeNode formFold = LoadFileTree.getChildFoldNode(projectNode, "DataElement", projectKey, projectNode.solutionKey);
        String pathName = Paths.get(formFold.key, fileName).toString();
        TreeNode node = new TreeNode(String.valueOf(key) + ".xml", "file", caption, pathName, formFold.key, projectKey, projectNode.solutionKey);
        mapDataElementKeyToXmlPath.put(key, node);
        tree.getNode(node.parentKey).addChild(node);
        return pathName;
    }

    public static String getResource(String filePath, String projectKey) throws Throwable {
        String designerSolutionPathPath = WebDesignerConfiguration.getDesignerSolutionPathPath(projectKey);
        String replace = StringUtils.replace((String)filePath, (String)designerSolutionPathPath, (String)"..");
        return replace;
    }

    public static boolean isTmpResource(String resource) {
        return StringUtils.contains((CharSequence)resource, (CharSequence)(".." + File.separator + ".." + File.separator + "Data" + File.separator + "designer" + File.separator + "tmp"));
    }

    public static String getTmpFilePath(String resource) {
        String path = new File(WebDesignerConfiguration.getDesignerDataPath()).getAbsolutePath();
        String filePath = path + File.separator + "tmp" + StringUtils.substringAfter((String)resource, (String)(".." + File.separator + ".." + File.separator + "Data" + File.separator + "designer" + File.separator + "tmp"));
        return filePath;
    }

    public static String getProjectKeyByFilePath(String filePath) throws IOException {
        if (StringUtils.contains((CharSequence)filePath, (CharSequence)"tmp") && !StringUtils.endsWithIgnoreCase((CharSequence)filePath, (CharSequence)"xml")) {
            String tempFileFullName = StringUtils.substringAfterLast((String)filePath, (String)File.separator);
            return tempFileFullName.split("__")[1];
        }
        if (StringUtils.contains((CharSequence)filePath, (CharSequence)"..")) {
            filePath = StringUtils.substringAfterLast((String)filePath, (String)"..");
            return StringUtils.split((String)filePath, (char)File.separatorChar)[3];
        }
        String solutionPath = String.valueOf(FilePathHelper.getCoreSolutionPath()) + File.separator;
        String relativePath = filePath.replace(solutionPath, "");
        return relativePath.substring(0, relativePath.indexOf(File.separator));
    }

    public static String getKeyByFilePath(String filePath) {
        int beginIndex = filePath.lastIndexOf(File.separator) + 1;
        String substring = filePath.substring(beginIndex);
        return substring.split(".xml")[0];
    }

    public static String getDataMapPathByKey(String Key) {
        if (StringUtils.isEmpty((CharSequence)Key)) {
            return "";
        }
        return Optional.ofNullable(mapDataKeyToXmlPath.get(Key)).map(node -> node.key).orElse("");
    }

    public static String getDataMigrationPathByKey(String Key) {
        if (StringUtils.isEmpty((CharSequence)Key)) {
            return "";
        }
        return Optional.ofNullable(mapDataMigrationToXmlPath.get(Key)).map(node -> node.key).orElse("");
    }

    public static String getBPMPathByKey(String Key) {
        if (StringUtils.isEmpty((CharSequence)Key)) {
            return "";
        }
        return Optional.ofNullable(mapBpmKeyToXmlPath.get(Key)).map(node -> node.key).orElse("");
    }

    public static String newDataMap(String projectKey, String fileName, String key, String caption) throws Throwable {
        if (mapDataKeyToXmlPath.containsKey(key)) {
            throw new Throwable("\u8be5key" + key + "\u5df2\u5b58\u5728");
        }
        TreeNode projectNode = LoadFileTree.getProjectNode(projectKey);
        TreeNode formFold = LoadFileTree.getChildFoldNode(projectNode, "Custom", projectKey, projectNode.solutionKey);
        String pathName = Paths.get(formFold.key, "DataMap", fileName).toString();
        TreeNode node = new TreeNode(String.valueOf(key) + ".xml", "file", caption, pathName, Paths.get(formFold.key, "DataMap").toString(), projectKey, projectNode.solutionKey);
        File file = new File(formFold.key);
        if (!file.exists()) {
            formFold = LoadFileTree.getChildFoldNode(formFold, "DataMap", projectKey, projectNode.solutionKey);
            pathName = Paths.get(formFold.key, fileName).toString();
            node = new TreeNode(String.valueOf(key) + ".xml", "file", caption, pathName, Paths.get(formFold.key, "").toString(), projectKey, projectNode.solutionKey);
        }
        mapDataKeyToXmlPath.put(key, node);
        tree.getNode(node.parentKey).addChild(node);
        return pathName;
    }

    public static String NewDataObjectFilePath(String projectKey, String key, String caption) throws Throwable {
        if (mapDataObjectKeyToXmlPath.containsKey(key.toLowerCase()) && MetaFactory.getGlobalInstance().getDataObjectList().get(key) != null) {
            throw new Exception("\u8be5key" + key + "\u5df2\u5b58\u5728");
        }
        TreeNode projectNode = LoadFileTree.getProjectNode(projectKey);
        TreeNode formFold = LoadFileTree.getChildFoldNode(projectNode, "DataObject", projectKey, projectNode.solutionKey);
        String pathName = Paths.get(formFold.key, "", String.valueOf(key) + ".xml").toString();
        TreeNode node = new TreeNode(String.valueOf(key) + ".xml", "file", caption, pathName, Paths.get(formFold.key, "").toString(), projectKey, projectNode.solutionKey);
        mapDataObjectKeyToXmlPath.put(key.toLowerCase(), node);
        tree.getNode(node.parentKey).addChild(node);
        return pathName;
    }

    public static String NewExcelfilePath(Map<String, String> result, String projectKey, String fileName, String key, String caption) throws Throwable {
        if (MetaFactory.getGlobalInstance().getMetaExcelTemplateList().get(projectKey) != null && MetaFactory.getGlobalInstance().getExcelTemplate(projectKey, key) != null) {
            result.put("result", "false");
            throw new Exception("\u8be5key" + key + "\u5df2\u5b58\u5728");
        }
        result.put("result", "true");
        TreeNode projectNode = LoadFileTree.getProjectNode(projectKey);
        TreeNode formFold = LoadFileTree.getChildFoldNode(projectNode, "ExcelTemplate", projectKey, projectNode.solutionKey);
        String pathName = Paths.get(formFold.key, "", fileName).toString();
        TreeNode node = new TreeNode(String.valueOf(key) + ".xml", "file", caption, pathName, Paths.get(formFold.key, "").toString(), projectKey, projectNode.solutionKey);
        if (!excelKeyToXmlPath.containsKey(projectKey)) {
            HashMap stringTreeNodeMap = new HashMap();
            excelKeyToXmlPath.put(projectKey, stringTreeNodeMap);
        }
        excelKeyToXmlPath.get(projectKey).put(key.toLowerCase(), node);
        tree.getNode(node.parentKey).addChild(node);
        return pathName;
    }

    public static String NewPrintfilePath(Map<String, String> result, String projectKey, String fileName, String key, String caption, String associationForm) throws Throwable {
        IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
        if (globalInstance.getReportSubList(associationForm) != null && globalInstance.getReportSubList(associationForm).get(key) != null) {
            result.put("result", "false");
            throw new Exception("\u8be5key" + key + "\u5df2\u5b58\u5728");
        }
        result.put("result", "true");
        TreeNode projectNode = LoadFileTree.getProjectNode(projectKey);
        TreeNode formFold = LoadFileTree.getChildFoldNode(projectNode, "Report", projectKey, projectNode.solutionKey);
        String pathName = Paths.get(formFold.key, "", fileName).toString();
        TreeNode node = new TreeNode(String.valueOf(key) + ".xml", "file", caption, pathName, Paths.get(formFold.key, "").toString(), projectKey, projectNode.solutionKey);
        if (!printKeyToXmlPath.containsKey(associationForm)) {
            HashMap objectObjectHashMap = new HashMap();
            printKeyToXmlPath.put(associationForm, objectObjectHashMap);
        }
        printKeyToXmlPath.get(associationForm).put(key.toLowerCase(), node);
        tree.getNode(node.parentKey).addChild(node);
        return pathName;
    }

    public static String newDataMigration(String projectKey, String fileName, String key, String caption) throws Throwable {
        if (mapDataMigrationToXmlPath.containsKey(key)) {
            throw new Exception("\u8be5key" + key + "\u5df2\u5b58\u5728");
        }
        TreeNode projectNode = LoadFileTree.getProjectNode(projectKey);
        TreeNode formFold = LoadFileTree.getChildFoldNode(projectNode, "DataMigration", projectKey, projectNode.solutionKey);
        String pathName = Paths.get(formFold.key, "", fileName).toString();
        TreeNode node = new TreeNode(String.valueOf(key) + ".xml", "file", caption, pathName, Paths.get(formFold.key, "").toString(), projectKey, projectNode.solutionKey);
        mapDataMigrationToXmlPath.put(key, node);
        tree.getNode(node.parentKey).addChild(node);
        return pathName;
    }

    public static String getNextFilePath(String filePath) throws Throwable {
        LoadFileTree.ensureLoad();
        TreeNode node = tree.getNode(filePath);
        TreeNode parentNode = tree.getNode(node.parentKey);
        List<TreeNode> brothers = parentNode.children;
        int pos = brothers.indexOf(node);
        String result = pos < brothers.size() - 1 ? brothers.get((int)(pos + 1)).key : (pos > 0 ? brothers.get((int)(pos - 1)).key : node.parentKey);
        return result;
    }

    public static void removeFilePath(String filePath) throws Throwable {
        LoadFileTree.removeFilePath(filePath, null);
    }

    public static void addFilePath(String filePath, Object node, String objectType) throws Throwable {
        TreeNode treeNode = (TreeNode)node;
        tree.addTreeNode(treeNode);
        String key = FilenameUtils.getBaseName((String)filePath);
        switch (objectType) {
            case "Form": {
                mapFormKeyToXmlPath.put(key, treeNode);
                break;
            }
            case "Process": {
                mapBpmKeyToXmlPath.put(key, treeNode);
                break;
            }
            case "Map": {
                mapDataKeyToXmlPath.put(key, treeNode);
                break;
            }
            case "DataObject": {
                mapDataObjectKeyToXmlPath.put(key, treeNode);
                break;
            }
            case "DataMigration": {
                mapDataMigrationToXmlPath.put(key, treeNode);
            }
        }
    }

    public static void addFilePath(String filePath, Object node, String projectKey, String formKey, String objectType) throws Throwable {
        TreeNode treeNode = (TreeNode)node;
        tree.addTreeNode(treeNode);
        String key = FilenameUtils.getBaseName((String)filePath);
        switch (objectType) {
            case "Workbook": {
                if (excelKeyToXmlPath.containsKey(projectKey)) {
                    HashMap objectObjectHashMap = new HashMap();
                    excelKeyToXmlPath.put(projectKey, objectObjectHashMap);
                }
                excelKeyToXmlPath.get(projectKey).put(key, treeNode);
                break;
            }
            case "Report": {
                if (!printKeyToXmlPath.containsKey(formKey)) {
                    HashMap objectObjectHashMap = new HashMap();
                    printKeyToXmlPath.put(formKey, objectObjectHashMap);
                }
                printKeyToXmlPath.get(formKey).put(key, treeNode);
            }
        }
    }

    public static void removeFilePath(String filePath, RecycleForm recycleForm) throws Throwable {
        String objectType;
        LoadFileTree.ensureLoad();
        TreeNode node = tree.getNode(filePath);
        tree.removeTreeNode(node);
        String key = FilenameUtils.getBaseName((String)filePath);
        if (recycleForm != null) {
            recycleForm.setTreeNode(node);
        }
        switch (objectType = DeleteXmlFileCmd.objectType) {
            case "Form": {
                mapFormKeyToXmlPath.remove(key);
                break;
            }
            case "Process": {
                mapBpmKeyToXmlPath.remove(key);
                break;
            }
            case "Map": {
                mapDataKeyToXmlPath.remove(key);
                break;
            }
            case "DataObject": {
                mapDataObjectKeyToXmlPath.remove(key);
                break;
            }
            case "DataElementDef": {
                mapDataElementKeyToXmlPath.remove(key);
                break;
            }
            case "DomainDef": {
                mapDomainKeyToXmlPath.remove(key);
                break;
            }
            case "Workbook": {
                if (!excelKeyToXmlPath.containsKey(recycleForm.getProjectKey())) break;
                excelKeyToXmlPath.get(recycleForm.getProjectKey()).remove(key);
                break;
            }
            case "Report": {
                XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePathNotLoadTmp(filePath, false);
                String formKey = xmlTreeWithPath.xmlTree.getRoot().getAttributes().get("FormKey");
                if (!printKeyToXmlPath.containsKey(formKey)) break;
                printKeyToXmlPath.get(formKey).remove(key);
                break;
            }
            case "DataMigration": {
                mapDataMigrationToXmlPath.remove(key);
            }
        }
    }

    public static boolean isDesignableSolution(String solutionKey) {
        return designableSolutionKeyMap.containsKey(solutionKey);
    }

    public static boolean isJarProjectKey(String projectKey) {
        return jarProjectKey.contains(projectKey);
    }

    public static List<String> getAllSolutionsPath() {
        ArrayList<String> result = new ArrayList<String>();
        List<TreeNode> children = LoadFileTree.tree.root.children;
        if (children != null) {
            for (TreeNode node : children) {
                if ("solution".equalsIgnoreCase(node.type)) {
                    result.add(node.key);
                    continue;
                }
                if ("importsolution".equalsIgnoreCase(node.type)) {
                    if (node.children == null) continue;
                    for (TreeNode importNode : node.children) {
                        if (!"solution".equalsIgnoreCase(importNode.type)) continue;
                        result.add(importNode.key);
                    }
                    continue;
                }
                if (!"jarsolution".equalsIgnoreCase(node.type) || node.children == null) continue;
                for (TreeNode jarNode : node.children) {
                    if (!"solution".equalsIgnoreCase(jarNode.type)) continue;
                    result.add(jarNode.key);
                }
            }
        }
        return result;
    }
}

