/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.io;

import com.bokesoft.yes.design.utils.IDLookup;
import com.bokesoft.yes.design.xml.node.AbstractNode;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.design.xml.node.TextNode;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.OrientationType;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaBlock;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewColumn;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.meta.form.component.panel.MetaPanel;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaGridLayoutPanel;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DesignIOMetaUtil {
    public static MetaPanel getMetaPanel(MetaForm metaForm, String panelKey) {
        MetaBlock metaBlock = (MetaBlock)metaForm.getMetaBody().get(0);
        MetaPanel metaPanel = (MetaPanel)metaBlock.getRoot();
        return DesignIOMetaUtil.loadPanel(metaPanel, panelKey);
    }

    private static MetaPanel loadPanel(MetaPanel metaPanel, String panelKey) {
        if (panelKey.equals(metaPanel.getKey())) {
            return metaPanel;
        }
        if (!(metaPanel instanceof MetaGridLayoutPanel)) {
            for (MetaComponent metaComponent : metaPanel.getComponentArray()) {
                if (!metaComponent.isPanel()) continue;
                return DesignIOMetaUtil.loadPanel((MetaPanel)metaComponent, panelKey);
            }
        }
        return null;
    }

    public static AbstractMetaObject getMetaComponent(MetaForm metaForm, String fieldKey) throws Throwable {
        return IDLookup.reloadIDLookup(metaForm).getMetaObjectColumnByKey(fieldKey);
    }

    public static AbstractMetaObject getMetaComponentForListView(MetaForm metaForm, String fieldKey) throws Throwable {
        return IDLookup.getIDLookup(metaForm).getMetaObjectColumnByKey(fieldKey);
    }

    public static String getChildrenOrderInfo(MetaPanel metaPanel) {
        StringBuilder result = new StringBuilder();
        for (MetaComponent metaComponent : metaPanel.getComponentArray()) {
            if (result.length() > 0) {
                result.append(";");
            }
            result.append(metaComponent.getKey());
        }
        return result.toString();
    }

    public static Object getPropertyValue(MetaComponent metaComponent, String propertyKey) throws Throwable {
        String getName = null;
        getName = propertyKey.equals("Tip") ? "getTool" + propertyKey : "get" + propertyKey;
        Class<?> clazz = metaComponent.getClass();
        Method method = null;
        try {
            method = clazz.getMethod(getName, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (Objects.isNull(method)) {
            getName = "is" + propertyKey;
            method = clazz.getMethod(getName, new Class[0]);
        }
        if (method == null) {
            throw new RuntimeException("\u5bf9\u8c61" + metaComponent + "\u7684\u5c5e\u6027" + propertyKey + "\u53d6\u4e0d\u5230\u503c \u3002");
        }
        Object result = method.invoke((Object)metaComponent, new Object[0]);
        if ("Orientation".equals(propertyKey)) {
            result = OrientationType.toString((Integer)((Integer)result));
        } else if ("ControlType".equals(propertyKey)) {
            result = ControlType.toString((Integer)((Integer)result));
        }
        return result;
    }

    public static Object getGridPropertyValue(MetaGridCell metaObject, String propertyKey) throws Throwable {
        String getName = null;
        getName = propertyKey.equals("Tip") ? "getTool" + propertyKey : "get" + propertyKey;
        Class<?> clazz = metaObject.getClass();
        Method method = null;
        try {
            method = clazz.getMethod(getName, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (method == null) {
            throw new RuntimeException("\u5bf9\u8c61" + metaObject + "\u7684\u5c5e\u6027" + propertyKey + "\u53d6\u4e0d\u5230\u503c \u3002");
        }
        Object result = method.invoke((Object)metaObject, new Object[0]);
        if ("Orientation".equals(propertyKey)) {
            result = OrientationType.toString((Integer)((Integer)result));
        } else if ("CellType".equals(propertyKey)) {
            result = ControlType.toString((Integer)((Integer)result));
        }
        return result;
    }

    public static Object getListViewPropertyValue(MetaListViewColumn metaObject, String propertyKey) throws Throwable {
        String getName = "get" + propertyKey;
        Class<?> clazz = metaObject.getClass();
        Method method = null;
        try {
            method = clazz.getMethod(getName, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (method == null) {
            throw new RuntimeException("\u5bf9\u8c61" + metaObject + "\u7684\u5c5e\u6027" + propertyKey + "\u53d6\u4e0d\u5230\u503c \u3002");
        }
        Object result = method.invoke((Object)metaObject, new Object[0]);
        if ("Orientation".equals(propertyKey)) {
            result = OrientationType.toString((Integer)((Integer)result));
        } else if ("ColumnType".equals(propertyKey)) {
            result = ControlType.toString((Integer)((Integer)result));
        }
        return result;
    }

    public static void setPropertyValue(MetaComponent metaComponent, String propertyKey, Object value) throws Throwable {
        if ("Orientation".equals(propertyKey)) {
            value = OrientationType.parse((String)((String)value));
        } else if ("ControlType".equals(propertyKey)) {
            value = ControlType.parse((String)((String)value));
        }
        String getName = "set" + propertyKey;
        Class<?> clazz = metaComponent.getClass();
        Method method = null;
        try {
            method = clazz.getMethod(getName, String.class);
            value = TypeConvertor.toString((Object)value);
            method.invoke((Object)metaComponent, value);
        }
        catch (NoSuchMethodException e) {
            try {
                method = clazz.getMethod(getName, Integer.class);
                value = TypeConvertor.toInteger((Object)value);
                method.invoke((Object)metaComponent, value);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (Objects.isNull(method)) {
            throw new RuntimeException("\u5bf9\u8c61" + metaComponent + "\u7684\u5c5e\u6027" + propertyKey + "\u65e0\u6cd5\u8bbe\u7f6e\u503c \u3002");
        }
    }

    public static void setGridPropertyValue(MetaGridCell metaGridCell, String propertyKey, Object value) throws Throwable {
        if ("Orientation".equals(propertyKey)) {
            value = OrientationType.parse((String)((String)value));
        } else if ("CellType".equals(propertyKey)) {
            value = ControlType.parse((String)((String)value));
        }
        String getName = "set" + propertyKey;
        Class<?> clazz = metaGridCell.getClass();
        Method method = null;
        try {
            method = clazz.getMethod(getName, String.class);
            value = TypeConvertor.toString((Object)value);
            method.invoke((Object)metaGridCell, value);
        }
        catch (NoSuchMethodException e) {
            try {
                method = clazz.getMethod(getName, Integer.class);
                value = TypeConvertor.toInteger((Object)value);
                method.invoke((Object)metaGridCell, value);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (Objects.isNull(method)) {
            throw new RuntimeException("\u5bf9\u8c61" + metaGridCell + "\u7684\u5c5e\u6027" + propertyKey + "\u65e0\u6cd5\u8bbe\u7f6e\u503c \u3002");
        }
    }

    public static void setListViewPropertyValue(MetaListViewColumn metaListViewColumn, String propertyKey, Object value) throws Throwable {
        String getName = "set" + propertyKey;
        if ("Orientation".equals(propertyKey)) {
            value = OrientationType.parse((String)((String)value));
        } else if ("ColumnKey".equals(propertyKey)) {
            getName = "setData" + propertyKey;
        }
        Class<?> clazz = metaListViewColumn.getClass();
        Method method = null;
        try {
            method = clazz.getMethod(getName, String.class);
            value = TypeConvertor.toString((Object)value);
            method.invoke((Object)metaListViewColumn, value);
        }
        catch (NoSuchMethodException e) {
            try {
                method = clazz.getMethod(getName, Integer.class);
                value = TypeConvertor.toInteger((Object)value);
                method.invoke((Object)metaListViewColumn, value);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (Objects.isNull(method)) {
            throw new RuntimeException("\u5bf9\u8c61" + metaListViewColumn + "\u7684\u5c5e\u6027" + propertyKey + "\u65e0\u6cd5\u8bbe\u7f6e\u503c \u3002");
        }
    }

    public static String getSubString(String s, String pattern) {
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(s);
        if (m.find()) {
            return m.group(1);
        }
        throw new RuntimeException("\u5b57\u7b26\u4e32" + s + "\u4e2d\u6ca1\u6709\u627e\u5230" + pattern);
    }

    public static String getXml(TagNode node) {
        DesignIOMetaUtil.beforeToXml(node);
        String result = node.toXml(0);
        if (result.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n")) {
            result = result.substring("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n".length());
        }
        if (result.endsWith("\r\n")) {
            result = result.substring(0, result.length() - 2);
        }
        return result;
    }

    public static String formToXml(TagNode node) {
        DesignIOMetaUtil.beforeToXml(node);
        String result = node.toXml(0);
        if (result.endsWith("\r\n")) {
            result = result.substring(0, result.length() - 2);
        }
        return result;
    }

    public static String orderAndgetXml(String key, TagNode node) {
        String result;
        AbstractNode childnode;
        DesignIOMetaUtil.beforeToXml(node);
        TagNode tagNode = null;
        Integer nodeX = 0;
        Integer nodeY = 0;
        Integer index = 0;
        List<AbstractNode> children = node.getChildren();
        int i = 0;
        while (i < children.size()) {
            String nodeKey;
            childnode = children.get(i);
            if (childnode instanceof TagNode && (nodeKey = ((TagNode)childnode).getAttributes().get("Key")) != null && nodeKey.equals(key)) {
                tagNode = (TagNode)childnode;
                nodeX = Integer.valueOf(tagNode.getAttributes().get("X"));
                nodeY = Integer.valueOf(tagNode.getAttributes().get("Y"));
                children.remove(i);
            }
            ++i;
        }
        i = children.size() - 1;
        while (i >= 0) {
            childnode = children.get(i);
            if (childnode instanceof TagNode && ((TagNode)childnode).hasAttribute("X") && ((TagNode)childnode).hasAttribute("Y")) {
                Integer x = Integer.valueOf(((TagNode)childnode).getAttributes().get("X"));
                Integer y = Integer.valueOf(((TagNode)childnode).getAttributes().get("Y"));
                if (y < nodeY || y.equals(nodeY) && x <= nodeX) {
                    index = ++i;
                    children.add(index, tagNode);
                    break;
                }
            }
            --i;
        }
        if (index == 0) {
            children.add(index, tagNode);
        }
        if ((result = node.toXml(0)).startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n")) {
            result = result.substring("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n".length());
        }
        if (result.endsWith("\r\n")) {
            result = result.substring(0, result.length() - 2);
        }
        return result;
    }

    public static String getXmlWithHead(TagNode node) {
        DesignIOMetaUtil.beforeToXml(node);
        String result = node.toXml(0);
        if (result.endsWith("\r\n")) {
            result = result.substring(0, result.length() - 2);
        }
        return result;
    }

    private static void beforeToXml(TagNode node) {
        List<AbstractNode> postComments;
        for (Map.Entry<String, String> entry : node.getAttributes().entrySet()) {
            String property = entry.getKey();
            String value = entry.getValue();
            if (value != null) {
                value = value.replaceAll("&amp;", "&").replaceAll("&gt;", ">").replaceAll("&lt;", "<").replaceAll("&quot;", "\"");
            }
            node.setAttributeNotRemove(property, value);
        }
        List<AbstractNode> preComments = node.getPreComment();
        if (preComments != null && preComments.size() > 0) {
            preComments.clear();
        }
        if ((postComments = node.getLastComment()) != null && postComments.size() > 0) {
            postComments.clear();
        }
        Iterator<AbstractNode> it = node.getChildren().iterator();
        while (it.hasNext()) {
            TextNode textChild;
            AbstractNode child = it.next();
            if (child instanceof TagNode) {
                DesignIOMetaUtil.beforeToXml((TagNode)child);
                continue;
            }
            if (!(child instanceof TextNode) || !(textChild = (TextNode)child).getText().matches("\\s*")) continue;
            it.remove();
        }
    }

    public static String getFirstLine(String content) {
        int pos = content.indexOf("\n");
        return pos >= 0 ? content.substring(0, pos) : null;
    }

    public static String getSecondLine(String content) {
        int pos = content.indexOf("\n");
        int pos2 = content.indexOf("\n", pos + 1);
        return content.substring(pos + 1, pos2);
    }
}

