/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.dataMigration.util;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.datamap.util.DataMapOperJsonUtil;
import com.bokesoft.yes.design.datamap.util.DataMapOperXmlUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationList;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationProfile;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.dom4j.Element;

public class DataMigrationOperJsonUtil {
    private static final Logger logger = Logger.getLogger(DataMapOperJsonUtil.class.getName());
    private static final String XML_EXTENSION = ".xml";

    public Map<String, String> createDataMigrationXml(String projectKey, String sourceFormKey, String targetFormKey, String key, String caption, String extend, String version) {
        HashMap<String, String> result = new HashMap<String, String>(10);
        String filePath = "";
        try {
            int verionNo = Integer.parseInt(version) + 1;
            String newFileName = String.valueOf(key) + XML_EXTENSION;
            filePath = LoadFileTree.newDataMigration(projectKey, newFileName, key, caption);
            StringBuilder sb = new StringBuilder();
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n");
            sb.append("<DataMigration Caption=\"" + caption + "\" Key=\"" + key + "\"\n");
            sb.append("SrcDataObjectKey=\"" + sourceFormKey + "\" TgtDataObjectKey=\"" + targetFormKey + "\" ");
            if (StringUtils.isNotEmpty((CharSequence)extend)) {
                sb.append(" Extend=\"" + extend.split(" ")[0] + "\" ");
            }
            sb.append(">\n");
            sb.append("    <SourceTableCollection Height=\"60\" Width=\"296\" X=\"30\" Y=\"80\"/>\n");
            sb.append("    <TargetTableCollection Height=\"60\" Width=\"296\" X=\"457\" Y=\"80\"/>\n");
            sb.append("</DataMigration>\n");
            String fileContent = sb.toString();
            XmlFileProcessor.instance.saveTempFile(filePath, fileContent, projectKey);
            FileUtils.writeStringToFile((File)new File(filePath), (String)fileContent, (String)"UTF-8");
            result.put("result", "true");
            result.put("filePath", filePath);
            result.put("version", String.valueOf(verionNo));
            result.put("fileName", newFileName.replaceAll(XML_EXTENSION, ""));
        }
        catch (Exception e) {
            logger.warning(e.getMessage());
        }
        catch (Throwable throwable) {
            logger.warning(throwable.getMessage());
        }
        return result;
    }

    public JSONObject convertXmlToJson(String filePaths) throws Throwable {
        JSONObject workFlowJson = new JSONObject(new LinkedHashMap());
        String tmpFile = XmlFileProcessor.instance.getTmpFile(filePaths);
        if (StringUtils.isBlank((CharSequence)tmpFile)) {
            tmpFile = filePaths;
        }
        Element root = DataMapOperJsonUtil.getElement(tmpFile);
        String extend = root.attributeValue("Extend");
        String caption = root.attributeValue("Caption");
        try {
            JSONObject source = this.setSourceFormJson(root);
            JSONObject target = this.setTargetFormJson(root);
            JSONObject paths = this.setPaths(root);
            JSONObject workFlowDesc = this.setWorkFlowAttributes(root);
            workFlowJson.put("paths", (Object)paths);
            workFlowJson.put("DataMigrationprops", (Object)workFlowDesc);
            workFlowJson.put("extend", (Object)extend);
            workFlowJson.put("source", (Object)source);
            workFlowJson.put("target", (Object)target);
            workFlowJson.put("Caption", (Object)caption);
        }
        catch (Throwable e) {
            logger.warning("\u8f6c\u6362xml\u6587\u4ef6\u4e3ajson\u6587\u4ef6\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
        }
        return workFlowJson;
    }

    public JSONObject setPaths(Element root) {
        String tgtDataObjectKey;
        JSONObject pathJson = new JSONObject(new LinkedHashMap());
        int i = 1;
        String srcDataObjectKey = root.attributeValue("SrcDataObjectKey");
        boolean isIdentical = srcDataObjectKey.equalsIgnoreCase(tgtDataObjectKey = root.attributeValue("TgtDataObjectKey"));
        if (isIdentical) {
            srcDataObjectKey = String.valueOf(srcDataObjectKey) + "__S";
            tgtDataObjectKey = String.valueOf(tgtDataObjectKey) + "__T";
        }
        List elements = root.element("SourceTableCollection").elements("SourceTable");
        HashMap<String, Integer> listHashMap = new HashMap<String, Integer>();
        int listHashMapi = -1;
        for (Element ele : elements) {
            List sourceField = ele.elements("SourceField");
            for (Element elefield : sourceField) {
                JSONObject temp;
                if (elefield.attributeValue("Type") != null && !listHashMap.containsKey(elefield.attributeValue("Definition"))) {
                    String definition = elefield.attributeValue("Definition");
                    listHashMap.put(definition, ++listHashMapi);
                }
                if (elefield.attributeValue("TargetFieldKey") != null && !listHashMap.containsKey(elefield.attributeValue("Definition"))) {
                    temp = new JSONObject(new LinkedHashMap());
                    String tableKey = DataMapOperXmlUtil.getTableKey(ele);
                    StringBuffer sourceID = new StringBuffer().append("F_").append(srcDataObjectKey).append(elefield.attributeValue("Definition")).append(tableKey);
                    this.isConstOrFormula(root, temp, tgtDataObjectKey, ele, elefield);
                    temp.put("sourceEndpoint", (Object)sourceID);
                    if ("Focus".equalsIgnoreCase(elefield.attributeValue("EdgeType"))) {
                        temp.put("EdgeType", (Object)"Focus");
                    }
                    if (temp.size() > 1) {
                        pathJson.put("path" + i, (Object)temp);
                    }
                    ++i;
                    continue;
                }
                if (elefield.attributeValue("TargetFieldKey") == null || !listHashMap.containsKey(elefield.attributeValue("Definition"))) continue;
                temp = new JSONObject(new LinkedHashMap());
                StringBuffer sourceConstAndFormula = null;
                String tableKey = DataMapOperXmlUtil.getTableKey(ele);
                int index = (Integer)listHashMap.get(elefield.attributeValue("Definition"));
                sourceConstAndFormula = new StringBuffer().append("F_").append(tableKey).append(srcDataObjectKey).append(index + 1);
                this.isConstOrFormula(root, temp, tgtDataObjectKey, ele, elefield);
                temp.put("sourceEndpoint", (Object)sourceConstAndFormula);
                if ("Focus".equalsIgnoreCase(elefield.attributeValue("EdgeType"))) {
                    temp.put("EdgeType", (Object)"Focus");
                }
                if (temp.size() > 1) {
                    pathJson.put("path" + i, (Object)temp);
                }
                ++i;
            }
        }
        JSONObject setpathJson = new JSONObject(new LinkedHashMap());
        setpathJson.put("path", (Object)pathJson);
        return setpathJson;
    }

    public void isConstOrFormula(Element root, JSONObject temp, String tgtDataObjectKey, Element ele, Element elefield) {
        List elementList = root.element("TargetTableCollection").elements("TargetTable");
        ArrayList<String> list = new ArrayList<String>();
        HashMap<String, Integer> listHashMap = new HashMap<String, Integer>();
        int listHashMapi = -1;
        String targetTableKey = elefield.attributeValue("TargetTableKey");
        for (Element targetele : elementList) {
            String tableKey;
            if (StringUtils.isBlank((CharSequence)targetTableKey)) {
                targetTableKey = ele.attributeValue("TargetTableKey");
            }
            if (!(tableKey = DataMapOperXmlUtil.getTableKey(targetele)).equalsIgnoreCase(targetTableKey)) continue;
            List targetField = targetele.elements("TargetField");
            for (Element targetfield : targetField) {
                String fieldValue;
                if (targetfield.attributeValue("Type") != null) {
                    fieldValue = DataMapOperXmlUtil.getFieldValue(targetfield);
                    listHashMap.put(fieldValue, ++listHashMapi);
                    list.add(fieldValue);
                }
                if (!(fieldValue = DataMapOperXmlUtil.getFieldValue(targetfield)).equalsIgnoreCase(elefield.attributeValue("TargetFieldKey"))) continue;
                if ("Const".equalsIgnoreCase(targetfield.attributeValue("Type")) || "Formula".equalsIgnoreCase(targetfield.attributeValue("Type"))) {
                    int index = (Integer)listHashMap.get(fieldValue);
                    StringBuffer targetID = new StringBuffer().append("F_").append(targetTableKey).append(tgtDataObjectKey).append(index + 1);
                    temp.put("targetEndpoint", (Object)targetID);
                    continue;
                }
                if (!Objects.isNull(targetfield.attributeValue("Type"))) continue;
                StringBuffer targetID = new StringBuffer().append("F_").append(tgtDataObjectKey).append(elefield.attributeValue("TargetFieldKey")).append(targetTableKey);
                temp.put("targetEndpoint", (Object)targetID);
            }
        }
    }

    public JSONObject setSourceFormJson(Element root) {
        boolean isIdentical = root.attributeValue("SrcDataObjectKey").equalsIgnoreCase(root.attributeValue("TgtDataObjectKey"));
        JSONObject setSourceFormJson = null;
        MetaDataObject metaDataObject = null;
        try {
            String key = "Definition";
            setSourceFormJson = new JSONObject(new LinkedHashMap());
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Element sourceTableCollection = root.element("SourceTableCollection");
            List sourceTable = sourceTableCollection.elements("SourceTable");
            if (sourceTable.size() != 0) {
                for (Element Definition : sourceTable) {
                    List SourceField = Definition.elements("SourceField");
                    int i = 0;
                    while (i < SourceField.size()) {
                        Element sourceField = (Element)SourceField.get(i);
                        JSONObject temp = new JSONObject(new LinkedHashMap());
                        String srcDataObjectKey = root.attributeValue("SrcDataObjectKey");
                        metaDataObject = MetaFactory.getGlobalInstance().getDataObject(srcDataObjectKey);
                        String tableKey = Definition.attributeValue("TableKey");
                        if (tableKey == null) {
                            tableKey = Definition.attributeValue("Key");
                        }
                        if (isIdentical) {
                            srcDataObjectKey = String.valueOf(root.attributeValue("SrcDataObjectKey")) + "__S";
                        }
                        if (!hashMap.containsKey(String.valueOf(sourceField.attributeValue("Definition")) + tableKey)) {
                            this.getSourceField(setSourceFormJson, temp, key, sourceField, srcDataObjectKey, metaDataObject, tableKey);
                        }
                        hashMap.put(String.valueOf(sourceField.attributeValue("Definition")) + tableKey, sourceField.attributeValue("Definition"));
                        ++i;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            logger.warning(throwable.getMessage());
        }
        JSONObject sourceJson = new JSONObject(new LinkedHashMap());
        sourceJson.put("source", (Object)setSourceFormJson);
        return sourceJson;
    }

    public void getSourceField(JSONObject setSourceFormJson, JSONObject temp, String key, Element sourceField, String srcDataObjectKey, MetaDataObject metaDataObject, String tableKey) {
        MetaTable metaTable = null;
        MetaTableCollection metaTableCollection = null;
        metaTable = metaDataObject.getTable(tableKey);
        metaTableCollection = metaDataObject.getTableCollection();
        String definitionKey = sourceField.attributeValue("Definition");
        MetaColumn metaColumn = null;
        metaColumn = (MetaColumn)metaTable.get(definitionKey);
        if (metaTable != null && !tableKey.contains("_NODB") && metaTableCollection != null) {
            int indexOf = metaTableCollection.indexOf(metaTable);
            String fieldCaption = null;
            if (metaColumn != null) {
                fieldCaption = metaColumn.getCaption();
            }
            if (StringUtils.isNotEmpty((CharSequence)sourceField.attributeValue("Type"))) {
                if (StringUtils.isBlank((CharSequence)definitionKey)) {
                    definitionKey = "  ";
                }
                StringBuffer fieldValue = new StringBuffer().append(indexOf + 1).append("_@_").append(definitionKey).append("_@_").append("  ").append("_@_").append(tableKey).append("_@_").append(srcDataObjectKey);
                temp.put("Definition", (Object)fieldValue);
            } else {
                StringBuffer fieldValue = new StringBuffer().append(indexOf + 1).append("_@_").append(definitionKey).append("_@_").append(StringUtils.isEmpty((CharSequence)fieldCaption) ? "SpecialField" : fieldCaption).append("_@_").append(tableKey).append("_@_").append(srcDataObjectKey);
                temp.put("Definition", (Object)fieldValue);
            }
            setSourceFormJson.put(String.valueOf(key) + (setSourceFormJson.size() + 1), (Object)temp);
        } else if (Objects.isNull(metaTable)) {
            definitionKey = sourceField.attributeValue("Definition");
            if (StringUtils.isNotEmpty((CharSequence)sourceField.attributeValue("Type"))) {
                if (StringUtils.isBlank((CharSequence)definitionKey)) {
                    definitionKey = "  ";
                }
                StringBuffer fieldValue = new StringBuffer().append(-1).append("_@_").append(definitionKey).append("_@_").append("  ").append("_@_").append(tableKey).append("_@_").append(srcDataObjectKey);
                temp.put("Definition", (Object)fieldValue);
            } else {
                StringBuffer fieldValue = new StringBuffer().append(-1).append("_@_").append(definitionKey).append("_@_").append(" ").append("_@_").append(tableKey).append("_@_").append(srcDataObjectKey);
                temp.put("Definition", (Object)fieldValue);
            }
            setSourceFormJson.put(String.valueOf(key) + (setSourceFormJson.size() + 1), (Object)temp);
        }
    }

    public JSONObject setTargetFormJson(Element root) throws Throwable {
        boolean isIdentical = root.attributeValue("SrcDataObjectKey").equalsIgnoreCase(root.attributeValue("TgtDataObjectKey"));
        String TgtDataObjectKey = root.attributeValue("TgtDataObjectKey");
        MetaDataObject dataObject = MetaFactory.getGlobalInstance().getDataObject(TgtDataObjectKey);
        if (isIdentical) {
            TgtDataObjectKey = String.valueOf(root.attributeValue("TgtDataObjectKey")) + "__T";
        }
        JSONObject settargetFormJson = null;
        try {
            String key = "Definition";
            settargetFormJson = new JSONObject(new LinkedHashMap());
            Element targetTableCollection = root.element("TargetTableCollection");
            List targetTable = targetTableCollection.elements("TargetTable");
            if (targetTable.size() != 0) {
                for (Element Definition : targetTable) {
                    List TargetField = Definition.elements("TargetField");
                    int i = 0;
                    while (i < TargetField.size()) {
                        Element targetField = (Element)TargetField.get(i);
                        JSONObject temp = new JSONObject(new LinkedHashMap());
                        String tableKey = Definition.attributeValue("TableKey");
                        if (tableKey != null && tableKey.indexOf("_NODB") == -1) {
                            String definitionKey;
                            MetaTable metaTable = dataObject.getTable(tableKey);
                            int indexOf = 0;
                            if (metaTable != null) {
                                indexOf = dataObject.getTableCollection().indexOf(metaTable);
                            }
                            String CoumnCaption = metaTable.get(definitionKey = targetField.attributeValue("FieldKey")) != null ? ((MetaColumn)metaTable.get(definitionKey)).getCaption() : null;
                            int groupType = -1;
                            if (metaTable.get(definitionKey) != null) {
                                groupType = ((MetaColumn)metaTable.get(definitionKey)).getGroupType();
                            }
                            String fieldCaption = DataMigrationOperJsonUtil.getGroupType(groupType);
                            StringBuffer fieldValue = new StringBuffer().append(indexOf + 1).append("_@_").append(definitionKey).append("_@_").append(String.valueOf(CoumnCaption) + fieldCaption).append("_@_").append(tableKey).append("_@_").append(TgtDataObjectKey).append("_@_").append("Migration");
                            temp.put("FieldKey", (Object)fieldValue);
                            settargetFormJson.put(String.valueOf(key) + (settargetFormJson.size() + 1), (Object)temp);
                        }
                        ++i;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            logger.warning(throwable.getMessage());
        }
        JSONObject sourceJson = new JSONObject(new LinkedHashMap());
        sourceJson.put("target", (Object)settargetFormJson);
        return sourceJson;
    }

    public static String getGroupType(int groupType) {
        String fieldCaption = "<\u65e0\u5206\u7ec4>";
        switch (groupType) {
            case -1: {
                fieldCaption = "<\u65e0\u5206\u7ec4>";
                break;
            }
            case 0: {
                fieldCaption = "<\u76f4\u63a5\u91cf>";
                break;
            }
            case 1: {
                fieldCaption = "<\u671f\u95f4\u5206\u7ec4>";
                break;
            }
        }
        return fieldCaption;
    }

    public JSONObject setWorkFlowAttributes(Element root) {
        List<String> keyList = Arrays.asList("Key", "Caption", "Description", "sourceForm", "targetForm", "StatusFieldKey", "StatusValue", "DetailCondition", "HeadCondition");
        JSONObject workFlowDescSub = new JSONObject(new LinkedHashMap());
        for (String key : keyList) {
            String value = root.attributeValue(key);
            JSONObject temp = new JSONObject(new LinkedHashMap());
            if ("DetailCondition".equalsIgnoreCase(key)) {
                value = root.attributeValue("Condition");
            }
            if (key.equalsIgnoreCase("sourceForm")) {
                value = root.attributeValue("SrcDataObjectKey");
            }
            if (key.equalsIgnoreCase("targetForm")) {
                value = root.attributeValue("TgtDataObjectKey");
            }
            temp.put("value", (Object)value);
            workFlowDescSub.put(key, (Object)temp);
        }
        JSONObject workFlowDesc = new JSONObject(new LinkedHashMap());
        workFlowDesc.put("DataMigrationprops", (Object)workFlowDescSub);
        return workFlowDesc;
    }

    public boolean existDataMigrationVest(String extend, IMetaFactory iMetaFactory) throws Throwable {
        MetaDataMigrationList dataMigrationList = iMetaFactory.getDataMigrationList();
        for (MetaDataMigrationProfile dataMigrationProfile : dataMigrationList) {
            if (StringUtils.isEmpty((CharSequence)extend)) break;
            if (StringUtils.isEmpty((CharSequence)dataMigrationProfile.getDataMigration().getExtend()) || !dataMigrationProfile.getDataMigration().getExtend().equals(extend.split(" ")[0])) continue;
            return true;
        }
        return false;
    }
}

