/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.codemirror;

import com.bokesoft.yes.common.log.LogSvr;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Objects;

public class MyClassLoader
extends ClassLoader {
    private final String classPath;

    public MyClassLoader(String classPath) {
        this.classPath = classPath;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] classData = this.getClassData(name);
        if (Objects.isNull(classData)) {
            throw new ClassNotFoundException();
        }
        return this.defineClass(name, classData, 0, classData.length);
    }

    private byte[] getClassData(String className) {
        String path = this.classNameToPath(className);
        FileInputStream inStream = null;
        ByteArrayOutputStream stream = null;
        try {
            inStream = new FileInputStream(path);
            stream = new ByteArrayOutputStream();
            byte[] buffer = new byte[2048];
            int num = 0;
            while ((num = ((InputStream)inStream).read(buffer)) != -1) {
                stream.write(buffer, 0, num);
            }
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            LogSvr.getInstance().error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (inStream != null) {
                    ((InputStream)inStream).close();
                }
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                LogSvr.getInstance().error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private String classNameToPath(String className) {
        return String.valueOf(this.classPath) + File.separatorChar + className.replace('.', File.separatorChar) + ".class";
    }

    public static void main(String[] args) {
        String classPath = "D:\\source2\\bokeerp\\autorecord\\target\\classes\\";
        MyClassLoader loader = new MyClassLoader(classPath);
        try {
            Class<?> clazz = loader.loadClass("com.bokesoft.erp.record.AutoRecord");
            Method[] methodArray = clazz.getDeclaredMethods();
        }
        catch (Exception e) {
            LogSvr.getInstance().error(e.getMessage(), (Throwable)e);
        }
    }
}

