/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.util.DebugUtil;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.DiffProperty;
import com.bokesoft.yes.design.MetaObjectType;
import com.bokesoft.yes.design.Property;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.utils.IDLookup;
import com.bokesoft.yes.design.xml.XmlParser;
import com.bokesoft.yes.design.xml.ex.XmlSyntaxException;
import com.bokesoft.yes.design.xml.node.AbstractNode;
import com.bokesoft.yes.design.xml.node.CDataNode;
import com.bokesoft.yes.design.xml.node.CommentNode;
import com.bokesoft.yes.design.xml.node.DTDNode;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.design.xml.node.TextNode;
import com.bokesoft.yes.design.xml.node.XmlTree;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.form.MetaForm;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class XmlDiffToPropertyDiff {
    public static final XmlDiffToPropertyDiff instance = new XmlDiffToPropertyDiff();

    public boolean processDiff(List<Diff> diffs) throws Throwable {
        boolean result = true;
        for (Diff diff : diffs) {
            boolean tmp = this.processDiff(diff);
            boolean bl = result = result && tmp;
        }
        return result;
    }

    private boolean processDiff(Diff diff) throws Throwable {
        if (diff.getMetaObjectType() != null && ("SetupMainTable".equals(diff.getMetaObjectType().name) || "DataSource".equals(diff.getMetaObjectType().name) || "newToolBar".equals(diff.getMetaObjectType().name) || "GridFieldMultiRowTable".equals(diff.getMetaObjectType().name) || "GridCellType".equals(diff.getMetaObjectType().name) || diff.isEmbed.booleanValue()) && ("".equals(diff.tableKey) || "".equals(diff.subTableKey))) {
            return true;
        }
        if (diff.isPropertyDiff()) {
            return true;
        }
        String orgXml = diff.getXmlTree().xmlTree.getOrgXml();
        String newXml = diff.getNewXml();
        Object[] orgLines = orgXml.split("\r\n");
        String tmpNewXml = newXml.replaceAll("\r\n", "\n");
        Object[] newLines = tmpNewXml.split("\n");
        int startSameLines = 0;
        int size = Math.min(orgLines.length, newLines.length);
        while (startSameLines < size) {
            if (!orgLines[startSameLines].equals(newLines[startSameLines])) break;
            ++startSameLines;
        }
        int endSameLines = 0;
        int size2 = Math.min(orgLines.length, newLines.length) - startSameLines;
        while (endSameLines < size2) {
            if (!orgLines[orgLines.length - endSameLines - 1].equals(newLines[newLines.length - endSameLines - 1])) break;
            ++endSameLines;
        }
        String orgXmlFragment = orgXml;
        String newXmlFragment = newXml;
        if (startSameLines > 0 || endSameLines > 0) {
            orgXmlFragment = StringUtils.join((Object[])orgLines, (String)"\r\n", (int)startSameLines, (int)(orgLines.length - endSameLines));
            if (orgXmlFragment.length() > 0) {
                orgXmlFragment = String.valueOf(orgXmlFragment) + "\r\n";
            }
            if ((newXmlFragment = StringUtils.join((Object[])newLines, (String)"\r\n", (int)startSameLines, (int)(newLines.length - endSameLines))).length() > 0) {
                newXmlFragment = String.valueOf(newXmlFragment) + "\r\n";
            }
        }
        diff.setXmlDiff(diff.getXmlTree(), startSameLines, orgXmlFragment, newXmlFragment);
        XmlTreeWithPath orgXmlTree = diff.getXmlTree();
        if (Objects.isNull(orgXmlTree)) {
            return true;
        }
        if (Objects.isNull(orgXmlTree.xmlTree.getRoot())) {
            return false;
        }
        int startPos = orgXmlTree.xmlTree.getLineStartPos(startSameLines + 1);
        int endPos = startPos + orgXmlFragment.length() - 1;
        List<AbstractNode> detailNodes = orgXmlTree.xmlTree.getDetailNodeByLine(startPos, endPos);
        List<AbstractNode> componentNodes = null;
        try {
            componentNodes = this.getComponentNodes(detailNodes);
        }
        catch (RuntimeException e) {
            DebugUtil.debug((Object)e.getMessage());
            return false;
        }
        if (componentNodes.size() > 1) {
            return false;
        }
        int nodeStartPos = startPos;
        int nodeEndPos = endPos;
        for (AbstractNode node : detailNodes) {
            nodeStartPos = Math.min(nodeStartPos, node.getElement().getBgIndex());
            nodeEndPos = Math.max(nodeEndPos, node.getElement().getEndIndex());
        }
        for (AbstractNode node : componentNodes) {
            nodeStartPos = Math.min(nodeStartPos, node.getElement().getBgIndex());
            List<AbstractNode> children = ((TagNode)node).getChildren();
            int tmp = CollectionUtils.isEmpty(children) ? node.getElement().getEndIndex() : children.get(children.size() - 1).getElement().getEndIndex();
            nodeEndPos = Math.max(nodeEndPos, tmp);
        }
        String newXmlFragmentFull = new StringBuilder(1024).append(orgXmlTree.xmlTree.getOrgXml().substring(nodeStartPos, startPos)).append(newXmlFragment).append(orgXmlTree.xmlTree.getOrgXml().substring(endPos + 1, nodeEndPos + 1)).toString();
        List<AbstractNode> newTagNodes = null;
        try {
            newTagNodes = this.getComponentNodes(newXmlFragmentFull);
        }
        catch (RuntimeException e) {
            DebugUtil.debug((Object)e.getMessage());
            return false;
        }
        if (componentNodes.size() == 0 && newTagNodes.size() == 0) {
            return true;
        }
        if (componentNodes.size() != 1 || newTagNodes.size() != 1) {
            return false;
        }
        TagNode orgTagNode = (TagNode)componentNodes.get(0);
        TagNode newTagNode = (TagNode)newTagNodes.get(0);
        return this.genPropertyDiff(diff, orgTagNode, newTagNode);
    }

    private List<AbstractNode> getComponentNodes(String xml) throws Throwable {
        String tmp = new StringBuilder(xml.length() + 30).append("<TempRoot>").append(xml).append("</TempRoot>").toString();
        XmlTree xmlTree = XmlParser.parse(tmp);
        List<AbstractNode> nodes = xmlTree.getRoot().getChildren();
        Iterator<AbstractNode> it = nodes.iterator();
        while (it.hasNext()) {
            AbstractNode node = it.next();
            if (node instanceof CommentNode || node instanceof TextNode || node instanceof DTDNode) {
                it.remove();
                continue;
            }
            if (node instanceof CDataNode) {
                throw new XmlSyntaxException("\u65e0\u6cd5\u89e3\u6790CDATA[" + node.getElement().getText() + "]");
            }
            TagNode tagNode = (TagNode)node;
            if (tagNode.getElement().getTagType() != 2) continue;
            it.remove();
        }
        return nodes;
    }

    private List<AbstractNode> getComponentNodes(List<AbstractNode> nodes) {
        ArrayList<AbstractNode> result = new ArrayList<AbstractNode>();
        boolean changed = false;
        for (AbstractNode node : nodes) {
            if (node instanceof CommentNode || node instanceof TextNode || node instanceof DTDNode) {
                changed = true;
                continue;
            }
            if (node instanceof CDataNode) {
                TagNode parent = node.getParent();
                if (!result.contains(parent)) {
                    result.add(parent);
                }
                changed = true;
                continue;
            }
            TagNode tagNode = (TagNode)node;
            String tagName = tagNode.getTagName();
            if (this.isEqualsAny(tagName, "Attachment", "BPMGraph", "Button", "Calendar", "CheckBox", "CheckListBox", "ColorPicker", "ComboBox", "CompDict", "CountDownView", "CountUp", "DataBinding", "DatePicker", "Item", "Dict", "DropdownButton", "DynamicDict", "Empty", "FileChooser", "FlatCanvas", "FontPicker", "GIFImage", "GridDesigner", "HyperLink", "Icon", "Image", "ImageButton", "ImageList", "ImageItem", "Label", "MaskEditor", "MonthPicker", "NumberEditor", "NumberInfoEditor", "PasswordEditor", "PopButton", "ProgressBar", "RadioButton", "RichEditor", "ScoreBar", "SearchBox", "SegmentedControl", "Separator", "Slider", "SplitButton", "StateList", "StepEditor", "SubForm", "Switch", "TabGroup", "TabItem", "TabItemCollection", "TextArea", "TextButton", "TextEditor", "TimePicker", "ToggleButton", "UploadButton", "UTCDatePicker", "ValidateBox", "WebBrowser")) {
                result.add(node);
                continue;
            }
            if (this.isEqualsAny(tagName, "GridCell", "GridColumn", "Grid")) {
                result.add(node);
                continue;
            }
            if (this.isEqualsAny(tagName, "Operation", "OperationCollection", "Macro", "MacroCollection")) {
                result.add(node);
                continue;
            }
            if (this.isEqualsAny(tagName, "GridLayoutPanel", "SplitPanel", "Embed", "FlexFlowLayoutPanel", "TabPanel")) {
                result.add(node);
                continue;
            }
            if (this.isEqualsAny(tagName, "DataBinding", "ValueChanged", "ItemFilter", "Filter", "FilterValue", "Item", "OnClick", "DefaultFormulaValue", "FormulaItems")) {
                result.add(node.getParent());
                changed = true;
                continue;
            }
            if (this.isEqualsAny(tagName, "ItemChanged")) {
                result.add(node.getParent());
                changed = true;
                continue;
            }
            throw new RuntimeException("\u672a\u5904\u7406\u7684TagName:" + tagName);
        }
        if (changed) {
            return this.getComponentNodes(result);
        }
        return nodes;
    }

    private boolean isEqualsAny(String left, String ... rights) {
        String[] stringArray = rights;
        int n = rights.length;
        int n2 = 0;
        while (n2 < n) {
            String right = stringArray[n2];
            if (left.equals(right)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean genPropertyDiff(Diff diff, TagNode orgNode, TagNode newNode) throws Throwable {
        String tagName = orgNode.getTagName();
        if (tagName.equals(newNode.getTagName())) {
            Map<String, String> orgAttributes = orgNode.getAttributes();
            String key = orgAttributes.get("Key");
            if (StringUtils.isBlank((CharSequence)key)) {
                return false;
            }
            Map<String, String> newAttributes = newNode.getAttributes();
            if (key.equals(newAttributes.get("Key"))) {
                String attribute;
                HashSet<String> allProperties = new HashSet<String>();
                ArrayList<DiffProperty> diffProperties = new ArrayList<DiffProperty>();
                for (Map.Entry<String, String> entry : orgAttributes.entrySet()) {
                    String newValue;
                    attribute = entry.getKey();
                    String orgValue = entry.getValue();
                    if (!orgValue.equals(newValue = newAttributes.get(attribute))) {
                        Property property = Property.getProperty(attribute);
                        if (Objects.isNull(property)) {
                            return false;
                        }
                        DiffProperty diffProperty = new DiffProperty(property, orgValue, newValue);
                        diffProperties.add(diffProperty);
                    }
                    allProperties.add(attribute);
                }
                for (Map.Entry<String, String> entry : newAttributes.entrySet()) {
                    attribute = entry.getKey();
                    if (allProperties.contains(attribute)) continue;
                    String newValue = entry.getValue();
                    Property property = Property.getProperty(attribute);
                    if (Objects.isNull(property)) {
                        return false;
                    }
                    DiffProperty diffProperty = new DiffProperty(property, "", newValue);
                    diffProperties.add(diffProperty);
                }
                MetaObjectType metaObjectType = this.getMetaObjectType(tagName);
                if (Objects.isNull(metaObjectType)) {
                    return false;
                }
                diff.setMetaObjectType(metaObjectType);
                MetaForm metaForm = diff.getMetaForm();
                IDLookup idLookup = IDLookup.getIDLookup(metaForm);
                String primaryFieldKey = idLookup.getFieldKeyByBuddyKey(key);
                if (primaryFieldKey != null && primaryFieldKey.length() > 0) {
                    diff.setKey(primaryFieldKey);
                    diff.setControlType(idLookup.getComponentByKey(primaryFieldKey).getControlType());
                    for (DiffProperty diffProperty : diffProperties) {
                        if (diffProperty.property == Property.caption) {
                            diffProperty.property = Property.buddyCaption;
                            continue;
                        }
                        if (diffProperty.property == Property.x) {
                            diffProperty.property = Property.buddyX;
                            continue;
                        }
                        if (diffProperty.property != Property.y) continue;
                        diffProperty.property = Property.buddyY;
                    }
                } else {
                    diff.setKey(key);
                    diff.setControlType(ControlType.parse((String)tagName));
                }
                diff.properties = diffProperties;
                return true;
            }
        }
        return false;
    }

    private MetaObjectType getMetaObjectType(String tagName) {
        MetaObjectType result = null;
        if (this.isEqualsAny(tagName, "GridCell", "GridColumn")) {
            result = MetaObjectType.gridField;
        } else if (this.isEqualsAny(tagName, "OperationCollection")) {
            result = MetaObjectType.operationCollection;
        } else if (this.isEqualsAny(tagName, "Operation")) {
            result = MetaObjectType.operation;
        } else if (this.isEqualsAny(tagName, "GridLayoutPanel", "SplitPanel", "Embed", "FlexFlowLayoutPanel", "TabPanel")) {
            result = MetaObjectType.panel;
        } else if (this.isEqualsAny(tagName, "Grid")) {
            result = MetaObjectType.grid;
        } else if (this.isEqualsAny(tagName, "Attachment", "BPMGraph", "Button", "Calendar", "CheckBox", "CheckListBox", "ColorPicker", "ComboBox", "CompDict", "CountDownView", "CountUp", "DataBinding", "DatePicker", "Item", "Dict", "DropdownButton", "DynamicDict", "Empty", "FileChooser", "FlatCanvas", "FontPicker", "GIFImage", "GridDesigner", "HyperLink", "Icon", "Image", "ImageButton", "ImageList", "ImageItem", "Label", "MaskEditor", "MonthPicker", "NumberEditor", "NumberInfoEditor", "PasswordEditor", "PopButton", "ProgressBar", "RadioButton", "RichEditor", "ScoreBar", "SearchBox", "SegmentedControl", "Separator", "Slider", "SplitButton", "StateList", "StepEditor", "SubForm", "Switch", "TabGroup", "TabItem", "TabItemCollection", "TextArea", "TextButton", "TextEditor", "TimePicker", "ToggleButton", "UploadButton", "UTCDatePicker", "ValidateBox", "WebBrowser")) {
            result = MetaObjectType.field;
        }
        return result;
    }
}

