/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.cmd.DesignerServiceCmd;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.dataMigration.util.DataMigrationOperJsonUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.ReloadForm;
import com.bokesoft.yes.erp.dev.MetaTableCache;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigration;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationList;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationProfile;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.intf.IMetaProject;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class WebDataMigration
extends DesignerServiceCmd {
    public static final String CMD = "WebDataMigration";
    private String projectKey;
    private String filePath;
    private String sourceFormKey;
    private String targetFormKey;
    private String extend;
    private String key;
    private String caption;
    private int type;
    public static final int CONST_ONE = 1;
    public static final int CONST_TWO = 2;
    public static final String CONST_TRUE = "true";
    public static final String CONST_FALSE = "false";
    public static final String CONST_RESULT = "result";
    private static final DataMigrationOperJsonUtil dataMigrationOperJsonUtil = new DataMigrationOperJsonUtil();

    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        this.filePath = FilePathHelper.toBackFilePath((String)arguments.get((Object)"filePath"));
        this.projectKey = (String)arguments.get((Object)"projectKey");
        this.sourceFormKey = (String)arguments.get((Object)"sourceFormKey");
        this.targetFormKey = (String)arguments.get((Object)"targetFormKey");
        this.key = (String)arguments.get((Object)"key");
        this.caption = (String)arguments.get((Object)"caption");
        this.type = Integer.parseInt(String.valueOf(arguments.get((Object)"type")));
        this.extend = (String)arguments.get((Object)"extend");
    }

    @Override
    public Object innerDoCmd(DefaultContext defaultContext) throws Throwable {
        JSONObject result = new JSONObject();
        if (1 == this.type) {
            IMetaFactory iMetaFactory = MetaFactory.getGlobalInstance();
            MetaDataMigrationList dataMigrationList = iMetaFactory.getDataMigrationList();
            boolean isExist = dataMigrationList.containsKey(this.key);
            if (isExist) {
                throw new Exception("\u5f53\u524d\u8f93\u5165\u7684\u6570\u636e\u8fc1\u79fb\u6807\u8bc6\u5df2\u7ecf\u5b58\u5728,\u8bf7\u91cd\u65b0\u8f93\u5165");
            }
            if (dataMigrationOperJsonUtil.existDataMigrationVest(this.extend, iMetaFactory)) {
                result.put("code", (Object)1);
                result.put("msg", (Object)("\u65b0\u589e\u6570\u636e\u8fc1\u79fb\u9a6c\u7532\u5931\u8d25\uff1a\u5df2\u5b58\u5728" + this.extend + "\u7684\u6570\u636e\u8fc1\u79fb\u9a6c\u7532"));
            } else {
                Map<String, String> res = dataMigrationOperJsonUtil.createDataMigrationXml(this.projectKey, this.sourceFormKey, this.targetFormKey, this.key, this.caption, this.extend, "0");
                if (CONST_TRUE.equals(res.get(CONST_RESULT))) {
                    this.filePath = res.get("filePath");
                    result.put("code", (Object)0);
                    result.put("msg", (Object)"\u65b0\u589e\u6570\u636e\u8fc1\u79fb\u6210\u529f");
                    result.put("filePath", (Object)this.filePath);
                    this.reloadDataMigration(iMetaFactory, dataMigrationList);
                    ArrayList<UICommand> uiCommands = new ArrayList<UICommand>();
                    uiCommands.add(UICommand.reloadFileTree(this.filePath));
                    uiCommands.add(UICommand.reloadMenuTree());
                    result.put("uICommands", (Object)UICommand.toJson(uiCommands));
                    result.put("caption", (Object)this.caption);
                    result.put("version", (Object)"V1");
                } else {
                    result.put("code", (Object)1);
                    result.put("msg", (Object)res.get("msg"));
                }
            }
        } else if (2 == this.type) {
            JSONObject jsonFileContent = WebDataMigration.getJsonFileContent(this.filePath);
            String sourceForm = jsonFileContent.getJSONObject("DataMigrationprops").getJSONObject("DataMigrationprops").getJSONObject("sourceForm").getString("value");
            String targetForm = jsonFileContent.getJSONObject("DataMigrationprops").getJSONObject("DataMigrationprops").getJSONObject("targetForm").getString("value");
            IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
            MetaDataObject tagetDataObject = globalInstance.getDataObject(targetForm);
            MetaDataObject metaDataObject = globalInstance.getDataObject(sourceForm);
            String sourceCaption = metaDataObject.getCaption();
            String targetCaption = tagetDataObject.getCaption();
            String extend = (String)jsonFileContent.get((Object)"extend");
            result.put("jsonFileContent", (Object)jsonFileContent);
            result.put("sourceCaption", (Object)sourceCaption);
            result.put("targetCaption", (Object)targetCaption);
            result.put("sourceForm", (Object)sourceForm);
            result.put("targetForm", (Object)targetForm);
            String linkDataMigrationCaption = this.getLinkCaption(extend, globalInstance);
            result.put("linkDataMigrationCaption", (Object)linkDataMigrationCaption);
            String linkDataMigrationPath = LoadFileTree.getDataMigrationPathByKey(extend);
            result.put("linkDataMigrationPath", (Object)linkDataMigrationPath);
            return JSONObject.toJSONString((Object)result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.DisableCircularReferenceDetect});
        }
        return result;
    }

    public static JSONObject getJsonFileContent(String tmpFile) throws Throwable {
        return dataMigrationOperJsonUtil.convertXmlToJson(tmpFile);
    }

    private void reloadDataMigration(IMetaFactory iMetaFactory, MetaDataMigrationList dataMigrationList) throws Throwable {
        MetaDataMigrationProfile metaDataMigrationProfile = new MetaDataMigrationProfile();
        MetaDataMigration metaDataMigration = new MetaDataMigration();
        metaDataMigrationProfile.setKey(this.key);
        metaDataMigrationProfile.setCaption(this.caption);
        metaDataMigrationProfile.setTgtDataObjectKey(this.targetFormKey);
        metaDataMigrationProfile.setSrcDataObjectKey(this.sourceFormKey);
        MetaProject metaProject = iMetaFactory.getMetaProject(this.projectKey);
        metaDataMigrationProfile.setProject((IMetaProject)metaProject);
        String resource = LoadFileTree.getResource(this.filePath, this.projectKey);
        metaDataMigrationProfile.setResource(resource);
        metaDataMigration.setKey(this.key);
        metaDataMigration.setCaption(this.caption);
        metaDataMigration.setProject((IMetaProject)metaProject);
        metaDataMigration.setSrcDataObjectKey(this.sourceFormKey);
        metaDataMigration.setTgtDataObjectKey(this.targetFormKey);
        metaDataMigrationProfile.setDataMigration(metaDataMigration);
        if (StringUtils.isNotEmpty((CharSequence)this.extend)) {
            metaDataMigrationProfile.setExtend(this.extend.split(" ")[0]);
        }
        dataMigrationList.add(metaDataMigrationProfile);
        ReloadForm.reloadDataMigrationKey(iMetaFactory, this.key, resource);
        MetaTableCache.updateMetaTables((IMetaFactory)iMetaFactory, (MetaDataMigration)metaDataMigration);
    }

    public String getCmd() {
        return CMD;
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new WebDataMigration();
    }

    private String getLinkCaption(String extend, IMetaFactory iMetaFactory) throws Throwable {
        String linkDataMigrationCaption = null;
        MetaDataMigrationList dataMigrationList = iMetaFactory.getDataMigrationList();
        for (MetaDataMigrationProfile dataMigrationProfile : dataMigrationList) {
            if (StringUtils.isEmpty((CharSequence)extend)) break;
            if (!dataMigrationProfile.getDataMigration().getKey().equals(extend)) continue;
            linkDataMigrationCaption = dataMigrationProfile.getDataMigration().getCaption();
            break;
        }
        return linkDataMigrationCaption;
    }
}

