/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.bokesoft.erp.webdesigner.language.infrastructure.index.IndexFacade;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.IndexFileWrapper;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.helper.FilePathHelper;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONObject;

public class UICommand {
    public final String key;
    public final Object content;

    public UICommand(String key, Object content) {
        this.key = key;
        this.content = content;
    }

    public static UICommand reloadDependency(JSONObject dependency) {
        return new UICommand("ReloadDependency", dependency);
    }

    public static UICommand renderControl(String fieldKey) {
        return new UICommand("RenderControl", fieldKey);
    }

    public static UICommand locate(String fieldKey) {
        return new UICommand("locate", fieldKey);
    }

    public static UICommand refreshMenuTree(String fieldKey) {
        return new UICommand("refreshMenuTree", fieldKey);
    }

    public static UICommand renderPanelLayout(String panelKey) {
        return new UICommand("RenderPanelLayout", panelKey);
    }

    public static UICommand renderForm() {
        return new UICommand("RenderForm", null);
    }

    public static UICommand freshFileTree() {
        return new UICommand("freshFileTree", null);
    }

    public static UICommand resetUIStatus() {
        return new UICommand("ResetUIStatus", null);
    }

    public static UICommand reloadFormKey(String formKey) {
        return new UICommand("ReloadFormKey", formKey);
    }

    public static UICommand updateXMLSource(String xmlPath, String objectType, String key, String newNodeText) {
        JSONObject tmp = new JSONObject();
        tmp.put("xmlPath", (Object)xmlPath);
        tmp.put("objectType", (Object)objectType);
        tmp.put("key", (Object)key);
        tmp.put("newNodeText", (Object)newNodeText);
        return new UICommand("UpdateXMLSource", tmp);
    }

    public static UICommand rebuildTable(List<com.alibaba.fastjson.JSONObject> jsonArray) {
        return new UICommand("rebuildTable", jsonArray);
    }

    public static UICommand uadataWebJson(Object jsonArray) {
        return new UICommand("uadataWebJson", jsonArray);
    }

    public static UICommand updateDiffFilePath(Map<String, String> diffSequenceToFilePath) {
        JSONObject tmp = new JSONObject();
        for (Map.Entry<String, String> entry : diffSequenceToFilePath.entrySet()) {
            tmp.put(entry.getKey(), (Object)entry.getValue());
        }
        return new UICommand("UpdateDiffFilePath", tmp);
    }

    public static UICommand reloadFileTree(String filePath) {
        UICommand.reloadIndex(filePath);
        JSONObject tmp = new JSONObject();
        tmp.put("filePath", (Object)FilePathHelper.toFrontFilePath(filePath));
        tmp.put("parentFilePath", (Object)FilePathHelper.toFrontFilePath(new File(filePath).getParent()));
        return new UICommand("ReloadFileTree", tmp);
    }

    private static String getParentFilePath(String filePath, String projectKey) {
        String parent1 = new File(filePath).getParent();
        if (parent1 != null) {
            if (parent1.endsWith(projectKey)) {
                return parent1;
            }
            parent1 = UICommand.getParentFilePath(parent1, projectKey);
        }
        return parent1;
    }

    public static UICommand reloadFileTreeAndParentFilePath(String filePath, String projectKey) {
        UICommand.reloadIndex(filePath);
        JSONObject tmp = new JSONObject();
        tmp.put("filePath", (Object)FilePathHelper.toFrontFilePath(filePath));
        String temp = UICommand.getParentFilePath(filePath, projectKey);
        tmp.put("parentFilePath", (Object)FilePathHelper.toFrontFilePath(temp));
        return new UICommand("ReloadFileTree", tmp);
    }

    public static UICommand reloadXmlSource(String filePath) {
        UICommand.reloadIndex(filePath);
        return new UICommand("ReloadXmlSource", FilePathHelper.toFrontFilePath(filePath));
    }

    public static UICommand removeScopeCache(String key) {
        return new UICommand("RemoveScopeCache", key);
    }

    public static UICommand runFormKey(String formKey) {
        return new UICommand("RunFormKey", formKey);
    }

    public static UICommand closeFormKey(String formKey) {
        return new UICommand("CloseFormKey", formKey);
    }

    public static UICommand closeFilePath(String filePath) {
        return new UICommand("CloseFilePath", FilePathHelper.toFrontFilePath(filePath));
    }

    public static UICommand showError(String xmlError) {
        return new UICommand("ShowError", xmlError);
    }

    public static UICommand showTip(String tip) {
        return new UICommand("showTip", tip);
    }

    public static UICommand showTipByList(List showTipByList) {
        return new UICommand("showTipByList", showTipByList);
    }

    public static UICommand reloadMenuTree() {
        return new UICommand("ReloadMenuTree", null);
    }

    public static UICommand refreshFileTreeChildren(String filePath) {
        UICommand.reloadIndex(filePath);
        String frontFilePath = FilePathHelper.toFrontFilePath(new File(filePath).getParent());
        return new UICommand("RefreshFileTreeChildren", frontFilePath);
    }

    public static UICommand reloadXmlSourceByTemp(String filePath, String temPath) {
        JSONObject tmp = new JSONObject();
        tmp.put("filePath", (Object)FilePathHelper.toFrontFilePath(filePath));
        tmp.put("temPath", (Object)FilePathHelper.toFrontFilePath(temPath));
        return new UICommand("ReloadXmlSourceByTemp", tmp);
    }

    public static UICommand processDocumentDirty(String formKey, JSONObject documentDirty) {
        JSONObject content = new JSONObject();
        content.put("formKey", (Object)formKey);
        content.put("documentDirty", (Object)documentDirty);
        return new UICommand("ProcessDocumentDirty", content);
    }

    private static void reloadIndex(String filePath) {
        String tempFilePath = XmlFileProcessor.instance.getTmpFile(filePath);
        IndexFileWrapper file = IndexFileWrapper.newInstance((String)filePath, (String)tempFilePath);
        IndexFacade.reload((IndexFileWrapper)file);
    }

    public JSONObject toJson() {
        JSONObject result = new JSONObject();
        result.put("key", (Object)this.key);
        result.put("content", this.content);
        return result;
    }

    public static JSONArray toJson(List<UICommand> uiCommands) {
        JSONArray result = new JSONArray();
        for (UICommand uiCommand : uiCommands) {
            result.put((Object)uiCommand.toJson());
        }
        return result;
    }

    public String toString() {
        return this.toJson().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UICommand)) {
            return false;
        }
        UICommand uiCommand = (UICommand)o;
        return Objects.equals(this.key, uiCommand.key) && Objects.equals(this.content, uiCommand.content);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.content);
    }
}

