/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.cmd.DesignerServiceCmd;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.helper.DataObjectHelper;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class RefreshDataObjectCmd
extends DesignerServiceCmd {
    public static final String CMD = "RefreshDataObject";
    private String formkey;

    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        this.formkey = (String)arguments.get((Object)"formKeys");
    }

    @Override
    public Object innerDoCmd(DefaultContext defaultContext) throws Throwable {
        String sourcePath = LoadFileTree.loadFilePathByDataObjectFieldKey(this.formkey);
        JSONObject resJson = new JSONObject();
        try {
            List<MetaFormProfile> metaFormProfiles = DataObjectHelper.reload(null, this.formkey, sourcePath, null);
            List formKeyList = metaFormProfiles.stream().map(item -> item.getKey()).collect(Collectors.toList());
            resJson.put("resultMsg", (Object)"\u4fee\u6539\u6210\u529f");
            resJson.put("formKeyList", formKeyList);
        }
        catch (Exception e) {
            LogSvr.getInstance().error("\n", (Throwable)e);
            resJson.put("formKeyList", Collections.emptyList());
            resJson.put("resultMsg", (Object)"\u8f85\u7c7b\u578b\u4e3a\u5b57\u5178\u3001\u94fe\u5f0f\u5b57\u5178\u7684\u9700\u8981\u4fdd\u5b58\u540e\u751f\u6548");
        }
        return resJson;
    }

    public String getCmd() {
        return CMD;
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new RefreshDataObjectCmd();
    }
}

