/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.bokesoft.erp.WebDesignerConfiguration;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.cmd.DesignerServiceCmd;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.design.xml.node.XmlTree;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.helper.MetaObjectHelper;
import com.bokesoft.yes.meta.persist.dom.MetaActionMap;
import com.bokesoft.yes.meta.persist.dom.commondef.MetaCommonDefSave;
import com.bokesoft.yes.meta.persist.dom.enhance.MetaEnhanceSave;
import com.bokesoft.yes.meta.persist.dom.iosetting.MetaIOSettingActionMap;
import com.bokesoft.yes.meta.persist.dom.paratable.MetaParaTableSave;
import com.bokesoft.yes.meta.persist.dom.rights.MetaRightsDefinitionSave;
import com.bokesoft.yes.meta.persist.dom.setting.MetaSettingSave;
import com.bokesoft.yes.meta.persist.dom.solution.MetaSolutionSave;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.commondef.MetaCommonDef;
import com.bokesoft.yigo.meta.enhance.MetaEnhance;
import com.bokesoft.yigo.meta.factory.DefaultMetaFactory;
import com.bokesoft.yigo.meta.factory.DefaultMetaResolverFactory;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.IMetaResolverFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.iosetting.MetaIOSetting;
import com.bokesoft.yigo.meta.paratable.MetaParaTable;
import com.bokesoft.yigo.meta.rights.MetaRightsDefinition;
import com.bokesoft.yigo.meta.setting.MetaSetting;
import com.bokesoft.yigo.meta.solution.MetaSolution;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.io.File;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class NewSolutionCmd
extends DesignerServiceCmd {
    public static final String CMD = "NewSolution";
    private StringHashMap<Object> arguments;

    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        this.arguments = arguments;
    }

    @Override
    public Object innerDoCmd(DefaultContext context) throws Throwable {
        String key = TypeConvertor.toString((Object)this.arguments.get((Object)"key"));
        String caption = TypeConvertor.toString((Object)this.arguments.get((Object)"caption"));
        String folderName = TypeConvertor.toString((Object)this.arguments.get((Object)"folderName"));
        String workspacePath = FilePathHelper.getWorkspacePath();
        Object[] existSamePaths = FileUtils.getFile((String[])new String[]{workspacePath}).list((dirFile, fileName) -> StringUtils.equals((CharSequence)fileName, (CharSequence)folderName));
        if (ArrayUtils.isNotEmpty((Object[])existSamePaths)) {
            throw new RuntimeException("warning: \u89e3\u51b3\u65b9\u6848\u5b58\u653e\u7684\u6587\u4ef6\u5939\u4e0e\u5df2\u6709\u6587\u4ef6\u6216\u6587\u4ef6\u5939\u540d\u79f0\u91cd\u590d\uff01");
        }
        File currentSolutionFile = FileUtils.getFile((String[])new String[]{workspacePath, folderName});
        FileUtils.forceMkdir((File)currentSolutionFile);
        String solutionPath = currentSolutionFile.getCanonicalPath();
        MetaSolution metaSolution = new MetaSolution();
        metaSolution.setKey(key);
        metaSolution.setCaption(caption);
        MetaObjectHelper.saveToXml((AbstractMetaObject)metaSolution, solutionPath, "Solution.xml", MetaSolutionSave.class);
        MetaSetting metaSetting = new MetaSetting();
        MetaObjectHelper.saveToXml((AbstractMetaObject)metaSetting, solutionPath, "setting.xml", MetaSettingSave.class);
        MetaIOSetting metaIOSetting = new MetaIOSetting();
        MetaObjectHelper.saveToXml((AbstractMetaObject)metaIOSetting, solutionPath, "IOSetting.xml", (MetaActionMap)MetaIOSettingActionMap.getInsance());
        MetaEnhance metaEnhance = new MetaEnhance();
        MetaObjectHelper.saveToXml((AbstractMetaObject)metaEnhance, solutionPath, "Enhance.xml", MetaEnhanceSave.class);
        MetaRightsDefinition metaRightsDefinition = new MetaRightsDefinition();
        MetaObjectHelper.saveToXml((AbstractMetaObject)metaRightsDefinition, solutionPath, "NoRights.xml", MetaRightsDefinitionSave.class);
        MetaCommonDef metaCommonDef = new MetaCommonDef();
        MetaObjectHelper.saveToXml((AbstractMetaObject)metaCommonDef, solutionPath, "CommonDef.xml", MetaCommonDefSave.class);
        MetaParaTable metaParaTable = new MetaParaTable();
        MetaObjectHelper.saveToXml((AbstractMetaObject)metaParaTable, solutionPath, "ParaTable.xml", MetaParaTableSave.class);
        MetaParaTable metaParaTable_Vest = new MetaParaTable();
        MetaObjectHelper.saveToXml((AbstractMetaObject)metaParaTable_Vest, solutionPath, "ParaTable_Vest.xml", MetaParaTableSave.class);
        File domainFoldFile = FileUtils.getFile((String[])new String[]{solutionPath, "Domain"});
        FileUtils.forceMkdir((File)domainFoldFile);
        File dataElementFoldFile = FileUtils.getFile((String[])new String[]{solutionPath, "DataElement"});
        FileUtils.forceMkdir((File)dataElementFoldFile);
        boolean isWrite = NewSolutionCmd.writeImportSolution(key, caption, solutionPath);
        ArrayList<UICommand> result = new ArrayList<UICommand>();
        if (isWrite) {
            IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
            DefaultMetaResolverFactory metaResolverFactory = new DefaultMetaResolverFactory(solutionPath);
            DefaultMetaFactory factory = new DefaultMetaFactory((IMetaResolverFactory)metaResolverFactory);
            LoadFileTree.loadImportSolution(globalInstance, workspacePath, solutionPath, (IMetaResolverFactory)metaResolverFactory, factory);
            result.add(UICommand.reloadFileTree(solutionPath));
            result.add(UICommand.showTip("\u89e3\u51b3\u65b9\u6848\u521b\u5efa\u6210\u529f"));
        } else {
            FileUtils.forceDelete((File)currentSolutionFile);
            result.add(UICommand.showError("\u64cd\u4f5c\u5931\u8d25\uff1a\u89e3\u51b3\u65b9\u6848\u91cd\u590d"));
        }
        return UICommand.toJson(result);
    }

    public static boolean writeImportSolution(String key, String caption, String solutionPath) throws Throwable {
        String designerImportSolutionsPath = WebDesignerConfiguration.getDesignerImportSolutionsPath();
        XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(designerImportSolutionsPath);
        XmlTree xmlTree = xmlTreeWithPath.xmlTree;
        boolean containKey = xmlTree.containKey("ImportSolution@" + key);
        if (!containKey) {
            TagNode tagNode = new TagNode("ImportSolution", null);
            tagNode.setAttribute("Key", key);
            tagNode.setAttribute("Caption", caption);
            tagNode.setAttribute("SolutionPath", solutionPath);
            xmlTree.getRoot().addNode(tagNode);
            String newXml = DesignIOMetaUtil.getXml(xmlTree.getRoot());
            File file = new File(designerImportSolutionsPath);
            FileUtils.writeStringToFile((File)file, (String)newXml, (String)"UTF-8");
        }
        return !containKey;
    }

    public String getCmd() {
        return CMD;
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new NewSolutionCmd();
    }
}

