/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.bokesoft.erp.metaobjectchange.MetaObjectChange;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.cmd.DesignerServiceCmd;
import com.bokesoft.yes.design.cmd.EntryProcessor;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.helper.MetaObjectHelper;
import com.bokesoft.yes.meta.persist.dom.form.MetaFormLoad;
import com.bokesoft.yes.meta.persist.dom.form.MetaFormSave;
import com.bokesoft.yes.meta.persist.dom.xml.XmlCreator;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaExtFormList;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaComponentFactory;
import com.bokesoft.yigo.meta.form.component.control.MetaButton;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaRowAction;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaRowActionCollection;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableRow;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableRowCollection;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableView;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRow;
import com.bokesoft.yigo.meta.form.component.panel.MetaFlexFlowLayoutPanel;
import com.bokesoft.yigo.meta.form.component.panel.MetaTabPanel;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaColumnDef;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaColumnDefCollection;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaGridLayoutPanel;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaRowDef;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaRowDefCollection;
import com.bokesoft.yigo.meta.intf.IMetaProject;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.io.File;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.json.JSONObject;
import org.w3c.dom.Document;

public class NewExtensionFormCmd
extends DesignerServiceCmd {
    public static final String CMD = "NewExtensionForm";
    public String projectKey;
    private String formKey;
    private String formCaption;
    private String directory;
    private String sourceFormKey;
    private DataTable fieldsTableInSourceForm;

    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        this.formKey = TypeConvertor.toString((Object)arguments.get((Object)"newFormKey")).trim();
        this.formCaption = TypeConvertor.toString((Object)arguments.get((Object)"formCaption")).trim();
        this.projectKey = TypeConvertor.toString((Object)arguments.get((Object)"projectKey")).trim();
        this.directory = TypeConvertor.toString((Object)arguments.get((Object)"directory")).trim();
        this.sourceFormKey = TypeConvertor.toString((Object)arguments.get((Object)"sourceFormKey")).trim();
        String tableJSON = TypeConvertor.toString((Object)arguments.get((Object)"fieldsTableInSourceForm")).trim();
        if (!tableJSON.isEmpty()) {
            this.fieldsTableInSourceForm = new DataTable();
            this.fieldsTableInSourceForm.fromJSON(new JSONObject(tableJSON));
        }
    }

    @Override
    protected Object innerDoCmd(DefaultContext defaultContext) throws Throwable {
        IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
        if (Objects.isNull(globalInstance.getExtFormList().get(this.formKey))) {
            String fileName = String.valueOf(this.formKey) + ".xml";
            String content = this.getNewFormContent();
            this.directory = this.directory.isEmpty() ? "Bill" : this.directory;
            String filePath = LoadFileTree.newFile(this.projectKey, 9, fileName, this.formKey, this.formCaption, this.directory, "1");
            String tmpFilePath = XmlFileProcessor.instance.saveTempFile(filePath, content, this.projectKey);
            File file = new File(filePath);
            FileUtils.writeStringToFile((File)file, (String)content, (String)"UTF-8");
            String resource = LoadFileTree.getResource(tmpFilePath, this.projectKey);
            ((MetaFormProfile)globalInstance.getExtFormList().get(this.formKey)).setResource(resource);
            EntryProcessor.instance.newForm(this.projectKey, 9, this.formKey, this.formCaption, "", true);
            globalInstance.getExtMetaForm(this.sourceFormKey, this.formKey);
            ArrayList<UICommand> result = new ArrayList<UICommand>();
            result.add(UICommand.reloadFileTree(filePath));
            result.add(UICommand.runFormKey(this.formKey));
            result.add(UICommand.reloadMenuTree());
            return UICommand.toJson(result);
        }
        return null;
    }

    private String getNewFormContent() throws Throwable {
        MetaForm module = MetaObjectHelper.deptClone(this.loadMetaForm("D_ExtensionModule"));
        IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
        MetaProject metaProject = globalInstance.getMetaProject(this.projectKey);
        module.setProject((IMetaProject)metaProject);
        MetaForm newMetaForm = MetaObjectHelper.deptClone(module);
        newMetaForm.setKey(this.formKey);
        newMetaForm.setCaption(this.formCaption);
        newMetaForm.setSourceForm(this.sourceFormKey);
        this.layoutFields(newMetaForm);
        MetaFormSave save = new MetaFormSave((AbstractMetaObject)newMetaForm);
        Document newDocument = save.getDocument();
        XmlCreator creator = new XmlCreator(newDocument, null);
        String xml = creator.createXml();
        MetaExtFormList metaFormList = globalInstance.getExtFormList();
        MetaFormProfile newFormProfile = MetaObjectHelper.deptClone((MetaFormProfile)metaFormList.get(module.getKey()));
        newMetaForm.setProject((IMetaProject)metaProject);
        newFormProfile.setProject((IMetaProject)metaProject);
        newFormProfile.setKey(this.formKey);
        newFormProfile.setCaption(this.formCaption);
        newFormProfile.setResource("");
        newFormProfile.setSourceForm(this.sourceFormKey);
        newFormProfile.setPlatform(newMetaForm.getPlatform());
        newFormProfile.setForm(newMetaForm);
        metaFormList.add((KeyPairMetaObject)newFormProfile);
        MetaObjectChange.fireChangeDesignMetaForm((MetaForm)newMetaForm, (String[])new String[0]);
        MetaForm erpNewMetaForm = globalInstance.getExtMetaForm(this.sourceFormKey, this.formKey);
        globalInstance.replaceMetaForm(this.formKey, erpNewMetaForm);
        return xml;
    }

    public MetaForm loadMetaForm(String formKey) throws Throwable {
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaFormProfile formProfile = (MetaFormProfile)metaFactory.getExtFormList().get(formKey);
        String resource = formProfile.getResource();
        String projectKey = formProfile.getProject().getKey();
        IMetaResolver resolver = metaFactory.getProjectResolver(projectKey);
        MetaFormLoad formLoad = new MetaFormLoad(2);
        formLoad.load(resolver, resource);
        MetaForm newMetaForm = (MetaForm)formLoad.getRootMetaObject();
        newMetaForm.setProject(formProfile.getProject());
        newMetaForm.setResource(resource);
        return newMetaForm;
    }

    /*
     * WARNING - void declaration
     */
    private void layoutFields(MetaForm metaForm) throws Throwable {
        MetaComponent rootPanel = ((MetaComponent)metaForm.getMetaBody().get(0)).getComponent(0);
        if (rootPanel instanceof MetaFlexFlowLayoutPanel) {
            void var9_10;
            MetaFlexFlowLayoutPanel metaRootPanel = (MetaFlexFlowLayoutPanel)rootPanel;
            MetaTabPanel metaTabPanel = new MetaTabPanel();
            metaTabPanel.setKey("MainTabPanel");
            metaTabPanel.setHeight(DefSize.parse((String)"100%"));
            metaRootPanel.addComponent((MetaComponent)metaTabPanel);
            MetaGridLayoutPanel baseTabItem = this.getBaseInfoPanel(this.fieldsTableInSourceForm.size());
            ArrayList<MetaButton> buttonList = new ArrayList<MetaButton>();
            ArrayList<MetaFlexFlowLayoutPanel> gridList = new ArrayList<MetaFlexFlowLayoutPanel>();
            int rowIndex = 0;
            int n = this.fieldsTableInSourceForm.size() - 1;
            while (var9_10 >= 0) {
                this.fieldsTableInSourceForm.setPos((int)var9_10);
                int selected = this.fieldsTableInSourceForm.getInt("IsSelected");
                if (selected == 1) {
                    String fieldType = this.fieldsTableInSourceForm.getString("FieldType");
                    if (fieldType.equals("Grid")) {
                        String fieldKey = this.fieldsTableInSourceForm.getString("FieldKey");
                        String fieldCaption = this.fieldsTableInSourceForm.getString("FieldCaption");
                        MetaFlexFlowLayoutPanel gridRootPanel = new MetaFlexFlowLayoutPanel();
                        gridRootPanel.setKey(String.valueOf(fieldKey) + "_RootPanel");
                        gridRootPanel.setCaption(fieldCaption);
                        MetaTableView metaTableView = this.getTableViewFromGrid(fieldKey, fieldCaption);
                        gridRootPanel.addComponent((MetaComponent)metaTableView);
                        gridList.add(gridRootPanel);
                    } else {
                        MetaComponent metaComponent = MetaComponentFactory.getInstance().newComponent(fieldType);
                        metaComponent.setKey(this.fieldsTableInSourceForm.getString("FieldKey"));
                        metaComponent.setCaption(this.fieldsTableInSourceForm.getString("FieldCaption"));
                        metaComponent.setCompStyle("innerLabel_m");
                        metaComponent.setCssClass("editcontrol");
                        if (fieldType.equals("Button")) {
                            buttonList.add((MetaButton)metaComponent);
                        } else {
                            metaComponent.setX(Integer.valueOf(1));
                            metaComponent.setY(Integer.valueOf(rowIndex));
                            baseTabItem.addComponent(metaComponent);
                            ++rowIndex;
                        }
                    }
                }
                --var9_10;
            }
            for (MetaButton metaButton : buttonList) {
                metaButton.setX(Integer.valueOf(1));
                metaButton.setY(Integer.valueOf(rowIndex));
                metaButton.setType(Integer.valueOf(0));
                baseTabItem.addComponent((MetaComponent)metaButton);
                ++rowIndex;
            }
            baseTabItem.getMetaRowDefCollection().remove(rowIndex + 1, baseTabItem.getMetaRowDefCollection().size() - 1);
            if (baseTabItem.getComponentCount() > 0) {
                metaTabPanel.addComponent((MetaComponent)baseTabItem);
            }
            for (MetaComponent metaComponent : gridList) {
                metaTabPanel.addComponent(metaComponent);
            }
        }
    }

    private MetaGridLayoutPanel getBaseInfoPanel(int size) {
        MetaGridLayoutPanel baseInfoPanel = new MetaGridLayoutPanel();
        baseInfoPanel.setKey("BaseInfo");
        baseInfoPanel.setCaption("\u8868\u5355\u4fe1\u606f");
        baseInfoPanel.setOverflowY(Integer.valueOf(1));
        MetaColumnDefCollection metaColumnDefCollection = new MetaColumnDefCollection();
        metaColumnDefCollection.setColumnGap(Integer.valueOf(5));
        MetaColumnDef metaColumnDef1 = new MetaColumnDef();
        metaColumnDef1.setWidth(DefSize.parse((String)"10px"));
        metaColumnDefCollection.add((AbstractMetaObject)metaColumnDef1);
        MetaColumnDef metaColumnDef2 = new MetaColumnDef();
        metaColumnDef2.setWidth(DefSize.parse((String)"100%"));
        metaColumnDefCollection.add((AbstractMetaObject)metaColumnDef2);
        MetaColumnDef metaColumnDef3 = new MetaColumnDef();
        metaColumnDef3.setWidth(DefSize.parse((String)"10px"));
        metaColumnDefCollection.add((AbstractMetaObject)metaColumnDef3);
        baseInfoPanel.setColumnDefCollection(metaColumnDefCollection);
        MetaRowDefCollection metaRowDefCollection = new MetaRowDefCollection();
        metaRowDefCollection.setRowGap(Integer.valueOf(5));
        metaRowDefCollection.setRowHeight(Integer.valueOf(30));
        int i = 0;
        while (i < size) {
            MetaRowDef metaRowDef = new MetaRowDef();
            metaRowDefCollection.add((AbstractMetaObject)metaRowDef);
            ++i;
        }
        baseInfoPanel.setRowDefCollection(metaRowDefCollection);
        return baseInfoPanel;
    }

    private MetaTableView getTableViewFromGrid(String fieldKey, String fieldCaption) throws Throwable {
        MetaTableView metaTableView = (MetaTableView)MetaComponentFactory.getInstance().newComponent("TableView");
        metaTableView.setKey(fieldKey);
        metaTableView.setCaption(fieldCaption);
        metaTableView.setHeight(DefSize.parse((String)"100%"));
        MetaTableRowCollection metaTableRowCollection = new MetaTableRowCollection();
        MetaTableRow metaTableRow = new MetaTableRow();
        metaTableRow.setRowType(Integer.valueOf(2));
        metaTableRow.setKey(String.valueOf(fieldKey) + "_DetailRow");
        metaTableRow.setCaption(fieldCaption);
        MetaBaseScript rowClick = new MetaBaseScript("RowClick");
        rowClick.setContent("EditRowPop('" + fieldKey + "', -1)");
        metaTableRow.setRowClick(rowClick);
        MetaRowActionCollection metaRowActions = new MetaRowActionCollection();
        MetaRowAction metaRowAction = new MetaRowAction();
        metaRowAction.setKey("DeleteRow");
        metaRowAction.setCaption("\u5220\u9664");
        metaRowAction.setContent("DeleteRow('" + fieldKey + "', -1)");
        metaRowActions.add((KeyPairMetaObject)metaRowAction);
        metaTableRow.setActionCollection(metaRowActions);
        MetaGridLayoutPanel gridLayout = new MetaGridLayoutPanel();
        gridLayout.setKey(String.valueOf(metaTableRow.getKey()) + "_RootPanel");
        MetaRowDefCollection metaRowDefCollection = new MetaRowDefCollection();
        metaRowDefCollection.setRowGap(Integer.valueOf(5));
        metaRowDefCollection.setRowHeight(Integer.valueOf(32));
        MetaRowDef metaRowDef1 = new MetaRowDef();
        metaRowDefCollection.add((AbstractMetaObject)metaRowDef1);
        gridLayout.setRowDefCollection(metaRowDefCollection);
        MetaColumnDefCollection metaColumnDefCollection = new MetaColumnDefCollection();
        metaColumnDefCollection.setColumnGap(Integer.valueOf(5));
        MetaColumnDef metaColumnDef1 = new MetaColumnDef();
        metaColumnDef1.setWidth(DefSize.parse((String)"10px"));
        metaColumnDefCollection.add((AbstractMetaObject)metaColumnDef1);
        MetaColumnDef metaColumnDef2 = new MetaColumnDef();
        metaColumnDef2.setWidth(DefSize.parse((String)"100%"));
        metaColumnDefCollection.add((AbstractMetaObject)metaColumnDef2);
        MetaColumnDef metaColumnDef3 = new MetaColumnDef();
        metaColumnDef3.setWidth(DefSize.parse((String)"10px"));
        metaColumnDefCollection.add((AbstractMetaObject)metaColumnDef3);
        gridLayout.setColumnDefCollection(metaColumnDefCollection);
        this.addGridCells(gridLayout, fieldKey);
        metaTableRow.setRoot((MetaComponent)gridLayout);
        metaTableRowCollection.add((AbstractMetaObject)metaTableRow);
        metaTableView.setRows(metaTableRowCollection);
        return metaTableView;
    }

    private void addGridCells(MetaGridLayoutPanel gridLayout, String gridKey) throws Throwable {
        MetaForm sourceForm = MetaFactory.getGlobalInstance().getMetaForm(this.sourceFormKey);
        AbstractMetaObject metaObject = (AbstractMetaObject)sourceForm.getAllUIComponents().get(gridKey);
        if (metaObject.getTagName().equals("Grid")) {
            MetaGrid metaGrid = (MetaGrid)metaObject;
            if (metaGrid.getRowCollection().isEmpty()) {
                return;
            }
            MetaGridRow metaGridRow = (MetaGridRow)metaGrid.getRowCollection().get(0);
            int cellCount = 0;
            int i = 0;
            while (i < metaGridRow.size()) {
                MetaGridCell metaGridCell = (MetaGridCell)metaGridRow.get(i);
                if (metaGridCell.isRequired().booleanValue()) {
                    MetaRowDef metaRowDef = new MetaRowDef();
                    gridLayout.getMetaRowDefCollection().add((AbstractMetaObject)metaRowDef);
                    String cellTagName = ControlType.toString((Integer)metaGridCell.getCellType());
                    MetaComponent metaCell = MetaComponentFactory.getInstance().newComponent(cellTagName);
                    metaCell.setKey(metaGridCell.getKey());
                    metaCell.setCaption(metaGridCell.getCaption());
                    metaCell.setX(Integer.valueOf(1));
                    metaCell.setY(Integer.valueOf(cellCount));
                    metaCell.setCssClass("innerLabel-show");
                    gridLayout.addComponent(metaCell);
                    ++cellCount;
                }
                ++i;
            }
        }
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new NewExtensionFormCmd();
    }

    public String getCmd() {
        return CMD;
    }
}

