/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.cmd.DesignerServiceCmd;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.helper.DataObjectHelper;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectList;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectProfile;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.io.File;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;

public class NewDataObjectCmd
extends DesignerServiceCmd {
    public static final String CMD = "NewDataObject";
    private StringHashMap<Object> arguments;

    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        this.arguments = new StringHashMap();
        this.arguments.putAll(arguments);
    }

    @Override
    public Object innerDoCmd(DefaultContext defaultContext) {
        try {
            String key = TypeConvertor.toString((Object)this.arguments.get((Object)"key"));
            String projectKey = TypeConvertor.toString((Object)this.arguments.get((Object)"projectKey"));
            String caption = TypeConvertor.toString((Object)this.arguments.get((Object)"caption"));
            String extend = TypeConvertor.toString((Object)this.arguments.get((Object)"extend"));
            IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
            MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
            if (dataObjectList.containsKey(key)) {
                throw new RuntimeException("\u65b0\u589e\u6570\u636e\u5bf9\u8c61\u5931\u8d25!key\u5b58\u5728");
            }
            MetaDataObjectProfile profile = DataObjectHelper.createOutsideProfile(key, caption, projectKey, extend);
            String filePath = LoadFileTree.NewDataObjectFilePath(projectKey, key, caption);
            String fileContent = DataObjectHelper.createXml(profile.getDataObject());
            XmlFileProcessor.instance.saveTempFile(filePath, fileContent, projectKey);
            FileUtils.writeStringToFile((File)new File(filePath), (String)fileContent, (String)"UTF-8");
            dataObjectList.add((KeyPairMetaObject)profile);
            LoadFileTree.loadFileTree();
            ArrayList<UICommand> uiCommands = new ArrayList<UICommand>();
            uiCommands.add(UICommand.reloadFileTree(filePath));
            uiCommands.add(UICommand.reloadMenuTree());
            JSONObject result = new JSONObject();
            result.put("code", (Object)0);
            result.put("msg", (Object)"\u65b0\u589e\u6570\u636e\u5bf9\u8c61\u6210\u529f");
            result.put("uICommands", (Object)UICommand.toJson(uiCommands));
            return result;
        }
        catch (Throwable e) {
            LogSvr.getInstance().error("\n", e);
            JSONObject result = new JSONObject();
            result.put("code", (Object)1);
            result.put("msg", (Object)"\u65b0\u589e\u6570\u636e\u5bf9\u8c61\u5931\u8d25!key\u5b58\u5728");
            return result;
        }
    }

    public String getCmd() {
        return CMD;
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new NewDataObjectCmd();
    }
}

