/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.bokesoft.erp.performance.trace.SessionUICommands;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.MetaObjectType;
import com.bokesoft.yes.design.cmd.CommitDiffCmd;
import com.bokesoft.yes.design.cmd.DesignerServiceCmd;
import com.bokesoft.yes.design.cmd.MetaFormDiffProcessor;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.cmd.UIFormDiffProcessor;
import com.bokesoft.yes.design.cmd.WebBuilderDiffProcessor;
import com.bokesoft.yes.design.cmd.XmlDiffProcessor;
import com.bokesoft.yes.design.cmd.XmlDiffToPropertyDiff;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.helper.DocumentHelper;
import com.bokesoft.yes.log.LogSvr;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.cmd.richdocument.strut.DocumentRecordDirty;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.IServiceContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

public class NewCompositeComponentCmd
extends DesignerServiceCmd {
    public static final String CMD = "newCompositeComponent";
    private String tableKey;
    private String metaObjectType;
    private Integer x;
    private Integer y;
    private String parentKey;
    private String formKey;
    private Document designerDocument;
    private DocumentRecordDirty formDocument;
    private String reserveTwo;
    private String reserveFour;
    private String sideKey;
    private Boolean insertAfter;
    private String entryParas;
    private static String showXmlError = "";

    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        String docStr;
        this.tableKey = (String)arguments.get((Object)"tableKey");
        if (StringUtils.isNotEmpty((CharSequence)((String)arguments.get((Object)"x")))) {
            this.x = Integer.parseInt((String)arguments.get((Object)"x"));
        }
        if (StringUtils.isNotEmpty((CharSequence)((String)arguments.get((Object)"y")))) {
            this.y = Integer.parseInt((String)arguments.get((Object)"y"));
        }
        this.parentKey = (String)arguments.get((Object)"parentKey");
        this.formKey = (String)arguments.get((Object)"formKey");
        this.metaObjectType = (String)arguments.get((Object)"metaObjectType");
        this.entryParas = (String)arguments.get((Object)"entryParas");
        this.reserveTwo = (String)arguments.get((Object)"reserveTwo");
        this.reserveFour = (String)arguments.get((Object)"reserveFour");
        this.sideKey = (String)arguments.get((Object)"sideKey");
        this.insertAfter = Boolean.parseBoolean((String)arguments.get((Object)"insertAfter"));
        if (arguments.containsKey((Object)"designerDocument")) {
            docStr = (String)arguments.get((Object)"designerDocument");
            this.designerDocument = DocumentHelper.parseDocumentFormJSON(docStr);
        }
        if (arguments.containsKey((Object)"formDocument")) {
            docStr = (String)arguments.get((Object)"formDocument");
            String documentFormKey = (String)arguments.get((Object)"documentFormKey");
            MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(documentFormKey);
            this.formDocument = new DocumentRecordDirty(metaForm, false);
            try {
                this.formDocument.fromJSON(new JSONObject(docStr));
            }
            catch (Exception e) {
                LogSvr.getInstance().error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public Object innerDoCmd(DefaultContext context) throws Throwable {
        MetaForm metaForm;
        String prjKey;
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        List<UICommand> uiCommands = new ArrayList<UICommand>();
        MetaFormProfile tmpProfile = (MetaFormProfile)metaFactory.getMetaFormList().get(this.formKey);
        if (tmpProfile == null) {
            tmpProfile = (MetaFormProfile)metaFactory.getExtFormList().get(this.formKey);
        }
        if (LoadFileTree.isJarProjectKey(prjKey = tmpProfile.getProject().getKey())) {
            uiCommands.add(UICommand.showTip("Jar\u5305\u4e2d\u7684\u8868\u5355\u65e0\u6cd5\u4fee\u6539 (" + NewCompositeComponentCmd.class.getSimpleName() + ")"));
            return UICommand.toJson(uiCommands);
        }
        List<Diff> diffs = this.getDiffs();
        if (diffs.size() < 1) {
            return uiCommands;
        }
        uiCommands = this.commitDiff(context, this.formKey, this.entryParas, diffs, this.designerDocument, this.formDocument);
        List sessionUICommands = SessionUICommands.getUICommands((IServiceContext)context);
        if (sessionUICommands != null) {
            for (com.bokesoft.yes.mid.cmd.richdocument.strut.UICommand runUICommand : sessionUICommands) {
                UICommand uiCommand = new UICommand(runUICommand.key, runUICommand.content);
                uiCommands.add(uiCommand);
            }
            sessionUICommands.clear();
        }
        if (StringUtils.isNotBlank((CharSequence)(metaForm = metaFactory.getMetaForm(this.formKey)).getExtend())) {
            uiCommands.add(UICommand.reloadFormKey(this.formKey));
            uiCommands.add(UICommand.reloadFormKey(metaForm.getExtend()));
        } else {
            MetaFormList metaFormList = metaFactory.getMetaFormList();
            for (MetaFormProfile metaFormProfile : metaFormList) {
                String extend = metaFormProfile.getExtend();
                if (!StringUtils.equals((CharSequence)extend, (CharSequence)this.formKey)) continue;
                uiCommands.add(UICommand.reloadFormKey(metaFormProfile.getKey()));
            }
        }
        boolean hasPreOpt = false;
        if (!hasPreOpt) {
            uiCommands = uiCommands.stream().distinct().collect(Collectors.toList());
            return UICommand.toJson(uiCommands);
        }
        String filePath = LoadFileTree.getPathByFormKey(this.formKey);
        if (XmlFileProcessor.filePathToTmpFileMap.containsKey(filePath)) {
            Stack<String> stack = XmlFileProcessor.filePathToTmpFileMap.get(filePath);
            String curTmpFile = stack.pop();
            stack.pop();
            stack.push(curTmpFile);
        }
        uiCommands = uiCommands.stream().distinct().collect(Collectors.toList());
        return UICommand.toJson(uiCommands);
    }

    private List<Diff> getDiffs() throws Throwable {
        ArrayList<Diff> diffs = new ArrayList<Diff>();
        DataTable dataTable = this.designerDocument.get("ComponentDtl");
        ArrayList fieldKeyList = new ArrayList();
        int i = 0;
        while (i < dataTable.size()) {
            Integer selectField = this.designerDocument.get("ComponentDtl").getInt(i, "SelectField");
            if (selectField >= 1) {
                String itemKey;
                Diff diff = new Diff("d" + System.currentTimeMillis(), this.formKey, true);
                String key = dataTable.getString(i, "ComponentKey");
                MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(this.formKey);
                metaForm.getAllUIComponents().keySet().forEach(fieldKey -> {
                    if (StringUtils.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)key)) {
                        fieldKeyList.add(key);
                    }
                });
                String columnKey = dataTable.getString(i, "ColumnKey");
                String caption = dataTable.getString(i, "ComponentCaption");
                String controlType = dataTable.getString(i, "ControlType");
                diff.setIsButtonQuote(false);
                diff.setCreate("false");
                diff.setEmbed(false);
                diff.setKey(key);
                diff.setDictType(null);
                diff.setContainerKey(null);
                if ("Field".equals(this.metaObjectType)) {
                    if ("DynamicDict".equals(controlType)) {
                        itemKey = dataTable.getString(i, "ItemKey");
                        diff.setReserveOne(itemKey);
                    }
                } else if ("GridField".equals(this.metaObjectType)) {
                    diff.setReserveOne(key);
                }
                diff.setReserveTwo(this.reserveTwo);
                diff.setTrueOrfalse(true);
                diff.setReserveThree(columnKey);
                diff.setReserveFour(this.reserveFour);
                if ("Dict".equals(controlType)) {
                    itemKey = dataTable.getString(i, "ItemKey");
                    diff.setItemKey(itemKey);
                }
                diff.setParamsformKey(this.formKey);
                diff.parentKey = this.parentKey.trim();
                String sObjectType = StringUtils.isBlank((CharSequence)this.metaObjectType) ? null : this.metaObjectType;
                diff.setMetaObjectType(StringUtils.isBlank((CharSequence)this.metaObjectType) ? null : MetaObjectType.getMetaObjectType(this.metaObjectType));
                boolean isNewComponent = StringUtils.isNotEmpty((CharSequence)caption);
                if (isNewComponent) {
                    diff.caption = caption;
                    diff.sideKey = this.sideKey;
                    diff.x = this.x;
                    diff.y = this.y;
                    if (sObjectType.equals(MetaObjectType.gridField.name) || sObjectType.equals(MetaObjectType.GridFieldRow.name) || sObjectType.equalsIgnoreCase(MetaObjectType.ListViewColumn.name)) {
                        diff.insertAfter = this.insertAfter;
                    }
                }
                diff.isDelete = false;
                diff.isMultyDelete = false;
                diff.isMultyMove = false;
                diff.controlType = ControlType.parse((String)controlType);
                if (diff.controlType == -1 && this.metaObjectType.equals(MetaObjectType.GridFieldRow.name) && StringUtils.isNotEmpty((CharSequence)controlType)) {
                    diff.controlType = Integer.parseInt(controlType);
                }
                diff.tableKey = this.tableKey;
                if (!"".equals(diff.tableKey) && diff.tableKey != null) {
                    diff.associatedTable = diff.tableKey;
                }
                diff.x = this.x;
                diff.y = this.y;
                diffs.add(diff);
            }
            ++i;
        }
        if (fieldKeyList.size() > 0) {
            throw new Throwable("\u7ec4\u4ef6\u6807\u8bc6 " + fieldKeyList.toString() + "\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539");
        }
        return diffs;
    }

    public List<UICommand> commitDiff(DefaultContext context, String formKey, String entryParas, List<Diff> diffs, Document designerDocument, DocumentRecordDirty formDocument) throws Throwable {
        CommitDiffCmd.loadXmlTrees(diffs, entryParas, null);
        int anInt = XmlDiffProcessor.instance.processDiff(diffs, designerDocument);
        boolean genPropertyDiffSuccess = XmlDiffToPropertyDiff.instance.processDiff(diffs);
        Map<String, String> tmpFiles = XmlFileProcessor.instance.processDiff(diffs, true);
        ArrayList<UICommand> uiCommands = new ArrayList<UICommand>();
        String XmlError = MetaFormDiffProcessor.instance.processDiff(context, diffs, genPropertyDiffSuccess, formDocument, tmpFiles);
        showXmlError = String.valueOf(showXmlError) + XmlError;
        if (genPropertyDiffSuccess) {
            WebBuilderDiffProcessor.instance.processDiff(context, diffs, uiCommands);
        }
        UIFormDiffProcessor.instance.processDiff(diffs, uiCommands, genPropertyDiffSuccess, XmlError, anInt);
        NewCompositeComponentCmd.processDocumentDirty(diffs, formKey, uiCommands, formDocument, context);
        NewCompositeComponentCmd.updateDiffFilePath(uiCommands);
        return uiCommands;
    }

    private static void processDocumentDirty(List<Diff> diffs, String Key, List<UICommand> uiCommands, DocumentRecordDirty formDocument, DefaultContext context) throws Throwable {
        if (Objects.isNull(formDocument)) {
            return;
        }
        String formKey = formDocument.getMetaForm().getKey();
        if (!StringUtils.equals((CharSequence)diffs.get(0).getParamsformKey(), (CharSequence)formKey)) {
            return;
        }
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaFormProfile metaFormProfile = (MetaFormProfile)metaFactory.getMetaFormList().get(Key);
        String extend = metaFormProfile.getExtend();
        if (StringUtils.isNotBlank((CharSequence)extend) && !metaFormProfile.getMergeToSource().booleanValue()) {
            return;
        }
        if (metaFormProfile.getForm().getFormType() == 3) {
            return;
        }
        RichDocumentContext richDocumentContext = NewCompositeComponentCmd.processParentContext(context, formDocument);
        formDocument.setContext(richDocumentContext);
        try {
            formDocument.setMetaForm(metaFormProfile.getForm());
            JSONObject documentDirty = formDocument.getDirtyJSON(richDocumentContext);
            uiCommands.add(UICommand.processDocumentDirty(formKey, documentDirty));
        }
        catch (Throwable e) {
            LogSvr.getInstance().error("", e);
        }
    }

    private static RichDocumentContext processParentContext(DefaultContext context, DocumentRecordDirty formDocument) throws Throwable {
        context.setFormKey(formDocument.getMetaForm().getKey());
        context.setDocument((Document)formDocument);
        RichDocumentContext parentContext = (RichDocumentContext)context.getParentContext();
        if (Objects.isNull(parentContext)) {
            parentContext = new RichDocumentContext(context);
            parentContext.setDocument((Document)formDocument);
            context.setParentContext((DefaultContext)parentContext);
        }
        return parentContext;
    }

    private static void updateDiffFilePath(List<UICommand> uiCommands) {
        HashMap<String, String> diffSequenceToFilePath = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((CharSequence)showXmlError)) {
            uiCommands.add(UICommand.showTip(showXmlError));
            showXmlError = "";
        }
        if (diffSequenceToFilePath.size() > 0) {
            if (UIFormDiffProcessor.Error != null) {
                return;
            }
            uiCommands.add(UICommand.updateDiffFilePath(diffSequenceToFilePath));
        }
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new NewCompositeComponentCmd();
    }

    public String getCmd() {
        return CMD;
    }
}

