/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.cmd.DesignerServiceCmd;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.io.File;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class LoadSearchFilesContentCmd
extends DesignerServiceCmd {
    public static final String CMD = "LoadSearchFilesContent";

    public void dealArguments(DefaultContext arg0, StringHashMap<Object> arg1) throws Throwable {
    }

    @Override
    public Object innerDoCmd(DefaultContext arg0) throws Throwable {
        List<String> solutionsPath = LoadFileTree.getAllSolutionsPath();
        JSONArray result = new JSONArray();
        for (String solutionPath : solutionsPath) {
            File solutionDir = new File(solutionPath);
            this.processDir(solutionDir, result);
        }
        return result;
    }

    private void processDir(File dir, JSONArray result) throws Throwable {
        if (dir != null && dir.isDirectory()) {
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.isDirectory()) {
                    this.processDir(child, result);
                } else if (child.getName().endsWith(".xml")) {
                    JSONObject r = new JSONObject();
                    r.put("key", (Object)child.getAbsolutePath());
                    r.put("value", (Object)FileUtils.readFileToString((File)child, (String)"UTF-8"));
                    result.put((Object)r);
                }
                ++n2;
            }
        }
    }

    public String getCmd() {
        return CMD;
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new LoadSearchFilesContentCmd();
    }
}

