/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.bokesoft.erp.WebDesignerConfiguration;
import com.bokesoft.erp.register.ErpConfig;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.cmd.DesignerServiceCmd;
import com.bokesoft.yes.design.cmd.NewSolutionCmd;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.design.xml.node.XmlTree;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.datamap.MetaDataMapProfile;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationProfile;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectList;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectProfile;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelTemplateSubList;
import com.bokesoft.yigo.meta.factory.DefaultMetaFactory;
import com.bokesoft.yigo.meta.factory.DefaultMetaResolverFactory;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.IMetaResolverFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.report.MetaReportSubList;
import com.bokesoft.yigo.meta.solution.MetaSolution;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.FileUtils;

public class ImportSolutionCmd
extends DesignerServiceCmd {
    public static final String CMD = "ImportSolution";
    String newSolutionPath = "";
    String deleteSolutionPath = "";
    boolean isNew;

    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        this.newSolutionPath = FilePathHelper.toBackFilePath((String)arguments.get((Object)"newSolutionPath"));
        this.deleteSolutionPath = (String)arguments.get((Object)"deleteSolutionPath");
        this.isNew = Boolean.parseBoolean((String)arguments.get((Object)"isNew"));
    }

    @Override
    public Object innerDoCmd(DefaultContext context) throws Throwable {
        ArrayList<UICommand> result;
        block10: {
            result = new ArrayList<UICommand>();
            String workspacePath = FilePathHelper.getWorkspacePath();
            try {
                try {
                    if (this.isNew) {
                        String caption;
                        DefaultMetaResolverFactory metaResolverFactory = new DefaultMetaResolverFactory(this.newSolutionPath);
                        DefaultMetaFactory factory = new DefaultMetaFactory((IMetaResolverFactory)metaResolverFactory);
                        String key = factory.getSolution().getKey();
                        boolean isWrite = NewSolutionCmd.writeImportSolution(key, caption = factory.getSolution().getCaption(), this.newSolutionPath);
                        if (isWrite) {
                            LoadFileTree.loadImportSolution(MetaFactory.getGlobalInstance(), workspacePath, this.newSolutionPath, (IMetaResolverFactory)metaResolverFactory, factory);
                            ErpConfig.initExtendConfig();
                            String parent = String.valueOf(new File(workspacePath).getParent()) + File.separator + "solutionsImport";
                            result.add(UICommand.reloadFileTree(parent));
                            result.add(UICommand.reloadFileTree(this.newSolutionPath));
                            result.add(UICommand.showTip("\u89e3\u51b3\u65b9\u6848\u5bfc\u5165\u6210\u529f"));
                        } else {
                            result.add(UICommand.showError("\u64cd\u4f5c\u5931\u8d25\uff1a\u89e3\u51b3\u65b9\u6848\u5bfc\u5165\u91cd\u590d"));
                        }
                        break block10;
                    }
                    DefaultMetaFactory factory = LoadFileTree.metaDesignerFactoryMap.get(this.deleteSolutionPath);
                    MetaSolution solution = factory.getSolution();
                    String key = solution.getKey();
                    ImportSolutionCmd.deleteImportSolution(key, result, workspacePath, factory);
                    LoadFileTree.metaDesignerFactoryMap.remove(this.deleteSolutionPath);
                    LoadFileTree.loadImportSolutions.remove(this.deleteSolutionPath);
                    LoadFileTree.removeFilePath(this.deleteSolutionPath);
                    Collection metaSolutions = MetaFactory.getGlobalInstance().getMetaSolutions();
                    for (MetaSolution metaSolution : metaSolutions) {
                        if (!metaSolution.getKey().equals(key)) continue;
                        metaSolutions.remove(metaSolution);
                        break;
                    }
                    MetaFormList metaFormList = factory.getMetaFormList();
                    MetaDataObjectList dataObjectList = MetaFactory.getGlobalInstance().getDataObjectList();
                    for (MetaFormProfile metaFormProfile : metaFormList) {
                        MetaDataObjectProfile metaDataObjectProfile = (MetaDataObjectProfile)dataObjectList.get(metaFormProfile.getKey());
                        if (Objects.isNull(metaDataObjectProfile)) continue;
                        dataObjectList.remove(metaFormProfile.getKey());
                    }
                    LoadFileTree.clear();
                }
                catch (Exception e) {
                    if (e.getMessage() == null) {
                        result.add(UICommand.showError("\u5bfc\u5165\u7684\u89e3\u51b3\u65b9\u6848\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5\uff01"));
                        break block10;
                    }
                    result.add(UICommand.showError(e.getMessage()));
                }
            }
            catch (Throwable throwable) {}
        }
        return UICommand.toJson(result);
    }

    public String getCmd() {
        return CMD;
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new ImportSolutionCmd();
    }

    public static void deleteImportSolution(String key, List<UICommand> result, String solutionPath, DefaultMetaFactory factory) throws Throwable {
        String designerImportSolutionsPath = WebDesignerConfiguration.getDesignerImportSolutionsPath();
        XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(designerImportSolutionsPath);
        XmlTree xmlTree = xmlTreeWithPath.xmlTree;
        String tagNodeKey = "ImportSolution@" + key;
        boolean containKey = xmlTree.containKey(tagNodeKey);
        if (containKey) {
            TagNode root = xmlTree.getRoot();
            root.deleteChildByTagKey(key);
            String newXml = DesignIOMetaUtil.getXml(root);
            IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
            for (MetaFormProfile metaFormProfile : factory.getMetaFormList()) {
                globalInstance.getMetaFormList().remove(metaFormProfile.getKey());
            }
            for (MetaDataObjectProfile metaDataObjectProfile : factory.getDataObjectList()) {
                globalInstance.getDataObjectList().remove(metaDataObjectProfile.getKey());
            }
            for (KeyPairMetaObject keyPairMetaObject : factory.getCustomList()) {
                globalInstance.getCustomList().remove(keyPairMetaObject);
            }
            for (MetaDataMigrationProfile metaDataMigrationProfile : factory.getDataMigrationList()) {
                globalInstance.getDataMigrationList().remove(metaDataMigrationProfile.getKey());
            }
            for (MetaDataMapProfile metaDataMapProfile : factory.getDataMapList()) {
                globalInstance.getDataMapList().remove(metaDataMapProfile.getKey());
            }
            for (MetaReportSubList metaReportProfiles : factory.getMetaReportList()) {
                globalInstance.getMetaReportList().remove(metaReportProfiles.getKey());
            }
            for (MetaExcelTemplateSubList metaExcelTemplateProfiles : factory.getMetaExcelTemplateList()) {
                globalInstance.getMetaExcelTemplateList().remove(metaExcelTemplateProfiles.getKey());
            }
            for (MetaFormProfile metaFormProfile : factory.getExtFormList()) {
                globalInstance.getExtFormList().remove(metaFormProfile.getKey());
            }
            File file = new File(designerImportSolutionsPath);
            FileUtils.writeStringToFile((File)file, (String)newXml, (String)"UTF-8");
            result.add(UICommand.reloadFileTree(solutionPath));
            result.add(UICommand.showTip("\u89e3\u51b3\u65b9\u6848\u5220\u9664\u6210\u529f"));
        }
    }
}

