/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.datamap.util.DataMapOperXmlUtil;
import com.bokesoft.yes.design.function.DesignActionUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.ProjectMetaResolverUtils;
import com.bokesoft.yes.design.utils.XMLWriter;
import com.bokesoft.yes.design.vo.RecycleForm;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.meta.persist.dom.entry.MetaEntryLoad;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.entry.MetaEntry;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.solution.MetaProjectProfile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;

public class EntryProcessor {
    public static final EntryProcessor instance = new EntryProcessor();
    public static final String STR_DefaultProjectKey = "config_basis";

    private File getEntryPath(String projectKey) throws Throwable {
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        String caption = metaFactory.getMetaProject(projectKey).getCaption();
        String entryPath = metaFactory.getProjectResolver(projectKey).getPath("Entry.xml");
        File file = new File(entryPath);
        if (!file.exists()) {
            String newContent = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<Entry Caption=\"\u6839\" Key=\"root\">\n    <Entry Caption=\"" + caption + "\u81ea\u5b9a\u4e49\u8868\u5355\" Icon=\"Bill.png\" Key=\"" + projectKey + "CustomBill" + "\">\n" + "    </Entry>\n" + "</Entry>";
            FileUtils.writeStringToFile((File)new File(entryPath), (String)newContent, (String)"UTF-8");
        }
        return new File(entryPath);
    }

    public void reloadEntry(String projectKey) throws Throwable {
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaEntry metaEntry = this.getMetaEntry(projectKey, metaFactory);
        MetaProjectProfile metaProjectProfile = (MetaProjectProfile)metaFactory.getSolution().getProjectCollection().get(projectKey);
        metaProjectProfile.setEntry(metaEntry);
    }

    private MetaEntry getMetaEntry(String projectKey, IMetaFactory metaFactory) throws Exception {
        IMetaResolver projectMetaResolver = metaFactory.getProjectResolver(projectKey);
        MetaEntryLoad entryLoad = new MetaEntryLoad(1);
        entryLoad.load(projectMetaResolver, "Entry.xml");
        MetaEntry metaEntry = (MetaEntry)entryLoad.getRootMetaObject();
        return metaEntry;
    }

    private void addCustomEntry(String source, Document document, int formType, String key, String caption) throws Throwable {
        Element node = null;
        int endIndex = source.lastIndexOf("/");
        String[] split = source.split("/");
        String sourceCaption = source.substring(endIndex + 1);
        int in = split.length - 1;
        if (in == -1 || in == 1) {
            node = document.getRootElement();
        }
        if (Objects.isNull(node)) {
            return;
        }
        if (formType == 2 || formType == 6 || formType == 7) {
            String path = LoadFileTree.getPathByFormKey(key);
            XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(path);
            TagNode dictView = xmlTreeWithPath.xmlTree.getRoot().findFirstTagNodeByTagName("DictView");
            if (Objects.isNull(dictView)) {
                node.addElement("Entry").addAttribute("Caption", sourceCaption).addAttribute("Key", "entry_" + key).addElement("EntryItem").addAttribute("Caption", caption).addAttribute("Key", "sub_" + key).addAttribute("Type", "Form").addAttribute("FormKey", "DictEdit").addAttribute("Parameters", "FormKey=" + key + ";");
            } else {
                node.addElement("Entry").addAttribute("Caption", sourceCaption).addAttribute("Key", "entry_" + key).addElement("EntryItem").addAttribute("Caption", caption).addAttribute("Key", "sub_" + key).addAttribute("Type", "Form").addAttribute("FormKey", key);
            }
        } else {
            node.addElement("Entry").addAttribute("Caption", sourceCaption).addAttribute("Key", "entry_" + key).addElement("EntryItem").addAttribute("Caption", caption).addAttribute("Key", "sub_" + key).addAttribute("Type", "Form").addAttribute("FormKey", key);
        }
    }

    public void newForm(String projectKey, int formType, String key, String caption, String source, boolean isNew) throws Throwable {
        SAXReader reader = new SAXReader();
        File entryPath = null;
        if (StringUtils.isNotEmpty((CharSequence)source)) {
            if (formType == -1 || formType == 8) {
                return;
            }
            String entryProject = null;
            Boolean flag = true;
            IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
            Document document = null;
            for (String pKey : metaFactory.getProjectKeys()) {
                String entryXml = ProjectMetaResolverUtils.readProjectFile(pKey, "Entry.xml");
                if (!StringUtils.isNotBlank((CharSequence)entryXml) || !StringUtils.isNotEmpty((CharSequence)source)) continue;
                document = reader.read((Reader)new StringReader(entryXml));
                Element node = (Element)document.getRootElement().selectSingleNode(source.substring(1));
                if (node != null) {
                    if (formType == 2 || formType == 6 || formType == 7) {
                        String path = LoadFileTree.getPathByFormKey(key);
                        XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(path);
                        TagNode dictView = xmlTreeWithPath.xmlTree.getRoot().findFirstTagNodeByTagName("DictView");
                        if (Objects.isNull(dictView)) {
                            node.addElement("EntryItem").addAttribute("Caption", caption).addAttribute("Key", "sub_" + key).addAttribute("Type", "Form").addAttribute("FormKey", "DictEdit").addAttribute("Parameters", "FormKey=" + key + ";");
                        } else {
                            node.addElement("EntryItem").addAttribute("Caption", caption).addAttribute("Key", "sub_" + key).addAttribute("Type", "Form").addAttribute("FormKey", key);
                        }
                    } else {
                        node.addElement("EntryItem").addAttribute("Caption", caption).addAttribute("Key", "sub_" + key).addAttribute("Type", "Form").addAttribute("FormKey", key);
                    }
                    entryProject = pKey;
                    flag = false;
                    break;
                }
                if (!StringUtils.contains((CharSequence)source, (CharSequence)"/")) {
                    source = "/" + source;
                }
                int endIndex = source.lastIndexOf("/");
                String[] split = source.split("/");
                String sourceCaption = source.substring(endIndex + 1);
                int in = split.length - 1;
                if (in != -1 && in != 1) {
                    String entry = source.substring(0, endIndex);
                    AtomicReference<String> single = new AtomicReference<String>("");
                    LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                    MetaEntry metaEntry = MetaFactory.getGlobalInstance().getMetaEntry(pKey);
                    String pEntryKey = "";
                    String pEntryCaption = "";
                    if (metaEntry != null) {
                        DesignActionUtil.getEntryItems(linkedHashMap, metaEntry, pEntryKey, pEntryCaption);
                    }
                    linkedHashMap.forEach((key1, entrys) -> {
                        if (entry.equalsIgnoreCase((String)entrys)) {
                            single.set((String)key1);
                            return;
                        }
                    });
                    String cs = single.get();
                    if (!StringUtils.isNotEmpty((CharSequence)cs)) continue;
                    node = (Element)document.getRootElement().selectSingleNode(cs.replaceAll("\\+", "=").substring(1));
                }
                if (Objects.isNull(node)) continue;
                if (formType == 2 || formType == 6 || formType == 7) {
                    String path = LoadFileTree.getPathByFormKey(key);
                    XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(path);
                    TagNode dictView = xmlTreeWithPath.xmlTree.getRoot().findFirstTagNodeByTagName("DictView");
                    if (Objects.isNull(dictView)) {
                        node.addElement("Entry").addAttribute("Caption", sourceCaption).addAttribute("Key", "entry_" + key).addElement("EntryItem").addAttribute("Caption", caption).addAttribute("Key", "sub_" + key).addAttribute("Type", "Form").addAttribute("FormKey", "DictEdit").addAttribute("Parameters", "FormKey=" + key + ";");
                    } else {
                        node.addElement("Entry").addAttribute("Caption", sourceCaption).addAttribute("Key", "entry_" + key).addElement("EntryItem").addAttribute("Caption", caption).addAttribute("Key", "sub_" + key).addAttribute("Type", "Form").addAttribute("FormKey", key);
                    }
                } else {
                    node.addElement("Entry").addAttribute("Caption", sourceCaption).addAttribute("Key", "entry_" + key).addElement("EntryItem").addAttribute("Caption", caption).addAttribute("Key", "sub_" + key).addAttribute("Type", "Form").addAttribute("FormKey", key);
                }
                entryProject = pKey;
                flag = false;
                break;
            }
            if (flag.booleanValue()) {
                String entryXml = ProjectMetaResolverUtils.readProjectFile(projectKey, "Entry.xml");
                if (StringUtils.isNotBlank((CharSequence)entryXml)) {
                    document = reader.read((Reader)new StringReader(entryXml));
                    this.addCustomEntry(source, document, formType, key, caption);
                    entryProject = projectKey;
                } else {
                    entryXml = ProjectMetaResolverUtils.readProjectFile(STR_DefaultProjectKey, "Entry.xml");
                    document = reader.read((Reader)new StringReader(entryXml));
                    this.addCustomEntry(source, document, formType, key, caption);
                    entryProject = STR_DefaultProjectKey;
                }
            }
            if (entryProject != null) {
                OutputFormat format = DataMapOperXmlUtil.getOutputFormat();
                Object object = null;
                Object var15_16 = null;
                try (StringWriter entryWriter = new StringWriter();){
                    XMLWriter writer = new XMLWriter(entryWriter, format);
                    writer.write(document);
                    String entryXml = ((Object)entryWriter).toString();
                    ProjectMetaResolverUtils.writeProjectFile(entryProject, "Entry.xml", entryXml);
                }
                catch (Throwable throwable) {
                    if (object == null) {
                        object = throwable;
                    } else if (object != throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    throw object;
                }
                this.reloadEntry(entryProject);
                String tmpEntryPath = ProjectMetaResolverUtils.tryGetProjectFilePath(entryProject, "Entry.xml");
                if (tmpEntryPath != null) {
                    entryPath = new File(tmpEntryPath);
                }
            }
        }
        if (isNew && entryPath != null && entryPath.exists()) {
            RecycleForm recycleForm = new RecycleForm();
            recycleForm.setFilePath(entryPath.getPath());
            String content = FileUtils.readFileToString((File)entryPath, (String)"UTF-8");
            recycleForm.setContent(content);
            if (!XmlFileProcessor.recycleToTmpFormAndFileMap.containsKey("Entry@Entry" + key)) {
                XmlFileProcessor.instance.saveTempRecycleFile("Entry@Entry" + key, recycleForm);
            }
        }
    }

    public void NewProject(String key, String caption, String SolutionKey) throws Throwable {
        EntryProcessor.writeSolution(key, caption, SolutionKey);
        this.getEntryPath(key);
        this.reloadEntry(key);
    }

    public static void writeSolution(String key, String caption, String SolutionKey) throws IOException, DocumentException {
        String entryPath = Paths.get(SolutionKey, "", "Solution.xml").toString();
        SAXReader reader = new SAXReader();
        Document document = reader.read(new File(entryPath));
        Element node = (Element)document.getRootElement().selectSingleNode("/Solution/ProjectCollection");
        node.addElement("Project").addAttribute("Caption", caption).addAttribute("Key", key);
        OutputFormat format = DataMapOperXmlUtil.getOutputFormat();
        FileOutputStream fileOutputStream = new FileOutputStream(entryPath);
        XMLWriter writer = new XMLWriter(fileOutputStream, format);
        writer.write(document);
    }

    public static void deleteSolutionByProjectKey(String key, String SolutionKey) throws IOException, DocumentException {
        String entryPath = Paths.get(SolutionKey, "", "Solution.xml").toString();
        entryPath = entryPath.replace("\\\\", File.separator).replace('\\', File.separatorChar).replace('/', File.separatorChar);
        SAXReader reader = new SAXReader();
        Document document = reader.read(new File(entryPath));
        Element node = (Element)document.getRootElement().selectSingleNode("/Solution/ProjectCollection");
        Element nodes = (Element)document.getRootElement().selectSingleNode("/Solution/ProjectCollection/Project[@Key='" + key + "']");
        node.remove(nodes);
        OutputFormat format = DataMapOperXmlUtil.getOutputFormat();
        FileOutputStream fileOutputStream = new FileOutputStream(entryPath);
        XMLWriter writer = new XMLWriter(fileOutputStream, format);
        writer.write(document);
    }
}

