/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.cmd.DesignerServiceCmd;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.XmlFormat;
import com.bokesoft.yes.design.xml.XmlParser;
import com.bokesoft.yes.design.xml.node.AbstractNode;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.design.xml.node.XmlTree;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.util.FileUtil;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CheckKeyLengthCmd
extends DesignerServiceCmd {
    public static final String CMD = "CheckKeyLength";
    private boolean isSourceActive;
    private String content;
    private String uiFormKey;
    private String entryParas;

    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        this.isSourceActive = Boolean.parseBoolean((String)arguments.get((Object)"isSourceActive"));
        if (this.isSourceActive) {
            this.content = (String)arguments.get((Object)"content");
        } else {
            this.uiFormKey = (String)arguments.get((Object)"uiFormKey");
            this.entryParas = (String)arguments.get((Object)"entryParas");
        }
    }

    @Override
    public Object innerDoCmd(DefaultContext context) throws Throwable {
        ArrayList<UICommand> result;
        block2: {
            block1: {
                result = new ArrayList<UICommand>();
                if (!this.isSourceActive) break block1;
                String failedInfo = this.CheckLengthByContent(this.content);
                if (!StringUtils.isNotEmpty((CharSequence)failedInfo)) break block2;
                result.add(UICommand.showError("\u5f53\u524d\u6e90\u4ee3\u7801\u6587\u4ef6\u5b58\u5728Key\u957f\u5ea6\u6821\u9a8c\u4e0d\u901a\u8fc7: " + failedInfo));
                break block2;
            }
            List<String[]> filePaths = LoadFileTree.loadFilePathsByFormKey(context, this.uiFormKey, this.entryParas, null);
            for (String[] tmp : filePaths) {
                String filePath = tmp[0];
                String tmpFilePath = XmlFileProcessor.instance.getTmpFile(filePath);
                if (StringUtils.isEmpty((CharSequence)tmpFilePath)) continue;
                String tmpContent = FileUtil.File2String((String)tmpFilePath, (String)"UTF-8");
                String tmpSecondLine = DesignIOMetaUtil.getSecondLine(tmpContent);
                String key = DesignIOMetaUtil.getSubString(tmpSecondLine, "Key=\"([A-Za-z_]\\w*)\"");
                String failedInfo = this.CheckLengthByContent(tmpContent);
                if (!StringUtils.isNotEmpty((CharSequence)failedInfo)) continue;
                failedInfo = "\u5f53\u524d\u8868\u5355\u4e2d\u5b58\u5728Key\u957f\u5ea6\u6821\u9a8c\u4e0d\u901a\u8fc7,\u4f4d\u4e8e" + key + ".xml\u4e2d: " + failedInfo;
                result.add(UICommand.showError(failedInfo));
                break;
            }
        }
        return UICommand.toJson(result);
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new CheckKeyLengthCmd();
    }

    public String getCmd() {
        return CMD;
    }

    private String CheckLengthByContent(String content) throws Throwable {
        XmlTree xmlTree;
        String failedInfo = "";
        try {
            String xmlFile = XmlFormat.formatXML_str(content);
            xmlTree = XmlParser.parse(xmlFile);
        }
        catch (Exception e) {
            return "xml\u7ed3\u6784\u9519\u8bef!";
        }
        HashMap<String, AbstractNode> mapNodes = xmlTree.getMapNodes();
        for (Map.Entry<String, AbstractNode> node : mapNodes.entrySet()) {
            TagNode tag = (TagNode)node.getValue();
            String tagName = tag.getTagName();
            Map<String, String> tagAttributes = tag.getAttributes();
            String tagKey = tagAttributes.getOrDefault("Key", "");
            int tagKeyLength = tagKey.length();
            if (StringUtils.isEmpty((CharSequence)tagKey)) continue;
            if ("Form".equals(tagName) && tagKeyLength > 50) {
                failedInfo = "\u8868\u5355Key\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750,\u5f53\u524d\u8868\u5355Key: " + tagKey + " \u957f\u5ea6: " + tagKeyLength;
                break;
            }
            if (this.isPanel(tagName) && tagKeyLength > 100) {
                failedInfo = "\u9762\u677f\u4e0e\u8868\u683cKey\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7100,\u5f53\u524dKey: " + tagKey + " \u957f\u5ea6: " + tagKeyLength;
                break;
            }
            if (this.isControl(tagName) && tagKeyLength > 50) {
                failedInfo = "\u63a7\u4ef6Key\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750,\u5f53\u524d\u63a7\u4ef6Key: " + tagKey + " \u957f\u5ea6: " + tagKeyLength;
                break;
            }
            if ("Table".equals(tagName)) {
                boolean isPersist = Boolean.parseBoolean(tagAttributes.getOrDefault("Persist", "true"));
                if (isPersist && tagKeyLength > 30) {
                    failedInfo = "\u6301\u4e45\u5316\u8868Key\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc730,\u5f53\u524d\u8868Key: " + tagKey + " \u957f\u5ea6: " + tagKeyLength;
                    break;
                }
                if (isPersist || tagKeyLength <= 50) continue;
                failedInfo = "\u975e\u6301\u4e45\u5316\u8868Key\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750,\u5f53\u524d\u8868Key: " + tagKey + " \u957f\u5ea6: " + tagKeyLength;
                break;
            }
            if ("Column".equals(tagName) && tagKeyLength > 30) {
                String persistParent = tag.getParent().getAttributes().get("Persist");
                String persist = tag.getAttributes().get("Persist");
                boolean equalsParent = "false".equals(persistParent);
                boolean equals = "false".equals(persist);
                if (equals || equalsParent) break;
                failedInfo = "ColumnKey\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750,\u5f53\u524dColumnKey: " + tagKey + " \u957f\u5ea6: " + tagKeyLength;
                break;
            }
            if (!StringUtils.isEmpty((CharSequence)tagAttributes.get("RefObjectKey")) || !"DataObject".equals(tagName) || tagKeyLength <= 50) continue;
            failedInfo = "\u6570\u636e\u5bf9\u8c61Key\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750,\u5f53\u524d\u6570\u636e\u5bf9\u8c61Key: " + tagKey + " \u957f\u5ea6: " + tagKeyLength;
            break;
        }
        return failedInfo;
    }

    private boolean isControl(String tagName) {
        List<String> controls = Arrays.asList("Dict", "NumberEditor", "TextEditor", "TextEditor", "ComboBox", "DatePicker", "UTCDatePicker", "CheckBox", "TextArea", "TextButton", "Label", "CheckListBox", "DynamicDict", "RichEditor", "TimePicker", "MonthPicker", "PasswordEditor", "Separator", "Image", "HyperLink", "DropdownButton", "Embed", "ToolBar", "Chart");
        return controls.contains(tagName);
    }

    private boolean isPanel(String tagName) {
        List<String> panels = Arrays.asList("FlexFlowLayoutPanel", "SplitPanel", "TabPanel", "GridLayoutPanel", "FlowLayoutPanel", "ColumnLayoutPanel", "FlexGridLayoutPanel", "Grid", "SubDetail");
        return panels.contains(tagName);
    }
}

