/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.bpm.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bokesoft.erp.WebDesignerConfiguration;
import com.bokesoft.yes.common.util.DateUtil;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.bpm.po.Path;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.enums.NodeKeyAndCaptionEnum;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.XMLWriter;
import com.bokesoft.yes.design.vo.JsonQuestVo;
import com.bokesoft.yes.design.vo.ResponseResult;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.meta.persist.dom.bpm.MetaProcessSave;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.meta.bpm.process.ProcessDefinitionProfile;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.intf.IMetaProject;
import com.bokesoft.yigo.meta.solution.MetaProject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Method;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;

public class BpmOperToXmlUtil {
    private static final Logger logger = Logger.getLogger(BpmOperToXmlUtil.class.getName());
    private static final String BPM_DIRECTORY = "BPM";
    private static final String XML_EXTENSION = ".xml";
    public static final int OPER_TYPE_THREE = 3;

    public Map<String, String> createXml(String projectKey, String key, String caption, String version) {
        HashMap<String, String> result = new HashMap<String, String>(10);
        result.put("result", "true");
        String filePath = "";
        try {
            if (this.validateForCreateXml(projectKey, key, caption, version, result)) {
                return result;
            }
            int verionNo = Integer.parseInt(version) + 1;
            if (key.contains("_V")) {
                key = String.valueOf(key.substring(0, key.indexOf("_V"))) + "_V" + verionNo;
            } else if (verionNo > 1) {
                key = String.valueOf(key) + "_V" + verionNo;
            }
            if (LoadFileTree.isExistKey(key)) {
                result.put("result", "false");
                result.put("filePath", "");
                result.put("msg", "\u65b0\u589e\u7684\u7248\u672cV" + verionNo + "\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u65b0\u589e\u7248\u672c");
                return result;
            }
            MetaProcess process = new MetaProcess();
            process.setKey(key);
            process.setCaption(caption);
            process.setVersion(Integer.valueOf(verionNo));
            IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
            IMetaResolver resolver = globalInstance.getProjectResolver(projectKey);
            String newFileName = String.valueOf(key) + XML_EXTENSION;
            MetaProcessSave metaProcessSave = new MetaProcessSave((AbstractMetaObject)process);
            metaProcessSave.save(resolver, String.valueOf(File.separator) + BPM_DIRECTORY + File.separator + newFileName);
            String versionStr = "0".equals(version) ? "" : " Version=\"" + verionNo + "\"";
            filePath = LoadFileTree.newBpmFile(projectKey, newFileName, key, caption);
            String fileContent = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<Process Caption=\"" + caption + "\" Key=\"" + key + "\"" + versionStr + ">\n" + "    <SwimlineCollection/>\n" + "    <BPMInfoCollection/>\n" + "    <DMTable/>\n" + "    <PermCollection/>\n" + "    <AttachmentCollection/>\n" + "</Process>";
            XmlFileProcessor.instance.saveTempFile(filePath, fileContent, projectKey);
            result.put("result", "true");
            result.put("filePath", filePath);
            result.put("version", String.valueOf(verionNo));
            result.put("fileName", newFileName.replaceAll(XML_EXTENSION, ""));
            ProcessDefinitionProfile formProfile = new ProcessDefinitionProfile();
            HashMap profileMap = globalInstance.getMetaBPM().getProfileMap();
            MetaProject metaProject = globalInstance.getMetaProject(projectKey);
            formProfile.setKey(key);
            formProfile.setCaption(caption);
            formProfile.setVersion(verionNo);
            formProfile.setResource(String.valueOf(projectKey) + "/BPM/" + key + XML_EXTENSION);
            formProfile.setProject((IMetaProject)metaProject);
            profileMap.put(key, formProfile);
        }
        catch (Throwable e) {
            logger.warning("\u65b0\u589exml\u6587\u4ef6\u5f02\u5e38,\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            if (StringUtils.isNotEmpty((CharSequence)filePath)) {
                try {
                    LoadFileTree.removeFilePath(filePath);
                }
                catch (Throwable e1) {
                    logger.warning("\u5220\u9664\u6587\u4ef6\u5f02\u5e38,\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e1));
                }
            }
            result.put("result", "false");
            result.put("filePath", "");
            result.put("msg", e.getMessage());
        }
        return result;
    }

    private boolean validateForCreateXml(String projectKey, String key, String caption, String version, Map<String, String> result) {
        if (StringUtils.isEmpty((CharSequence)projectKey)) {
            result.put("result", "false");
            result.put("filePath", "");
            result.put("msg", "\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a");
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)key)) {
            result.put("result", "false");
            result.put("filePath", "");
            result.put("msg", "\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)caption)) {
            result.put("result", "false");
            result.put("filePath", "\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            result.put("msg", "");
            return true;
        }
        String pattern = "([A-Za-z_]\\w*)";
        boolean isMatch = Pattern.matches(pattern, key);
        if (!isMatch) {
            result.put("result", "false");
            result.put("filePath", "");
            result.put("msg", "\u6807\u8bc6\u4e0d\u6b63\u786e\uff0c\u4e0d\u662f\u5b57\u6bcd\u6216\u4e0b\u5212\u7ebf\u5f00\u59cb\u7684");
            return true;
        }
        if (LoadFileTree.isExistKey(key) && "0".equals(version)) {
            result.put("result", "false");
            result.put("filePath", "");
            result.put("msg", "\u6587\u4ef6'" + key + "'\u5df2\u5b58\u5728");
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResponseResult<JSONObject> updateXml(JsonQuestVo jsonQuestVo) {
        result = new ResponseResult<JSONObject>();
        fileOutputStream = null;
        writer = null;
        try {
            block49: {
                filePath = jsonQuestVo.getFilePath();
                tempPath = XmlFileProcessor.instance.getTmpFile(filePath);
                if (StringUtils.isBlank((CharSequence)tempPath)) {
                    tempPath = filePath;
                }
                frontUpdateJson = JSON.parseObject((String)jsonQuestVo.getContent());
                key = frontUpdateJson.getString("key");
                value = frontUpdateJson.getString("value");
                reader = new SAXReader();
                document = reader.read(new File(tempPath));
                root = document.getRootElement();
                var13_15 = key;
                tmp = -1;
                switch (var13_15.hashCode()) {
                    case -2077740602: {
                        if (!var13_15.equals("Caption")) break;
                        tmp = 1;
                        break;
                    }
                    case -1870406194: {
                        if (!var13_15.equals("PermCollection")) break;
                        tmp = 2;
                        break;
                    }
                    case -1852888825: {
                        if (!var13_15.equals("WorkFlowHookPath")) break;
                        tmp = 3;
                        break;
                    }
                    case -1789251387: {
                        if (!var13_15.equals("DMTable")) break;
                        tmp = 4;
                        break;
                    }
                    case -857475227: {
                        if (!var13_15.equals("TemplateKey")) break;
                        tmp = 1;
                        break;
                    }
                    case -476485541: {
                        if (!var13_15.equals("IgnoreFormState")) break;
                        tmp = 1;
                        break;
                    }
                    case 951866373: {
                        if (!var13_15.equals("KillInstanceTrigger")) break;
                        tmp = 1;
                        break;
                    }
                    case 987187931: {
                        if (!var13_15.equals("FormKey")) break;
                        tmp = 1;
                        break;
                    }
                    case 1216611011: {
                        if (!var13_15.equals("QueryRetreatWorkitem")) break;
                        tmp = 5;
                        break;
                    }
                    case 1323267087: {
                        if (!var13_15.equals("LockWorkitem")) break;
                        tmp = 6;
                        break;
                    }
                    case 1415473634: {
                        if (!var13_15.equals("BPMGraphInfoPath")) break;
                        tmp = 7;
                        break;
                    }
                }
                switch (tmp) {
                    case 4: {
                        if (root.element(key) != null) {
                            root.remove(root.element(key));
                        }
                        if ("null".equals(value) || !StringUtils.isNotEmpty((CharSequence)value)) break;
                        root.addElement(key);
                        array = JSON.parseArray((String)value);
                        if (CollectionUtils.isEmpty((Collection)array)) break;
                        i = 0;
                        if (true) ** GOTO lbl180
                    }
                    case 1: {
                        if (StringUtils.isNotEmpty((CharSequence)value)) {
                            root.addAttribute(key, value);
                            break;
                        }
                        this.deleteXmlElementAttribute(root, root.attribute(key));
                        break;
                    }
                    case 5: {
                        if ("false".equals(value)) {
                            root.addAttribute(key, value);
                            break;
                        }
                        this.deleteXmlElementAttribute(root, root.attribute(key));
                        break;
                    }
                    case 6: {
                        if ("true".equals(value)) {
                            root.addAttribute(key, value);
                            break;
                        }
                        this.deleteXmlElementAttribute(root, root.attribute(key));
                        break;
                    }
                    case 2: {
                        if (root.element(key) != null) {
                            root.remove(root.element(key));
                        }
                        if (!StringUtils.isNotEmpty((CharSequence)value) || (permJson = JSON.parseObject((String)value)) == null) break;
                        optPermArray = permJson.getJSONArray("OptPerm");
                        visiblePermArray = permJson.getJSONArray("VisiblePerm");
                        enablePermArray = permJson.getJSONArray("EnablePerm");
                        v0 = hasPerm = CollectionUtils.isEmpty((Collection)optPermArray) == false || CollectionUtils.isEmpty((Collection)visiblePermArray) == false || CollectionUtils.isEmpty((Collection)enablePermArray) == false;
                        if (!hasPerm) break;
                        permCollection = root.addElement(key);
                        permCollection.addElement("Perm");
                        keys = Arrays.asList(new String[]{"OptPerm", "VisiblePerm", "EnablePerm"});
                        keys.forEach((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$0(com.alibaba.fastjson.JSONObject org.dom4j.Element java.lang.String ), (Ljava/lang/String;)V)((BpmOperToXmlUtil)this, (JSONObject)permJson, (Element)permCollection));
                        break;
                    }
                    case 7: {
                        if (StringUtils.isNotEmpty((CharSequence)value)) {
                            if (root.element("Expand") == null) {
                                root.addElement("Expand");
                            }
                            root.element("Expand").addAttribute(key, value);
                            break;
                        }
                        if (root.element("Expand") == null) break;
                        if (root.element("Expand").attribute("WorkFlowHookPath") == null) {
                            root.remove(root.element("Expand"));
                            break;
                        }
                        this.deleteXmlElementAttribute(root.element("Expand"), root.element("Expand").attribute(key));
                        break;
                    }
                    case 3: {
                        if (StringUtils.isNotEmpty((CharSequence)value)) {
                            if (root.element("Expand") == null) {
                                root.addElement("Expand");
                            }
                            root.element("Expand").addAttribute(key, value);
                            break;
                        }
                        if (root.element("Expand") == null) break;
                        if (root.element("Expand").attribute("BPMGraphInfoPath") == null) {
                            root.remove(root.element("Expand"));
                            break;
                        }
                        this.deleteXmlElementAttribute(root.element("Expand"), root.element("Expand").attribute(key));
                        break;
                    }
                }
                break block49;
                do {
                    obj = array.getJSONObject(i);
                    field = root.element(key).addElement("Field");
                    if (StringUtils.isEmpty((CharSequence)obj.getString("Key"))) {
                        result.setCode(1);
                        result.setMsg("\u7b2c" + (i + 1) + "\u884c'\u8fc1\u79fb\u5b57\u6bb5\u7684\u6807\u8bc6'\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u8fdb\u884c\u64cd\u4f5c");
                        var22_25 = result;
                        this.closeFileStream(fileOutputStream, writer);
                        return var22_25;
                    }
                    field.addAttribute("Key", obj.getString("Key"));
                    field.addAttribute("Caption", obj.getString("Caption"));
                    type = obj.getString("Type");
                    if ("Field".equals(type)) {
                        if (StringUtils.isEmpty((CharSequence)obj.getString("Value"))) {
                            result.setCode(1);
                            result.setMsg("\u7b2c" + (i + 1) + "\u884c'\u6765\u6e90\u5b57\u6bb5'\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u8fdb\u884c\u64cd\u4f5c");
                            var22_26 = result;
                            this.closeFileStream(fileOutputStream, writer);
                            return var22_26;
                        }
                        field.addAttribute("SourceFieldKey", obj.getString("Value"));
                    } else if ("Const".equals(type)) {
                        field.addAttribute("Type", type);
                        field.addAttribute("ConstValue", obj.getString("Value"));
                    }
                    detail = obj.getString("Detail");
                    field.addAttribute("Detail", detail.replaceAll("\"", "'"));
                    ++i;
lbl180:
                    // 2 sources

                } while (i < array.size());
            }
            format = this.getOutputFormat();
            solutionPath = String.valueOf(FilePathHelper.getWorkspacePath()) + File.separator;
            newFilePath = Paths.get(WebDesignerConfiguration.getDesignerDataPath(), new String[]{"tmp", String.valueOf(filePath.substring(solutionPath.length()).replace(File.separator, "__")) + "." + System.currentTimeMillis()}).toString();
            fileOutputStream = new FileOutputStream(newFilePath);
            writer = new XMLWriter(fileOutputStream, format);
            writer.write(document);
            XmlFileProcessor.stackput(filePath, newFilePath);
            result.setCode(0);
            result.setMsg("\u66f4\u65b0xml\u6210\u529f");
        }
        catch (Exception e) {
            BpmOperToXmlUtil.logger.warning("\u66f4\u65b0xml\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            result.setCode(999);
            result.setMsg("\u66f4\u65b0xml\u5931\u8d25\uff0c\u5931\u8d25\u6d88\u606f\u4e3a:" + e.getMessage());
            this.closeFileStream(fileOutputStream, writer);
            return result;
        }
        catch (Throwable throwable) {
            try {
                BpmOperToXmlUtil.logger.warning(throwable.getMessage());
                return result;
            }
            catch (Throwable var21_28) {
                throw var21_28;
            }
            finally {
                this.closeFileStream(fileOutputStream, writer);
            }
        }
        this.closeFileStream(fileOutputStream, writer);
        return result;
    }

    private OutputFormat getOutputFormat() {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setNewLineAfterDeclaration(false);
        format.setIndentSize(4);
        format.setExpandEmptyElements(false);
        format.setPadText(false);
        return format;
    }

    public ResponseResult<JSONObject> deployBpm(JsonQuestVo jsonQuestVo) {
        ResponseResult<JSONObject> result;
        block12: {
            JSONObject frontUpdateJson;
            String bpmFilePath;
            XMLWriter writer;
            FileOutputStream fileOutputStream;
            block11: {
                result = new ResponseResult<JSONObject>();
                fileOutputStream = null;
                writer = null;
                String filePath = jsonQuestVo.getFilePath();
                File workFlowFile = new File(filePath);
                String parentPath = workFlowFile.getParent();
                bpmFilePath = String.valueOf(parentPath.substring(0, parentPath.length() - 4)) + File.separator + "BPM.xml";
                frontUpdateJson = JSON.parseObject((String)jsonQuestVo.getContent());
                if (frontUpdateJson != null) break block11;
                result.setCode(1);
                result.setMsg("\u5de5\u4f5c\u6d41\u6807\u8bc6\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u90e8\u7f72");
                ResponseResult<JSONObject> responseResult = result;
                this.closeFileStream(fileOutputStream, writer);
                return responseResult;
            }
            try {
                SAXReader reader = new SAXReader();
                Document document = reader.read(new File(bpmFilePath));
                Element root = document.getRootElement();
                String key = frontUpdateJson.getString("Key");
                if (root.element("DeployInfoCollection") == null) {
                    root.addElement("DeployInfoCollection");
                }
                if (root.element("DeployInfoCollection").elements("DeployInfo") != null) {
                    List deployInfoList = root.element("DeployInfoCollection").elements("DeployInfo");
                    for (Element ele : deployInfoList) {
                        if (!key.equals(ele.attributeValue("Key"))) continue;
                        root.element("DeployInfoCollection").remove(ele);
                    }
                }
                root.element("DeployInfoCollection").addElement("DeployInfo").addAttribute("InitDate", DateUtil.getDateFormatText(null, (String)"yyyy-MM-dd HH:mm:ss")).addAttribute("Key", key);
                OutputFormat format = this.getOutputFormat();
                fileOutputStream = new FileOutputStream(bpmFilePath);
                writer = new XMLWriter(fileOutputStream, format);
                writer.write(document);
                result.setCode(0);
                result.setMsg("\u90e8\u7f72\u5de5\u4f5c\u6d41\u6210\u529f");
            }
            catch (Exception e) {
                logger.warning("\u90e8\u7f72\u5de5\u4f5c\u6d41\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
                result.setCode(999);
                result.setMsg("\u90e8\u7f72\u5de5\u4f5c\u6d41\u5931\u8d25\uff0c\u5931\u8d25\u6d88\u606f\u4e3a:" + e.getMessage());
                this.closeFileStream(fileOutputStream, writer);
                break block12;
            }
            catch (Throwable throwable) {
                try {
                    logger.warning(throwable.getMessage());
                    break block12;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    this.closeFileStream(fileOutputStream, writer);
                }
            }
            this.closeFileStream(fileOutputStream, writer);
        }
        return result;
    }

    public ResponseResult<List<JSONObject>> workflowAndBillsConfig(JsonQuestVo jsonQuestVo) {
        ResponseResult<List<JSONObject>> result;
        block18: {
            String filePath;
            XMLWriter writer;
            FileOutputStream fileOutputStream;
            block17: {
                result = new ResponseResult<List<JSONObject>>();
                fileOutputStream = null;
                writer = null;
                filePath = jsonQuestVo.getFilePath();
                if (!StringUtils.isEmpty((CharSequence)filePath)) break block17;
                result.setCode(1);
                result.setMsg("\u53c2\u6570filePath\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u8bbe\u7f6e");
                ResponseResult<List<JSONObject>> responseResult = result;
                this.closeFileStream(fileOutputStream, writer);
                return responseResult;
            }
            try {
                File workFlowFile = new File(filePath);
                SAXReader reader = new SAXReader();
                Document document = reader.read(workFlowFile);
                Element root = document.getRootElement();
                if (root.element("ProcessMapCollection") != null) {
                    root.remove(root.element("ProcessMapCollection"));
                }
                root.addElement("ProcessMapCollection");
                JSONArray arrayJson = null;
                if (!"null".equals(jsonQuestVo.getContent()) && StringUtils.isNotEmpty((CharSequence)jsonQuestVo.getContent())) {
                    String json = jsonQuestVo.getContent();
                    json = json.replaceAll("\"\\{", "{").replaceAll("}\"", "}").replaceAll("(\\\\r\\\\n)|\\\\n", "\\\n").replaceAll("\\\\", "");
                    arrayJson = JSON.parseArray((String)json);
                }
                int i = 0;
                while (i < arrayJson.size()) {
                    JSONObject permJson;
                    String v;
                    JSONObject obj = arrayJson.getJSONObject(i);
                    if (StringUtils.isEmpty((CharSequence)obj.getString("Key"))) {
                        ++i;
                        continue;
                    }
                    Element processMapEle = root.element("ProcessMapCollection").addElement("ProcessMap").addAttribute("InitDate", String.valueOf(DateUtil.getDateFormatText(null, (String)"yyyy-MM-dd HH:mm:ss")) + " CST").addAttribute("Key", obj.getString("Key")).addAttribute("StartAction", obj.getString("StartAction")).addAttribute("StartCaption", obj.getString("StartCaption"));
                    String type = obj.getString("Type");
                    if ("Bill".equals(type)) {
                        processMapEle.addAttribute("ProcessKey", obj.getString("ProcessKey"));
                    } else if ("DataObject".equals(type)) {
                        processMapEle.addAttribute("Type", type);
                        processMapEle.addAttribute("ProcessKeyFormula", obj.getString("ProcessKey"));
                    }
                    if ("true".equals(obj.getString("IsDynamic"))) {
                        processMapEle.addAttribute("IsDynamic", obj.getString("IsDynamic"));
                        processMapEle.addAttribute("ProcessKeyFormula", obj.getString("ProcessKey"));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)(v = obj.getString("Perm"))) && (permJson = JSON.parseObject((String)(v = v.replaceAll("\"\"\\[", "\"[").replaceAll("]\"\"", "]").replaceAll("\"\\[", "[").replaceAll("]\"", "]").replaceAll("(\\\\r\\\\n)|\\\\n", "\\\n")))) != null) {
                        processMapEle.addElement("Perm");
                        this.setXmlPerm(permJson, processMapEle, "OptPerm", "OptPermItem");
                        this.setXmlPerm(permJson, processMapEle, "VisiblePerm", "VisiblePermItem");
                        this.setXmlPerm(permJson, processMapEle, "EnablePerm", "EnablePermItem");
                    }
                    ++i;
                }
                OutputFormat format = this.getOutputFormat();
                fileOutputStream = new FileOutputStream(filePath);
                writer = new XMLWriter(fileOutputStream, format);
                writer.write(document);
                result.setCode(0);
                result.setMsg("\u6d41\u7a0b\u5355\u636e\u5173\u8054\u8bbe\u7f6e\u6210\u529f");
                ArrayList jsonObjects = new ArrayList();
                this.closeFileStream(fileOutputStream, writer);
                IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
                globalInstance.reloadMetaBPM();
                result.setData(jsonObjects);
            }
            catch (Exception e) {
                logger.warning("\u6d41\u7a0b\u5355\u636e\u5173\u8054\u8bbe\u7f6e\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
                result.setCode(999);
                result.setMsg("\u6d41\u7a0b\u5355\u636e\u5173\u8054\u8bbe\u7f6e\u5931\u8d25\uff0c\u5931\u8d25\u6d88\u606f\u4e3a:" + e.getMessage());
                this.closeFileStream(fileOutputStream, writer);
                break block18;
            }
            catch (Throwable throwable) {
                try {
                    logger.warning(throwable.getMessage());
                    break block18;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    this.closeFileStream(fileOutputStream, writer);
                }
            }
            this.closeFileStream(fileOutputStream, writer);
        }
        return result;
    }

    private boolean checkColumn(MetaForm metaForm, String mainTableKey) throws Throwable {
        XmlTreeWithPath xmlTree;
        boolean ishas = false;
        if (StringUtils.isNotEmpty((CharSequence)metaForm.getDataSource().getRefObjectKey())) {
            MetaDataObject dataObject = metaForm.getDataSource().getDataObject();
            String filePath = LoadFileTree.loadFilePathByDataObjectFieldKey(dataObject.getKey());
            xmlTree = XmlTreeWithPath.parseFilePath(filePath);
        } else {
            String filePath = LoadFileTree.getPathByFormKey(metaForm.getKey());
            xmlTree = XmlTreeWithPath.parseFilePath(filePath);
        }
        List<TagNode> table = xmlTree.xmlTree.getRoot().findNodesByTagName("Table");
        block0: for (TagNode tag : table) {
            if (!tag.getAttributes().get("Key").equals(mainTableKey)) continue;
            List<TagNode> column = tag.findNodesByTagName("Column");
            for (TagNode tg : column) {
                if (!tg.getAttributes().get("Key").equals("InstanceID")) continue;
                ishas = true;
                continue block0;
            }
        }
        return ishas;
    }

    private List<Element> findTableNode(Element element) {
        List elements = element.element("DataSource").element("DataObject").element("TableCollection").elements("Table");
        return elements;
    }

    private List<Element> findDataObjectTableNode(Element element) {
        List elements = element.element("TableCollection").elements("Table");
        return elements;
    }

    private void setXmlPerm(JSONObject permJson, Element node, String firstElementName, String secondElementName) {
        JSONArray permArray = permJson.getJSONArray(firstElementName);
        if (!CollectionUtils.isEmpty((Collection)permArray)) {
            if (node.element("Perm").element(firstElementName) != null) {
                node.element("Perm").remove(node.element("Perm").element(firstElementName));
            }
            Element permElement = node.element("Perm").addElement(firstElementName);
            for (Object o : permArray) {
                JSONObject eachObj = (JSONObject)o;
                permElement.addElement(secondElementName).addAttribute("Key", eachObj.getString("Key"));
            }
        } else {
            node.element("Perm").remove(node.element("Perm").element(firstElementName));
        }
    }

    public ResponseResult<JSONObject> newVersion(JsonQuestVo jsonQuestVo) {
        ResponseResult<JSONObject> result = new ResponseResult<JSONObject>();
        JSONObject data = new JSONObject();
        String newFilePath = "";
        try {
            Long version;
            String caption;
            String key;
            String filePath = jsonQuestVo.getFilePath();
            if (StringUtils.isEmpty((CharSequence)filePath)) {
                result.setCode(1);
                result.setMsg("\u53c2\u6570filePath\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u65b0\u589e\u7248\u672c");
                return result;
            }
            JSONObject frontUpdateJson = JSON.parseObject((String)jsonQuestVo.getContent());
            if (frontUpdateJson == null) {
                result.setCode(1);
                result.setMsg("\u53c2\u6570\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u65b0\u589e\u7248\u672c");
                return result;
            }
            if (StringUtils.isEmpty((CharSequence)frontUpdateJson.getString("Key"))) {
                result.setCode(1);
                result.setMsg("\u53c2\u6570Key\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u65b0\u589e\u7248\u672c");
                return result;
            }
            if (StringUtils.isEmpty((CharSequence)frontUpdateJson.getString("Caption"))) {
                result.setCode(1);
                result.setMsg("\u53c2\u6570Caption\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u65b0\u589e\u7248\u672c");
                return result;
            }
            if (StringUtils.isEmpty((CharSequence)frontUpdateJson.getString("Version"))) {
                result.setCode(1);
                result.setMsg("\u53c2\u6570Version\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u65b0\u589e\u7248\u672c");
                return result;
            }
            String projectKey = this.getProjectKeyByFilePath(filePath);
            Map<String, String> res = this.createXml(projectKey, key = frontUpdateJson.getString("Key"), caption = frontUpdateJson.getString("Caption"), (version = frontUpdateJson.getLong("Version")).toString());
            if (!"true".equals(res.get("result"))) {
                result.setCode(999);
                result.setMsg("\u65b0\u589e\u7248\u672c\u5931\u8d25\uff0c\u5931\u8d25\u6d88\u606f\u4e3a:" + res.get("msg"));
                return result;
            }
            newFilePath = res.get("filePath");
            data.put("code", (Object)0);
            data.put("msg", (Object)"\u65b0\u589e\u7248\u672c\u6210\u529f");
            data.put("filePath", (Object)newFilePath);
            data.put("fileName", (Object)res.get("fileName"));
            data.put("caption", (Object)caption);
            data.put("version", (Object)res.get("version"));
            result.setCode(0);
            result.setMsg("\u65b0\u589e\u7248\u672c\u6210\u529f");
            result.setData(data);
        }
        catch (Exception e) {
            logger.warning("\u65b0\u589e\u7248\u672c\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            if (StringUtils.isNotEmpty((CharSequence)newFilePath)) {
                try {
                    LoadFileTree.removeFilePath(newFilePath);
                }
                catch (Throwable e1) {
                    logger.warning("\u5220\u9664\u6587\u4ef6\u5f02\u5e38,\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e1));
                }
            }
            result.setCode(999);
            result.setMsg("\u65b0\u589e\u7248\u672c\u5931\u8d25\uff0c\u5931\u8d25\u6d88\u606f\u4e3a:" + e.getMessage());
        }
        return result;
    }

    private String getProjectKeyByFilePath(String filePath) {
        String parentPath = new File(filePath).getParent();
        return parentPath.substring(parentPath.indexOf("solution") + 9, parentPath.lastIndexOf(File.separator));
    }

    private Element getRootElementByFilePath(String filePath) throws DocumentException {
        SAXReader reader = new SAXReader();
        Document document = reader.read(new File(filePath));
        return document.getRootElement();
    }

    public ResponseResult<JSONArray> getWorkflowAndBillsTableData(String filePath) {
        ResponseResult<JSONArray> result = new ResponseResult<JSONArray>();
        try {
            JSONArray jsonArray = new JSONArray();
            Element root = this.getRootElementByFilePath(filePath);
            if (!CollectionUtils.isEmpty((Collection)root.element("ProcessMapCollection").elements("ProcessMap"))) {
                List elements = root.element("ProcessMapCollection").elements("ProcessMap");
                int i = 0;
                while (i < elements.size()) {
                    Element ele = (Element)elements.get(i);
                    JSONObject obj = new JSONObject();
                    obj.put("id", (Object)(i + 1));
                    if (StringUtils.isNotEmpty((CharSequence)ele.attributeValue("Type"))) {
                        obj.put("Type", (Object)"DataObject");
                    } else {
                        obj.put("Type", (Object)"Bill");
                    }
                    obj.put("Key", (Object)ele.attributeValue("Key"));
                    obj.put("IsDynamic", (Object)StringUtils.isNotEmpty((CharSequence)ele.attributeValue("IsDynamic")));
                    if (StringUtils.isNotEmpty((CharSequence)ele.attributeValue("ProcessKey"))) {
                        obj.put("ProcessKey", (Object)ele.attributeValue("ProcessKey"));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)ele.attributeValue("ProcessKeyFormula"))) {
                        obj.put("ProcessKey", (Object)ele.attributeValue("ProcessKeyFormula"));
                    }
                    obj.put("StartAction", (Object)ele.attributeValue("StartAction"));
                    obj.put("StartCaption", (Object)ele.attributeValue("StartCaption"));
                    obj.put("Perm", (Object)JSON.toJSONString((Object)this.setPerm(ele)));
                    jsonArray.add((Object)obj);
                    ++i;
                }
            }
            result.setCode(0);
            result.setMsg("\u83b7\u53d6json\u6570\u636e\u6210\u529f");
            result.setData(jsonArray);
        }
        catch (Exception e) {
            logger.warning("\u83b7\u53d6json\u6570\u636e\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            result.setCode(999);
            result.setMsg("\u83b7\u53d6json\u6570\u636e\u5931\u8d25\uff0c\u5931\u8d25\u6d88\u606f\u4e3a:" + e.getMessage());
        }
        return result;
    }

    private JSONObject setPerm(Element node) {
        List optPermItems = null;
        List visiblePermItems = null;
        List enablePermItems = null;
        if (node.element("Perm") != null && node.element("Perm").element("OptPerm") != null) {
            optPermItems = node.element("Perm").element("OptPerm").elements("OptPermItem");
        }
        if (node.element("Perm") != null && node.element("Perm").element("VisiblePerm") != null) {
            visiblePermItems = node.element("Perm").element("VisiblePerm").elements("VisiblePermItem");
        }
        if (node.element("Perm") != null && node.element("Perm").element("EnablePerm") != null) {
            enablePermItems = node.element("Perm").element("EnablePerm").elements("EnablePermItem");
        }
        JSONObject value = new JSONObject();
        List<String> keyList = Arrays.asList("OptPerm", "VisiblePerm", "EnablePerm");
        List elements = null;
        Iterator<String> iterator = keyList.iterator();
        while (iterator.hasNext()) {
            String k;
            switch (k = iterator.next()) {
                case "OptPerm": {
                    elements = optPermItems;
                    break;
                }
                case "VisiblePerm": {
                    elements = visiblePermItems;
                    break;
                }
                case "EnablePerm": {
                    elements = enablePermItems;
                    break;
                }
            }
            if (CollectionUtils.isEmpty(elements)) continue;
            JSONArray array = new JSONArray();
            for (Element ele : elements) {
                JSONObject jsonObj = new JSONObject();
                jsonObj.put("Key", (Object)ele.attributeValue("Key"));
                array.add((Object)jsonObj);
            }
            value.put(k, (Object)array);
        }
        return value;
    }

    public ResponseResult<JSONObject> handleNodesAndPaths(JsonQuestVo jsonQuestVo, Integer operType) {
        ResponseResult<JSONObject> result = new ResponseResult<JSONObject>();
        try {
            JSONObject operJsonResultObject;
            String replaceStr;
            String filePath = jsonQuestVo.getFilePath();
            JSONObject frontFullJson = JSON.parseObject((String)jsonQuestVo.getContent());
            String nodeId = jsonQuestVo.getNodeId();
            if (3 == operType) {
                return this.deleteXmlNodeAndPaths(filePath, frontFullJson, nodeId);
            }
            JSONObject operNodeJson = frontFullJson.getJSONObject("states").getJSONObject(nodeId);
            if (operNodeJson != null) {
                replaceStr = "states";
                operJsonResultObject = this.handleNodes(filePath, nodeId, operNodeJson);
            } else {
                operNodeJson = frontFullJson.getJSONObject("paths").getJSONObject(nodeId);
                if (operNodeJson == null) {
                    result.setCode(1);
                    result.setMsg("\u64cd\u4f5c\u5931\u8d25,\u8be5\u8282\u70b9\u4e0d\u5b58\u5728");
                    return result;
                }
                replaceStr = "paths";
                operJsonResultObject = new Path().save(filePath, frontFullJson, nodeId, operNodeJson);
            }
            this.fillFrontFullJson(frontFullJson, operJsonResultObject, nodeId, replaceStr);
            JSONObject restoreJson = new JSONObject();
            restoreJson.put("restore", (Object)frontFullJson);
            result.setCode(0);
            result.setMsg("\u64cd\u4f5c\u6210\u529f");
            result.setData(restoreJson);
        }
        catch (Throwable e) {
            logger.warning("\u64cd\u4f5c\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            result.setCode(999);
            result.setMsg("\u64cd\u4f5c\u5931\u8d25\uff0c\u5931\u8d25\u6d88\u606f\u4e3a:" + e.getMessage());
        }
        return result;
    }

    private JSONObject handleNodes(String filePath, String nodeId, JSONObject operNodeJson) throws Throwable {
        JSONObject result;
        FileOutputStream fileOutputStream = null;
        XMLWriter writer = null;
        String nodeType = operNodeJson.getString("type");
        try {
            try {
                String tempPath = XmlFileProcessor.instance.getTmpFile(filePath);
                if (StringUtils.isBlank((CharSequence)tempPath)) {
                    tempPath = filePath;
                }
                SAXReader reader = new SAXReader();
                Document document = reader.read(new File(tempPath));
                Element root = document.getRootElement();
                String packagePath = "com.bokesoft.yes.design.bpm.po";
                Class<?> c = Class.forName(String.valueOf(packagePath) + "." + nodeType);
                Object instance = c.newInstance();
                Method commonMethod = c.getMethod("save", JSONObject.class, Element.class, String.class, String.class);
                Element node = (Element)commonMethod.invoke(instance, operNodeJson, root, nodeType, nodeId);
                Method selfMethod = c.getMethod("saveSelfAttributesToXml", JSONObject.class, Element.class);
                selfMethod.invoke(instance, operNodeJson, node);
                Method frontDefaultValuesMethod = c.getMethod("setFrontDefaultValues", new Class[0]);
                result = (JSONObject)frontDefaultValuesMethod.invoke(instance, new Object[0]);
                OutputFormat format = this.getOutputFormat();
                String solutionPath = String.valueOf(FilePathHelper.getWorkspacePath()) + File.separator;
                String newFilePath = Paths.get(WebDesignerConfiguration.getDesignerDataPath(), "tmp", String.valueOf(filePath.substring(solutionPath.length()).replace(File.separator, "__")) + "." + System.currentTimeMillis()).toString();
                fileOutputStream = new FileOutputStream(newFilePath);
                writer = new XMLWriter(fileOutputStream, format);
                XmlFileProcessor.stackput(filePath, newFilePath);
                writer.setEscapeText(false);
                try {
                    writer.write(document);
                }
                catch (IOException e) {
                    logger.warning("\u683c\u5f0f\u5316XML\u6587\u6863\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
            }
            catch (Exception e) {
                logger.warning("\u4fdd\u5b58\u5c5e\u6027\u5230xml\u6587\u4ef6\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
                throw e;
            }
        }
        catch (Throwable throwable) {
            this.closeFileStream(fileOutputStream, writer);
            throw throwable;
        }
        this.closeFileStream(fileOutputStream, writer);
        return result;
    }

    private ResponseResult<JSONObject> deleteXmlNodeAndPaths(String filePath, JSONObject frontFullJson, String nodeId) {
        ResponseResult<JSONObject> result = new ResponseResult<JSONObject>();
        try {
            String nodeType;
            String key;
            Boolean delResult;
            JSONObject json = frontFullJson.getJSONObject("states").getJSONObject(nodeId);
            if (json == null) {
                json = frontFullJson.getJSONObject("paths").getJSONObject(nodeId);
            }
            if ((delResult = this.handleDelNodesAndPaths(filePath, key = json.getJSONObject("props").getJSONObject("Key").getString("value"), nodeType = json.getJSONObject("props").getJSONObject("NodeType").getString("value"))).booleanValue()) {
                result.setCode(0);
                result.setMsg("\u5220\u9664\u6210\u529f");
            } else {
                result.setCode(1);
                result.setMsg("\u5220\u9664\u5931\u8d25");
            }
            JSONObject restoreJson = new JSONObject();
            restoreJson.put("restore", (Object)frontFullJson);
            result.setData(restoreJson);
        }
        catch (Exception e) {
            logger.warning("\u5220\u9664xml\u4e2d\u7684\u8282\u70b9\u548c\u8def\u5f84\u529f\u80fd\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            result.setCode(999);
            result.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return result;
    }

    private void closeFileStream(FileOutputStream fileOutputStream, XMLWriter writer) {
        try {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
        catch (Exception e) {
            logger.warning("\u5173\u95edwriter\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private Boolean handleDelNodesAndPaths(String filePath, String key, String nodeType) {
        boolean result;
        block19: {
            FileOutputStream fileOutputStream = null;
            XMLWriter writer = null;
            result = true;
            try {
                String tempPath = XmlFileProcessor.instance.getTmpFile(filePath);
                if (StringUtils.isBlank((CharSequence)tempPath)) {
                    tempPath = filePath;
                }
                SAXReader reader = new SAXReader();
                Document document = reader.read(new File(tempPath));
                Element root = document.getRootElement();
                List elements = root.elements();
                if (NodeKeyAndCaptionEnum.SequenceFlow.getKey().equals(nodeType) || NodeKeyAndCaptionEnum.Association.getKey().equals(nodeType) || NodeKeyAndCaptionEnum.ExceptionFlow.getKey().equals(nodeType)) {
                    block7: for (Element ele : elements) {
                        List paths;
                        Element transitionCollectionEle = ele.element("TransitionCollection");
                        if (transitionCollectionEle == null || CollectionUtils.isEmpty((Collection)(paths = transitionCollectionEle.elements(nodeType)))) continue;
                        for (Element e : paths) {
                            if (e == null || !key.equals(e.attributeValue("Key"))) continue;
                            transitionCollectionEle.remove(e);
                            continue block7;
                        }
                    }
                } else {
                    List<String> paths = Arrays.asList("SequenceFlow", "Association", "ExceptionFlow");
                    for (Element ele : elements) {
                        Element transitionCollection = ele.element("TransitionCollection");
                        if (transitionCollection == null) continue;
                        for (String path : paths) {
                            if (CollectionUtils.isEmpty((Collection)transitionCollection.elements(path))) continue;
                            List pathEles = transitionCollection.elements(path);
                            for (Element e : pathEles) {
                                if (!key.equals(e.attributeValue("TargetNodeKey"))) continue;
                                logger.info("\u5220\u9664\u8def\u5f84:" + e.attributeValue("Key") + "\u6210\u529f");
                                transitionCollection.remove(e);
                            }
                        }
                    }
                    block12: for (Element ele : elements) {
                        if ("SwimlineCollection".equals(ele.getName()) && NodeKeyAndCaptionEnum.Swimline.getKey().equals(nodeType)) {
                            List swimlines = ele.elements("Swimline");
                            if (CollectionUtils.isEmpty((Collection)swimlines)) continue;
                            for (Element e : swimlines) {
                                if (!key.equals(e.attributeValue("Key"))) continue;
                                ele.remove(e);
                                logger.info("\u5220\u9664\u5143\u7d20" + key + "\u6210\u529f");
                                continue block12;
                            }
                            continue;
                        }
                        if (!key.equals(ele.attributeValue("Key"))) continue;
                        root.remove(ele);
                        logger.info("\u5220\u9664\u5143\u7d20" + key + "\u6210\u529f");
                        break;
                    }
                }
                OutputFormat format = this.getOutputFormat();
                String solutionPath = String.valueOf(FilePathHelper.getWorkspacePath()) + File.separator;
                String newFilePath = Paths.get(WebDesignerConfiguration.getDesignerDataPath(), "tmp", String.valueOf(filePath.substring(solutionPath.length()).replace(File.separator, "__")) + "." + System.currentTimeMillis()).toString();
                fileOutputStream = new FileOutputStream(newFilePath);
                writer = new XMLWriter(fileOutputStream, format);
                XmlFileProcessor.stackput(filePath, newFilePath);
                writer.write(document);
            }
            catch (Exception e) {
                logger.warning("\u5220\u9664\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
                result = false;
                this.closeFileStream(fileOutputStream, writer);
                break block19;
            }
            catch (Throwable throwable) {
                try {
                    logger.warning(throwable.getMessage());
                    break block19;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    this.closeFileStream(fileOutputStream, writer);
                }
            }
            this.closeFileStream(fileOutputStream, writer);
        }
        return result;
    }

    private void fillFrontFullJson(JSONObject frontFullJson, JSONObject operJsonObject, String nodeId, String replaceStr) {
        JSONObject nodeIdJsonObj = frontFullJson.getJSONObject(replaceStr).getJSONObject(nodeId);
        if (nodeIdJsonObj != null) {
            nodeIdJsonObj.put("props", (Object)operJsonObject);
            frontFullJson.put(nodeId, (Object)nodeIdJsonObj);
        }
    }

    private void deleteXmlElementAttribute(Element element, Attribute attribute) {
        if (attribute != null) {
            element.remove(attribute);
        }
    }

    private /* synthetic */ void lambda$0(JSONObject jSONObject, Element element, String q) {
        this.setXmlPerm(jSONObject, element, q, String.valueOf(q) + "Item");
    }
}

