/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.webdesigner.service.datamap;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.design.utils.IDLookup;
import com.bokesoft.yes.design.utils.TwoTuple;
import com.bokesoft.yes.design.utils.publicMethodUtil;
import com.bokesoft.yes.mid.cmd.richdocument.strut.ComboxStringBuilder;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DataMapUtil {
    public static MetaTableCollection getTableCollection(String formKey) throws Throwable {
        TwoTuple<MetaForm, MetaDataObject> metaFormOrMetaDataObject = publicMethodUtil.MetaFormOrMetaDataObject(formKey);
        MetaForm metaForm = (MetaForm)metaFormOrMetaDataObject.metaForm;
        MetaDataObject metaDataObject = (MetaDataObject)metaFormOrMetaDataObject.metaDataObject;
        MetaTableCollection tableCollection = null;
        if (metaForm != null) {
            tableCollection = metaForm.getDataSource().getDataObject().getTableCollection();
        } else if (metaDataObject != null) {
            tableCollection = metaDataObject.getTableCollection();
        }
        return tableCollection;
    }

    public static HashMap<String, HashMap<String, Object>> getNodbFields(MetaTableCollection tableCollection) {
        HashMap<String, HashMap<String, Object>> hashNODBFields = new HashMap<String, HashMap<String, Object>>();
        HashMap<String, String> formKeys = new HashMap<String, String>();
        hashNODBFields.put("DesignFormKeys", formKeys);
        for (MetaTable metaTable : tableCollection) {
            if (!metaTable.getKey().contains("_NODB")) continue;
            HashMap<String, MetaColumn> hashNODBField = new HashMap<String, MetaColumn>();
            for (MetaColumn metaColumn : metaTable) {
                if (metaColumn.isSystemControlField().booleanValue()) continue;
                hashNODBField.put(metaColumn.getKey(), metaColumn);
            }
            String metaTableKey = metaTable.getKey().substring(0, metaTable.getKey().indexOf("_NODB"));
            hashNODBFields.put(metaTableKey, hashNODBField);
            formKeys.put(metaTableKey, metaTable.getKey());
        }
        return hashNODBFields;
    }

    public static void getComboxValues(MetaTable metaTable, MetaTableCollection tableCollection, IDLookup idLookup, String condition, ComboxStringBuilder csb, String type) throws Throwable {
        String finalTable = metaTable.getKey();
        Map<String, List<String>> columKeysAndFieldKeys = idLookup.getColumKeysAndFieldListKeys(finalTable);
        for (MetaColumn metaColumn : metaTable) {
            List<String> fieldKeys;
            int index = tableCollection.indexOf(metaTable) + 1;
            if (columKeysAndFieldKeys == null || CollectionUtils.isEmpty(fieldKeys = columKeysAndFieldKeys.get(metaColumn.getKey()))) continue;
            String fieldKey = fieldKeys.get(0);
            String string = fieldKey = StringUtils.isBlank((CharSequence)fieldKey) ? metaColumn.getKey() : fieldKey;
            if (!StringUtil.isBlankOrNull((String)condition) && !fieldKey.toLowerCase().contains(condition.toLowerCase()) && !metaColumn.getCaption().toLowerCase().contains(condition.toLowerCase())) continue;
            String value = String.valueOf(metaTable.getKey()) + "|" + fieldKey;
            String caption = "\u8868(" + index + ")" + fieldKey + " " + metaColumn.getCaption();
            csb.addItem(value, caption);
        }
        if ("target".equals(type) && DataMapUtil.getNodbFields(tableCollection).containsKey(metaTable.getKey())) {
            HashMap<String, HashMap<String, Object>> nodbFields = DataMapUtil.getNodbFields(tableCollection);
            HashMap<String, Object> designFormKeys = nodbFields.get("DesignFormKeys");
            columKeysAndFieldKeys = idLookup.getColumKeysAndFieldListKeys((String)designFormKeys.get(metaTable.getKey()));
            HashMap<String, Object> metaColumns = nodbFields.get(metaTable.getKey());
            for (Map.Entry<String, Object> Columns : metaColumns.entrySet()) {
                MetaColumn metaColumn = (MetaColumn)Columns.getValue();
                int index = tableCollection.indexOf(metaTable) + 1;
                List<String> fieldKeys = columKeysAndFieldKeys.get(metaColumn.getKey());
                if (CollectionUtils.isEmpty(fieldKeys)) continue;
                String fieldKey = fieldKeys.get(0);
                fieldKey = StringUtils.isBlank((CharSequence)fieldKey) ? metaColumn.getKey() : fieldKey;
                String cap = DataMapUtil.getCap(idLookup, metaColumn, fieldKey);
                if (!StringUtil.isBlankOrNull((String)condition) && !fieldKey.toLowerCase().contains(condition.toLowerCase()) && !cap.toLowerCase().contains(condition.toLowerCase())) continue;
                String value = String.valueOf(metaTable.getKey()) + "|" + fieldKey;
                String caption = "\u8868(" + index + ")" + fieldKey + " " + cap;
                csb.addItem(value, caption);
            }
        }
    }

    public static String getCap(IDLookup idLookup, MetaColumn metaColumn, String fieldKey) {
        String cap = metaColumn.getCaption();
        MetaGridCell gridCellByKey = idLookup.getGridCellByKey(fieldKey);
        if (gridCellByKey == null) {
            try {
                cap = idLookup.getComponentByKey(fieldKey).getCaption();
            }
            catch (Exception e) {
                return cap;
            }
        } else {
            cap = gridCellByKey.getCaption();
        }
        return cap;
    }
}

