/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.webdesigner.service.datamap;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bokesoft.erp.entity.util.EntityDesigerContextAction;
import com.bokesoft.erp.webdesigner.service.datamap.DataMapUtil;
import com.bokesoft.yes.design.datamap.util.DataMapOperJsonUtil;
import com.bokesoft.yes.design.datamap.util.DataMapOperXmlUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.IDLookup;
import com.bokesoft.yes.design.utils.TwoTuple;
import com.bokesoft.yes.design.utils.publicMethodUtil;
import com.bokesoft.yes.erpdatamap.ERPMetaMap;
import com.bokesoft.yes.mid.cmd.richdocument.strut.ComboxStringBuilder;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class DataMapFunction
extends EntityDesigerContextAction {
    public DataMapFunction(RichDocumentContext _context) {
        super(_context);
    }

    public String dataMapGetAllFields() throws Throwable {
        String xml = (String)this._context.getPara("XML");
        Element element = DocumentHelper.parseText((String)xml).getRootElement();
        JSONObject resJson = new JSONObject();
        String extend = element.attributeValue("Extend");
        String srcFormKey = "";
        String tgtFormKey = "";
        String srcDataObjectKey = "";
        String tgtDataObjectKey = "";
        if (StringUtils.isEmpty((CharSequence)extend)) {
            srcFormKey = element.attributeValue("SrcFormKey");
            tgtFormKey = element.attributeValue("TgtFormKey");
            srcDataObjectKey = element.attributeValue("SrcDataObjectKey");
            tgtDataObjectKey = element.attributeValue("TgtDataObjectKey");
        } else {
            List customList = MetaFactory.getGlobalInstance().getCustomList();
            for (KeyPairMetaObject erpMetaMap : customList) {
                if (!(erpMetaMap instanceof ERPMetaMap) || !StringUtils.equals((CharSequence)erpMetaMap.getKey(), (CharSequence)extend)) continue;
                srcFormKey = ((ERPMetaMap)erpMetaMap).getSrcFormKey();
                tgtFormKey = ((ERPMetaMap)erpMetaMap).getTgtFormKey();
                srcDataObjectKey = ((ERPMetaMap)erpMetaMap).getSrcDataObjectKey();
                tgtDataObjectKey = ((ERPMetaMap)erpMetaMap).getTgtDataObjectKey();
                break;
            }
        }
        String mergeToSource = element.attributeValue("MergeToSource");
        boolean isFilter = StringUtils.isNotEmpty((CharSequence)extend) && StringUtils.isNotEmpty((CharSequence)mergeToSource);
        JSONObject srcTableJS = this.dealDataSourceFiled(srcFormKey, isFilter, extend);
        resJson.put("srcitems", (Object)srcTableJS);
        JSONObject targetTableJS = this.dealDataSourceFiled(tgtFormKey, isFilter, extend);
        resJson.put("taritems", (Object)targetTableJS);
        List<String> feedBackList = this.getFeedBackFormKeys(element);
        JSONArray array = new JSONArray();
        int i = 0;
        while (i < feedBackList.size()) {
            JSONObject feedBackJson = this.dealDataSourceFiled(feedBackList.get(i), isFilter, extend);
            array.add((Object)feedBackJson);
            ++i;
        }
        resJson.put("feedbackItems", (Object)array);
        resJson.put("SrcFormKey", (Object)srcFormKey);
        resJson.put("TgtFormKey", (Object)tgtFormKey);
        resJson.put("SrcDataObjectKey", (Object)srcDataObjectKey);
        resJson.put("TgtDataObjectKey", (Object)tgtDataObjectKey);
        return resJson.toString();
    }

    private List<String> getFeedBackFormKeys(Element root) {
        ArrayList<String> feedBackKeyList = new ArrayList<String>();
        Node feedbackCollection = root.selectSingleNode("FeedbackCollection");
        if (Objects.isNull(feedbackCollection)) {
            return feedBackKeyList;
        }
        List feedbackObjectList = feedbackCollection.selectNodes("FeedbackObject");
        int i = 0;
        while (i < feedbackObjectList.size()) {
            Element element = (Element)feedbackObjectList.get(i);
            String formKey = element.attributeValue("FormKey");
            if (!StringUtils.isBlank((CharSequence)formKey)) {
                feedBackKeyList.add(formKey);
            }
            ++i;
        }
        return feedBackKeyList;
    }

    public JSONObject dealDataSourceFiled(String formKey, Boolean isFilter, String extend) throws Throwable {
        String key = "";
        String caption = "";
        JSONObject tableJS = new JSONObject();
        TwoTuple<MetaForm, MetaDataObject> metaFormOrMetaDataObject = publicMethodUtil.MetaFormOrMetaDataObject(formKey);
        MetaForm metaForm = (MetaForm)metaFormOrMetaDataObject.metaForm;
        MetaDataObject metaDataObject = (MetaDataObject)metaFormOrMetaDataObject.metaDataObject;
        MetaForm metaForm1 = MetaFactory.getGlobalInstance().getMetaForm(formKey);
        IDLookup idLookup = IDLookup.getIDLookup(metaForm1);
        MetaTableCollection tableCollection = DataMapUtil.getTableCollection(formKey);
        if (metaForm != null) {
            tableCollection = metaForm.getDataSource().getDataObject().getTableCollection();
            key = metaForm.getKey();
            caption = metaForm.getCaption();
        } else if (metaDataObject != null) {
            tableCollection = metaDataObject.getTableCollection();
            key = metaForm.getKey();
            caption = metaForm.getCaption();
        }
        JSONObject dataObjectJS = new JSONObject();
        dataObjectJS.put("Key", (Object)key);
        dataObjectJS.put("Caption", (Object)caption);
        tableJS.put(key, (Object)dataObjectJS);
        if (Objects.isNull(tableCollection)) {
            return tableJS;
        }
        for (MetaTable metaTable : tableCollection) {
            String finalTable = metaTable.getKey();
            Map<String, List<String>> columKeysAndFieldKeys = idLookup.getColumKeysAndFieldListKeys(finalTable);
            for (MetaColumn metaColumn : metaTable) {
                List<Object> fieldKeys = new ArrayList();
                if (columKeysAndFieldKeys != null) {
                    fieldKeys = columKeysAndFieldKeys.get(metaColumn.getKey());
                }
                if (CollectionUtils.isEmpty(fieldKeys)) continue;
                String fieldKey = null;
                if (fieldKeys != null && fieldKeys.size() > 0) {
                    fieldKey = (String)fieldKeys.get(0);
                }
                String string = fieldKey = StringUtils.isBlank(fieldKey) ? metaColumn.getKey() : fieldKey;
                if (isFilter.booleanValue()) {
                    Map<String, String> map = DataMapOperXmlUtil.filterFiledMap(extend, metaForm1);
                    if (map.containsValue(fieldKey)) continue;
                    this.setArray(tableCollection.indexOf(metaTable) + 1, tableJS, fieldKey, metaColumn, metaForm);
                    continue;
                }
                this.setArray(tableCollection.indexOf(metaTable) + 1, tableJS, fieldKey, metaColumn, metaForm);
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("Key", (Object)metaTable.getKey());
            jsonObject.put("Caption", (Object)metaTable.getCaption());
            jsonObject.put("index", (Object)String.valueOf(tableCollection.indexOf(metaTable) + 1));
            tableJS.put(metaTable.getKey(), (Object)jsonObject);
        }
        return tableJS;
    }

    public void setArray(int index, JSONObject nodesJsonArray, String fieldKey, MetaColumn metaColumn, MetaForm metaForm) throws Throwable {
        IDLookup idLookup = IDLookup.reloadIDLookup(metaForm);
        String caption = metaColumn.getCaption();
        if (caption.isEmpty()) {
            MetaGridCell gridCellByKey = idLookup.getGridCellByKey(fieldKey);
            if (gridCellByKey == null) {
                try {
                    caption = idLookup.getComponentByKey(fieldKey).getCaption();
                }
                catch (Exception exception) {}
            } else {
                caption = gridCellByKey.getCaption();
            }
        }
        JSONObject nodeJsonObj = new JSONObject();
        nodeJsonObj.put("Key", (Object)fieldKey);
        nodeJsonObj.put("Caption", (Object)caption);
        nodeJsonObj.put("DataType", (Object)metaColumn.getDataType());
        nodeJsonObj.put("index", (Object)index);
        nodesJsonArray.put((String)nodeJsonObj.get((Object)"Key"), (Object)nodeJsonObj);
    }

    public static String getComponentKey(IDLookup idLookup, String tableKey, String columnKey) {
        Map<String, List<String>> columKeysAndFieldKeys = idLookup.getColumKeysAndFieldListKeys(tableKey);
        List<String> fieldKeys = columKeysAndFieldKeys.get(columnKey);
        String key = null;
        if (fieldKeys != null && fieldKeys.size() > 0) {
            key = fieldKeys.get(0);
        }
        return StringUtils.isBlank(key) ? columnKey : key;
    }

    public String getFormAllField(String formKey, String type, String condition) throws Throwable {
        ComboxStringBuilder csb = ComboxStringBuilder.newInstance();
        if (StringUtils.isBlank((CharSequence)formKey)) {
            return csb.toString();
        }
        MetaForm metaForm1 = MetaFactory.getGlobalInstance().getMetaForm(formKey);
        IDLookup idLookup = IDLookup.getIDLookup(metaForm1);
        MetaTableCollection tableCollection = DataMapUtil.getTableCollection(formKey);
        if (Objects.isNull(tableCollection)) {
            return "";
        }
        for (MetaTable metaTable : tableCollection) {
            if (metaTable.getKey().contains("_NODB")) continue;
            DataMapUtil.getComboxValues(metaTable, tableCollection, idLookup, condition, csb, type);
        }
        return csb.toString();
    }

    public String getTableFields(String formKey, String tableKey, String type, String condition) throws Throwable {
        ComboxStringBuilder csb = ComboxStringBuilder.newInstance();
        if (StringUtils.isBlank((CharSequence)formKey)) {
            return csb.toString();
        }
        MetaForm metaForm1 = MetaFactory.getGlobalInstance().getMetaForm(formKey);
        MetaTableCollection tableCollection = DataMapUtil.getTableCollection(formKey);
        IDLookup idLookup = IDLookup.getIDLookup(metaForm1);
        if (Objects.isNull(tableCollection)) {
            return "";
        }
        for (MetaTable metaTable : tableCollection) {
            if (metaTable.getKey().contains("_NODB") || !tableKey.equals(metaTable.getKey())) continue;
            DataMapUtil.getComboxValues(metaTable, tableCollection, idLookup, condition, csb, type);
        }
        return csb.toString();
    }

    public String getRefField(String formKey, String tableKey) throws Throwable {
        ComboxStringBuilder csb = ComboxStringBuilder.newInstance();
        if (StringUtils.isBlank((CharSequence)formKey)) {
            return csb.toString();
        }
        MetaForm metaForm1 = MetaFactory.getGlobalInstance().getMetaForm(formKey);
        MetaTableCollection tableCollection = DataMapUtil.getTableCollection(formKey);
        IDLookup idLookup = IDLookup.getIDLookup(metaForm1);
        if (Objects.isNull(tableCollection)) {
            return "";
        }
        for (MetaTable metaTable : tableCollection) {
            if (metaTable.getKey().contains("_NODB") || !tableKey.equals(metaTable.getKey())) continue;
            String finalTable = metaTable.getKey();
            Map<String, List<String>> columKeysAndFieldKeys = idLookup.getColumKeysAndFieldListKeys(finalTable);
            for (MetaColumn metaColumn : metaTable) {
                if (metaColumn.getKey().contains("_NODB")) continue;
                int index = tableCollection.indexOf(metaTable) + 1;
                List<String> fieldKeys = columKeysAndFieldKeys.get(metaColumn.getKey());
                if (CollectionUtils.isEmpty(fieldKeys)) continue;
                String fieldKey = null;
                if (fieldKeys != null && fieldKeys.size() > 0) {
                    fieldKey = fieldKeys.get(0);
                }
                String value = fieldKey = StringUtils.isBlank(fieldKey) ? metaColumn.getKey() : fieldKey;
                String caption = "\u8868(" + index + ")" + fieldKey + " " + metaColumn.getCaption();
                csb.addItem(value, caption);
            }
        }
        return csb.toString();
    }

    public String getTableCaption(String formKey, String tableKey) throws Throwable {
        IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
        MetaForm metaForm = globalInstance.getMetaForm(formKey);
        MetaDataObject dataObject = metaForm.getDataSource().getDataObject();
        MetaTable table = dataObject.getTable(tableKey);
        if (Objects.isNull(table)) {
            return metaForm.getCaption();
        }
        return table.getCaption();
    }

    public MetaColumn getMetaColumn(String formKey, String tableKey, String fieldKey) throws Throwable {
        MetaForm metaForm1 = MetaFactory.getGlobalInstance().getMetaForm(formKey);
        MetaTableCollection tableCollection = DataMapUtil.getTableCollection(formKey);
        IDLookup idLookup = IDLookup.getIDLookup(metaForm1);
        for (MetaTable metaTable : tableCollection) {
            if (!metaTable.getKey().equals(tableKey) && !metaTable.getKey().equals(String.valueOf(tableKey) + "_NODB")) continue;
            Map<String, List<String>> columKeysAndFieldKeys = idLookup.getColumKeysAndFieldListKeys(metaTable.getKey());
            for (MetaColumn metaColumn : metaTable) {
                List<String> fieldKeys = columKeysAndFieldKeys.get(metaColumn.getKey());
                if (CollectionUtils.isEmpty(fieldKeys)) continue;
                String findFieldKey = null;
                if (fieldKeys != null && fieldKeys.size() > 0) {
                    findFieldKey = fieldKeys.get(0);
                }
                String string = findFieldKey = StringUtils.isBlank(findFieldKey) ? metaColumn.getKey() : findFieldKey;
                if (!fieldKey.equals(findFieldKey)) continue;
                return metaColumn;
            }
        }
        return null;
    }

    public String getDataType(String formKey, String tableKey, String fieldKey) throws Throwable {
        MetaColumn metaColumn = this.getMetaColumn(formKey, tableKey, fieldKey);
        String value = Objects.isNull(metaColumn) ? "\u672a\u5b9a\u4e49" : DataType.toString((Integer)metaColumn.getDataType());
        return value;
    }

    public String getCaption(String formKey, String tableKey, String fieldKey) throws Throwable {
        MetaColumn metaColumn = this.getMetaColumn(formKey, tableKey, fieldKey);
        if (Objects.isNull(metaColumn)) {
            return "\u672a\u5b9a\u4e49";
        }
        if (metaColumn.getCaption().isEmpty()) {
            IDLookup idLookup = IDLookup.reloadIDLookup(MetaFactory.getGlobalInstance().getMetaForm(formKey));
            String cap = DataMapUtil.getCap(idLookup, metaColumn, fieldKey);
            return cap;
        }
        return metaColumn.getCaption();
    }

    public static String getFormInfo(String formKey) throws Throwable {
        JSONObject form = new JSONObject();
        MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(formKey);
        form.put("Key", (Object)formKey);
        form.put("Caption", (Object)metaForm.getCaption());
        JSONObject dataObject = new JSONObject();
        dataObject.put("Key", (Object)metaForm.getDataSource().getDataObject().getKey());
        form.put("DataObject", (Object)dataObject);
        return form.toJSONString();
    }

    public static String getCaptionByDataObjectKey(String formKey, String dataObjectKey) throws Throwable {
        IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
        MetaForm metaForm = globalInstance.getMetaForm(formKey);
        MetaDataObject dataObject = metaForm.getDataSource().getDataObject();
        if (dataObjectKey.equals(dataObject.getKey())) {
            return dataObject.getCaption();
        }
        return "";
    }

    public String getSourceTypeValue(String tableKey) throws Throwable {
        ComboxStringBuilder csb = ComboxStringBuilder.newInstance();
        csb.addItem("default", "\u9ed8\u8ba4");
        String xml = (String)this._context.getPara("XML");
        Element curRoot = DocumentHelper.parseText((String)xml).getRootElement();
        String extend = curRoot.attributeValue("Extend");
        if (StringUtils.isNotEmpty((CharSequence)extend)) {
            String linkDataMapPath = LoadFileTree.getDataMapPathByKey(extend);
            Element root = DataMapOperJsonUtil.getElement(linkDataMapPath);
            List elements = root.selectNodes("/Map/SourceTableCollection/SourceTable[@Key='" + tableKey + "']/SourceField");
            for (Node ele1 : elements) {
                Element ele = (Element)ele1;
                String caption = "";
                String value = "";
                if (StringUtils.isBlank((CharSequence)ele.attributeValue("Definition"))) {
                    caption = String.valueOf(ele.attributeValue("Key")) + "->" + ele.attributeValue("TargetFieldKey") + "_" + ele.attributeValue("Key");
                    value = String.valueOf(ele.attributeValue("Key")) + "@" + ele.attributeValue("TargetFieldKey") + "@" + ele.attributeValue("Key");
                } else {
                    caption = String.valueOf(ele.attributeValue("Definition")) + "->" + ele.attributeValue("TargetFieldKey") + "_" + ele.attributeValue("Key");
                    value = String.valueOf(ele.attributeValue("Definition")) + "@" + ele.attributeValue("TargetFieldKey") + "@" + ele.attributeValue("Key");
                }
                csb.addItem(value, caption);
            }
        }
        return csb.toString();
    }

    public String getSourceTypeDefaultValue(String sectionXml) throws Throwable {
        String xml = (String)this._context.getPara("XML");
        Element curRoot = DocumentHelper.parseText((String)xml).getRootElement();
        String extend = curRoot.attributeValue("Extend");
        Element ligature = DocumentHelper.parseText((String)sectionXml).getRootElement();
        String tableKey = ligature.attributeValue("TableKey");
        Element node = (Element)ligature.selectSingleNode("SourceField");
        String key = node.attributeValue("Key");
        if (StringUtils.isNotEmpty((CharSequence)extend)) {
            String linkDataMapPath = LoadFileTree.getDataMapPathByKey(extend);
            Element root = DataMapOperJsonUtil.getElement(linkDataMapPath);
            Element ele = (Element)root.selectSingleNode("/Map/SourceTableCollection/SourceTable[@Key='" + tableKey + "']/SourceField[@Key='" + key + "']");
            if (Objects.isNull(ele)) {
                return "default";
            }
            if (StringUtils.isBlank((CharSequence)ele.attributeValue("Definition"))) {
                return String.valueOf(ele.attributeValue("Key")) + "@" + ele.attributeValue("TargetFieldKey") + "@" + ele.attributeValue("Key");
            }
            return String.valueOf(ele.attributeValue("Definition")) + "@" + ele.attributeValue("TargetFieldKey") + "@" + ele.attributeValue("Key");
        }
        return "default";
    }

    public Map<String, ArrayList> getExtendDataMapLinks(String extend) throws Throwable {
        String path = LoadFileTree.getDataMapPathByKey(extend);
        HashMap<String, ArrayList> links = new HashMap<String, ArrayList>();
        SAXReader reader = new SAXReader();
        Document document = reader.read(new File(path));
        Element root = document.getRootElement();
        links.put("sourceToTarget", this.getSourceToTargetLinks(root));
        links.put("serviceSourceTable", this.getServiceSourceTable(root));
        Element feedbackTables = root.element("FeedbackCollection");
        if (Objects.isNull(feedbackTables)) {
            return links;
        }
        links.put("targetToFeedback", this.getTargetToFeedbackLinks(root));
        return links;
    }

    public ArrayList<String> getTargetToFeedbackLinks(Element root) throws Throwable {
        Element targetTables = root.element("TargetTableCollection");
        List targetTableElements = targetTables.elements("TargetTable");
        ArrayList<String> targetToFeedbackList = new ArrayList<String>();
        for (Element tableElement : targetTableElements) {
            String targetTableKey = tableElement.attributeValue("Key");
            List fieldElements = tableElement.elements("TargetField");
            for (Element fieldElement : fieldElements) {
                List elements = fieldElement.elements("Feedback");
                String fieldKey = fieldElement.attributeValue("Definition");
                for (Element element : elements) {
                    String feedDataObjectKey = element.attributeValue("DataObjectKey");
                    String feedTableKey = element.attributeValue("TableKey");
                    String feedFieldKey = element.attributeValue("FieldKey");
                    String link = String.valueOf(targetTableKey) + "*" + fieldKey + "--" + feedDataObjectKey + "*" + feedTableKey + "*" + feedFieldKey;
                    targetToFeedbackList.add(link);
                }
            }
        }
        return targetToFeedbackList;
    }

    public ArrayList<String> getServiceSourceTable(Element root) throws Throwable {
        Element sourceTables = root.element("SourceTableCollection");
        List tableElements = sourceTables.elements("SourceTable");
        ArrayList<String> serviceSourceTableList = new ArrayList<String>();
        for (Element tableElement : tableElements) {
            if (!StringUtils.equals((CharSequence)tableElement.attributeValue("Type"), (CharSequence)"SERVICE")) continue;
            String sourceTableKey = tableElement.attributeValue("Key");
            serviceSourceTableList.add(sourceTableKey);
        }
        return serviceSourceTableList;
    }

    public ArrayList<String> getSourceToTargetLinks(Element root) throws Throwable {
        Element sourceTables = root.element("SourceTableCollection");
        List tableElements = sourceTables.elements("SourceTable");
        ArrayList<String> sourceToTargetList = new ArrayList<String>();
        for (Element tableElement : tableElements) {
            String sourceTableKey = tableElement.attributeValue("Key");
            List fieldElements = tableElement.elements("SourceField");
            for (Element fieldElement : fieldElements) {
                if (StringUtils.isEmpty((CharSequence)fieldElement.attributeValue("TargetFieldKey"))) continue;
                String fieldKey = "";
                fieldKey = StringUtils.isEmpty((CharSequence)fieldElement.attributeValue("Definition")) ? fieldElement.attributeValue("Key") : fieldElement.attributeValue("Definition");
                String targetTableKey = fieldElement.attributeValue("TargetTableKey");
                String targetFieldKey = fieldElement.attributeValue("TargetFieldKey");
                String link = String.valueOf(sourceTableKey) + "*" + fieldKey + "--" + targetTableKey + "*" + targetFieldKey;
                sourceToTargetList.add(link);
            }
        }
        return sourceToTargetList;
    }

    public ArrayList<String> getExtendDataMigrationLinks(String extend) throws Throwable {
        String path = LoadFileTree.getDataMigrationPathByKey(extend);
        SAXReader reader = new SAXReader();
        Document document = reader.read(new File(path));
        Element root = document.getRootElement();
        Element sourceTables = root.element("SourceTableCollection");
        List tableElements = sourceTables.elements("SourceTable");
        ArrayList<String> sourceToTargetList = new ArrayList<String>();
        for (Element tableElement : tableElements) {
            String sourceTableKey = tableElement.attributeValue("Key");
            List fieldElements = tableElement.elements("SourceField");
            for (Element fieldElement : fieldElements) {
                if (StringUtils.isEmpty((CharSequence)fieldElement.attributeValue("TargetFieldKey"))) continue;
                String fieldKey = "";
                fieldKey = StringUtils.isEmpty((CharSequence)fieldElement.attributeValue("Definition")) ? fieldElement.attributeValue("Key") : fieldElement.attributeValue("Definition");
                String targetTableKey = fieldElement.attributeValue("TargetTableKey");
                String targetFieldKey = fieldElement.attributeValue("TargetFieldKey");
                String link = String.valueOf(sourceTableKey) + "*" + fieldKey + "--" + targetTableKey + "*" + targetFieldKey;
                sourceToTargetList.add(link);
            }
        }
        return sourceToTargetList;
    }

    public boolean getTargetTableKeyEnable(String xml) {
        return false;
    }

    public String getTargetTableKey(String xml, String tableKey) throws Throwable {
        Element root = DocumentHelper.parseText((String)xml).getRootElement();
        String extend = root.attributeValue("Extend");
        if (StringUtils.isEmpty((CharSequence)extend)) {
            Element ele = (Element)root.selectSingleNode("/Map/SourceTableCollection/SourceTable[@Key='" + tableKey + "']");
            return ele.attributeValue("TargetTableKey", "");
        }
        String filePath = LoadFileTree.getDataMapPathByKey(extend);
        SAXReader reader = new SAXReader();
        Document document = reader.read(new File(filePath));
        Element extendRoot = document.getRootElement();
        Element tableEle = (Element)extendRoot.selectSingleNode("/Map/SourceTableCollection/SourceTable[@Key='" + tableKey + "']");
        return tableEle.attributeValue("TargetTableKey", "");
    }

    public boolean testMapConditionFalse() {
        return false;
    }

    public boolean testMapConditionTrue() {
        return true;
    }
}

