/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp;

import com.bokesoft.erp.all.initiator.InitializingDesigner;
import com.bokesoft.yes.design.function.DesignActionUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.ReloadForm;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.solution.MetaSolution;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

@Configuration
@ComponentScan
public class WebDesignerConfiguration {
    private static Logger logger = LoggerFactory.getLogger(WebDesignerConfiguration.class);
    @Value(value="${application-erp.webdesigner.enable:false}")
    private boolean enable;
    @Value(value="${application-erp.webdesigner.target-solution-location:}")
    private String targetSolutionLocation;
    private boolean delayedProcessScope = false;
    @Value(value="${yigo.configuration.solution.data-path:}")
    private String dataPath;
    @Autowired
    private ResourceLoader resourceLoader;
    private static WebDesignerConfiguration instance;

    public WebDesignerConfiguration() {
        instance = this;
    }

    @PostConstruct
    public void postConstruct() throws IOException {
        InitializingDesigner.setEnable(this.enable);
        this.setupTargetSolutionPath();
        String isDelayedProcessScope = DesignActionUtil.getPreferencesInfo("DelayedProcessScope");
        if (isDelayedProcessScope != null) {
            this.delayedProcessScope = Boolean.parseBoolean(isDelayedProcessScope);
        }
        ReloadForm.setDelayedProcessScope(this.delayedProcessScope);
        logger.info("WebDesignerConfiguration inited!");
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setupTargetSolutionPath() throws IOException {
        if (StringUtils.isBlank((CharSequence)this.targetSolutionLocation)) {
            FilePathHelper.setTargetSolutionPath(null);
            return;
        }
        String locError = null;
        Resource res = this.resourceLoader.getResource(this.targetSolutionLocation);
        if (res.isFile()) {
            File f = res.getFile();
            String locPath = f.getCanonicalPath();
            if (!f.exists()) {
                locError = "\u8bbe\u8ba1\u5668\u76ee\u6807 Solution '" + this.targetSolutionLocation + "' \u5bf9\u5e94\u7684\u6587\u4ef6\u8def\u5f84 '" + locPath + "' \u4e0d\u5b58\u5728";
            } else {
                if (f.isDirectory()) {
                    FilePathHelper.setTargetSolutionPath(locPath);
                    logger.info("\u8bbe\u8ba1\u5668\u76ee\u6807 Solution '{}' \u7684\u5b9e\u9645\u8def\u5f84\u4e3a '{}' .", (Object)this.targetSolutionLocation, (Object)locPath);
                    return;
                }
                locError = "\u8bbe\u8ba1\u5668\u76ee\u6807 Solution '" + this.targetSolutionLocation + "' \u5bf9\u5e94\u7684\u6587\u4ef6\u8def\u5f84 '" + locPath + "' \u4e0d\u662f\u6709\u6548\u76ee\u5f55";
            }
        } else {
            locError = "\u8bbe\u8ba1\u5668\u76ee\u6807 Solution '" + this.targetSolutionLocation + "' \u4e0d\u662f\u6587\u4ef6\u7cfb\u7edf\u8def\u5f84";
        }
        if (locError != null) {
            logger.error("Web Designer \u914d\u7f6e\u9519\u8bef: " + locError);
            throw new RuntimeException(locError);
        }
    }

    public static String getDesignerDataPath() {
        return String.valueOf(FilePathHelper.toBackFilePath(WebDesignerConfiguration.instance.dataPath)) + File.separator + "designer";
    }

    public static String getDesignerSolutionPathPath(String projectKey) throws Throwable {
        String solutionPath = null;
        IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
        MetaSolution solution = (MetaSolution)globalInstance.getSolution().getProject(projectKey).getSolution();
        solutionPath = LoadFileTree.getSolutionPath(solution.getKey());
        if (solutionPath == null) {
            throw new Exception("solution not found!");
        }
        return FilePathHelper.toBackFilePath(solutionPath);
    }

    public static Set<String> getDesignerSolutionTmpDataPaths() throws Throwable {
        HashSet<String> paths = new HashSet<String>();
        IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
        for (MetaSolution metaSolution : globalInstance.getMetaSolutions()) {
            String solutionPath = LoadFileTree.getSolutionPath(metaSolution.getKey());
            String path = String.valueOf(solutionPath) + File.separator + "Data" + File.separator + "designer" + File.separator + "tmp";
            paths.add(FilePathHelper.toBackFilePath(path));
        }
        return paths;
    }

    public static String getDesignerSolutionTmpDataPath(String projectKey) throws Throwable {
        String solutionPath = String.valueOf(WebDesignerConfiguration.getDesignerSolutionPathPath(projectKey)) + File.separator + "Data" + File.separator + "designer" + File.separator + "tmp";
        return WebDesignerConfiguration.PathNormalization(solutionPath.replaceAll("/", "\\\\").replace("\\\\", File.separator));
    }

    public static String getDesignerImportSolutionsPath() {
        return String.valueOf(FilePathHelper.toBackFilePath(WebDesignerConfiguration.instance.dataPath)) + File.separator + "designer" + File.separator + "ImportSolutions.xml";
    }

    public static String getDesignerSolutionDataPath() {
        return String.valueOf(FilePathHelper.toBackFilePath(WebDesignerConfiguration.instance.dataPath)) + File.separator + "designer" + File.separator + "solutions";
    }

    public static String getDesignerJsonFilePath() {
        return String.valueOf(FilePathHelper.toBackFilePath(WebDesignerConfiguration.instance.dataPath)) + File.separator + "designer" + File.separator + "endFuns.json";
    }

    public static String getxmlAttrJsonFilePath() {
        return String.valueOf(FilePathHelper.toBackFilePath(WebDesignerConfiguration.instance.dataPath)) + File.separator + "designer" + File.separator + "xmlAttrs.json";
    }

    public static String PathNormalization(String path) {
        Path path1 = Paths.get(path, new String[0]);
        return FilePathHelper.toBackFilePath(path1.normalize().toString());
    }
}

